!= 
!
!= Prepare initial surface data
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module initial_surface_data
  !
  != 
  !
  != Prepare initial surface data
  !
  ! ͥǡΥץ󶡤ޤ. 
  !
  ! Prepare sample data of initial surface data (restart data)
  !
  !== Procedures List
  !
  ! SetInitSurfaceData :: ͥǡ
  ! ------------------ :: ------------
  ! SetInitSurfaceData :: Get initial surface data
  !
  !== NAMELIST
  !
  ! NAMELIST#initial_surface_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetInitSurfaceData
  public:: InitSurfaceDataInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: initial_surface_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(STRING), save, public:: Pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
  real(DP), save, public:: SoilMoist
                              ! soil moisture (kg m-2)
  real(DP), save, public:: SurfSnow
                              ! surface snow (kg m-2)
  real(DP), save, public:: SurfMajCompIce
                              ! surface major component ice (kg m-2)

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'initial_surface_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetInitSurfaceData(                      &
    & xy_SurfMajCompIce, xy_SoilMoist, xy_SurfSnow    & ! (out)
    & )
    !
    ! ͥǡΥץ󶡤ޤ. 
    ! 
    ! Prepare sample data of initial data
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $.
                              ! ߼Ψ. Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm

    ! ߥ饰ήƥѽͺ
    ! Preparation of initial condition for SLTT advection
    !
    use sltt_debug, only : SLTTDebugSetUV, SLTTDebugSetQ


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(out):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
                            ! 
                            ! surface major component ice
    real(DP), intent(out):: xy_SoilMoist(0:imax-1, 1:jmax)
                            ! 
                            ! soil moisture
    real(DP), intent(out):: xy_SurfSnow(0:imax-1, 1:jmax)
                            ! 
                            ! surface snow amount

    ! ѿ
    ! Work variables
    !

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. initial_surface_data_inited ) call InitSurfaceDataInit

    do j = 1, jmax
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SurfMajCompIce(:,j) = 0.0_DP
!!$      else
        xy_SurfMajCompIce(:,j) = 0.0_DP
!!$      end if
        !
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SoilMoist(:,j) = 0.0_DP
!!$      else
        xy_SoilMoist(:,j) = 0.0_DP
!!$      end if
        !
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SurfSnow(:,j) = 0.0_DP
!!$      else
        xy_SurfSnow(:,j) = 0.0_DP
!!$      end if
    end do



  end subroutine SetInitSurfaceData

  !--------------------------------------------------------------------------------------

  subroutine InitSurfaceDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /initial_surface_data_nml/ Pattern, &
!!$      & TempAvr, PsAvr, QVapAvr, Ueq, UGeos, VGeos
          !
          ! ǥեͤˤĤƤϽ³ "initial_surface_data#InitSurfaceDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "initial_surface_data#InitSurfaceDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( initial_surface_data_inited ) return


    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
!!$    Pattern = 'Small Disturbance of Temperature'
    !Pattern = 'AGCM 5.3 Default'

    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &             ! (in)
!!$        & nml = initial_data_nml, & ! (out)
!!$        & iostat = iostat_nml )     ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
!!$    call MessageNotify( 'M', module_name, '  TempAvr = %f', d = (/ TempAvr  /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    initial_surface_data_inited = .true.

  end subroutine InitSurfaceDataInit

  !--------------------------------------------------------------------------------------

end module initial_surface_data
