!= Output frequently used variables
!
!= Output frequently used variables
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module output_freq_used_vars
  !
  != Output frequently used variables
  !
  != Output frequently used variables
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !
  !== References
  !
!!$  !  McFarlane, N. A., 
!!$  !    The effect of orographically excited gravity wave drag on the general
!!$  !    circulation of the lower stratosphere and troposphsere,
!!$  !    J. Atmos. Sci., 44, 1775-1800, 1987.
  !
  !== Procedures List
  !
!!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
!!$  ! GWDM1987Init :: Initialization
!!$  ! ------------ :: ------------
!!$  ! GWDM1987     :: Calculation of gravity wave drag tendency
!!$  ! GWDM1987Init :: Initialization
  !
  !== NAMELIST
  !
  ! NAMELIST#gwd_m1987_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI                    ! $ \pi $.
                            ! ߼Ψ. Circular constant


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: OutputFreqUsedVars
  public :: OutputFreqUsedVarsInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  real(DP), save :: AdiabLapseRate
                              ! Adiabatic lapse rate
  real(DP), save :: SigmaRefForSLP
                              ! Sigma of level for calculation of scale height


  logical, save :: output_freq_used_vars_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'output_freq_used_vars'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: output_freq_used_vars.f90,v 1.2 2015/02/11 11:55:46 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine OutputFreqUsedVars(     &
    & xy_PsA, xyz_TempA, xyzf_QMixA, & ! (in)
    & xy_SurfHeight                  & ! (in)
    & )
    !
    ! 
    !
    ! Output frequently used variables
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimeA, &              ! ƥå $ t + \Delta t $ λ.
                              ! Time of step $ t + \Delta t $.
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only: &
      &                    ncmax, &
                              ! ʬο
                              ! Number of composition
      &                    IndexH2OVap

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure

    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level,
    ! and calculate pressure and height
    !
    use auxiliary, only: AuxVars

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat, xyz_CalcQVapSatOnLiq


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ) :: xy_PsA       (0:imax-1, 1:jmax)
                              ! Temperature
    real(DP), intent(in ) :: xyz_TempA    (0:imax-1, 1:jmax, 1:kmax)
                              ! Temperature
    real(DP), intent(in ) :: xyzf_QMixA   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
    real(DP), intent(in ) :: xy_SurfHeight(0:imax-1, 1:jmax)


    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
                              ! Pressure
    real(DP) :: xyz_Exner     (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner function
    real(DP) :: xyz_VirTemp   (0:imax-1, 1:jmax, 1:kmax)
                              ! Virtual temperature
    real(DP) :: xyz_Height    (0:imax-1, 1:jmax, 1:kmax)
                              ! Height
    real(DP) :: xyz_Rho       (0:imax-1, 1:jmax, 1:kmax)
                              ! Pressure
    real(DP) :: xyz_PotTemp   (0:imax-1, 1:jmax, 1:kmax)
                              ! Potential temperature
    real(DP) :: xyz_BVFreqSq  (0:imax-1, 1:jmax, 1:kmax)
                              ! Brunt-Vaisalla frequency squared

    real(DP) :: xyz_QVapSat(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_RH     (0:imax-1, 1:jmax, 1:kmax)

    integer  :: xy_KIndex          (0:imax-1, 1:jmax)
                              ! K index for reference level used for SLP calc.
    real(DP) :: xy_PressRefForSLP  (0:imax-1, 1:jmax)
    real(DP) :: xy_HeightRefForSLP (0:imax-1, 1:jmax)
    real(DP) :: xy_VirTempRefForSLP(0:imax-1, 1:jmax)
    real(DP) :: xy_ScaleHeight     (0:imax-1, 1:jmax)
    real(DP) :: xy_SLP             (0:imax-1, 1:jmax)
                              ! Sea level pressure


    integer :: i               ! ˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in longitude
    integer :: j               ! ˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in latitude
    integer :: k               ! ľ˲ DO 롼Ѻѿ
                               ! Work variables for DO loop in vertical direction
    integer :: kp
    integer :: kn


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. output_freq_used_vars_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level,
    ! and calculate pressure and height
    !
    call AuxVars( &
      & xy_PsA, xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap),    & ! (in )
      & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
      & xyz_Press     = xyz_Press,                           & ! (out) optional
      & xyz_VirTemp   = xyz_VirTemp,                         & ! (out) optional
      & xyz_Height    = xyz_Height,                          & ! (out) optional
      & xyz_Exner     = xyz_Exner                            & ! (out) optional
      & )
    !
    xyz_Rho = xyz_Press / ( GasRDry * xyz_TempA )
    call HistoryAutoPut( TimeA, 'Rho', xyz_TempA / xyz_Exner )
    !
    call HistoryAutoPut( TimeA, 'Height', xyz_Height )
    !
    xyz_PotTemp = xyz_TempA / xyz_Exner
    call HistoryAutoPut( TimeA, 'PotTemp', xyz_PotTemp )
    !
    do k = 1, kmax
      kp = max( k - 1, 1    )
      kn = min( k + 1, kmax )
      xyz_BVFreqSq(:,:,k) =                               &
        & Grav / xyz_PotTemp(:,:,k)                       &
        & * ( xyz_PotTemp(:,:,kn) - xyz_PotTemp(:,:,kp) ) &
        & / ( xyz_Height (:,:,kn) - xyz_Height (:,:,kp) )
    end do
    call HistoryAutoPut( TimeA, 'BVFreqSq', xyz_BVFreqSq )


    xy_KIndex = 1
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Press(i,j,k) / xy_PsA(i,j) > SigmaRefForSLP ) then
            xy_KIndex(i,j) = k
          end if
        end do
      end do
    end do
    do j = 1, jmax
      do i = 0, imax-1
        xy_PressRefForSLP  (i,j) = xyz_Press  (i,j,xy_KIndex(i,j))
        xy_HeightRefForSLP (i,j) = xyz_Height (i,j,xy_KIndex(i,j))
        xy_VirTempRefForSLP(i,j) = xyz_VirTemp(i,j,xy_KIndex(i,j))
      end do
    end do
    xy_SLP = &
      & xy_PressRefForSLP &
      & * (   1.0_DP &
      &     + AdiabLapseRate &
      &       * ( 0.0_DP - xy_HeightRefForSLP ) / xy_VirTempRefForSLP &
      &   )**( - Grav / ( GasRDry * AdiabLapseRate ) )
    call HistoryAutoPut( TimeA, 'SLP', xy_SLP )


    xyz_QVapSat = xyz_CalcQVapSat( xyz_TempA, xyz_Press )
    xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
    call HistoryAutoPut( TimeA, 'RH', xyz_RH )

    xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_TempA, xyz_Press )
    xyz_RH = xyzf_QMixA(:,:,:,IndexH2OVap) / xyz_QVapSat
    call HistoryAutoPut( TimeA, 'RHOnWat', xyz_RH )


    ! MEMO
    !
    ! dp/dz = - \rho g
    !       = - p / (RT) g
    ! 1/p dp/dz = - g / (RT)
    ! d(lnp)/dz = - g / (RT)
    !
    ! \int_{z_0}^z d{lnp(z')}/dz' = - \int_{z_0}^z g / (RT(z')) dz'
    ! ln{p(z)} - ln{p(z_0)} = - g/R \int_{z_0}^z 1/T(z') dz'
    ! ln{p(z)/p(z_0)}
    ! = - g/R \int_{z_0}^z 1/T(z') dz'
    ! = - g/R \int_{z_0}^z 1/{ T(z_0) + \Gamma (z' - z_0) } dz'
    ! = - g/(R \Gamma) \int_{z_0}^z \Gamma/{ T(z_0) + \Gamma (z' - z_0) } dz'
    ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z' - z_0) } ]_{z_0}^z
    ! = - g/(R \Gamma) [ ln{ T(z_0) + \Gamma (z - z_0) } - ln{ T(z_0) } ]
    ! = - g/(R \Gamma) ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]
    ! = ln[ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
    ! p(z)/p(z_0)
    ! = [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
    ! p(z)
    ! = p(z_0) [ { T(z_0) + \Gamma (z - z_0) } / T(z_0) ]^{- g/(R \Gamma)}
    ! = p(z_0) { 1.0 + \Gamma (z - z_0) / T(z_0) }^{- g/(R \Gamma)}
    !
    ! T(z) = T(z_0) + \Gamma (z - z_0)


    do j = 1, jmax
      do i = 0, imax-1
        xy_ScaleHeight(i,j) = GasRDry * xyz_VirTemp(i,j,xy_KIndex(i,j)) / Grav
      end do
    end do
    xy_SLP = xy_PsA * exp( - ( 0.0_DP - xy_SurfHeight ) / xy_ScaleHeight )
    call HistoryAutoPut( TimeA, 'SLPTmp', xy_SLP )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine OutputFreqUsedVars

  !--------------------------------------------------------------------------------------

  subroutine OutputFreqUsedVarsInit
    !
    ! moist_conv_adjust ⥸塼νԤޤ. 
    ! NAMELIST#moist_conv_adjust_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "moist_conv_adjust" module is initialized. 
    ! "NAMELIST#moist_conv_adjust_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & AxnameX, &
      & AxnameY, &
      & AxnameZ, &
      & AxnameR, &
      & AxnameT

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

!!$    real(DP)         :: GWDDampPeriodValue
!!$    character(TOKEN) :: GWDDampPeriodUnit

    integer:: k


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /output_freq_used_vars_nml/ &
      & SigmaRefForSLP, &
      & AdiabLapseRate
          ! ǥեͤˤĤƤϽ³ "moist_conv_adjust#CumAdjInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "moist_conv_adjust#MoistConvAdjustInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( output_freq_used_vars_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    SigmaRefForSLP = exp( - 200.0_DP / ( ( GasRDry * 300.0_DP ) / Grav ) )
                              ! 200 m height is approximately set

    AdiabLapseRate = - 5.0e-3_DP
                              ! Another example:
                              ! -5 degrees / km
                              ! This value is originated from JMA method
                              ! (see dcmodel e-mail at 2013/03/25 from 
                              ! Toyoda-san).
                              ! In addition, this value is shown in a book 
                              ! by Ninomiya-sensei, "ݤ狼ȼ".

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                      &  ! (in)
        & nml = output_freq_used_vars_nml, &  ! (out)
        & iostat = iostat_nml )               ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! Calculation of divergence damping period
    !
!!$    GWDDampPeriod = DCCalConvertByUnit( GWDDampPeriodValue, GWDDampPeriodUnit, 'sec' )

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'Rho'    ,       &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'density', 'kg m-3' )                        ! (in)
    call HistoryAutoAddVariable( 'Height' ,       &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'geopotential height', 'm' )                 ! (in)
    call HistoryAutoAddVariable( 'PotTemp' ,      &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'potential temperature', 'K' )               ! (in)
    call HistoryAutoAddVariable( 'BVFreqSq'    ,  &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'potential temperature', 'K' )               ! (in)
    call HistoryAutoAddVariable( 'RH'          ,  &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'relative humidity', '1' )                   ! (in)
    call HistoryAutoAddVariable( 'RHOnWat'     ,  &  ! (in)
      & (/ AxNameX, AxNameY, AxNameZ, AxNameT /), &  ! (in)
      & 'relative humidity on water', '1' )          ! (in)
    call HistoryAutoAddVariable( 'SLP'    ,       &  ! (in)
      & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
      & 'sea level pressure', 'Pa' )                 ! (in)
    call HistoryAutoAddVariable( 'SLPTmp' ,       &  ! (in)
      & (/ AxNameX, AxNameY, AxNameT /),          &  ! (in)
      & 'sea level pressure', 'Pa' )                 ! (in)


    ! Initialization of modules used in this module
    !


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  FlagUse               = %b', l = (/ FlagUse /) )
    call MessageNotify( 'M', module_name, '  SigmaRefForSLP = %f', d = (/ SigmaRefForSLP /) )
    call MessageNotify( 'M', module_name, '  AdiabLapseRate = %f', d = (/ AdiabLapseRate /) )
    call MessageNotify( 'M', module_name, '    (compared to -g/Cp = %f)', d = (/ (- Grav / CpDry) /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    output_freq_used_vars_inited = .true.

  end subroutine OutputFreqUsedVarsInit

  !--------------------------------------------------------------------------------------

end module output_freq_used_vars
