!= Schneider and Liu (2009) ˤľ
!
!= Vertical diffusion by Schneider and Liu (2009)
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: sl09_diffusion.f90,v 1.8 2013-09-16 12:20:02 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module sl09_diffusion
  !
  != Schneider and Liu (2009) ˤľ
  !
  != Vertical diffusion by Schneider and Liu (2009)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !
  !== Procedures List
  ! 
!!$  ! Hs94Forcing   :: Ȼη׻
!!$  ! Hs94Finalize  :: λ (⥸塼ѿγդ)
!!$  ! ------------  :: ------------
!!$  ! Hs94Forcing   :: Calculate forcing and dissipation
!!$  ! Hs94Finalize  :: Termination (deallocate variables in this module)
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#sl09_diffusion_nml
  !++
  !== References
  !
  !  Schneider, T. and J. Liu, 
  !    Formation of jets and equatorial superrotation on Jupiter, 
  !    J. Atmos. Sci., 69, 579, 2009.
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax, &
                              ! ʬο
                              ! Number of composition
    &                    IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SL09Diffusion, SL09DiffusionInit 

  ! ѿ
  ! Public variables
  !
  logical, save, public:: sl09_diffusion_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save, allocatable :: xyz_kv (:,:,:)
                              ! $ k_v $ .
  real(DP), save              :: LBHeatFlux

  real(DP), save              :: SurfQMixDiffCoef
  real(DP), save              :: SurfQVap


  character(*), parameter:: module_name = 'sl09_diffusion'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: sl09_diffusion.f90,v 1.8 2013-09-16 12:20:02 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine SL09Diffusion(                            &
    & xy_SurfHeight, xyz_Height,                       &
    & xyz_U, xyz_V, xyzf_QMix, xyr_Press, xyr_VirTemp, & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt    & ! (out)
    & )
    !
    !
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat, &              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma               ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      &                  CpDry    ! $ C_p $ [J kg-1 K-1].
                                  ! 絤갵Ǯ.
                                  ! Specific heat of air at constant pressure

    ! ľȻեå
    ! Vertical diffusion flux
    !
    use vdiffusion_my, only: VDiffusionExpTendency

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_SurfHeight(0:imax-1, 1:jmax)
    real(DP), intent(in):: xyz_Height   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. 
                              ! Eastward wind
    real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. 
                              ! Northward wind
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
    real(DP), intent(in):: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
                              ! $ p_s $ . ɽ̵. 
                              ! Surface pressure
    real(DP), intent(in):: xyr_VirTemp  (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyzf_DQMixDt (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP) :: xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)

    real(DP) :: xy_SurfQMixTransCoef(0:imax-1, 1:jmax)

!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. sl09_diffusion_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! ® $ u $ ® $ v $ إ쥤꡼໤Ŭ
    ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
    !
    xyz_DUDt = - xyz_kv * xyz_U
    xyz_DVDt = - xyz_kv * xyz_V


    ! Set heat flux at the lower boundary
    !
    xyr_HeatFlux(:,:,0     ) = LBHeatFlux
    xyr_HeatFlux(:,:,1:kmax) = 0.0_DP

    ! Set moisture flux at the lower boundary
    !
    xyrf_QMixFlux = 0.0_DP
    n = IndexH2OVap
    k = 0
    xy_SurfQMixTransCoef =                                    &
      &   SurfQMixDiffCoef                                    &
      & * xyr_Press(:,:,k) / ( GasRDry * xyr_VirTemp(:,:,k) ) &
      & / ( xyz_Height(:,:,k+1) - xy_SurfHeight )
    xyrf_QMixFlux(:,:,k,n) =   &
      & - xy_SurfQMixTransCoef &
      &   * ( xyzf_QMix(:,:,k+1,n) - SurfQVap )



    ! ѲΨη׻Ԥޤ.
    ! Calculate tendencies.
    !
    call VDiffusionExpTendency(        &
      & xyr_Press,                     & ! (in )
      & xyr_HeatFlux  = xyr_HeatFlux,  & ! (in ) optional
      & xyrf_QMixFlux = xyrf_QMixFlux, & ! (in ) optional
      & xyz_DTempDt  = xyz_DTempDt,    & ! (out) optional
      & xyzf_DQMixDt = xyzf_DQMixDt    & ! (out) optional
      & )


    ! This is commented out (yot, 2013/05/12) to be consistent with SL09.
    ! Temporarily, xyzf_DQMixDt is overwritten.
!!$    xyzf_DQMixDt = 0.0_DP
!!$    k = 1
!!$    n = IndexH2OVap
!!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
!!$      & / ( 2.0_DP * DelTime )
!!$    xyzf_DQMixDt(:,:,k,n) = ( SurfQVap - xyzf_QMix(:,:,k,n) ) &
!!$      & / ( 2.0_DP * DelTime )


    !
    ! Add heating due to MHD drag dissipation
    !
    xyz_DTempDt = xyz_DTempDt &
      & - ( xyz_DUDt * xyz_U + xyz_DVDt * xyz_V ) / CpDry


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DUDtVDiffSL09',    xyz_DUDt    )
    call HistoryAutoPut( TimeN, 'DVDtVDiffSL09',    xyz_DVDt    )
    call HistoryAutoPut( TimeN, 'DTempDtVDiffSL09', xyz_DTempDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SL09Diffusion

  !-------------------------------------------------------------------

  subroutine SL09DiffusionInit
    !
    ! sl09_diffusion ⥸塼νԤޤ. 
    ! NAMELIST#sl09_diffusion_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "sl09_diffusion" module is initialized. 
    ! "NAMELIST#sl09_diffusion_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI
                              ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat, &              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma               ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ľȻեå
    ! Vertical diffusion flux
    !
    use vdiffusion_my, only: VDiffusionInit


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), parameter :: day_seconds = 86400.0_DP
                              ! 1 ÿ. 
                              ! Seconds in day. 
    real(DP):: SigmaB         ! $ \sigma_b $ .
    real(DP):: kf             ! $ k_f $ .

    real(DP):: kfTimeScaleInDay
    real(DP):: FrictionLBLat

    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /sl09_diffusion_nml/ &
      & SigmaB,                   &
      & kfTimeScaleInDay,         &
      & FrictionLBLat,            &
      & LBHeatFlux,               &
      & SurfQMixDiffCoef,         &
      & SurfQVap

          !
          ! ǥեͤˤĤƤϽ³ "sl09_diffusion#SL09DiffusionInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "sl09_diffusion#SL09DiffusionInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( sl09_diffusion_inited ) return

    ! ǥեͤ
    ! Default values settings
    !
    SigmaB           =  0.8_DP
    kfTimeScaleInDay = 20.0_DP
    FrictionLBLat    = 16.3_DP
    LBHeatFlux       =  5.7_DP
    SurfQMixDiffCoef =  0.0_DP
!!$    SurfQMixDiffCoef = 800.0d2    ! Sugiyama et al. (2009) Nagare Multimedia
    SurfQVap         =  0.0_DP
!!$    SurfQVap         = 7.816d-4   ! Sugiyama et al. (2009) Nagare Multimedia


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                       ! (in)
        & nml = sl09_diffusion_nml, &         ! (out)
        & iostat = iostat_nml )               ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
    end if

    ! 
    ! Configure coefficients
    !
    kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )

    allocate( xyz_kv (0:imax-1, 1:jmax, 1:kmax) )
    do k = 1, kmax
      do j = 1, jmax
        if ( abs( y_Lat(j) ) * 180.0_DP / PI <= FrictionLBLat ) then
          xyz_kv(:,j,k) = 0.0_DP
        else
          xyz_kv(:,j,k) = kf &
            & * max( 0.0_DP, ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) )
        end if
      end do
    end do


    ! ľȻեå (Mellor and Yamada, 1974, ٥ 2)
    ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
    !
    call VDiffusionInit


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DUDtVDiffSL09', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'eastward wind tendency', 'm s-2' )
    call HistoryAutoAddVariable( 'DVDtVDiffSL09', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'northward wind tendency', 'm s-2' )
    call HistoryAutoAddVariable( 'DTempDtVDiffSL09', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'temperature tendency', 'K s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
    call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
    call MessageNotify( 'M', module_name, 'FrictionLBLat    = %f', d = (/ FrictionLBLat /) )
    call MessageNotify( 'M', module_name, 'LBHeatFlux       = %f', d = (/ LBHeatFlux /) )
    call MessageNotify( 'M', module_name, 'SurfQMixDiffCoef = %f', d = (/ SurfQMixDiffCoef /) )
    call MessageNotify( 'M', module_name, 'SurfQVap         = %f', d = (/ SurfQVap /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    sl09_diffusion_inited = .true.
  end subroutine SL09DiffusionInit

  !-------------------------------------------------------------------

end module sl09_diffusion
