!= 1 ׻ϳز桼ƥƥ⥸塼
!
!= Utility module for dynamics for 1-D calculation
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dynamics_1d_utils
  !
  != 1 ׻ϳز桼ƥƥ⥸塼
  !
  != Utility module for dynamics for 1-D calculation
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !

  !== References
  !
!!$  !  Chou, M.-D.,
!!$  !    Atmospheric solar heating rate in the water vapor bands,
!!$  !    J. Climate Appl. Meteor., 25, 1532-1542, 1986.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#set_1d_profile_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  implicit none

  private

  ! ѿ
  ! Public variables
  !
  logical, save, public:: dynamics_1d_utils_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: Dynamics1DUtilsVerAdv
  public :: Dynamics1DUtilsVerInterp
  public :: Dynamics1DUtilsInit

  character(*), parameter:: module_name = 'dynamics_1d_utils'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: dynamics_1d_utils.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine Dynamics1DUtilsVerAdv(  &
    & xyz_W, xyz_Height, xyz_Array,  &
    & xyz_VAdv                       &
    & )

    ! ⥸塼 ; USE statements
    !

    real(DP), intent(in ) :: xyz_W     (0:imax-1,1:jmax,1:kmax)
    real(DP), intent(in ) :: xyz_Height(0:imax-1,1:jmax,1:kmax)
    real(DP), intent(in ) :: xyz_Array (0:imax-1,1:jmax,1:kmax)
    real(DP), intent(out) :: xyz_VAdv  (0:imax-1,1:jmax,1:kmax)


    !
    ! local variables
    !
    integer :: i
    integer :: j
    integer :: k
    integer :: kp
    integer :: kn


    ! ǧ
    ! Initialization check
    !
    if ( .not. dynamics_1d_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do k = 1, kmax

      do j = 1, jmax
        do i = 0, imax-1

!!$          kp = max( k - 1, 1    )
!!$          kn = min( k + 1, kmax )
          if ( xyz_W(i,j,k) >= 0.0_DP ) then
            kp = max( k - 1, 1    )
            kn = kp + 1
          else
            kn = min( k + 1, kmax )
            kp = kn - 1
          end if
          xyz_VAdv(i,j,k) =                                                &
            & - xyz_W(i,j,k) * ( xyz_Array (i,j,kn) - xyz_Array (i,j,kp) ) &
            &                / ( xyz_Height(i,j,kn) - xyz_Height(i,j,kp) )
        end do
      end do

    end do

  end subroutine Dynamics1DUtilsVerAdv

  !--------------------------------------------------------------------------------------

  subroutine Dynamics1DUtilsVerInterp( &
    & NLev, z_Press, z_Array,          &
    & xyz_Press,                       &
    & xyz_Array                        &
    & )

    integer , intent(in ) :: NLev
    real(DP), intent(in ) :: z_Press  (1:NLev)
    real(DP), intent(in ) :: z_Array  (1:NLev)
    real(DP), intent(in ) :: xyz_Press(0:imax-1,1:jmax,1:kmax)
    real(DP), intent(out) :: xyz_Array(0:imax-1,1:jmax,1:kmax)


    !
    ! local variables
    !
    integer  :: k
    integer  :: kk


    ! ǧ
    ! Initiarization check
    !
    if ( .not. dynamics_1d_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do k = 1, kmax
      if( xyz_Press(0,1,k) <= z_Press(NLev) ) then
        xyz_Array(0,1,k) = z_Array(NLev)
      else
        search_loop : do kk = 2, NLev
          if( z_Press( kk ) < xyz_Press(0,1,k) ) exit search_loop
        end do search_loop
        if( kk > NLev ) &
          stop 'Unexpected error in setting vertical profile'
        xyz_Array(0,1,k) =                                  &
          &   ( z_Array( kk ) - z_Array( kk-1 ) )   &
          & / ( log( z_Press( kk )    / z_Press( kk-1 ) ) ) &
          & * ( log( xyz_Press(0,1,k) / z_Press( kk-1 ) ) ) &
          & + z_Array( kk-1 )
      end if
    end do

    do k = 1, kmax
      xyz_Array(:,:,k) = xyz_Array(0,1,k)
    end do


  end subroutine Dynamics1DUtilsVerInterp

  !--------------------------------------------------------------------------------------

  subroutine Dynamics1DUtilsInit

    ! ʸ
    ! Character handling
    !
!!$    use dc_string, only: toChar

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
!!$    use dc_iounit, only: FileOpen


    ! ʸ ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /set_TWPICE_profile_nml/ &
!!$      & InFileNameSounding, &
!!$      & InFileNameForcing
          !
          ! ǥեͤˤĤƤϽ³ "set_GATE_profile#SetGATEProfileInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "set_GATE_profile#SetGATEProfileInit" for the default values.
          !

    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = set_TWPICE_profile_nml,   & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'InFileNameSounding = %c', c1 = trim(InFileNameSounding) )
!!$    call MessageNotify( 'M', module_name, 'InFileNameForcing  = %c', c1 = trim(InFileNameForcing ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    dynamics_1d_utils_inited = .true.


  end subroutine Dynamics1DUtilsInit

  !--------------------------------------------------------------------------------------

  subroutine Dynamics1DUtilsFinalize


    ! ʸ ; Declaration statements
    !



    dynamics_1d_utils_inited = .false.


  end subroutine Dynamics1DUtilsFinalize

  !--------------------------------------------------------------------------------------

end module dynamics_1d_utils
