#= Rules for GNU make
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: rules.make,v 1.12 2012-02-23 23:09:47 takepiro Exp $
# Tag Name::  $Name:  $
# Copyright:: Copyright (C) GFD Dennou Club, 2006-. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file provides general rules for Makefiles.
# To use, "include" this file.
#
# [JAPANESE]
# Υեˤ Makefile ƤӽФ붦̥롼뤬
# ҤƤޤ. ΥեѤˤ,  Makefile 
# Υե include Ƥ.
#
############################################################

%.o: %.F90
	@test $< -ot depend || eval "rm -fv depend; $(MAKE) depend"
	$(FC) -o $@ -c $(FFLAGS) $(MODPATHFLAG)$(MODDIR) $(SYSFFLAGS) $(CPPFLAGS) $<
	@if [ -f $(MODFILE) ]; then \
	    test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR) ;\
	    $(CP) $(MODFILE) $(MODDIR) ;\
	    if [ ! `dirname $@` = "." ]; then \
		$(MV) $(MODFILE) `dirname $@` ;\
	    fi ;\
	fi

%.o: %.f90
	@test $< -ot depend || eval "rm -fv depend; $(MAKE) depend"
	$(FC) -o $@ -c $(FFLAGS) $(MODPATHFLAG)$(MODDIR) $(SYSFFLAGS) $<
	@if [ -f $(MODFILE) ]; then \
	    test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR) ;\
	    $(CP) $(MODFILE) $(MODDIR) ;\
	    if [ ! `dirname $@` = "." ]; then \
		$(MV) $(MODFILE) `dirname $@` ;\
	    fi ;\
	fi

%: %.o
	$(LINKF) -o $@ $+ $(SYSLDFLAGS) $(SYSLDLIBS)

$(LIBDIR)/$(DCPAMLIB): $(OBJS)
	test -d $(LIBDIR) || $(INSTALLDIR) $(LIBDIR)
	test -z "$+" || $(AR) $(ARFLAGS) $@ $+
	test -f $@ && $(RANLIB) $@ || true
	test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR)
	test -z "`ls $(CLEAN_MODS)`" || $(INSTALL) $(CLEAN_MODS) $(MODDIR)

test:
	@for i in $(TESTS) ; do \
	  $(SH) ./$$i || \
	    eval " echo ; echo \"  *** Error is occured in $$i ***\" ; echo  ; exit 1" ; \
	done

clean:
	-@$(RM) $(wildcard $(CLEAN_MODS) $(OBJS) $(CLEAN_TESTS) $(TARGETS) $(TMPFILES) *~)
	-@$(RM) $(wildcard $(OBJS:%.o=$(MODDIR)/%$(MODSUFFIX)))
	@test -d $(MODDIR) && $(RMDIR) $(MODDIR) 2> /dev/null || true

clean.lib:
	-@$(RM) $(wildcard $(LIBDIR)/$(DCPAMLIB))
	-@$(RM) $(wildcard $(MODDIR)/$(CLEAN_MODS))

clean.bin:
	-cd $(BINDIR) ; $(RM) $(wildcard $(TARGETS))

clean.rb2f90:
	-@$(RM) $(wildcard $(RB2F90))

depend: Makefile
	if [ `ls ../*/*.F90 2> /dev/null | wc -l` -gt 0 ]; then \
		$(F90DEPEND) $(F90DEPENDOPTS) $(wildcard *.f90 *.F90) ../*/*.f90 ../*/*.F90 > $@ ; \
	else \
		$(F90DEPEND) $(F90DEPENDOPTS) $(wildcard *.f90 *.F90) ../*/*.f90 > $@ ; \
	fi

depend.for.test: Makefile
	$(F90DEPEND) $(F90DEPENDOPTS) $(wildcard *.f90 *.F90) ../../src/*/*.f90 ../../src/*/*.F90 > depend

######################################################################
#== Mode setting for Emacs
#Local Variables:
#mode: makefile
#End:
#
