!= 主成分相変化
!
!= Phase change of atmospheric major component
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_major_comp
  !
  != 主成分相変化
  !
  != Phase change of atmospheric major component
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== References
  !
  ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
  !   A Martian general circulation experiment with large topography, 
  !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: 乾燥対流調節
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#saturate_major_comp_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING     ! 文字列.       Strings. 

  ! NAMELIST ファイル入力に関するユーティリティ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST から読み込む配列の最大サイズ. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private


  integer, save      :: IndexSpc
  integer, parameter :: IndexSpcCO2     = 1


  real(DP), parameter :: LatentHeatCO2Subl = 5.9d5
                              ! Latent heat of CO2 (J kg^{-1})
                              ! This value is obtained from Pollack et al. 
                              ! (1981) and Forget et al. (1998).

  ! 公開手続き
  ! Public procedure
  !
  public :: SaturateMajorCompCalcCondTemp
  public :: SaturateMajorCompInqLatentHeat
  public :: SaturateMajorCompInit

  ! 公開変数
  ! Public variables
  !
  logical, save, public:: saturate_major_comp_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag

  ! 非公開変数
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate_major_comp'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version


  interface SaturateMajorCompCalcCondTemp
    module procedure &
      SaturateMajorCompCalcCondTemp3D, &
      SaturateMajorCompCalcCondTemp2D
  end interface


contains

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompCalcCondTemp3D(  &
    & xyz_Press,                               &  ! (in)
    & xyz_TempCond                             &  ! (inout)
    & )
    !
    ! 主成分相変化
    !
    ! Major component phase change
    !

    ! モジュール引用 ; USE statements
    !

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    use saturate_co2_p81, only : xyz_SaturateCO2P81TempCond


    ! 宣言文 ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press   (:,:,:)
                              ! $ p $ . 気圧 (整数レベル). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyz_TempCond(:,:,:)
                              !
                              ! Condensation temperature

    ! 作業変数
    ! Work variables
    !

    ! 実行文 ; Executable statement
    !


    ! 初期化
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( IndexSpc )
    case ( IndexSpcCO2 )
      ! CO2 condensation temperature

      xyz_TempCond = xyz_SaturateCO2P81TempCond( xyz_Press )

    end select


  end subroutine SaturateMajorCompCalcCondTemp3D

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompCalcCondTemp2D(  &
    & xy_Press,                                &  ! (in)
    & xy_TempCond                              &  ! (inout)
    & )
    !
    ! 主成分相変化
    !
    ! Major component phase change
    !

    ! モジュール引用 ; USE statements
    !


    ! 宣言文 ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_Press   (:,:)
                              ! $ p $ . 気圧 (整数レベル). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xy_TempCond(:,:)
                              !
                              ! Condensation temperature

    ! 作業変数
    ! Work variables
    !
    real(DP) :: xyz_Press   (size(xy_Press   ,1),size(xy_Press   ,2),1)
    real(DP) :: xyz_TempCond(size(xy_TempCond,1),size(xy_TempCond,2),1)


    ! 実行文 ; Executable statement
    !


    ! 初期化
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    xyz_Press(:,:,1) = xy_Press

    call SaturateMajorCompCalcCondTemp3D(  &
      & xyz_Press,                         &  ! (in)
      & xyz_TempCond                       &  ! (inout)
      & )

    xy_TempCond = xyz_TempCond(:,:,1)


  end subroutine SaturateMajorCompCalcCondTemp2D

  !--------------------------------------------------------------------------------------

  function SaturateMajorCompInqLatentHeat( ) result( LatentHeat )
    !
    ! 主成分の潜熱を返しします. 
    !
    ! Inquiry of latent heat of major component
    !

    ! モジュール引用 ; USE statements
    !

    ! メッセージ出力
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 宣言文 ; Declaration statements
    !
    implicit none

    real(DP) :: LatentHeat


    ! 実行文 ; Executable statement
    !

    ! 初期化
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Set latent heat
    select case ( IndexSpc )
    case ( IndexSpcCO2  )
      LatentHeat = LatentHeatCO2Subl
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select


  end function SaturateMajorCompInqLatentHeat

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompInit(  &
    & CondMajCompName                & ! (in)
    & )
    !
    ! saturate_major_comp モジュールの初期化を行います. 
    ! NAMELIST#saturate_major_comp_nml の読み込みはこの手続きで行われます. 
    !
    ! "saturate_major_comp" module is initialized. 
    ! "NAMELIST#saturate_major_comp_nml" is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

!!$    ! NAMELIST ファイル入力に関するユーティリティ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
!!$
!!$    ! ファイル入出力補助
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! 種別型パラメタ
!!$    ! Kind type parameter
!!$    !
!!$    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: StoA

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    use saturate_co2_p81, only : SaturateCO2P81Init


    ! 宣言文 ; Declaration statements
    !
    implicit none

    character(*), intent(in) :: CondMajCompName
                                        ! Condensable major component


!!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
!!$    namelist /saturate_major_comp_nml/ &
!!$      & FlagUse

          ! デフォルト値については初期化手続 "saturate_major_comp#MajorCompSaturateInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_major_comp#MajorCompSaturateInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( saturate_major_comp_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                    &  ! (in)
!!$        & nml = saturate_major_comp_nml, &  ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
!!$    end if


    ! Set index
    select case ( CondMajCompName )
    case ( 'CO2' )
      IndexSpc = IndexSpcCO2
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select


    ! Initialization of modules called in this module
    !

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    call SaturateCO2P81Init


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    saturate_major_comp_inited = .true.

  end subroutine SaturateMajorCompInit

  !-------------------------------------------------------------------

end module saturate_major_comp
