!= wrapper of RRTMG
!
!= wrapper of RRTMG
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module rad_rrtmg_wrapper
  !
  != wrapper of RRTMG
  !
  != wrapper of RRTMG
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! This is a wrapper program of radiation model, RRTMG.
  !

  ! Preparation
  ! * Extract src/radiation_rrtmg.tgz
  !   * src/radiation_rrtmg.tgz includes rrtmg_lw_read_nc_wrapper, 
  !     rrtmg_sw_read_nc_wrapper, and Makefile.
  ! * Copy following files from rrtmg_lw_v4.85 and rrtmg_sw_v3.9 packages to 
  !   dcpam5/src/radiation_rrtmg.
  !   % cp rrtmg_lw_v4.85/gcm_model/src/... dcpam5/src/radiation_rrtmg
  !   Copied files:
  !     parkind.f90 parrrsw.f90 parrrtm.f90 
  !     rrlw_cld.f90 rrlw_con.f90
  !     rrlw_kg01.f90 rrlw_kg02.f90 rrlw_kg03.f90 rrlw_kg04.f90 rrlw_kg05.f90
  !     rrlw_kg06.f90 rrlw_kg07.f90 rrlw_kg08.f90 rrlw_kg09.f90 rrlw_kg10.f90
  !     rrlw_kg11.f90 rrlw_kg12.f90 rrlw_kg13.f90 rrlw_kg14.f90 rrlw_kg15.f90
  !     rrlw_kg16.f90
  !     rrlw_ncpar.f90 rrlw_ref.f90 rrlw_tbl.f90 rrlw_vsn.f90 rrlw_wvn.f90
  !     rrtmg_lw_cldprmc.f90 rrtmg_lw_cldprop.f90 rrtmg_lw_init.f90
  !     rrtmg_lw_rad.nomcica.f90 rrtmg_lw_read_nc.f90 rrtmg_lw_rtrn.f90
  !     rrtmg_lw_rtrnmc.f90 rrtmg_lw_rtrnmr.f90 rrtmg_lw_setcoef.f90
  !     rrtmg_lw_taumol.f90 
  !     rrsw_aer.f90 rrsw_cld.f90 rrsw_con.f90
  !     rrsw_kg16.f90 rrsw_kg17.f90 rrsw_kg18.f90 rrsw_kg19.f90 rrsw_kg20.f90
  !     rrsw_kg21.f90 rrsw_kg22.f90 rrsw_kg23.f90 rrsw_kg24.f90 rrsw_kg25.f90
  !     rrsw_kg26.f90 rrsw_kg27.f90 rrsw_kg28.f90 rrsw_kg29.f90 
  !     rrsw_ncpar.f90 rrsw_ref.f90 rrsw_tbl.f90 rrsw_vsn.f90 rrsw_wvn.f90
  !     rrtmg_sw_cldprmc.f90 rrtmg_sw_cldprop.f90 rrtmg_sw_init.f90
  !     rrtmg_sw_rad.nomcica.f90 rrtmg_sw_read_nc.f90 rrtmg_sw_reftra.f90
  !     rrtmg_sw_setcoef.f90 rrtmg_sw_spcvmc.f90 rrtmg_sw_spcvrt.f90
  !     rrtmg_sw_taumol.f90 rrtmg_sw_vrtqdr.f90
  ! * Add a following line in rrtmg_lw_init.f90.
  !     use rrtmg_lw_read_nc_wrapper
  ! * Add a following line in rrtmg_sw_init.f90.
  !     use rrtmg_sw_read_nc_wrapper
  ! * Compile with FFLAGS=-DRRTMG
  !   * Add radiation_rrtmg in LIBDIRS in src/Makefile
  !   * Perform make clean.depend after configuration once
  !   * Perform make depend
  !   * Perform make distclean
  !   * Perform configure with FFLAGS=-DRRTMG
  !   * Perform make
  !
  !== References
  !
  !
  !== Procedures List
  !
!!$  ! RadEarthV2Flux :: 放射フラックスの計算
!!$  ! ------------          :: ------------
!!$  ! RadEarthV2Flux :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_rrtmg_wrapper_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  !
  ! Physical constants settings
  !
  use constants, only: Grav     ! $ g $ [m s-2].
                                !
                                ! Gravitational acceleration

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数.
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数.
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数.
                             ! Number of vertical level

  implicit none

  private

  real(DP), save :: MeanMolWeight
  real(DP), save :: H2OMolWeight
  real(DP), save :: CO2MolWeight
  real(DP), save :: N2OMolWeight
  real(DP), save :: CH4MolWeight

  integer, save     :: IDCloudIceREffMethod
  !
  integer, parameter:: IDCloudIceREffMethodConst = 0
  integer, parameter:: IDCloudIceREffMethodLin   = 1

  real(DP), save :: CloudWatREff
  real(DP), save :: CloudIceREff

  real(DP), allocatable, save :: xyz_QO3(:,:,:)
                              ! O3 分布 (1)
                              ! O3 distribution (1)

!!$  integer , save              :: SWVer
!!$  integer , save              :: LWVer

  ! 公開変数
  ! Public variables
  !
  logical, save :: rad_rrtmg_wrapper_inited = .false.
                              ! 初期設定フラグ.
                              ! Initialization flag

  public :: RadRRTMGWrapperFlux
  public :: RadRRTMGWrapperInit


  character(*), parameter:: module_name = 'rad_rrtmg_wrapper'
                              ! モジュールの名称.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadRRTMGWrapperFlux(               &
    & xy_SurfAlbedo,                            & ! (in)
    & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp, & ! (in)
    & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,    & ! (in)
    & xyz_CloudCover,                           & ! (in)
    & xy_SurfTemp,                              & ! (in)
    & xyr_RadSUwFlux, xyr_RadSDwFlux,           & ! (out)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,           & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux    & ! (out)
    & )


    ! USE statements
    !

    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)

!!$    real(DP):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$    real(DP):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    ! Work variables
    !
    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)

    integer  :: k


    ! 初期化確認
    ! Initialization check
    !
    if ( .not. rad_rrtmg_wrapper_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

#ifndef RRTMG
    call MessageNotify( 'E', module_name, 'RRTMG modules are not included in compilation.' )
#endif

    do k = 1, kmax
      xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
    end do

    call RadRRTMGWrapperFluxCore(                          &
      & xy_SurfAlbedo,                                     &
      & xyz_DelAtmMass, &
      & xyz_Press, xyr_Press, &
      & xyz_Temp, xyr_Temp, &
      & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
      & xyz_CloudCover,                                    &
      & xy_SurfTemp,                                       &
      & xyr_RadSUwFlux, xyr_RadSDwFlux,                    &
      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
      & )


  end subroutine RadRRTMGWrapperFlux

  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine RadEarthV2FluxforNHM(                                          &
!!$    & r_Height, xy_SurfAlbedo,                                              &
!!$    & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
!!$    & xy_SurfTemp,                                                          &
!!$    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                          &
!!$    & )
!!$
!!$
!!$    ! USE statements
!!$    !
!!$
!!$    real(DP), intent(in ) :: r_Height                          (0:kmax)
!!$    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
!!$    real(DP), intent(in ) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
!!$    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
!!$    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$
!!$
!!$    ! Work variables
!!$    !
!!$    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
!!$
!!$    integer  :: k
!!$
!!$
!!$    ! 初期化確認
!!$    ! Initialization check
!!$    !
!!$    if ( .not. rad_Earth_V2_inited ) then
!!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
!!$    end if
!!$
!!$
!!$    do k = 1, kmax
!!$      xyz_DelAtmMass(:,:,k) = xyz_Dens(:,:,k) * ( r_Height(k) - r_Height(k-1) )
!!$    end do
!!$
!!$    call RadEarthV2FluxCore(                                                        &
!!$      & xy_SurfAlbedo,                                                              &
!!$      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
!!$      & xy_SurfTemp,                                                                &
!!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                &
!!$      & )
!!$
!!$
!!$  end subroutine RadEarthV2FluxforNHM
!!$
  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine RadDcpamEV2FluxforNHM2DWrapper(                    &
!!$    & r_Height, x_SurfAlbedo,                                   &
!!$    & xz_Dens, xz_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,       &
!!$    & x_SurfTemp,                                               &
!!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                 &
!!$    & )
!!$
!!$
!!$    ! USE statements
!!$    !
!!$
!!$
!!$    real(DP), intent(in ) :: r_Height                 (0:kmax)
!!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
!!$    real(DP), intent(in ) :: xz_Dens        (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
!!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
!!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
!!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
!!$
!!$
!!$    ! Work variables
!!$    !
!!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
!!$    real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
!!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$
!!$    integer  :: k
!!$
!!$
!!$    ! 初期化確認
!!$    ! Initialization check
!!$    !
!!$    if ( .not. rad_dcpam_E_V2_inited ) then
!!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
!!$    end if
!!$
!!$
!!$    if ( jmax /= 1 ) then
!!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
!!$    end if
!!$
!!$
!!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
!!$    do k = 1, kmax
!!$      xyz_Dens        (:, 1, k)    = xz_Dens        (:, k)
!!$      xyz_Press       (:, 1, k)    = xz_Press       (:, k)
!!$      xyz_Temp        (:, 1, k)    = xz_Temp        (:, k)
!!$      xyz_QH2OVap     (:, 1, k)    = xz_QH2OVap     (:, k)
!!$      xyz_QH2OLiq     (:, 1, k)    = xz_QH2OLiq     (:, k)
!!$    end do
!!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
!!$
!!$    call RadDcpamEV2FluxforNHM(                                       &
!!$      & r_Height, xy_SurfAlbedo,                                      &
!!$      & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,      &
!!$      & xy_SurfTemp,                                                  &
!!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
!!$      & )
!!$
!!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
!!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
!!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
!!$
!!$
!!$  end subroutine RadDcpamEV2FluxforNHM2DWrapper
!!$
  !--------------------------------------------------------------------------------------
!!$
!!$  subroutine RadDcpamEV2Flux2DWrapper(                         &
!!$    & x_SurfAlbedo,                                            &
!!$    & xz_Press, xr_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,     &
!!$    & x_SurfTemp,                                              &
!!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                &
!!$    & )
!!$
!!$
!!$    ! USE statements
!!$    !
!!$
!!$
!!$
!!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
!!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xr_Press       (0:imax-1, 0:kmax)
!!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
!!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
!!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
!!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
!!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
!!$
!!$
!!$    ! Work variables
!!$    !
!!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
!!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
!!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
!!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$
!!$
!!$    ! 初期化確認
!!$    ! Initialization check
!!$    !
!!$    if ( .not. rad_dcpam_E_V2_inited ) then
!!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
!!$    end if
!!$
!!$
!!$    if ( jmax /= 1 ) then
!!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
!!$    end if
!!$
!!$
!!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
!!$    xyz_Press       (:, 1, :)    = xz_Press       (:, :)
!!$    xyr_Press       (:, 1, :)    = xr_Press       (:, :)
!!$    xyz_Temp        (:, 1, :)    = xz_Temp        (:, :)
!!$    xyz_QH2OVap     (:, 1, :)    = xz_QH2OVap     (:, :)
!!$    xyz_QH2OLiq     (:, 1, :)    = xz_QH2OLiq     (:, :)
!!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
!!$
!!$    call RadDcpamEV2Flux(                                             &
!!$      & xy_SurfAlbedo,                                                &
!!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
!!$      & xy_SurfTemp,                                                  &
!!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
!!$      & )
!!$
!!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
!!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
!!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
!!$
!!$
!!$  end subroutine RadDcpamEV2Flux2DWrapper
!!$
  !--------------------------------------------------------------------------------------

  subroutine RadRRTMGWrapperFluxCore(                          &
    & xy_SurfAlbedo,                                           &
    & xyz_DelAtmMass,                                          &
    & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp,                &
    & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,                   &
    & xyz_CloudCover,                                          &
    & xy_SurfTemp,                                             &
    & xyr_RadSUwFlux, xyr_RadSDwFlux,                          &
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )


    ! USE statements
    !

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 時刻管理
    ! Time control
    !
    use timeset, only: &
      & TimeN                 ! ステップ $ t $ の時刻.
                              ! Time of step $ t $.

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    use set_gcmr, only : SetGCMR

    ! O3 分布の設定
    ! Set O3 distribution
    !
    use set_o3, only: SetO3

!!$    ! 地球大気向け短波放射モデル Ver. 2.6
!!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
!!$    !
!!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Flux
!!$
!!$    ! 地球大気向け長波放射モデル Ver. 2.4
!!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
!!$    !
!!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Flux

#ifdef RRTMG
    ! RRTMG modules
    ! RRTMG modules
    !
    use parrrtm, only : nbndlw
    use rrtmg_lw_rad, only : rrtmg_lw
    use parrrsw, only : nbndsw, naerec
    use rrtmg_sw_rad, only : rrtmg_sw
#endif

    ! 太陽放射フラックスの設定
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConst

    ! 短波入射 (太陽入射)
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome


    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


#ifdef RRTMG
    ! Work variables
    !
    real(DP) :: VMRCO2
    real(DP) :: xyz_QCO2         (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: VMRN2O
    real(DP) :: xyz_QN2O         (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: VMRCH4
    real(DP) :: xyz_QCH4         (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyz_DelCO2Mass   (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelN2OMass   (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelCH4Mass   (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xy_CloudCoverRand(0:imax-1, 1:jmax)


    ! ----- Input -----
    integer :: ncol
    ! Number of horizontal columns
    integer :: nlay
    ! Number of model layers
    integer :: icld
    ! Cloud overlap method
    !    0: Clear only
    !    1: Random
    !    2: Maximum/random
    !    3: Maximum
    integer :: idrv
    ! Flag for calculation of dFdT, the change
    !    in upward flux as a function of
    !    surface temperature [0=off, 1=on]
    !    0: Normal forward calculation
    !    1: Normal forward calculation with
    !       duflx_dt and duflxc_dt output

    real(DP) :: az_play( 1:imax*jmax, 1:kmax )
    ! Layer pressures (hPa, mb)
    !    Dimensions: (ncol,nlay)
    real(DP) :: ar_plev( 1:imax*jmax, 0:kmax )
    ! Interface pressures (hPa, mb)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: az_tlay( 1:imax*jmax, 1:kmax )
    ! Layer temperatures (K)
    !    Dimensions: (ncol,nlay)
    real(DP) :: ar_tlev( 1:imax*jmax, 0:kmax )
    ! Interface temperatures (K)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: a_tsfc( 1:imax*jmax )
    ! Surface temperature (K)
    !    Dimensions: (ncol)
    real(DP) :: az_h2ovmr( 1:imax*jmax, 1:kmax )
    ! H2O volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_o3vmr( 1:imax*jmax, 1:kmax )
    ! O3 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_co2vmr( 1:imax*jmax, 1:kmax )
    ! CO2 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_ch4vmr( 1:imax*jmax, 1:kmax )
    ! Methane volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_n2ovmr( 1:imax*jmax, 1:kmax )
    ! Nitrous oxide volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_o2vmr( 1:imax*jmax, 1:kmax )
    ! Oxygen volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_cfc11vmr( 1:imax*jmax, 1:kmax )
    ! CFC11 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_cfc12vmr( 1:imax*jmax, 1:kmax )
    ! CFC12 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_cfc22vmr( 1:imax*jmax, 1:kmax )
    ! CFC22 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_ccl4vmr( 1:imax*jmax, 1:kmax )
    ! CCL4 volume mixing ratio
    !    Dimensions: (ncol,nlay)
    real(DP) :: aa_emis( 1:imax*jmax, 1:kmax )
    ! Surface emissivity
    !    Dimensions: (ncol,nbndlw)

    integer :: inflglw         ! Flag for cloud optical properties
    integer :: iceflglw        ! Flag for ice particle specification
    integer :: liqflglw        ! Flag for liquid droplet specification

    real(DP) :: az_cldfr( 1:imax*jmax, 1:kmax )
    ! Cloud fraction
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_cicewp( 1:imax*jmax, 1:kmax )
    ! Cloud ice water path (g/m2)
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_cliqwp( 1:imax*jmax, 1:kmax )
    ! Cloud liquid water path (g/m2)
    !    Dimensions: (ncol,nlay)
    real(DP) :: az_reice( 1:imax*jmax, 1:kmax )
    ! Cloud ice particle effective size (microns)
    !    Dimensions: (ncol,nlay)
    ! specific definition of reice depends on setting of iceflglw:
    ! iceflglw = 0: ice effective radius, r_ec, (Ebert and Curry, 1992),
    !               r_ec must be >= 10.0 microns
    ! iceflglw = 1: ice effective radius, r_ec, (Ebert and Curry, 1992),
    !               r_ec range is limited to 13.0 to 130.0 microns
    ! iceflglw = 2: ice effective radius, r_k, (Key, Streamer Ref. Manual, 1996)
    !               r_k range is limited to 5.0 to 131.0 microns
    ! iceflglw = 3: generalized effective size, dge, (Fu, 1996),
    !               dge range is limited to 5.0 to 140.0 microns
    !               [dge = 1.0315 * r_ec]
    real(DP) :: az_reliq( 1:imax*jmax, 1:kmax )
    ! Cloud water drop effective radius (microns)
    !    Dimensions: (ncol,nlay)
    real(DP) :: aaz_taucld( 1:nbndlw, 1:imax*jmax, 1:kmax )
    ! In-cloud optical depth
    !    Dimensions: (nbndlw,ncol,nlay)
    real(DP) :: aza_tauaer( 1:imax*jmax, 1:kmax, 1:nbndlw )
    ! aerosol optical depth
    !    Dimensions: (ncol,nlay,nbndlw)

! ----- Output -----

    real(DP) :: ar_uflx( 1:imax*jmax, 0:kmax )
    ! Total sky longwave upward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: ar_dflx( 1:imax*jmax, 0:kmax )
    ! Total sky longwave downward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: az_hr( 1:imax*jmax, 1:kmax )
    ! Total sky longwave radiative heating rate (K/d)
    !    Dimensions: (ncol,nlay)
    real(DP) :: ar_uflxc( 1:imax*jmax, 0:kmax )
    ! Clear sky longwave upward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: ar_dflxc( 1:imax*jmax, 0:kmax )
    ! Clear sky longwave downward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: az_hrc( 1:imax*jmax, 1:kmax )
    ! Clear sky longwave radiative heating rate (K/d)
    !    Dimensions: (ncol,nlay)

! ----- Optional Output -----
    real(DP) :: ar_duflx_dt( 1:imax*jmax, 0:kmax )
    ! change in upward longwave flux (w/m2/k)
    ! with respect to surface temperature
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: ar_duflxc_dt( 1:imax*jmax, 0:kmax )
    ! change in clear sky upward longwave flux (w/m2/k)
    ! with respect to surface temperature
    !    Dimensions: (ncol,nlay+1)




    ! ----- Input -----
    integer :: iaer
    ! Aerosol option flag
    !    0: No aerosol
    !    6: ECMWF method
    !    10:Input aerosol optical
    !       properties

    real(DP) :: a_asdir( imax*jmax )
    ! UV/vis surface albedo direct rad
    !    Dimensions: (ncol)
    real(DP) :: a_aldir( imax*jmax )
    ! Near-IR surface albedo direct rad
    !    Dimensions: (ncol)
    real(DP) :: a_asdif( imax*jmax )
    ! UV/vis surface albedo: diffuse rad
    !    Dimensions: (ncol)
    real(DP) :: a_aldif( imax*jmax )
    ! Near-IR surface albedo: diffuse rad
    !    Dimensions: (ncol)

    integer :: dyofyr
    ! Day of the year (used to get Earth/Sun
    !  distance if adjflx not provided)
    real(DP) :: adjes
    ! Flux adjustment for Earth/Sun distance
    real(DP) :: a_coszen( imax*jmax )
    ! Cosine of solar zenith angle
    !    Dimensions: (ncol)
    real(DP) :: scon
    ! Solar constant (W/m2)

    integer :: inflgsw
    ! Flag for cloud optical properties
    integer :: iceflgsw
    ! Flag for ice particle specification
    integer :: liqflgsw
    ! Flag for liquid droplet specification

    real(DP) :: aaz_ssacld( 1:nbndsw, 1:imax*jmax, 1:kmax )
    ! In-cloud single scattering albedo
    !    Dimensions: (nbndsw,ncol,nlay)
    real(DP) :: aaz_asmcld( 1:nbndsw, 1:imax*jmax, 1:kmax )
    ! In-cloud asymmetry parameter
    !    Dimensions: (nbndsw,ncol,nlay)
    real(DP) :: aaz_fsfcld( 1:nbndsw, 1:imax*jmax, 1:kmax )
    ! In-cloud forward scattering fraction
    !    Dimensions: (nbndsw,ncol,nlay)
    real(DP) :: aza_ssaaer( 1:imax*jmax, 1:kmax, 1:nbndsw )
    ! Aerosol single scattering albedo (iaer=10 only)
    !    Dimensions: (ncol,nlay,nbndsw)
    ! (non-delta scaled)
    real(DP) :: aza_asmaer( 1:imax*jmax, 1:kmax, 1:nbndsw )
    ! Aerosol asymmetry parameter (iaer=10 only)
    !    Dimensions: (ncol,nlay,nbndsw)
    ! (non-delta scaled)
    real(DP) :: aza_ecaer( 1:imax*jmax, 1:kmax, 1:naerec )
    ! Aerosol optical depth at 0.55 micron (iaer=6 only)
    !    Dimensions: (ncol,nlay,naerec)
    ! (non-delta scaled)

    ! ----- Output -----

    real(DP) :: ar_swuflx( 1:imax*jmax, 0:kmax )
    ! Total sky shortwave upward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: ar_swdflx( 1:imax*jmax, 0:kmax )
    ! Total sky shortwave downward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: az_swhr( 1:imax*jmax, 1:kmax )
    ! Total sky shortwave radiative heating rate (K/d)
    !    Dimensions: (ncol,nlay)
    real(DP) :: ar_swuflxc( 1:imax*jmax, 0:kmax )
    ! Clear sky shortwave upward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: ar_swdflxc( 1:imax*jmax, 0:kmax )
    ! Clear sky shortwave downward flux (W/m2)
    !    Dimensions: (ncol,nlay+1)
    real(DP) :: az_swhrc( 1:imax*jmax, 1:kmax )
    ! Clear sky shortwave radiative heating rate (K/d)
    !    Dimensions: (ncol,nlay)

    real(DP) :: SolarConst

    real(DP) :: xy_CosZet    (0:imax-1, 1:jmax)
    real(DP) :: DistFromStarScld
                               ! Distance between the central star and the planet
    real(DP) :: DiurnalMeanFactor

    real(DP) :: xyr_RadCSSUwFlux(0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadCSSDwFlux(0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadCSLUwFlux(0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadCSLDwFlux(0:imax-1, 1:jmax, 0:kmax)


    integer :: i
    integer :: j
    integer :: k
    integer :: l


    ! 初期化確認
    ! Initialization check
    !
    if ( .not. rad_rrtmg_wrapper_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    call SetGCMR( &
      & 'CO2',    & ! (in)
      & VMRCO2    & ! (out)
      & )
    xyz_QCO2 = VMRCO2 * CO2MolWeight / MeanMolWeight

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    call SetGCMR( &
      & 'N2O',    & ! (in)
      & VMRN2O    & ! (out)
      & )
    xyz_QN2O = VMRN2O * N2OMolWeight / MeanMolWeight

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    call SetGCMR( &
      & 'CH4',    & ! (in)
      & VMRCH4    & ! (out)
      & )
    xyz_QCH4 = VMRCH4 * CH4MolWeight / MeanMolWeight


    ! O3 分布の設定
    ! Setting of O3 distribution
    !
    call SetO3( &
      & xyz_Press, & ! (in )
      & xyz_QO3    & ! (out)
      & )


    !
    ! Set cloud effective radius
    !
    xyz_CloudWatREff = CloudWatREff
    !
    select case ( IDCloudIceREffMethod )
    case ( IDCloudIceREffMethodConst )
      xyz_CloudIceREff = CloudIceREff
    case ( IDCloudIceREffMethodLin )
      ! This is a simple model mimicing a result of Ou and Liou (1995).
      ! This was used in MRI model probably.
      xyz_CloudIceREff = &
        &   ( 20.0e-6_DP              - 150.0e-6_DP             ) &
        & / ( ( 273.15_DP - 60.0_DP ) - ( 273.15_DP - 20.0_DP ) ) &
        & * ( xyz_Temp                - ( 273.15_DP - 20.0_DP ) ) &
        & + 150.0e-6_DP
      xyz_CloudIceREff = min( max( xyz_CloudIceREff, 20.0e-6_DP ), 150.0e-6_DP )
    end select


    xyz_DelCO2Mass    = xyz_DelAtmMass * xyz_QCO2
    xyz_DelH2OVapMass = xyz_DelAtmMass * xyz_QH2OVap
    xyz_DelH2OLiqMass = xyz_DelAtmMass * xyz_QH2OLiq
    xyz_DelH2OSolMass = xyz_DelAtmMass * xyz_QH2OSol
    xyz_DelO3Mass     = xyz_DelAtmMass * xyz_QO3
    xyz_DelN2OMass    = xyz_DelAtmMass * xyz_QN2O
    xyz_DelCH4Mass    = xyz_DelAtmMass * xyz_QCH4




    ncol = imax * jmax
    ! Number of horizontal columns
    nlay = kmax
    ! Number of model layers
    icld = 1
    ! Cloud overlap method
    !    0: Clear only
    !    1: Random
    !    2: Maximum/random
    !    3: Maximum
    idrv = 1
    ! Flag for calculation of dFdT, the change
    !    in upward flux as a function of
    !    surface temperature [0=off, 1=on]
    !    0: Normal forward calculation
    !    1: Normal forward calculation with
    !       duflx_dt and duflxc_dt output

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        do k = 1, kmax
          az_play( l, k ) = xyz_Press(i,j,k) * 1.0e-2_DP
          ! Layer pressures (hPa, mb)
          !    Dimensions: (ncol,nlay)
        end do
        do k = 0, kmax
          ar_plev( l, k ) = xyr_Press(i,j,k) * 1.0e-2_DP
          ! Interface pressures (hPa, mb)
          !    Dimensions: (ncol,nlay+1)
        end do
        do k = 1, kmax
          az_tlay( l, k ) = xyz_Temp(i,j,k)
          ! Layer temperatures (K)
          !    Dimensions: (ncol,nlay)
        end do
        do k = 0, kmax
          ar_tlev( l, k ) = xyr_Temp(i,j,k)
          ! Interface temperatures (K)
          !    Dimensions: (ncol,nlay+1)
        end do
        a_tsfc( l ) = xy_SurfTemp(i,j)
        ! Surface temperature (K)
        !    Dimensions: (ncol)
        do k = 1, kmax
          az_h2ovmr( l, k ) = xyz_QH2OVap(i,j,k) * MeanMolWeight / H2OMolWeight
          ! H2O volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_o3vmr( l, k ) = xyz_QO3(i,j,k) * MeanMolWeight / ( 16.0_DP * 3.0_DP * 1.0e-3_DP )
          ! O3 volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_co2vmr( l, k ) = xyz_QCO2(i,j,k) * MeanMolWeight / CO2MolWeight
          ! CO2 volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_ch4vmr( l, k ) = xyz_QCH4(i,j,k) * MeanMolWeight / CH4MolWeight
          ! Methane volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_n2ovmr( l, k ) = xyz_QN2O(i,j,k) * MeanMolWeight / N2OMolWeight
          ! Nitrous oxide volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_o2vmr( l, k ) = 0.21_DP
          ! Oxygen volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_cfc11vmr( l, k ) = 0.0_DP
          ! CFC11 volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_cfc12vmr( l, k ) = 0.0_DP
          ! CFC12 volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_cfc22vmr( l, k ) = 0.0_DP
          ! CFC22 volume mixing ratio
          !    Dimensions: (ncol,nlay)
          az_ccl4vmr( l, k ) = 0.0_DP
          ! CCL4 volume mixing ratio
          !    Dimensions: (ncol,nlay)
        end do
      end do
    end do

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        do k = 1, kmax
!!$          az_cldfr( l, k ) = xyz_CloudCover(i,j,k)
          az_cldfr( l, k ) = 1.0_DP
          ! Cloud fraction
          !    Dimensions: (ncol,nlay)
!!$          az_cicewp( l, k ) = xyz_DelH2OSolMass(i,j,k) * 1.0e3_DP
          az_cicewp( l, k ) = xyz_DelH2OSolMass(i,j,k) * 1.0e3_DP * xyz_CloudCover(i,j,k)**1.5
          ! Cloud ice water path (g/m2)
          !    Dimensions: (ncol,nlay)
!!$          az_cliqwp( l, k ) = xyz_DelH2OLiqMass(i,j,k) * 1.0e3_DP
          az_cliqwp( l, k ) = xyz_DelH2OLiqMass(i,j,k) * 1.0e3_DP * xyz_CloudCover(i,j,k)**1.5
          ! Cloud liquid water path (g/m2)
          !    Dimensions: (ncol,nlay)
          az_reice( l, k ) = xyz_CloudIceREff(i,j,k) * 1.0e6_DP
          ! Cloud ice particle effective size (microns)
          !    Dimensions: (ncol,nlay)
          az_reliq( l, k ) = xyz_CloudWatREff(i,j,k) * 1.0e6_DP
          ! Cloud water drop effective radius (microns)
          !    Dimensions: (ncol,nlay)
          aaz_taucld( :, l, k ) = 0.0_DP
          !            This is updated in rrtmg_lw when inflglw /= 0
          ! In-cloud optical depth
          !    Dimensions: (nbndlw,ncol,nlay)
          aza_tauaer( l, k, : ) = 0.0_DP
          ! aerosol optical depth
          !    Dimensions: (ncol,nlay,nbndlw)
        end do
      end do
    end do



    ! 太陽放射フラックスの設定
    ! Set solar constant
    !
    call SetSolarConst( &
      & SolarConst      & ! (out)
      & )

    ! 短波入射の計算
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_CosZet         = xy_CosZet,         & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )


    ! ----- Input -----
    iaer = 0
    ! Aerosol option flag
    !    0: No aerosol
    !    6: ECMWF method
    !    10:Input aerosol optical
    !       properties

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        a_asdir( l ) = xy_SurfAlbedo(i,j)
        ! UV/vis surface albedo direct rad
        !    Dimensions: (ncol)
        a_aldir( l ) = xy_SurfAlbedo(i,j)
        ! Near-IR surface albedo direct rad
        !    Dimensions: (ncol)
        a_asdif( l ) = xy_SurfAlbedo(i,j)
        ! UV/vis surface albedo: diffuse rad
        !    Dimensions: (ncol)
        a_aldif( l ) = xy_SurfAlbedo(i,j)
        ! Near-IR surface albedo: diffuse rad
        !    Dimensions: (ncol)
      end do
    end do
    dyofyr = 0.0_DP
    ! Day of the year (used to get Earth/Sun
    !  distance if adjflx not provided)
    adjes = DistFromStarScld
    ! Flux adjustment for Earth/Sun distance
    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        a_coszen( l ) = xy_CosZet(i,j)
        ! Cosine of solar zenith angle
        !    Dimensions: (ncol)
      end do
    end do
    scon = SolarConst
    ! Solar constant (W/m2)

    inflgsw = 2
    ! Flag for cloud optical properties
    iceflgsw = 1
    ! Flag for ice particle specification
    liqflgsw = 1
    ! Flag for liquid droplet specification

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        do k = 1, kmax
          aaz_ssacld( :, l, k ) = 0.0_DP
          ! In-cloud single scattering albedo
          !    Dimensions: (nbndsw,ncol,nlay)
          aaz_asmcld( :, l, k ) = 0.0_DP
          ! In-cloud asymmetry parameter
          !    Dimensions: (nbndsw,ncol,nlay)
          aaz_fsfcld( :, l, k ) = 0.0_DP
          ! In-cloud forward scattering fraction
          !    Dimensions: (nbndsw,ncol,nlay)
          aza_ssaaer( l, k, : ) = 1.0_DP
          ! Aerosol single scattering albedo (iaer=10 only)
          !    Dimensions: (ncol,nlay,nbndsw)
          ! (non-delta scaled)
          aza_asmaer( l, k, : ) = 0.0_DP
          ! Aerosol asymmetry parameter (iaer=10 only)
          !    Dimensions: (ncol,nlay,nbndsw)
          ! (non-delta scaled)
          aza_ecaer( l, k, : ) = 0.0_DP
          ! Aerosol optical depth at 0.55 micron (iaer=6 only)
          !    Dimensions: (ncol,nlay,naerec)
          ! (non-delta scaled)
        end do
      end do
    end do

    call rrtmg_sw( &
      & ncol    ,nlay    ,icld    ,iaer    , &
      & az_play    ,ar_plev    ,az_tlay    ,ar_tlev    ,a_tsfc    , &
      & az_h2ovmr  ,az_o3vmr   ,az_co2vmr  ,az_ch4vmr  ,az_n2ovmr  ,az_o2vmr, &
      & a_asdir   ,a_asdif   ,a_aldir   ,a_aldif   , &
      & a_coszen  ,adjes   ,dyofyr  ,scon    , &
      & inflgsw ,iceflgsw,liqflgsw,az_cldfr   , &
      & aaz_taucld  ,aaz_ssacld  ,aaz_asmcld  ,aaz_fsfcld  , &
      & az_cicewp  ,az_cliqwp  ,az_reice   ,az_reliq   , &
      & aza_tauaer  ,aza_ssaaer  ,aza_asmaer  ,aza_ecaer   , &
      & ar_swuflx  ,ar_swdflx  ,az_swhr    ,ar_swuflxc ,ar_swdflxc ,az_swhrc &
      & )

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        do k = 0, kmax
          xyr_RadSUwFlux(i,j,k) = ar_swuflx( l, k )
          ! Total sky shortwave upward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
          xyr_RadSDwFlux(i,j,k) = ar_swdflx( l, k )
          ! Total sky shortwave downward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
        end do
!!$        do k = 1, kmax
!!$          az_swhr( l, k )
!!$          ! Total sky shortwave radiative heating rate (K/d)
!!$          !    Dimensions: (ncol,nlay)
!!$        end do
        do k = 0, kmax
          xyr_RadCSSUwFlux(i,j,k) = ar_swuflxc( l, k )
          ! Clear sky shortwave upward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
          xyr_RadCSSDwFlux(i,j,k) = ar_swdflxc( l, k )
          ! Clear sky shortwave downward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
        end do
!!$        do k = 1, kmax
!!$          az_swhrc( l, k )
!!$          ! Clear sky shortwave radiative heating rate (K/d)
!!$          !    Dimensions: (ncol,nlay)
!!$        end do
      end do
    end do




    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        aa_emis( l, : ) = 1.0_DP
        ! Surface emissivity
        !    Dimensions: (ncol,nbndlw)
      end do
    end do

    inflglw = 2
    !           see inflag in rrtmg_lw_cldprop.f90
    ! Flag for cloud optical properties
    iceflglw = 1
    !           see iceflag in rrtmg_lw_cldprop.f90
    ! Flag for ice particle specification
    ! specific definition of reice depends on setting of iceflglw:
    ! iceflglw = 0: ice effective radius, r_ec, (Ebert and Curry, 1992),
    !               r_ec must be >= 10.0 microns
    ! iceflglw = 1: ice effective radius, r_ec, (Ebert and Curry, 1992),
    !               r_ec range is limited to 13.0 to 130.0 microns
    ! iceflglw = 2: ice effective radius, r_k, (Key, Streamer Ref. Manual, 1996)
    !               r_k range is limited to 5.0 to 131.0 microns
    ! iceflglw = 3: generalized effective size, dge, (Fu, 1996),
    !               dge range is limited to 5.0 to 140.0 microns
    !               [dge = 1.0315 * r_ec]
    liqflglw = 1
    !           see liqflag in rrtmg_lw_cldprop.f90
    ! Flag for liquid droplet specification


    call rrtmg_lw( &
      & ncol    ,nlay    ,icld    ,idrv    , &
      & az_play    ,ar_plev    ,az_tlay    ,ar_tlev    ,a_tsfc    , &
      & az_h2ovmr  ,az_o3vmr   ,az_co2vmr  ,az_ch4vmr  ,az_n2ovmr  ,az_o2vmr, &
      & az_cfc11vmr,az_cfc12vmr,az_cfc22vmr,az_ccl4vmr ,aa_emis    , &
      & inflglw ,iceflglw,liqflglw,az_cldfr   , &
      & aaz_taucld  ,az_cicewp  ,az_cliqwp  ,az_reice   ,az_reliq   , &
      & aza_tauaer  , &
      & ar_uflx    ,ar_dflx    ,az_hr      ,ar_uflxc   ,ar_dflxc,  az_hrc, &
      & ar_duflx_dt,ar_duflxc_dt &
      & )

    do j = 1, jmax
      do i = 0, imax-1
        l = imax * (j-1) + i + 1
        do k = 0, kmax
          xyr_RadLUwFlux(i,j,k) = ar_uflx( l, k )
          ! Total sky longwave upward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
          xyr_RadLDwFlux(i,j,k) = ar_dflx( l, k )
          ! Total sky longwave downward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)

!!$      az_hr( 1:imax*jmax, 1:kmax )
!!$      ! Total sky longwave radiative heating rate (K/d)
!!$      !    Dimensions: (ncol,nlay)
          xyr_RadCSLUwFlux(i,j,k) = ar_uflxc( l, k )
          ! Clear sky longwave upward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
          xyr_RadCSLDwFlux(i,j,k) = ar_dflxc( l, k )
          ! Clear sky longwave downward flux (W/m2)
          !    Dimensions: (ncol,nlay+1)
!!$      az_hrc( 1:imax*jmax, 1:kmax )
!!$      ! Clear sky longwave radiative heating rate (K/d)
!!$      !    Dimensions: (ncol,nlay)

          xyra_DelRadLUwFlux(i,j,k,0) = ar_duflx_dt( l, k )
          ! change in upward longwave flux (w/m2/k)
          ! with respect to surface temperature
          !    Dimensions: (ncol,nlay+1)
          xyra_DelRadLUwFlux(i,j,k,1) = 0.0_DP
          xyra_DelRadLDwFlux(i,j,k,0) = 0.0_DP
          xyra_DelRadLDwFlux(i,j,k,1) = 0.0_DP
!!$      ar_duflxc_dt( 1:imax*jmax, 1:kmax )
          ! change in clear sky upward longwave flux (w/m2/k)
          ! with respect to surface temperature
          !    Dimensions: (ncol,nlay+1)
        end do
      end do
    end do





!!$    ! 地球大気向け短波放射モデル Ver. 2.6
!!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
!!$    !
!!$    call RadEarthSWV26Flux(                                      &
!!$      & xy_SurfAlbedo,                                           &
!!$      & xyz_DelAtmMass,                                          &
!!$      & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
!!$      & xyz_DelO3Mass,                                           &
!!$      & xyz_Press, xyz_Temp,                                     &
!!$      & xyz_CloudCover,                                          &
!!$      & xyz_CloudWatREff, xyz_CloudIceREff,                      &
!!$      & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
!!$      & )
!!$
!!$
!!$    call RadEarthLWV24Flux(                                      &
!!$      & xyz_DelCO2Mass,                                          &
!!$      & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
!!$      & xyz_DelO3Mass,                                           &
!!$      & xyz_DelN2OMass, xyz_DelCH4Mass,                          &
!!$      & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
!!$      & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
!!$      & xyz_QN2O, xyz_QCH4,                                      & ! (in )
!!$      & xyz_CloudCover,                                          & ! (in )
!!$      & xyz_CloudWatREff, xyz_CloudIceREff,                      & ! (in )
!!$      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
!!$      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
!!$      & )



    ! Output variables
    !
    call HistoryAutoPut( TimeN, 'CloudCoverforRad', xyz_CloudCover )
    !
    xy_CloudCoverRand = 1.0_DP
    do k = 1, kmax
      xy_CloudCoverRand = xy_CloudCoverRand * ( 1.0_DP - xyz_CloudCover(:,:,k) )
    end do
    xy_CloudCoverRand = 1.0_DP - xy_CloudCoverRand
    call HistoryAutoPut( TimeN, 'CloudCoverRand', xy_CloudCoverRand )


    call HistoryAutoPut( TimeN, 'RadCSLUWFLXB', xyr_RadCSLUwFlux )
    call HistoryAutoPut( TimeN, 'RadCSLDWFLXB', xyr_RadCSLDwFlux )
    call HistoryAutoPut( TimeN, 'RadCSSUWFLXB', xyr_RadCSSUwFlux )
    call HistoryAutoPut( TimeN, 'RadCSSDWFLXB', xyr_RadCSSDwFlux )

#endif

  end subroutine RadRRTMGWrapperFluxCore

  !--------------------------------------------------------------------------------------

  subroutine RadRRTMGWrapperInit(    &
    & FlagSnow                  &
    & )

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    use set_gcmr, only : SetGCMRInit

    ! O3 分布の設定
    ! Set O3 distribution
    !
    use set_o3, only : SetO3Init

    !
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry
                            ! $ C_p $ [J kg-1 K-1].
                            ! 乾燥大気の定圧比熱.
                            ! Specific heat of air at constant pressure

!!$    ! 地球大気向け短波放射モデル Ver. 2.6
!!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
!!$    !
!!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Init
!!$
!!$    ! 地球大気向け長波放射モデル Ver. 2.4
!!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
!!$    !
!!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Init

#ifdef RRTMG
    ! RRTMG LW initialization
    ! RRTMG LW initialization
    !
    use rrtmg_lw_init, only: &
      & rrtmg_lw_ini

    ! RRTMG SW initialization
    ! RRTMG SW initialization
    !
    use rrtmg_sw_init, only: &
      & rrtmg_sw_ini
#endif

    ! 太陽放射フラックスの設定
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConstInit

    ! 短波入射 (太陽入射)
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only : AxnameX, AxnameY, AxnameZ, AxnameR, AxnameT

    ! 宣言文 ; Declaration statements
    !

    logical, intent(in) :: FlagSnow

    character(STRING)   :: CloudIceREffMethod

    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /rad_rrtmg_wrapper_nml/ &
      & CloudIceREffMethod,     &
      & CloudWatREff,           &
      & CloudIceREff

!!$      & SWVer, LWVer
          !
          ! デフォルト値については初期化手続 "rad_rrtmg_wrapper#RadEarthV2Init"
          ! のソースコードを参照のこと.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_rrtmg_wrapper#RadEarthV2Init" for the default values.
          !

    if ( rad_rrtmg_wrapper_inited ) return


    ! Molecular weights of atmosphere, CO2, H2O, N2O, CH4
    !
    MeanMolWeight = 28.0d-3
    CO2MolWeight  = 44.0d-3
    H2OMolWeight  = 18.0d-3
    N2OMolWeight  = 44.0d-3
    CH4MolWeight  = 16.0d-3


    ! デフォルト値の設定
    ! Default values settings
    !
    CloudIceREffMethod = 'Const'
!!$    CloudIceREffMethod = 'Lin'

    CloudWatREff    = 10.0d-6
    CloudIceREff    = 50.0d-6


!!$    SWVer = 1
!!$    LWVer = 3


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = rad_rrtmg_wrapper_nml,         & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! Identification of calculation method of cloud particle effective radius
    !
    call MessageNotify( 'M', module_name, &
      & 'CloudIceREffMethod=<%c>.', &
      & c1 = trim(CloudIceREffMethod) )
    !
    select case ( CloudIceREffMethod )
    case ( 'Const' )
      IDCloudIceREffMethod = IDCloudIceREffMethodConst
    case ( 'Lin' )
      IDCloudIceREffMethod = IDCloudIceREffMethodLin
    case default
      call MessageNotify( 'E', module_name, &
        & 'CloudIceREffMethod=<%c> is not supported.', &
        & c1 = trim(CloudIceREffMethod) )
    end select


    ! Allocate a local variable for O3 distribution
    !
    allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )


    ! Initialization of modules used in this module
    !

    ! 全球一定体積混合比の設定
    ! Set globally constant volume mixing ratio
    !
    call SetGCMRInit

    ! O3 分布の設定
    ! Set O3 distribution
    !
    call SetO3Init


!!$    ! 地球大気向け短波放射モデル Ver. 2.6
!!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
!!$    !
!!$    call RadEarthSWV26Init( &
!!$      & FlagSnow &
!!$      & )
!!$
!!$    ! 地球大気向け長波放射モデル Ver. 2.4
!!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
!!$    !
!!$    call RadEarthLWV24Init( &
!!$      & FlagSnow            &
!!$      & )


#ifdef RRTMG
    ! RRTMG LW initialization
    ! RRTMG LW initialization
    !
    call rrtmg_lw_ini( CpDry )

    ! RRTMG SW initialization
    ! RRTMG SW initialization
    !
    call rrtmg_sw_ini( CpDry )
#endif

    ! 太陽放射フラックスの設定
    ! Set solar constant
    !
    call SetSolarConstInit

    ! 短波入射 (太陽入射)
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit


    ! ヒストリデータ出力のためのへの変数登録
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'CloudCoverforRad', &
      & (/ AxnameX, AxnameY, AxnameZ, AxnameT /), &
      & 'cloud cover', '1' )
    call HistoryAutoAddVariable( 'CloudCoverRand', &
      & (/ AxnameX, AxnameY, AxnameT /), &
      & 'cloud cover', '1' )

    call HistoryAutoAddVariable( 'RadCSLUWFLXB', &
      & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
      & 'clear sky upward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadCSLDWFLXB', &
      & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
      & 'clear sky downward longwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadCSSUWFLXB', &
      & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
      & 'clear sky upward shortwave flux', 'W m-2' )
    call HistoryAutoAddVariable( 'RadCSSDWFLXB', &
      & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
      & 'clear sky downward shortwave flux', 'W m-2' )

    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  CloudWatREff      = %f', &
      & d = (/ CloudWatREff /) )
    call MessageNotify( 'M', module_name, '  CloudIceREff      = %f', &
      & d = (/ CloudIceREff /) )
!!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
!!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_rrtmg_wrapper_inited = .true.

  end subroutine RadRRTMGWrapperInit

  !--------------------------------------------------------------------------------------

end module rad_rrtmg_wrapper
