!= 地表面データ生成主プログラム
!
!= dcpam main program for generation of surface data
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_init_data_surface
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 地表面データファイルを生成します. 
  !
  ! Surface data file is created. 
  !

  ! モジュール引用 ; USE statements
  !

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only:       &
    &                imax, & ! 経度格子点数. 
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数. 
                             ! Number of grid points in latitude
    &                kslmax  ! 地下の鉛直層数.
                             ! Number of subsurface vertical level

  ! 地表面データ提供
  ! Prepare surface data
  !
  use surface_data, only: SetSurfData

  !
  ! Prepare initial surface data
  !
  use initial_surface_data, only: SetInitSurfaceData

  ! 地表面温度リスタートデータ入出力
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutput

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING, &  ! 文字列.       Strings. 
    &                 TOKEN      ! キーワード.   Keywords. 

  ! 宣言文 ; Declaration statements
  !
  implicit none

  ! 変数
  ! Variables
  !
  real(DP), allocatable:: xy_SurfTemp (:,:)
                            ! 地表面温度. 
                            ! Surface temperature
  real(DP), allocatable:: xyz_SoilTemp (:,:,:)
                            ! 土壌温度. 
                            ! Soil temperature
  real(DP), allocatable:: xy_SurfMajCompIceB(:,:)
                            ! 
                            ! surface major component ice at previous time step
  real(DP), allocatable:: xy_SurfMajCompIceN(:,:)
                            ! 
                            ! surface major component ice at present time step
  real(DP), allocatable:: xy_SoilMoistB(:,:)
                            ! 
                            ! soil moisture at previous time step
  real(DP), allocatable:: xy_SoilMoistN(:,:)
                            ! 
                            ! soil moisture at present time step
  real(DP), allocatable:: xy_SurfSnowB(:,:)
                            ! 
                            ! surface snow amount at previous time step
  real(DP), allocatable:: xy_SurfSnowN(:,:)
                            ! 
                            ! surface snow amount at present time step


  ! 作業変数
  ! Work variables
  !
  integer :: k


  ! 実行文 ; Executable statement
  !

  ! 主プログラムの初期化 (内部サブルーチン)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! 地表面データの作成
  ! Generate surface data
  !
  call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional

  do k = 1, kslmax
    xyz_SoilTemp(:,:,k) = xy_SurfTemp
  end do

  !
  != Prepare initial surface data
  !
  call SetInitSurfaceData(                        &
    & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB   & ! (out)
    & )
  xy_SurfMajCompIceN = xy_SurfMajCompIceB
  xy_SoilMoistN      = xy_SoilMoistB
  xy_SurfSnowN       = xy_SurfSnowB


  ! 地表面温度リスタートデータ出力
  ! Restart data of surface temperature output
  !
  call RestartSurfTempOutput(                             &
    & xy_SurfTemp,                                        & ! (in)
    & xyz_SoilTemp,                                       & ! (in) optional
    & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,    & ! (in) optional
    & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN     & ! (in) optional
    & )


  ! 主プログラムの終了処理 (内部サブルーチン)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! 主プログラムの初期化手続き. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! コマンドライン引数処理
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 時刻管理
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ステップ $ t $ の時刻. Time of step $ t $. 

    ! 出力ファイルの基本情報管理
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! 格子点設定
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! 経度格子点数. 
                               ! Number of grid points in longitude
      &                jmax, & ! 緯度格子点数. 
                               ! Number of grid points in latitude
      &                kslmax  ! 地下の鉛直層数.
                               ! Number of subsurface vertical level

    ! 物理定数設定
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! 地表面温度リスタートデータ入出力
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempInit, RestartSurfTempOpen, RestartSurfTempGet

    ! 地表面データ提供
    ! Prepare surface data
    !
    use surface_data, only : SurfDataInit

    !
    ! Prepare initial surface data
    !
    use initial_surface_data, only: InitSurfaceDataInit


    ! 宣言文 ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'dcpam_init_data_surface'
                              ! 主プログラム名. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name:  $' // &
      & '$Id: dcpam_init_data_surface.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
                              ! 主プログラムのバージョン
                              ! Main program version
    character(STRING)      :: namelist_filename
                              ! NAMELIST ファイルの名称. 
                              ! NAMELIST file name

    character(STRING):: brief
                              ! 実行ファイルの簡潔な説明
                              ! Brief account of executable file

    ! 実行文 ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit

    brief = 'SST data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! コマンドライン引数処理
    ! Command line option parser
    !
    call OptParseInit(       &
      & namelist_filename,   & ! (out)
      & prog_name,           & ! (in )
      & brief                & ! (in )
      & )

    ! NAMELIST ファイル名入力
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & namelist_filename  & ! (in)
      & )

    ! 時刻管理
    ! Time control
    !
    call TimesetInit

    ! 出力ファイルの基本情報管理
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! 格子点設定
    ! Grid points settings
    !
    call GridsetInit

    ! 物理定数設定
    ! Physical constants settings
    !
    call ConstantsInit

    ! 座標データ設定
    ! Axes data settings
    !
    call AxessetInit

    ! 地表面データ提供
    ! Prepare surface data
    !
    call SurfDataInit

    !
    ! Prepare initial surface data
    !
    call InitSurfaceDataInit


    ! 地表面温度変数の割付
    ! Allocation of a variable of surface temperature
    !
    allocate( xy_SurfTemp       (0:imax-1, 1:jmax) )
    allocate( xyz_SoilTemp      (0:imax-1, 1:jmax, 1:kslmax) )
    allocate( xy_SurfMajCompIceB(0:imax-1, 1:jmax) )
    allocate( xy_SurfMajCompIceN(0:imax-1, 1:jmax) )
    allocate( xy_SoilMoistB     (0:imax-1, 1:jmax) )
    allocate( xy_SoilMoistN     (0:imax-1, 1:jmax) )
    allocate( xy_SurfSnowB      (0:imax-1, 1:jmax) )
    allocate( xy_SurfSnowN      (0:imax-1, 1:jmax) )

    ! 地表面温度リスタートデータファイルの初期化
    ! Initialization of restart data file of surface temperature
    !
    call RestartSurfTempInit
    call RestartSurfTempOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! 主プログラムの終了処理手続き. 
    !
    ! Termination procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! 時刻管理
    ! Time control
    !
    use timeset, only: TimesetClose

    ! 地表面温度リスタートデータ入出力
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ヒストリデータ出力
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! 宣言文 ; Declaration statements
    !
    implicit none

    ! 実行文 ; Executable statement
    !

    ! 地表面温度リスタートデータファイルクローズ
    ! Close restart data file of surface temperature
    !
    call RestartSurfTempClose

    ! 時刻管理終了処理
    ! Termination of time control
    !
    call TimesetClose

    ! 地表面温度変数の割付解除
    ! Deallocation of a variable of surface temperature
    !
    deallocate( xy_SurfTemp )

    ! Finalize MPI
    !
    call MPIWrapperFinalize

  end subroutine MainTerminate

end program dcpam_init_data_surface
