!= 初期値データファイル生成主プログラム
!
!= dcpam main program for generation of initial data file
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_init_data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 初期値データファイルを生成します. 
  !
  ! Initial data file is created. 
  !

  ! モジュール引用 ; USE statements
  !

  ! 組成に関わる配列の設定
  ! Settings of array for atmospheric composition
  !
  use composition, only : &
    &                ncmax, & ! 成分の数
                              ! Number of composition
    &                IndexH2OVap
                              ! 水蒸気のインデックス
                              ! Index for water vapor

  ! 初期値データ (リスタートデータ) 提供
  ! Prepare initial data (restart data)
  !
  use initial_data, only: SetInitData

  ! リスタートデータ入出力
  ! Restart data input/output
  !
  use restart_file_io, only: InitialFileOutPut

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING, &  ! 文字列.       Strings. 
    &                 TOKEN      ! キーワード.   Keywords. 

  ! 宣言文 ; Declaration statements
  !
  implicit none

  ! 予報変数 (ステップ $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_U (:,:,:)
                              ! $ u $ .   東西風速. Eastward wind
  real(DP), allocatable:: xyz_V (:,:,:)
                              ! $ v $ .   南北風速. Northward wind
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .   温度. Temperature
  real(DP), allocatable:: xyzf_QVap (:,:,:,:)
                              ! $ q $ .   比湿. Specific humidity
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ p_s $ . 地表面気圧. Surface pressure

  ! 作業変数
  ! Work variables
  !
  integer :: n


  ! 実行文 ; Executable statement
  !

  ! 主プログラムの初期化 (内部サブルーチン)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! 初期値データの作成
  ! Generate initial data
  !
  call SetInitData( &
    & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (out)

  ! 初期値データの出力
  ! Output initial data
  !
  call InitialFileOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (in)

  ! 主プログラムの終了処理 (内部サブルーチン)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! 主プログラムの初期化手続き. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! コマンドライン引数処理
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 時刻管理
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ステップ $ t $ の時刻. Time of step $ t $. 

    ! 出力ファイルの基本情報管理
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! 格子点設定
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! 経度格子点数. 
                               ! Number of grid points in longitude
      &                jmax, & ! 緯度格子点数. 
                               ! Number of grid points in latitude
      &                kmax    ! 鉛直層数. 
                               ! Number of vertical level

    ! 組成に関わる配列の設定
    ! Settings of array for atmospheric composition
    !
    use composition, only : &
      &                CompositionInit, &
      &                ncmax   ! 成分の数
                               ! Number of composition

    ! 物理定数設定
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ファイルから 1 次元プロファイルを読んで設定する. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfileInit

    ! リスタートデータ入出力
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileInit, RestartFileOpen

    ! 初期値データ (リスタートデータ) 提供
    ! Prepare initial data (restart data)
    !
    use initial_data, only: InitDataInit


    ! 宣言文 ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'dcpam_init_data'
                              ! 主プログラム名. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name:  $' // &
      & '$Id: dcpam_init_data.f90,v 1.1 2013/10/06 13:42:17 yot Exp $'
                              ! 主プログラムのバージョン
                              ! Main program version
    character(STRING)      :: namelist_filename
                              ! NAMELIST ファイルの名称. 
                              ! NAMELIST file name

    character(STRING):: brief
                              ! 実行ファイルの簡潔な説明
                              ! Brief account of executable file

    ! 実行文 ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit


    brief = 'Initial data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! コマンドライン引数処理
    ! Command line option parser
    !
    call OptParseInit(       &
      & namelist_filename,   & ! (out)
      & prog_name,           & ! (in )
      & brief                & ! (in )
      & )

    ! NAMELIST ファイル名入力
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & namelist_filename  & ! (in)
      & )

    ! 時刻管理
    ! Time control
    !
    call TimesetInit

    ! 出力ファイルの基本情報管理
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! 格子点設定
    ! Grid points settings
    !
    call GridsetInit

    ! 組成に関わる配列の設定
    ! Settings of array for atmospheric composition
    !
    call CompositionInit

    ! 物理定数設定
    ! Physical constants settings
    !
    call ConstantsInit

    ! 座標データ設定
    ! Axes data settings
    !
    call AxessetInit

    ! 初期値データ (リスタートデータ) 提供
    ! Prepare initial data (restart data)
    !
    call InitDataInit


    ! 予報変数の割付
    ! Allocation of prediction variables
    !
    allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QVap(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_Ps    (0:imax-1, 1:jmax) )

    ! ファイルから 1 次元プロファイルを読んで設定する. 
    ! read 1-D profile from a file and set it 
    !
    call Set1DProfileInit

    ! 初期値データ出力
    ! Initial data output
    !
    call RestartFileInit
    call RestartFileOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! 主プログラムの終了処理手続き. 
    !
    ! Termination procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! 時刻管理
    ! Time control
    !
    use timeset, only: TimesetClose

    ! リスタートデータ入出力
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! 宣言文 ; Declaration statements
    !
    implicit none

    ! 実行文 ; Executable statement
    !

    ! リスタートデータファイルクローズ
    ! Close restart data input
    !
    call RestartFileClose

    ! 時刻管理終了処理
    ! Termination of time control
    !
    call TimesetClose

    ! 予報変数の割付解除
    ! Deallocation of prediction variables
    !
    deallocate( xyz_U     )
    deallocate( xyz_V     )
    deallocate( xyz_Temp  )
    deallocate( xyzf_QVap )
    deallocate( xy_Ps     )

    ! Finalize MPI
    !
    call MPIWrapperFinalize


  end subroutine MainTerminate

end program dcpam_init_data
