=begin JA

= Held and Suarez (1994) 力学コア実験

# * 森川 靖大 (morikawa), 納多 哲史 (noda), 高橋 芳幸 (yot), 竹広 真一 (takepiro)
#   * $Id: exp-hs94.rd,v 1.16 2014/07/07 14:50:00 yot Exp $

=end JA
=begin EN

= Held and Suarez (1994) dynamcal core experiment

# * Yasuhiro MORIKAWA (morikawa), Satoshi NODA (noda), Yoshiyuki * O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-hs94.rd,v 1.16 2014/07/07 14:50:00 yot Exp $

=end EN


=begin JA
Held and Suarez (1994) が提案した, 
大気大循環モデルの力学過程を評価するための
実験を実行する方法を説明します. 

この計算には以下の物理過程を用いています. 

  * 軸対称温度分布に近づけるニュートン冷却
  * 下層のレイリー摩擦
  * 水蒸気に関する物理過程無し.
  * 乾燥対流調節 
=end JA
=begin EN
A method to perform dynamical core experiment proposed by
Held and Suarez (1994) is described.

Following physical processes are used in this experiment.

  * Newtonian relaxation of the temperature field to a zonally symmetric state
  * Rayleigh damping of low-level winds
  * processes related to moisture are excluded.
  * Dry convective adjustment
=end EN


=begin JA
== 概要
本実験は海表面温度データ等の実験用データを用いないため, 以下の 3 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験の実行
=end JA
=begin EN
== Overview
This experiment does not require additional data, such as SST data.
So, the experiment is performed with the following 3 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Execution of experiments
=end EN


=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDDとする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/hs94-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/hs94-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/hs94-exp
  $ cd ../dcpam5-exp/hs94-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf


#practice ディレクトリに移動してください.
#
#  $ cd practice
#
#そのディレクトリ内で, make コマンドを実行してください.
#自動的に実行ファイルや NAMELIST ファイルがコピーされます. 
#make コマンド入力後, まずディレクトリ名を適宜入力してください.
#(下記の例では hs94-exp としています). 
#それ以降の質問はとりあえずそのまま Enter キーを入力してください. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: hs94-exp
#    Directory in which executable files are prepared
#      [../src/main]:
#    Directory in which NAMELIST files are prepared
#      [../src/main]:
#    Save F90/95 source code files? [y/N]:
#
#                  :
#
#  *** Setup of "hs94-exp" is complete ***
#
#hs94-exp というディレクトリが作成され, その中に
#実行ファイルや NAMELIST ファイル, ソースコードがコピーされます.
#hs94-exp ディレクトリ内に移動してください.
#
#  $ cd hs94-exp

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

=end JA
=begin EN

== Preparation of a directory for experiments

Let us move to the top directory of DCPAM5 src tree 
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/hs94-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/hs94-exp
  $ cd ../dcpam5-exp/hs94-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf


#Move to "practice" directory.
#
#  $ cd practice
#
#In the directory, execute 'make' command. 
#The execution files and the NAMELIST files will be automatically copied. 
#Input directory name after inputting 'make' command. 
#(It is assumed "hs94-exp" in the following example). 
#Input 'Enter' to the question after that. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: hs94-exp
#    Directory in which executable files are prepared
#      [../src/main]:
#    Directory in which NAMELIST files are prepared
#      [../src/main]:
#    Save F90/95 source code files? [y/N]: 
#
#                  :
#
#  *** Setup of "hs94-exp" is complete ***
#
#Then a directory 'hs94-exp' is created, and executable files,
#NAMELIST files, and source code files are copied to the
#directory.
#Move the 'hs94-exp'.
#
#  $ cd hs94-exp


Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.


=end EN


=begin JA

== 初期値データファイルの作成

dcpam_init_data と init_data_hs94_T21L20.conf
を用いて初期値ファイル init_T21L20.nc を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_hs94_T21L20.conf

                         : 
   *** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_file_io] ***  Input::
   *** MESSAGE [restart_file_io] ***    InputFile  =
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_T21L20.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "init_T21L20.nc" is created (origin=0. [day])
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = Small Disturbance of Temperature
   *** MESSAGE [initial_data] ***    TempAvr = 280.
   *** MESSAGE [initial_data] ***    PsAvr   = 100000.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.1E-09

   *** MESSAGE [HistoryClose] ***  "init_T21L20.nc" is closed


== 実験の実行

実行ファイル "dcpam_main" と NAMELIST ファイル
((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>))
を用いて, 以下のように dcpam_main を実行してください. 
プログラム終了には数分〜数十分かかります. 

(なお, クロスコンパイル環境では以下の方法でプログラムを
実行することはできないので注意してください. その場合の実行方法
に関しては, その環境でのプログラム実行マニュアルなどを参照ください. )

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.conf | tee hs94.log

   *** MESSAGE [dcpam_main] ***  Run: Held and Suarez (1994) benchmark test
                     :
   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
   *** MESSAGE [timeset] ***    StartTime  = 0. [day]
   *** MESSAGE [timeset] ***    EndTime    = 10. [day]
   *** MESSAGE [timeset] ***    DelTime    = 30. [min]
   *** MESSAGE [timeset] ***               = 1800. [sec]
                     :
                     :
   *** MESSAGE [fileset] ***  ----- Initialization Messages -----
   *** MESSAGE [fileset] ***    FileTitle       = Held and Suarez (1994) benchmark test
   *** MESSAGE [fileset] ***    FileSource      = dcpam5 (http://www.gfd-dennou.org/library/dcpam)
   *** MESSAGE [fileset] ***    FileInstitution = GFD Dennou Club (http://www.gfd-dennou.org)
   *** MESSAGE [fileset] ***  -- version = ....
   *** MESSAGE [gridset] ***  ----- Initialization Messages -----
   *** MESSAGE [gridset] ***    nmax = 21
   *** MESSAGE [gridset] ***    imax = 64
   *** MESSAGE [gridset] ***    jmax = 32
   *** MESSAGE [gridset] ***    kmax = 20
   *** MESSAGE [gridset] ***  -- version = ....
                     : 

   ########## PREDICTION OF CALCULATION ###########
   Start Date             2009-03-06T08:26:41+09:00
   Current Date           2009-03-06T08:26:45+09:00
   Progress     20.00%  [*****                    ]
   Remaining CPU TIME      0.160000E+02
   Completion Date        2009-03-06T08:27:01+09:00
   
                     :

   ############## CPU TIME SUMMARY ################
   held_suarez_1994       0.165611E+01
   dynamics_hspl_vas83    0.191452E+02
   timefilter_asselin19   0.264027E+00
   others                 0.896038E+00
   ------------------------------------------------
          TOTAL TIME =    0.219614E+02

この場合, 10 日分の時間積分が行われます. 
空間解像度は T21L20 (経度格子点数 64, 緯度点数 32, 鉛直層数 20) です. 
計算結果は U.nc や Temp.nc として出力されます. 
また, リスタートファイルが restart.nc として出力されます. 


== 結果の描画

10 日後における温度の東西平均分布は以下の図のようになります.

#これらの図は GPhys パッケージに同梱されている gpview というコマンドを
#使って以下のようにして描いた図です.
#
#  $ gpview U.nc@U,time=10 --mean lon --int 1 --noannotate --wsn 2
#  $ gpview Temp.nc@Temp,time=10 --mean lon --int 5 --noannotate --wsn 2
#
#((<"IMG:images/gpview_hs94_U.png">))
#((<"IMG:images/gpview_hs94_Temp.png">))

((<"IMG:images/hs94_irb_temp_meanlon_time11day.png">))

この図は, ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)) を
用いて,  下の処理によって描画しています. 

  まず irb を起動. 

  $ irb

  以下のような irb のプロンプトが表示されます.

  irb(main):001:0>

  このプロンプトに, 以下のようにコマンドを打ちます.
  左端の数字は行番号で, 打つ必要はありません.

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.tone( gphys.mean('lon').cut('time'=>11) )
  7: GGraph.color_bar
  8: DCL.grcls

  irb のプロンプトにおいて quit と打つと irb を終了することができます. 

Held and Suarez (1994) では空間解像度は T63L20
(経度格子点 192, 緯度格子点 96, 鉛直層 20) 相当で, 
1200 日の時間積分が行われています. 
DCPAM を用いた, より高い解像度での長期間積分の結果は((<こちら|URL:http://www.gfd-dennou.org/library/dcpam/sample/>)) に載せています. 

また, 解析・可視化のもう少し詳しい方法については((<こちら|URL:./visualization.htm>))を参照してください. 

=end JA

=begin EN

== Create initial data file

Create initial data file "init_T21L20.nc"
using "dcpam_init_data" and "init_data_hs94_T21L20.conf" 
  
  $ ./bin/dcpam_init_data -N=./conf/init_data_hs94_T21L20.conf

                         : 
   *** MESSAGE [restart_file_io] ***  ----- Initialization Messages -----
   *** MESSAGE [restart_file_io] ***  Input::
   *** MESSAGE [restart_file_io] ***    InputFile  =
   *** MESSAGE [restart_file_io] ***  Output::
   *** MESSAGE [restart_file_io] ***    OutputFile = init_T21L20.nc
   *** MESSAGE [restart_file_io] ***    IntTime    = 1. [day]
   
   *** MESSAGE [HistoryCreate3] ***  "init_T21L20.nc" is created (origin=0. [day])
   *** MESSAGE [initial_data] ***  NAMELIST group "initial_data_nml" is loaded from "./conf/init_data_T21L16.conf".
   *** MESSAGE [initial_data] ***  ----- Initialization Messages -----
   *** MESSAGE [initial_data] ***    Pattern = Small Disturbance of Temperature
   *** MESSAGE [initial_data] ***    TempAvr = 280.
   *** MESSAGE [initial_data] ***    PsAvr   = 100000.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.1E-09

   *** MESSAGE [HistoryClose] ***  "init_T21L20.nc" is closed

== Run the experiment

Using an executable files 'dcpam_main' and a NAMELIST file
((<dcpam_hs94_T21L20.conf|URL:../../exp_setup_files/dcpam_hs94_T21L20.conf>)), 
execute 'dcpam_main' as follows. 
This program will be finished in few minutes - tens of minutes. 

  $ ./bin/dcpam_main -N=./conf/dcpam_hs94_T21L20.conf | tee hs94.log

   *** MESSAGE [dcpam_main] ***  Run: Held and Suarez (1994) benchmark test
                     :
   *** MESSAGE [timeset] ***  ----- Initialization Messages -----
   *** MESSAGE [timeset] ***    StartTime  = 0. [day]
   *** MESSAGE [timeset] ***    EndTime    = 10. [day]
   *** MESSAGE [timeset] ***    DelTime    = 30. [min]
   *** MESSAGE [timeset] ***               = 1800. [sec]
                     :
                     :
   *** MESSAGE [fileset] ***  ----- Initialization Messages -----
   *** MESSAGE [fileset] ***    FileTitle       = Held and Suarez (1994) benchmark test
   *** MESSAGE [fileset] ***    FileSource      = dcpam5 (http://www.gfd-dennou.org/library/dcpam)
   *** MESSAGE [fileset] ***    FileInstitution = GFD Dennou Club (http://www.gfd-dennou.org)
   *** MESSAGE [fileset] ***  -- version = ....
   *** MESSAGE [gridset] ***  ----- Initialization Messages -----
   *** MESSAGE [gridset] ***    nmax = 21
   *** MESSAGE [gridset] ***    imax = 64
   *** MESSAGE [gridset] ***    jmax = 32
   *** MESSAGE [gridset] ***    kmax = 20
   *** MESSAGE [gridset] ***  -- version = ....
                     : 

   ########## PREDICTION OF CALCULATION ###########
   Start Date             2009-03-06T08:26:41+09:00
   Current Date           2009-03-06T08:26:45+09:00
   Progress     20.00%  [*****                    ]
   Remaining CPU TIME      0.160000E+02
   Completion Date        2009-03-06T08:27:01+09:00
     
                     :

   ############## CPU TIME SUMMARY ################
   held_suarez_1994       0.165611E+01
   dynamics_hspl_vas83    0.191452E+02
   timefilter_asselin19   0.264027E+00
   others                 0.896038E+00
   ------------------------------------------------
          TOTAL TIME =    0.219614E+02

In this case, 10 days integration is performed. 
Resolution is T21L20 (Number of grid points of longitude, latitude is 
64, 32, and number of vertical layer is 20). 
History data are output to 'U.nc' and 'Temp.nc' etc., 
and a restart data is output to 'restart.nc'. 


== Visualization of result

Zonal mean temperature at 10 day is shown in following figures.

#These figures are drawn by gpview command of GPyes package;
#
#  $ gpview U.nc@U,time=10 --mean lon --int 1 --noannotate --wsn 2
#  $ gpview Temp.nc@Temp,time=10 --mean lon --int 5 --noannotate --wsn 2
#
#((<"IMG:images/gpview_hs94_U.png">))
#((<"IMG:images/gpview_hs94_Temp.png">))

((<"IMG:images/hs94_irb_temp_meanlon_time11day.png">))

This figure is drawn by using ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)), as follows: 

  Please type irb. 

  $ irb

  Following prompt of irb is shown. 

  irb(main):001:0>

  Type following lines. Please note that the left-most number is line number, and it has not been typed. 

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.tone( gphys.mean('lon').cut('time'=>11) )
  7: GGraph.color_bar
  8: DCL.grcls

  Type quit to exit irb. 

In Held and Suarez (1994), integration period is 1200 days and
resolution is T63L20 (Number of grid points of longitude, latitude is
192, 96, and number of vertical layer is 20). 
The result of such integration by using the DCPAM is shown ((<here|URL:http://www.gfd-dennou.org/library/dcpam/sample/>)) (Japanese version only).

=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN

=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin
* ((<Held, I. M., and M. J. Suarez, 1994: 
  A proposal for the intercomparison of the dynamical cores of
  atmospheric general circuation models,
  ((|Bull. Am. Meteor. Soc.|)), ((*75*)), 1825--1830.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0477%281994%29075%3C1825%3AAPFTIO%3E2.0.CO%3B2>))
=end


=begin HTML
<hr />
<small>
  $Id: exp-hs94.rd,v 1.16 2014/07/07 14:50:00 yot Exp $
</small>
=end HTML

