=begin JA

= Neale and Hoskins (2000) による水惑星実験

# * 高橋 芳幸 (yot), 竹広 真一 (takepiro)
#   * $Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $

=end JA
=begin EN

= Aqua planet experiment by Neale and Hoskins (2000)

# * Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $

=end EN


=begin JA

Neale and Hoskins (2000) によって提案された, 惑星表面が全て水であるような条件 (水惑星) 
で実験を行う方法を説明します. 

この計算には以下の物理過程を用いています. 

  * 放射 (地球大気用放射) 
  * 鉛直拡散 (Mellor and Yamada, 1982, レベル 2.5) 
  * 積雲パラメタリゼーション: Relaxed Arakawa-Schubert スキーム (Moorthi and Suarez, 1992) 
  * 診断型大規模凝結 
#  * 乾燥対流調節 

=end JA
=begin EN

A method to perform an aqua planet experiment
(planetary surface is covered by watar) proposed by Neale and Hoskins (2000) 
is described. 

Following physical processes are used in this experiment.

  * Radiation (model for the Earth's atmosphere) 
  * Vertical diffusion (Mellor and Yamada, 1982, level 2.5) 
  * Cumulus parameterization: Relaxed Arakawa-Schubert scheme (Moorthi and Suarez, 1992) 
  * Large scale condensation
#  * Dry convective adjustment

=end EN


=begin JA
== 概要

本実験では, 海表面温度のデータが必要です. したがって, 
実験の実行は以下の 4 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験用データ (海表面温度分布) の準備
  * 実験の実行

=end JA
=begin EN
== Overview

This experiment requires data of distribution of sea surface temperature. 
So, the experiment is performed with the following 4 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Preparation of additional data (sea surface temperature) for experiments
  * Execution of experiments

=end EN

=begin JA

== 実験用ディレクトリ準備


DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/ape-nh00-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/ape-nh00-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/ape-nh00-exp
  $ cd ../dcpam5-exp/ape-nh00-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface   bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

#practice ディレクトリに移動してください. 
#
#  $ cd practice
#
#そのディレクトリ内で, make コマンドを実行してください.
#自動的に実行ファイルや NAMELIST ファイルがコピーされます. 
#make コマンド入力後, まずディレクトリ名を適宜入力してください.
#(下記の例では ape-nh00-exp としています). 
#それ以降の質問はとりあえずそのまま Enter キーを入力してください. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: ape-nh00-exp
#    Directory in which executable files are prepared
#      [../src/main]: 
#            :
#
#そしてそのディレクトリに移動します. 
#
#  $ cd ape-nh00-exp

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 

== 初期値データファイルの作成

dcpam_init_data と init_data_APE_NH00_T21L26.conf
を用いて初期値ファイル init_T21L26.nc を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_APE_NH00_T21L26.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/init_data_APE_NH00_T21L26.conf".
                         : 
   *** MESSAGE [initial_data] ***    PsAvr   = 101080.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L26.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.400020E-01
   ------------------------------------------------
          TOTAL TIME =    0.400020E-01


== 実験用データの準備

実験用データとして, オゾン分布のデータを
以下に用意してあります. 

  * ((<サンプルデータ|URL:http://www.gfd-dennou.org/library/dcpam/sample/2015-02-11_tutorial/APE_NH00/>))

上記のページから "O3_NH00_T021.nc" をダウンロードして, 実験を行うディレクトリに置いてください. 

== SST データファイルの作成

次に, dcpam_init_data_surface と surface_data_APE_NH00_T21.conf を用いて, 海水面データ
surface_T21.nc を作成します. 

  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_APE_NH00_T21.conf

   *** MESSAGE [sst_data] ***  Run: SST data generation
   *** MESSAGE [sst_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/surface_data_APE_NH00_T21.conf".
                         :
   *** MESSAGE [surface_data] ***    SoilHeatCap      = 2100000.
   *** MESSAGE [surface_data] ***    SoilHeatDiffCoef = 1.2
   *** MESSAGE [surface_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [HistoryClose] ***  "surface_T21.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.400000E-02
   ------------------------------------------------
          TOTAL TIME =    0.400000E-02


== 実験の実行

最後に dcpam_main, dcpam_APE_NH00_T21L26.conf を用いて実験を実施します. 
解像度 T21L26 で 2 日分計算を行います. 
リスタートデータ, 地表面リスタートデータといくつかのヒストリデータ
ファイルが出力されます. 

  $ ./bin/dcpam_main -N=./conf/dcpam_APE_NH00_T21L26.conf | tee ape-nh00.log

初期値データ, 地表面データ, 実験設定を変更する場合には,
上記の実行に際して conf ディレクトリ内の init_data_APE_NH00_T21L26.conf, surface_data_APE_NH00_T21.conf, dcpam_APE_NH00_T21L26.conf を変更してください. 


== 結果の可視化

2 日後における温度の東西平均分布は以下の図のようになります.
ただし, コードのバージョンの違いによって, 図は必ずしも下の図と全く同じにはならないかもしれません.
 

((<"IMG:images/ape_nh01_irb_temp_meanlon_time02day.png">))

この図は, ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)) を
用いて,  下の処理によって描画しています. 

  まず irb を起動. 

  $ irb

  以下のような irb のプロンプトが表示されます.

  irb(main):001:0>

  このプロンプトに, 以下のようにコマンドを打ちます.
  左端の数字は行番号で, 打つ必要はありません.

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.tone( gphys.mean('lon').cut('time'=>2) )
  7: GGraph.color_bar
  8: DCL.grcls

  irb のプロンプトにおいて quit と打つと irb を終了することができます. 

この計算で用いている初期値は等温静止大気です. 
この計算で用いている大気 (ほぼ地球大気) は, 2 日間では準定常状態には達しませんので, 
上記の図はスピンアップ中の状態を表しています. 

解析・可視化のもう少し詳しい方法については((<こちら|URL:./visualization.htm>))を参照してください. 

=end JA

=begin EN

== Preparation of a directory for an experiment

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/ape-nh00-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/ape-nh00-exp
  $ cd ../dcpam5-exp/ape-nh00-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data_surface   bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

#Move "practice" directory:
#
#  $ cd practice
#
#In the directory, execute 'make' command. 
#The execution files and the NAMELIST files will be automatically copied. 
#Input directory name first of all after inputting 'make' command. 
#(It is assumed "ape-nh00-exp" in the following example). 
#Input 'Enter' to the question after that. 
#
#  $ make
#
#  ****** Setup a directory for a experiment ******
#
#    Enter directory name [testXX]: ape-nh00-exp
#    Directory in which executable files are prepared
#      [../src/main]: 
#            :
#
#Move the directory
#
#  $ cd ape-nh00-exp


Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.


== Create initial data file

Create initial data file "init_T21L26.nc"
using "dcpam_init_data" and "init_data_APE_NH00_T21L26.conf" 
  
  $ ./bin/dcpam_init_data -N=./conf/init_data_APE_NH00_T21L26.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/init_data_APE_NH00_T21L26.conf".
                         : 
   *** MESSAGE [initial_data] ***    PsAvr   = 101080.
   *** MESSAGE [initial_data] ***    QVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L26.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.400020E-01
   ------------------------------------------------
          TOTAL TIME =    0.400020E-01

== Preparation of additional data

This experiment requires additional data of ozone distribution. 
Those data are prepared at following site.

  * ((<sample data|URL:http://www.gfd-dennou.org/library/dcpam/sample/2015-02-11_tutorial/APE_NH00/>))

Please download "O3_NH00_T021.nc" from above site, and place those files at experimental directory. 


== Create SST data file

Next, create SST data "surface_T21.nc" using
"dcpam_init_data_surface" and "surface_data_APE_NH00_T21.conf". 

  $ ./bin/dcpam_init_data_surface -N=./conf/surface_data_APE_NH00_T21.conf

   *** MESSAGE [sst_data] ***  Run: SST data generation
   *** MESSAGE [sst_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/surface_data_APE_NH00_T21.conf".
                         :
   *** MESSAGE [surface_data] ***    SoilHeatCap      = 2100000.
   *** MESSAGE [surface_data] ***    SoilHeatDiffCoef = 1.2
   *** MESSAGE [surface_data] ***  -- version = $Name:  $$Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
   *** MESSAGE [HistoryClose] ***  "surface_T21.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.400000E-02
   ------------------------------------------------
          TOTAL TIME =    0.400000E-02

== Run the experiment

At the last, run a experiment using 
"dcpam_main" and "dcpam_APE_NH00_T21L22.conf". 
Resolution is T21L26. 
Integration time is 7 days. 
A restart data file, a restart data file of surface data,
and some history data files are output. 

  $ ./bin/dcpam_main -N=./conf/dcpam_APE_NH00_T21L26.conf | tee ape-nh00.log

If initial data, surface data, settings of experiments want to be
changed, edit "init_data_APE_NH00_T21L26.ocnf", "surface_data_APE_NH00_T21.conf", 
"dcpam_APE_NH00_T21L26.conf" in "conf" directory. 


== Visualization of result

Zonal mean temperature distribution after integration for 2 days is shown below. 
It should be noted that the figure you draw may not be the same as that shown here because of difference in model version. 

((<"IMG:images/ape_nh01_irb_temp_meanlon_time02day.png">))

This figure is drawn by using ((<Gphys|URL:http://www.gfd-dennou.org/library/ruby/products/gphys/>)), as follows: 

  Please type irb. 

  $ irb

  Following prompt of irb is shown. 

  irb(main):001:0>

  Type following lines. Please note that the left-most number is line number, and it has not been typed. 

  1: require "numru/ggraph"
  2: include NumRu
  3: gphys = GPhys::IO.open('Temp.nc', 'Temp')
  4: DCL.gropn(1)
  5: DCL.sgpset('lcntl', false) ; DCL.uzfact(0.7)
  6: GGraph.tone( gphys.mean('lon').cut('time'=>2) )
  7: GGraph.color_bar
  8: DCL.grcls

  Type quit to exit irb. 

Above figure shows spin-up phase of the atmosphere, because the Earth's atmosphere 
does not reach quasi-equilibrium in 5 days. 

=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN

=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin

#* Manabe, S., J. Smagorinsky, and R. F. Strickler, 1965: 
#  Simulated climatology of a general circulation model with a
#  hydrologic cycle,
#  ((|Mon. Wea. Rev.|)), ((*93*)), 769--798.

* ((<Mellor, G. L., and T. Yamada, 1974: 
  A hierarchy of turbulence closure models for planetary
  boundary layers,
  ((|J. Atmos. Sci.|)), ((*31*)), 1791--1806.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0469%281974%29031%3C1791%3AAHOTCM%3E2.0.CO%3B2>))

* ((<Moorthi, S., and M. J. Suarez, 1992:
  Relaxed Arakawa-Schubert: A parameterization of moist convection for 
  general circulation models, 
  ((|Mon. Wea. Rev.|)), ((*120*)), 978--1002.
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/1520-0493%281992%29120%3C0978%3ARASAPO%3E2.0.CO%3B2>))

* ((<"Neale, R. B., and B. J. Hoskins, 2000:
  A standard test for AGCMs including their physical parameterizations:
  I: The proposal, 
  ((|Atmos. Sci. Lett.|)), doi:10.1006/asle.2000.0019."|URL:http://onlinelibrary.wiley.com/doi/10.1006/asle.2000.0022/abstract>))

=end

=begin HTML
<hr />
<small>
  $Id: exp-APE-NH00.rd,v 1.8 2015/02/12 16:50:31 yot Exp $
</small>
=end HTML

