=begin JA
= DCPAM 開発における Git のブランチ利用のモデル

履歴
* 2015-03-25 高橋芳幸
* 2015-03-20 高橋芳幸

== まえがき

ここでは, DCPAM Git 共有ディレクトリに置くブランチを示し, 
また, 各ユーザ (開発者) のローカルにおけるのブランチ利用の例を示す
(もちろん実際には, ローカルリポジトリは各ユーザの好きなように使えば良い). 


== 共有リポジトリにおけるブランチ

DCPAM Git 共有リポジトリには下のようなブランチを配置する. 

* master ブランチ
  * 次のリリースのための開発用ブランチ
* feature/<user_name>/<branch_name> ブランチ
  * 各ユーザが個別に開発した内容を共有するときに用いるブランチ
    * 各ユーザは master ブランチに push しても良いが, そうせずに開発内容を共有したい場合に用いることができる


== 各ユーザのローカルリポジトリにおけるブランチ利用の例

ここでは, それぞれのユーザ (開発者) がローカルで用いるブランチの例を示す. 

以下に説明する例の模式図を((<こちら|URL:./fig_git_branch.pdf>))に示す. 
なお, 図中の数字は下に示すコマンド例と対応している. 

ローカルリポジトリでのブランチの例
* master ブランチ
  * 共有リポジトリの clone から始まる開発用リポジトリ
* feature ブランチ
  * 新機能を開発したいときに用いるリポジトリ
    * 各ユーザは, ローカルの master ブランチを用いて開発しても良い.
    * もし実験的な開発など, ローカルの master ブランチを変更せずに作業したい場合には新しいブランチを作ると良いだろう.
    * もちろん名前は feature である必要はない

上記のローカルのリポジトリを用いることを考えると, 下のような作業手順となる.
* 共有リポジトリから master ブランチを取得
* [必要に応じて] ローカルの master ブランチからローカルの feature ブランチを作成
* ローカルの master or feature ブランチで開発
  * 共有リポジトリの master ブランチが他のユーザによって更新されたら, その更新をローカルの master or feature ブランチにマージ
* [必要に応じて] feature ブランチの開発が成功したらローカルの master ブランチにマージ
* [必要に応じて] feature ブランチの開発が終了/上手く行かなければ feature ブランチを削除
* ローカルの master ブランチの内容を共有リポジトリの master ブランチ or feature/<user_name>/<branch_name> ブランチに push


== 作業手順

=== 共有リポジトリから clone [1]

  > git clone -v dennou-k.gfd-dennou.org:/GFD_Dennou_Club/ftp/library/dcpam/git_repos/dcpam.git


=== [必要に応じて] ローカルに master から feature ブランチを作成 [2]

feature ブランチを作成.

  > git branch feature

作業ブランチを feature ブランチに設定.

  > git checkout feature

git branch のみでは, 作業は引き続き元のブランチで行われる.
feature ブランチで作業するためには checkout が必要.

あるいは, git branch と git checkout は下のようにすると同時に実行できる.

  > git checkout -b feature


=== ローカルでの開発結果をコミット [3].

開発結果をローカルにコミット. 

まずファイルをインデックスに追加.

  > git add <file>

ファイルの更新をコミット.

  > git commit <file> -m "...comments..."


==== リモートの master ブランチが更新された時に更新を取り込む [4]

もしリモートの master ブランチが更新されたらローカルに取り込む必要が
あるかもしれない. 

作業ブランチを master ブランチに設定.

  > git checkout master

リモートの master ブランチの更新情報を取得. 

  > git fetch origin master

ただし, このとき, ローカルのファイルは更新されない. ただ, ローカルで
保持しているリモートの master リポジトリの更新情報 (origin/master) を
更新するだけである.

この取得した情報を使うことで, ローカルの master ブランチとの diff を
とることができる. 

  > git diff master origin/master

問題なければ, merge する. 

  > git merge origin/master

なお, 上記で使っている fetch と merge を合わせた操作が pull である. 
diff を取る必要がなければ下の操作のみで済む.

  > git pull origin master

ローカルに feature ブランチを作成している場合には同様に取り込む必要が
あるだろう. 

=== [必要に応じて] ローカルの feature の開発が成功したらローカルの master ブランチにマージ [5]

作業ブランチを master ブランチに設定.

  > git checkout master

feature ブランチをマージ. 

  > git merge --no-ff feature

この --no-ff は, マージしたことをログに残すためのオプション.


=== ローカルの master ブランチをリモートに反映 [6]

==== リモートの master ブランチに反映

作業ブランチを master ブランチに設定.

  > git checkout master

ローカルの master ブランチをリモートの master ブランチに反映 (push).

  > git push origin master

==== リモートの他のブランチに反映

作業ブランチを master ブランチに設定.

  > git checkout master

ローカルの master ブランチをリモートの <remote_branch> ブランチに反映 (push).

  > git push origin master:<remote_branch>

<remote_branch> は, 例えば feature/<user_name>/<branch_name>.

=== [必要に応じて] (ローカルの) feature ブランチを削除 [7]

  > git branch -d feature

=== [必要に応じて] リモートのブランチを削除

  > git push --delete origin <remote_branch>


== 一般的なこと

=== ブランチを表示

  > git branch

リモートも含めて表示

  > git branch -a


=== ブランチの作成とチェックアウト

ブランチを作成してチェックアウト

  > git checkout -b <branch> <start point>

作成とチェックアウトを分けてやる

  > git branch <branch> <start point>
  > git checkout <branch>

git branch のみでは HEAD は移らない. 

=== ブランチの削除

  > git checkout -d <branch>

=== 誰かが消してしまったリモートのブランチの情報をローカルから削除

削除されたリモートのブランチを確認.

  > git remote show origin

dry run. (実際には削除せずに, 何が起こるか確認.)

  > git remote prune -n origin

dry run で問題なければ実際に削除.

  > git remote prune origin


== 参考文献

* "A successful Git branching model" [((<英語|URL:http://nvie.com/posts/a-successful-git-branching-model/>))]|[((<日本語|URL:http://keijinsonyaban.blogspot.jp/2010/10/successful-git-branching-model.html>))]
* ((<【初心者向け】gitのbranch運用入門【git flow もどき】|URL:http://ism1000ch.hatenablog.com/entry/2014/03/31/152441>))


#* master ブランチ
#  * 製品としてリリースされる状態にあるブランチ
#    * 共有リポジトリにも存在するブランチ
#  * DCPAM Git リポジトリでは push できるユーザを制限している
#* develop ブランチ
#  * 次のリリースのための開発用ブランチ
#    * ソースコードが安定したら master ブランチへマージされる
#    * 共有リポジトリにも存在するブランチ
#  * 分岐元
#    * master
#  * マージ先
#    * master
#* feature ブランチ
#  * 新機能を開発するためのブランチ
#    * 残念ながら捨てられるかもしれない開発を行うブランチ
#    * 共有リポジトリには存在しないブランチ
#  * 分岐元
#    * develop
#  * マージ先
#    * develop
#* release ブランチ
#  * 新しい製品のリリースを準備するブランチ
#    * 共有リポジトリには存在しないブランチ
#  * 分岐元
#    * develop
#  * マージ先
#    * develop と master
#* hotfix ブランチ
#  * 後々追記.


=end JA
