=begin JA

= dcpam5 ドキュメントの概説と保守管理の解説

# * 森川 靖大 (morikawa)
#   * $Id: doc-overview.rd,v 1.4 2009/04/05 14:40:02 morikawa Exp $

=end JA

=begin JA

本文書は dcpam5 ドキュメントを概観し,
その保守管理について記します.

== 概説

dcpam5 では以下の種類のドキュメントを用意しています.

* ((<インストールガイド|URL:../../INSTALL.htm>)),
  ((<開発履歴|URL:../../HISTORY.htm>)),
  ((<使用上の注意とライセンス規程|URL:../../CREDITS.htm>)) ((*[rdtool]*))
* ((<チュートリアル|URL:../tutorial>)) ((*[rdtool]*))
* マニュアル
  * ((<支配方程式系とその離散化|URL:../basic_equations/htm/basic_equations.htm>)) ((*[TeX]*))
  * ((<導出に関する参考資料|URL:../derivation/htm/derivation.htm>)) ((*[TeX]*))
  * ((<コード解説|URL:../code_description/htm/code_description.htm>)) ((*[TeX]*))
  * コードリファレンス
    * ((<トップページ|URL:../code_reference/>)) ((*[rdtool]*))
    * ((<リファレンス本体|URL:../code_reference/htm>)) ((*[RDoc]*))
* 開発者・メンテナ向け各種文書 ((*[rdtool]*))
  * 本文書, 
    ((<configure と Config.mk.in の保守管理|URL:configure.htm>)), 
    ((<リリースのための作業|URL:release.htm>)), …
* ((<ChangeLog|URL:../../ChangeLog>)) ((*[git2cl]*))

これらの文書は HTML (または XHTML) となっており,
ブラウザから参照することが想定されています.
(一部, PDF も生成しています). 

しかし, 保守管理を容易にするため, それぞれの文書は HTML
等を直接編集するのでは無く, 
別途ソースとなるファイルを用意し, そのファイルから HTML
等を自動生成するようにしています. 
上記文書のうち, 末尾に ((*[rdtool]*)) と記述されているものは,
RD (Ruby Document) 形式のテキストをソースファイルとしています. 
((*[TeX]*)) と記述されているものは TeX 形式のテキストをソースファイルとしています. 
((*[RDoc]*)) と記述されているものは, Fortran 90/95
コードをソースファイルとしています. 
((*[git2cl]*)) と記述されているものは, Git
で管理されているバージョン情報やログ情報をソースとしています
(例外的に「ソースファイル」という形態では管理していません).


以下ではその保守管理のために必要なソフトウェア,
HTML 生成のための具体的な手順について記します.


== 保守管理に必要なソフトウェア

上記ドキュメントを保守管理する際には,
以下のソフトウェアが必要となります.

* ((<Ruby|URL:http://www.ruby-lang.org/>))
* ((<Perl|URL:http://www.perl.org/>))
* ((<GNU Make|URL:http://www.gnu.org/software/make/>))
* ((<rdtool|URL:http://raa.ruby-lang.org/project/rdtool/>))
* ((<rd2html-ext|URL:http://raa.ruby-lang.org/project/rd2html-ext>))
* ((<LaTeX|URL:http://www.latex-project.org/>))
  * スタイルファイル: ((<Dennou6 style|URL:http://www.gfd-dennou.org/library/cc-env/TeXmacro/dennou/SIGEN.htm>))
* ((<LaTeX2HTML 日本語の扱いに関する修正と Dennou6 style に関して拡張したもの|URL:http://www.gfd-dennou.org/library/cc-env/latex2html/SIGEN.htm>))
* ((<DVIPDFMx|URL:http://project.ktug.or.kr/dvipdfmx/>))
* ((<"RDoc Fortran90/95 ソースコード解析機能強化版"|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95>))

以降では, これらを以下のように実行できることを想定して解説します.
システムへのインストールやパスの設定を適切に行ってください.

* Ruby

    $ ruby -v
    ruby 1.X.X (20XX-XX-XX) ...

* Perl

    $ perl -v
    This is perl, vX.X.X built ...

* GNU Make

    $ make -v  (もしくは gmake -v)
    GNU Make X.XX ..

  以下では, make コマンドが GNU Make であると想定しています.
  gmake が GNU Make である環境では, make を gmake に置き換えてください.

* rdtool

    $ rd2 -v
    RDtool -- rd2 X.X.XX ..

* rd2html-ext

    $ rd2 -r rd/rd2html-ext-lib --version
    ... RDtool -- RD2HTMLVisitor X.X.XX ...

* LaTeX

    $ ptex --version
    pTeX 3.141...

* LaTeX2HTML 日本語修正, Dennou6 style 拡張版

    $ latex2html -version
    ... This is jLaTeX2HTML Version 2002-2-1 ...
    (ヘルプ自体は, オリジナルの LaTeX2HTML と変わりません)

* DVIPDFMx

    $ dvipdfmx
    This is dvipdfmx-XXXXXX by the DVIPDFMx project team, ...

* RDoc Fortran90/95 ソースコード解析機能強化版

    $ rdoc --version
    rdoc RDoc modified by GFD Dennou Club ...

  もしくは

    $ rdoc-f95 --version
    rdoc-f95 X.X.X ...


== rdtool を用いたドキュメントの保守管理

ドキュメントの多くは, 
RD 形式のテキストファイル (以降は RD ファイルと呼びます) 
として管理され, これを rdtool を用いて
HTML に変換して公開されます. 

以下では, それぞれ

  (1) ((<RD ファイルの編集>))
  (2) ((<新規のディレクトリの作成と RD ファイル管理に必要な作業>))

を行うための手順を記します.

また, 例外として
((<doc 以下に置いていない RD 形式のドキュメントの管理>))
についても記します.

=== RD ファイルの編集

一連の手順は以下のようになります.

  (1) RD 形式のテキストファイルの作成もしくは編集
  (2) rdtool と GNU Make による HTML の作成

以下では, この 2 つの手順の詳細を記します.

==== 1. RD 形式のテキストファイルの作成もしくは編集

RD 形式のテキストファイルの書き方については,
((<地球流体電脳倶楽部 dcmodel プロジェクト: モデルプロジェクトのための最低限 rd -- rd ファイルの作成|URL:http://www.gfd-dennou.org/library/dcmodel/doc/TEBIKI.dcmodel-rd-guide.htm#label-10>))
を参考にしてください.

ファイルを新規作成した場合には, そのファイルの拡張子を ((*rd*)) とし,
doc ディレクトリに置いてください.

==== 2. rdtool と GNU Make による HTML の作成

HTML を作成する際には, doc ディレクトリ以下で
以下のように make を実行してください.

  $ make rd2html

これにより, 拡張子 ((*rd*)) のファイルから, その拡張子を
((*htm*)) および ((*htm.en*)) に置き換えたファイルが作成されます.

  |****.rd  =====[make]=====>  ****.htm, ****.htm.en 

直接 rd2 コマンドを入力する必要はありません.
事前に用意されている Makefile および Makefile.rd2html
内で rd2 コマンドが実行されるとともに, その他のいくつかの処理が行われます.


=== 新規のディレクトリの作成と RD ファイル管理に必要な作業

((<RD ファイルの編集>)) において,
rdtool を用いたドキュメントの日常的な保守管理方法を記しました.

以下では, doc 以下に新たなディレクトリを作成してそこにドキュメントを作成する場合について記します.
ここでは, doc 以下に users というディレクトリを作成し,
そこでドキュメントを管理することを想定して解説します.

==== 1. Makefile.rd2html のダウンロード

users ディレクトリを作成し, そこに移動した後,
((<地球流体電脳倶楽部 dcmodel プロジェクト: モデルプロジェクトのための最低限 rd|URL:http://www.gfd-dennou.org/library/dcmodel/doc/TEBIKI.dcmodel-rd-guide.htm>))
より ((<Makefile.rd2html|URL:http://www.gfd-dennou.org/library/dcmodel/doc/sample_Makefile/Makefile.rd2html>))
をダウンロードします.

  $ mkdir users
  $ cd users
  $ wget http://www.gfd-dennou.org/library/dcmodel/doc/sample_Makefile/Makefile.rd2html

==== 2. Makefile の作成

users ディレクトリ以下に Makefile を作成します.
((<サンプル Makefile|URL:doc-overview.Makefile>))
をダウンロードし, Makefile にリネームしてください.

  $ mv doc-overview.Makefile Makefile

Makefile について, 以下の項目について編集を行ってください.
編集が必須となる項目は "< >" で括られています.

* 作者

  Makefile を編集者の名前を記してください.

    # Authors::   <Input your name>

* ディレクトリの深さ DIRDEPTH

  今回の場合, doc/users ディレクトリを用意しているため,
  "((*../..*))" を与えてください.

    DIRDEPTH=<Input relative path to dcpam5 top directory. For example, "../..", etc.>

#* インストール先ディレクトリ DEST_DOC_THISDIR
#
#  今回の場合, ((*doc/users*)) を与えてください.
#  ($(DEST_DOC) は消さないようにしてください).
#
#    DEST_DOC_THISDIR=$(DEST_DOC)/<Input directory name>


==== 3. 動作テスト

以上でとりあえずの準備は完了です.
RD ファイルを users ディレクトリに置いた後,
HTML ファイルの作成と削除を試してください.

* HTML ファイルの作成

  doc/users ディレクトリで, 以下のようにコマンドを実行してください.

    $ make rd2html

  htm, htm.en ファイルが作成されれば OK です.


* HTML ファイルの削除

  doc/users ディレクトリで, 以下のようにコマンドを実行してください.

    $ make clean.rd2html

  htm, htm.en ファイルが削除されれば OK です.


==== 4. Makefile.rd2html の編集

ダウンロードした Makefile.rd2html の冒頭には,
HTML 生成に関する各種設定項目が並んでいます.
スタイルシートファイルやヘッダ, フッタなど,
必要に応じて適宜修正を行ってください.

既に作成されている doc や doc/tutorial 以下の Makefile.rd2html
を参考にして下さい.


==== 5. doc ディレクトリの Makefile の編集

トップディレクトリで make doc や make install-doc コマンドを入力した際に,
doc/users 以下でも HTML の生成もしくはインストールが為されるよう,
doc 直下の Makefile の編集を行います.
以下のように SUBDIRS 変数に, 作成したディレクトリを追記してください.

  SUBDIRS=images tutorial users


=== doc 以下に置いていない RD 形式のドキュメントの管理

例外的に, doc 以下に置いていない文書として,
((<インストールガイド|URL:../../INSTALL.htm>)),
((<開発履歴|URL:../../HISTORY.htm>)),
((<使用上の注意とライセンス規程|URL:../../CREDITS.htm>))
といったものがあります.

これらのソースファイルには拡張子 rd を付加せず,
それぞれ ((<INSTALL|URL:../../INSTALL>)),
((<HISTORY|URL:../../HISTORY>)), ((<CREDITS|URL:../../CREDITS>))
がソースファイルとなっています.

これらから htm, htm.en ファイルを作成する際には,
dcpam5 トップディレクトリにおいて以下のコマンドを入力します.

  $ make guide


== TeX を用いたドキュメントの保守管理

数式を多く含むドキュメントは TeX 形式のテキストとして管理され, 
これを LaTeX, LaTeX2HTML, DVIPDFMx を用いて, HTML および PDF 
に変換して公開されます. 現在は以下の 3 種類の文書が TeX
形式のテキストとして管理されています. 

  * ((<支配方程式系とその離散化|URL:basic_equations/htm/basic_equations.htm>))
  * ((<導出に関する参考資料|URL:derivation/htm/derivation.htm>))
  * ((<コード解説|URL:code_description/htm/code_description.htm>))

以下では, これらドキュメントのディレクトリ構造と,
HTML や PDF 生成の方法に関して記します.
なお, TeX 書式に関しては, 書籍や Web 上から多数の情報が得られると思われるため, 
ここでの説明は割愛します. 

=== TeX を用いたドキュメントに関するディレクトリ構造

TeX を用いたドキュメントは以下のような構造のディレクトリツリーに格納されます.
<tex_dir_name> は, それぞれ basic_equations, derivation,
code_description で置き換えられます. 

  doc/<tex_dir_name>
  |
  |-- Makefile                ドキュメント生成用 Makefile
  |
  |-- src/                    TeX 置場 (PS や EPS 等の画像も格納される) 
  |   |
  |   |-- <tex_dir_name>.tex  TeX メインファイル
  |   |
  |   |-- Makefile            LaTeX, LaTeX2HTML, DVIPDFMx に関連する設定
  |   |                       が記述された Makefile
  |   |
  |   `-- xxxxxx/             TeX サブディレクトリ
  |
  |-- htm/                    LaTeX + LaTeX2HTML で自動生成される HTML 置場
  |
  `-- pub/                    LaTeX + DVIPDFMx で自動生成される PDF 置場


=== ドキュメント (HTML, PDF) 生成の方法

それぞれのディレクトリ (doc/basic_equations 等) に移動したのち,

  $ make

を入力することで, 上記の ((*htm*)), ((*pub*)) ディレクトリが自動生成され, 
そのディレクトリ内に HTML ファイルと PDF ファイルがそれぞれ作成されます. 


=== ドキュメント (HTML, PDF) 生成の設定の変更

LaTeX, LaTeX2HTML, DVIPDFMx に関連する設定は,
それぞれのディレクトリの src/Makefile に記述されます. 
設定を変更する際には, これら Makefile を編集してください. 



== RDoc を用いたドキュメントの保守管理

コードリファレンスは, トップページのみ rdtool を用いて管理されていますが,
本体は
((<"RDoc Fortran90/95 ソースコード解析機能強化版"|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95>))
を用いて, Fortran 90/95 ソースコードから自動生成されています.
以下では, ディレクトリ構造と, 

  (1) ((<RDoc を用いたドキュメントの日常的な保守管理>))
  (2) ((<RDoc によるドキュメント生成の設定変更>))

について記します.

=== RDoc を用いたドキュメントに関するディレクトリ構造

コードリファレンスに関するドキュメントのディレクトリ構造は以下のようになっています. 

  doc/code_reference
  |
  |-- index.rd     トップページの RD ファイル
  |-- index.htm    index.rd から生成される HTML ファイル (日)
  |-- index.htm.en               〃                      (英)
  |
  |-- Makefile     RDoc に関する設定が記述された Makefile
  |
  |-- htm/         MathML を用いずに作成したコードリファレンス
  |
  `-- xml/         MathML を用いて作成したコードリファレンス


MathML とは, 数式用のマークアップ言語で, 画像を使用することなく,
ブラウザ上で数式を表現することを目的としたものです. 
((<"RDoc Fortran90/95 ソースコード解析機能強化版"|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95>))
では,
((<ひらくの工房|URL:http://www.hinet.mydns.jp/~hiraku/>))
にて公開されている Ruby 用 MathML ライブラリを使用することで,
ソースコード中のコメントに記述される TeX 書式のテキストを MathML に変換し, 
コードリファレンスに埋め込んでいます.
((<Mozilla Firefox|URL:http://www.mozilla.org/products/firefox/>))
および Internet Explorer
(+ ((<MathPlayer|URL:http://www.dessci.com/en/products/mathplayer/>)))
では正しく表示されることを確認していますが,
メジャーなブラウザの中にも MathML に対応していないものがあるため,
MathML を用いないコードリファレンスも用意しています. 


=== RD ファイルの編集に関して

doc/code_reference 以下の index.rd の編集および
index.htm, index.htm.en の生成に関しては,
((<rdtool を用いたドキュメントの保守管理>)) を参照ください. 


=== RDoc を用いたドキュメントの日常的な保守管理

一連の手順は以下のようになります.

  (1) Fortran ソースコードの編集
  (2) RDoc と GNU Make による HTML の作成

以下では, この 2 つの手順の詳細を記します.

==== 1. Fortran ソースコードの編集

Fortran ソースコード中に既定の書法でコメントを記述することで,
これをコードリファレンスに反映することが可能です.
書法については,
((<チュートリアル: RDoc による数値モデルの自動ドキュメント生成|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95/tutorial/>))
の
((<7.2 RDoc によるドキュメント生成 -- コメントを書き込んでみる|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95/tutorial/#label-13>))
および
((<8.1 RDoc の便利な機能を使ってみる -- コメント部の修飾|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95/tutorial/#label-16>))
を参考にして下さい.
詳細については
((<"RDoc Fortran 90/95 解析機能強化版におけるコメントの書き方"|URL:http://www.gfd-dennou.org/library/dcmodel/rdoc-f95/rdoc-f95/doc/files/parsers/parse_f95_rb.html>))
を参照してください.


==== 2. RDoc と GNU Make による HTML の作成

doc ディレクトリ以下で以下のコマンドを入力することで,
Makefile が rdoc コマンドを呼び出し, コードリファレンスが生成されます.

  $ make

直接 rdoc コマンドを入力する必要はありません.


=== RDoc によるドキュメント生成の設定変更

((<RDoc を用いたドキュメントの日常的な保守管理>)) において,
RDoc を用いたドキュメントの日常的な保守管理方法を記しました.

以下では, RDoc におけるドキュメント生成の際の設定の変更について記します.

==== RDoc 生成用 Makefile の設定項目

doc/code_reference ディレクトリ以下の
((<Makefile|URL:../code_reference/Makefile>)) が,
それぞれ, MathML 使用および不使用のコードリファレンス作成の Makefile です. 
以下では, いくつかの設定項目について紹介します. 

* 出力先ディレクトリ OPDIR, OPDIRNOMATH

    OPDIR           = xml
                       # Document directory (with MathML)
                       # [JA] 出力先ディレクトリ (MathML 使用)
    OPDIRNOMATH     = htm
                       # Document directory (without MathML)
                       # [JA] 出力先ディレクトリ (MathML 不使用)

* ソースコード置場ディレクトリ SRCDIR

    SRCDIR          = $(DIRDEPTH)/src
                       # Source code directory
                       # [JA] ソースコード置き場ディレクトリ

* ソースファイル SRCFILES

  RDoc は引数を指定しない場合, RDoc が解釈可能なソースコード
  (Ruby, C, Fortran 等) を自動的に解釈しますが,
  ここでは以下のように明示的にファイルを指定しています.
  これは上記 SRCDIR からの相対パスとして記述しています.

    SRCFILES        = */*.f90 */*.F90 SRC_DIR_LIST
                       # Source code files
                       # [JA] ソースファイル

* RDoc ドキュメントのメインページ MAINPAGE

  code_reference ディレクトリ以下の index.html
  を閲覧した際に表示するページを指定します.
  以下の例であれば, src 以下のファイル,
  ディレクトリリストに関するページがメインとなります.

    MAINPAGE        = SRC_DIR_LIST
                       # Main page
                       # [JA] メインページ


== ChangeLog の保守管理

ChangeLog は, Git で管理されているバージョン情報やログ情報をソースとしています.

更新は dcpam5 トップディレクトリで以下のコマンドを入力します.

  $ make cl

これにより, ChangeLog が更新されます.


== 一括でのドキュメント生成

rdtool, TeX, RDoc を用いたドキュメントについて,
その生成を一括で行うには, dcpam5 トップディレクトリで

  $ make doc

とするか, doc ディレクトリ以下で

  $ make

として下さい.

ただし, ChangeLog のみ別途生成する必要があります.


=end JA

=begin HTMLJA
<hr />
<small>
  $Id: doc-overview.rd,v 1.4 2009/04/05 14:40:02 morikawa Exp $
</small>
=end HTMLJA
