!= ֥ե륿 (Williams, 2009)
!
!= Time filter (Williams, 2009)
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timefilter_williams2009
  !
  != ֥ե륿 (Williams, 2009)
  !
  != Time filter (Williams, 2009)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ׻⡼ɤޤ뤿λ֥ե륿 (Williams, 2009)
  ! ŬѤ뤿Υ⥸塼Ǥ.
  ! Time filter by Williams (2009) is the modified version of that 
  ! by Asselin (1972).
  !
!!$  ! ʤ
!!$  ! \[
!!$  !   \bar{A}^{t}
!!$  !   = {A}^{t}
!!$  !     + \epsilon_f
!!$  !        \left( 
!!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
!!$  !        \right) \] \[
!!$  !   \qquad
!!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
!!$  !     + \epsilon_f 
!!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
!!$  ! \]
!!$  ! Ȥ $ \bar{A}^{t} $ ޤ. ź
!!$  ! $ t-\Delta t, t, t+\Delta t $ Ϥ줾֥ƥåפɽ,
!!$  ! ե륿ŬѤ줿ˤϾ ( $ \bar{\quad} $ ) 
!!$  ! դƤޤ.
!!$  !
!!$  ! ե륿η $\epsilon_f$  Create κݤꤷޤ.
!!$  !
!!$  !--
!!$  ! \[
!!$  !   \bar{\mathscr A}^{t}
!!$  !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
!!$  !     +  \epsilon_f 
!!$  !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
!!$  ! \]
!!$  ! Ȥ$\bar{\mathscr A}^{t}$ޤ. ź
!!$  !++
!!$  !
!!$  ! Time filter (Asselin, 1972) for suppression of computational mode 
!!$  ! is applied.
!!$  !
!!$  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
!!$  ! \[
!!$  !   \bar{A}^{t}
!!$  !   = {A}^{t}
!!$  !     + \epsilon_f
!!$  !        \left( 
!!$  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
!!$  !        \right) \] \[
!!$  !   \qquad
!!$  !   = ( 1-2 \epsilon_f ) {A}^{t}
!!$  !     + \epsilon_f 
!!$  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
!!$  ! \]
!!$  ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step, 
!!$  ! and over-bar $ \bar{\quad} $ represents the terms applied 
!!$  ! time filter.
!!$  !
!!$  ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
  !
  !== Procedures List
  ! 
  ! TimeFilterWilliams2009    :: ֥ե륿Ŭ
  ! ------------------------  :: ------------
  ! TimeFilterWilliams2009    :: Apply time filter
  !
  !== NAMELIST
  !
  ! NAMELIST#timefilter_williams2009_nml
  !
  !== References
  !
  ! * Williams, P. D., 2009: 
  !   A proposed modification to the Robert-Asselin time filter, 
  !   <i>Mon. Wea. Rev.</i>, <b>137</b>, 2538--2546. 
  !
  ! * Asselin, R. A., 1972: 
  !   Frequency filter for time integrations.
  !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  use composition, only: ncmax  ! ʬο
                                ! Number of composition

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: TimeFilterWilliams2009
  public :: TimeFilterWilliams2009SurfVars
  public :: TimeFilterWilliams2009Init

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: timefilter_williams2009_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), save :: FilterParameterRA
                              ! Robert-Asselin ֥ե륿η. 
                              ! Time filter coefficient for Robert-Asselin filter
                              ! This is equal to nu/2 in Williams (2009).
  real(DP), save :: FilterParameterW
                              ! Williams ֥ե륿η. 
                              ! Time filter coefficient for Williams filter
                              ! This is equal to alpha in Williams (2009).

  character(*), parameter:: module_name = 'timefilter_williams2009'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: timefilter_williams2009.f90,v 1.4 2015/01/29 12:09:04 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine TimeFilterWilliams2009(                 &
    & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
    & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
    & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (inout)
    & )
    !
    ! ͽѿ˥ե륿ŬѤޤ. 
    !
    ! Time filter is applied to predictional variables.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only: &
    &                    IndexH2OVap

    ! ̤
    ! Mass fixer
    !
    use mass_fixer, only: MassFixer

    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level,
    ! and calculate pressure and height
    !
    use auxiliary, only: AuxVars

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t-\Delta t) $ .   . Mass mixing ratio of constituents
    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t) $ .     . Mass mixing ratio of constituents
    real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
    real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
    real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
    real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t+\Delta t) $ .   . Temperature
    real(DP), intent(inout):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t+\Delta t) $ .   . Mass mixing ratio of constituents
    real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
    real(DP) :: xyz_Delta (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyzf_Delta(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)

    !   Variables for mass fix
    real(DP) :: xy_PsNSave    (0:imax-1, 1:jmax)
    real(DP) :: xy_PsASave    (0:imax-1, 1:jmax)
    real(DP) :: xyzf_QMixNSave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
    real(DP) :: xyzf_QMixASave(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
    real(DP) :: xyr_PressNSave(0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_PressASave(0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_PressN    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_PressA    (0:imax-1, 1:jmax, 0:kmax)

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. timefilter_williams2009_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! FilterParameterRA ͭΥå
    ! Check validity of "FilterParameterRA"
    !
    if ( FilterParameterRA == 0.0_DP ) return


    ! Variables are saved
    xy_PsNSave     = xy_PsN
    xy_PsASave     = xy_PsA
    xyzf_QMixNSave = xyzf_QMixN
    xyzf_QMixASave = xyzf_QMixA


    ! ե륿Ŭ
    ! Apply time filter
    !
    xyz_Delta  =  &
      & + FilterParameterRA * ( xyz_UB     - 2.0_DP * xyz_UN     + xyz_UA     )
    xyz_UN     =  xyz_UN    &
      & + FilterParameterW              * xyz_Delta
!!$    xyz_UA     =  xyz_UA    &
!!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
    xyz_UA     =  xyz_UA    &
      & - ( 1.0_DP - FilterParameterW ) * xyz_Delta

    xyz_Delta  =  &
      & + FilterParameterRA * ( xyz_VB     - 2.0_DP * xyz_VN     + xyz_VA     )
    xyz_VN     =  xyz_VN    &
      & + FilterParameterW              * xyz_Delta
!!$    xyz_VA     =  xyz_VA    &
!!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
    xyz_VA     =  xyz_VA    &
      & - ( 1.0_DP - FilterParameterW ) * xyz_Delta

    xyz_Delta  =  &
      & + FilterParameterRA * ( xyz_TempB  - 2.0_DP * xyz_TempN  + xyz_TempA  )
    xyz_TempN  =  xyz_TempN &
      & + FilterParameterW              * xyz_Delta
!!$    xyz_TempA  =  xyz_TempA &
!!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyz_Delta
    xyz_TempA  =  xyz_TempA &
      & - ( 1.0_DP - FilterParameterW ) * xyz_Delta

    xy_Delta   =  &
      & + FilterParameterRA * ( xy_PsB     - 2.0_DP * xy_PsN     + xy_PsA     )
    xy_PsN     =  xy_PsN    &
      & + FilterParameterW              * xy_Delta
!!$    xy_PsA     =  xy_PsA    &
!!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
    xy_PsA     =  xy_PsA    &
      & - ( 1.0_DP - FilterParameterW ) * xy_Delta

    xyzf_Delta =  &
      & + FilterParameterRA * ( xyzf_QMixB - 2.0_DP * xyzf_QMixN + xyzf_QMixA )
!!$    xyzf_QMixN = xyzf_QMixN + xyzf_Delta
    xyzf_QMixN = xyzf_QMixN &
      & + FilterParameterW              * xyzf_Delta
!    xyzf_QMixA = xyzf_QMixA &
!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xyzf_Delta
    xyzf_QMixA = xyzf_QMixA &
      & - ( 1.0_DP - FilterParameterW ) * xyzf_Delta
    !
    ! Mass fix
    !   MEMO (1/2):
    !     If mass fixing below is commented out, filter behaves like 
    !     Robert-Asselin filter.
    !   -----
    call AuxVars( &
      & xy_PsNSave, xyz_TempN, xyzf_QMixNSave(:,:,:,IndexH2OVap), & ! (in )
      & xyr_Press = xyr_PressNSave                                & ! (out) optiona
      & )
    call AuxVars( &
      & xy_PsN    , xyz_TempN, xyzf_QMixN    (:,:,:,IndexH2OVap), & ! (in )
      & xyr_Press = xyr_PressN                                    & ! (out) optiona
      & )
    call MassFixer(                    &
      & xyr_PressN,                    & ! (in)
      & xyzf_QMixN,                    & ! (inout)
      & xyr_PressRef = xyr_PressNSave, & ! (in) optional
      & xyzf_QMixRef = xyzf_QMixNSave  & ! (in) optional
      & )
    call AuxVars( &
      & xy_PsASave, xyz_TempA, xyzf_QMixASave(:,:,:,IndexH2OVap), & ! (in )
      & xyr_Press = xyr_PressASave                                & ! (out) optiona
      & )
    call AuxVars( &
      & xy_PsA    , xyz_TempA, xyzf_QMixA    (:,:,:,IndexH2OVap), & ! (in )
      & xyr_Press = xyr_PressA                                    & ! (out) optiona
      & )
    call MassFixer(                    &
      & xyr_PressA,                    & ! (in)
      & xyzf_QMixA,                    & ! (inout)
      & xyr_PressRef = xyr_PressASave, & ! (in) optional
      & xyzf_QMixRef = xyzf_QMixASave  & ! (in) optional
      & )
    !   -----


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine TimeFilterWilliams2009

  !--------------------------------------------------------------------------------------

  subroutine TimeFilterWilliams2009SurfVars(           &
    & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, & ! (in)
    & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, & ! (inout)
    & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA, & ! (inout)
    & xy_PsA                                           & ! (inout)
    & )
    !
    ! ͽѿ˥ե륿ŬѤޤ. 
    !
    ! Time filter is applied to predictional variables.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & Grav
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
                              ! $ M_mcs (t-\Delta t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
                              ! $ M_ss (t-\Delta t) $ . .
                              ! Surface snow amount
    real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
                              ! $ M_mcs (t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
                              ! $ M_ss (t) $ . .
                              ! Surface snow amount
    real(DP), intent(inout):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
                              ! $ M_mcs (t+\Delta t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(inout):: xy_SoilMoistA (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(inout):: xy_SurfSnowA  (0:imax-1, 1:jmax)
                              ! $ M_ss (t+\Delta t) $ . .
                              ! Surface snow amount
    real(DP), intent(inout):: xy_PsA (0:imax-1, 1:jmax)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP) :: xy_Delta  (0:imax-1, 1:jmax)
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. timefilter_williams2009_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! FilterParameterRA ͭΥå
    ! Check validity of "FilterParameterRA"
    !
    if ( FilterParameterRA == 0.0_DP ) return

    ! ե륿Ŭ
    ! Apply time filter
    !
    xy_Delta   =  &
      & + FilterParameterRA                                         &
      & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )
    xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
      & + FilterParameterW              * xy_Delta
!!$    xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
!!$      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
    xy_SurfMajCompIceA = xy_SurfMajCompIceA                         &
      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
!!$    xy_SurfMajCompIceN = max( xy_SurfMajCompIceN, 0.0_DP )
!!$    xy_SurfMajCompIceA = max( xy_SurfMajCompIceA, 0.0_DP )
    ! Mass fix
    !   MEMO (2/2):
    !     If mass fixing below is commented out, filter behaves like 
    !     Robert-Asselin filter.
    !   -----
    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfMajCompIceA(i,j) < 0.0_DP ) then
          xy_PsA(i,j) = xy_PsA(i,j) + xy_SurfMajCompIceA(i,j) * Grav
          xy_SurfMajCompIceA(i,j) = 0.0_DP
        end if
      end do
    end do
    !   -----

    xy_Delta   =  &
      & + FilterParameterRA                                         &
      & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )
    xy_SoilMoistN = xy_SoilMoistN + xy_Delta
!!$    xy_SoilMoistN = xy_SoilMoistN                                   &
!!$      & + FilterParameterW              * xy_Delta
!!$!    xy_SoilMoistA = xy_SoilMoistA                                   &
!!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
!!$    xy_SoilMoistA = xy_SoilMoistA                                   &
!!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
!!$    xy_SoilMoistN = max( xy_SoilMoistN, 0.0_DP )
!!$    xy_SoilMoistA = max( xy_SoilMoistA, 0.0_DP )

    xy_Delta   =  &
      & + FilterParameterRA                                         &
      & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )
    xy_SurfSnowN  = xy_SurfSnowN + xy_Delta
!!$    xy_SurfSnowN  = xy_SurfSnowN                                    &
!!$      & + FilterParameterW              * xy_Delta
!!$!    xy_SurfSnowA  = xy_SurfSnowA                                    &
!!$!      & - ( 1.0_DP - FilterParameterW ) * FilterParameterW * xy_Delta
!!$    xy_SurfSnowA  = xy_SurfSnowA                                    &
!!$      & - ( 1.0_DP - FilterParameterW ) * xy_Delta
!!$    xy_SurfSnowN  = max( xy_SurfSnowN, 0.0_DP )
!!$    xy_SurfSnowA  = max( xy_SurfSnowA, 0.0_DP )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine TimeFilterWilliams2009SurfVars

  !--------------------------------------------------------------------------------------

  subroutine TimeFilterWilliams2009Init
    !
    ! timefilter_williams2009 ⥸塼νԤޤ. 
    ! NAMELIST#timefilter_williams2009_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "timefilter_williams2009" module is initialized. 
    ! "NAMELIST#timefilter_williams2009_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ̤
    ! Mass fixer
    !
    use mass_fixer, only : MassFixerInit

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /timefilter_williams2009_nml/ &
      & FilterParameterRA, &
      & FilterParameterW
          !
          ! ǥեͤˤĤƤϽ³ "timefilter_asselin1972#Hs94Init" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "timefilter_asselin1972#Hs94Init" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( timefilter_williams2009_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FilterParameterRA = 0.05_DP
    FilterParameterW  = 0.53_DP
                    ! recommended value for alpha in Williams (2009)

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                         ! (in)
        & nml = timefilter_williams2009_nml, &  ! (out)
        & iostat = iostat_nml )                 ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_williams2009_nml )
    end if


    ! ̤
    ! Mass fixer
    !
    call MassFixerInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FilterParameterRA = %f', d = (/ FilterParameterRA /) )
    call MessageNotify( 'M', module_name, '  FilterParameterW  = %f', d = (/ FilterParameterW  /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    timefilter_williams2009_inited = .true.

  end subroutine TimeFilterWilliams2009Init

  !--------------------------------------------------------------------------------------

end module timefilter_williams2009
