!= ե륿 (Asselin, 1972)
!
!= Time filter (Asselin, 1972)
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timefilter_asselin1972
  !
  != ե륿 (Asselin, 1972)
  !
  != Time filter (Asselin, 1972)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ׻⡼ɤޤ뤿Υե륿 (Asselin, 1972)
  ! ŬѤ뤿Υ⥸塼Ǥ.
  !
  ! ʤ
  ! \[
  !   \bar{A}^{t}
  !   = {A}^{t}
  !     + \epsilon_f
  !        \left( 
  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
  !        \right) \] \[
  !   \qquad
  !   = ( 1-2 \epsilon_f ) {A}^{t}
  !     + \epsilon_f 
  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
  ! \]
  ! Ȥ $ \bar{A}^{t} $ ޤ. ź
  ! $ t-\Delta t, t, t+\Delta t $ Ϥ줾֥ƥåפɽ,
  ! ե륿ŬѤ줿ˤϾ ( $ \bar{\quad} $ ) 
  ! դƤޤ.
  !
  ! ե륿η $\epsilon_f$  Create κݤꤷޤ.
  !
  !--
  ! \[
  !   \bar{\mathscr A}^{t}
  !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
  !     +  \epsilon_f 
  !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
  ! \]
  ! Ȥ$\bar{\mathscr A}^{t}$ޤ. ź
  !++
  !
  ! Time filter (Asselin, 1972) for suppression of computational mode 
  ! is applied.
  !
  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
  ! \[
  !   \bar{A}^{t}
  !   = {A}^{t}
  !     + \epsilon_f
  !        \left( 
  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
  !        \right) \] \[
  !   \qquad
  !   = ( 1-2 \epsilon_f ) {A}^{t}
  !     + \epsilon_f 
  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
  ! \]
  ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step, 
  ! and over-bar $ \bar{\quad} $ represents the terms applied 
  ! time filter.
  !
  ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
  !
  !== Procedures List
  ! 
  ! TimeFilter    :: ե륿Ŭ
  ! ------------  :: ------------
  ! TimeFilter    :: Apply time filter
  !
  !== NAMELIST
  !
  ! NAMELIST#timefilter_asselin1972_nml
  !
  !== References
  !
  ! * Asselin, R. A., 1972: 
  !   Frequency filter for time integrations.
  !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  use composition, only: ncmax  ! ʬο
                                ! Number of composition

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: TimeFilter
  public :: TimeFilterSurfVars
  public :: TimeFiltInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: timefilter_asselin1972_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), save:: FilterParameter
                              ! ե륿η. 
                              ! Time filter coefficient
!!$  integer, save:: IntStep     ! ե륿ŬѤ륹ƥå״ֳ. 
!!$                              ! Step interval of time filter application
!!$  integer, save:: CurStep     ! TimeFilter ƤФ줿. 
!!$                              ! Number of times that "TimeFilter" is called
!!$  integer, save:: PrevStep    ! 󥿥ե륿ŬѤƥå׿. 
!!$                              ! Step number that is filtered previously

  character(*), parameter:: module_name = 'timefilter_asselin1972'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: timefilter_asselin1972.f90,v 1.13 2014/05/07 09:39:24 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine TimeFilter( &
    & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
    & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
    & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  &   ! (in)
    & )
    !
    ! ͽѿ˥ե륿ŬѤޤ. 
    !
    ! Time filter is applied to predictional variables.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_UB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyzf_QMixB (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t-\Delta t) $ .   . Mass mixing ratio of constituents
    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(inout):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(inout):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(inout):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(inout):: xyzf_QMixN (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t) $ .     . Mass mixing ratio of constituents
    real(DP), intent(inout):: xy_PsN (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t+\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyzf_QMixA (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t+\Delta t) $ .   . Mass mixing ratio of constituents
    real(DP), intent(in):: xy_PsA (0:imax-1, 1:jmax)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. timefilter_asselin1972_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


!!$    ! ƥåפΥå
!!$    ! Check Step
!!$    !
!!$    CurStep = CurStep + 1
!!$    if ( CurStep - PrevStep < IntStep ) return
!!$    PrevStep = CurStep

    ! FilterParameter ͭΥå
    ! Check validity of "FilterParameter"
    !
    if ( FilterParameter == 0.0_DP ) return

    ! ե륿Ŭ
    ! Apply time filter
    !
    xyz_UN     =  xyz_UN    &
      & + FilterParameter * ( xyz_UB     - 2.0d0 * xyz_UN     + xyz_UA     )

    xyz_VN     =  xyz_VN    &
      & + FilterParameter * ( xyz_VB     - 2.0d0 * xyz_VN     + xyz_VA     )

    xyz_TempN  =  xyz_TempN &
      & + FilterParameter * ( xyz_TempB  - 2.0d0 * xyz_TempN  + xyz_TempA  )

    xy_PsN     =  xy_PsN    &
      & + FilterParameter * ( xy_PsB     - 2.0d0 * xy_PsN     + xy_PsA     )

    xyzf_QMixN = xyzf_QMixN &
      & + FilterParameter * ( xyzf_QMixB - 2.0d0 * xyzf_QMixN + xyzf_QMixA )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine TimeFilter

  !--------------------------------------------------------------------------------------

  subroutine TimeFilterSurfVars(                       &
    & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB, &   ! (in)
    & xy_SurfMajCompIceN, xy_SoilMoistN, xy_SurfSnowN, &   ! (inout)
    & xy_SurfMajCompIceA, xy_SoilMoistA, xy_SurfSnowA  &   ! (in)
    & )
    !
    ! ͽѿ˥ե륿ŬѤޤ. 
    !
    ! Time filter is applied to predictional variables.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
                              ! $ M_mcs (t-\Delta t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(in   ):: xy_SoilMoistB (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(in   ):: xy_SurfSnowB  (0:imax-1, 1:jmax)
                              ! $ M_ss (t-\Delta t) $ . .
                              ! Surface snow amount
    real(DP), intent(inout):: xy_SurfMajCompIceN(0:imax-1, 1:jmax)
                              ! $ M_mcs (t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(inout):: xy_SoilMoistN (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(inout):: xy_SurfSnowN  (0:imax-1, 1:jmax)
                              ! $ M_ss (t) $ . .
                              ! Surface snow amount
    real(DP), intent(in   ):: xy_SurfMajCompIceA(0:imax-1, 1:jmax)
                              ! $ M_mcs (t+\Delta t) $ . 
                              ! Surface major component ice amount
    real(DP), intent(in   ):: xy_SoilMoistA (0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ɽ. 
                              ! Soil moisture
    real(DP), intent(in   ):: xy_SurfSnowA  (0:imax-1, 1:jmax)
                              ! $ M_ss (t+\Delta t) $ . .
                              ! Surface snow amount

    ! ѿ
    ! Work variables
    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. timefilter_asselin1972_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


!!$    ! ƥåפΥå
!!$    ! Check Step
!!$    !
!!$    CurStep = CurStep + 1
!!$    if ( CurStep - PrevStep < IntStep ) return
!!$    PrevStep = CurStep

    ! FilterParameter ͭΥå
    ! Check validity of "FilterParameter"
    !
    if ( FilterParameter == 0.0_DP ) return

    ! ե륿Ŭ
    ! Apply time filter
    !
    xy_SurfMajCompIceN = xy_SurfMajCompIceN                         &
      & + FilterParameter                                           &
      & * ( xy_SurfMajCompIceB - 2.0_DP * xy_SurfMajCompIceN + xy_SurfMajCompIceA )

    xy_SoilMoistN = xy_SoilMoistN                                   &
      & + FilterParameter                                           &
      & * ( xy_SoilMoistB - 2.0_DP * xy_SoilMoistN + xy_SoilMoistA )

    xy_SurfSnowN  = xy_SurfSnowN                                    &
      & + FilterParameter                                           &
      & * ( xy_SurfSnowB  - 2.0_DP * xy_SurfSnowN  + xy_SurfSnowA  )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine TimeFilterSurfVars

  !--------------------------------------------------------------------------------------

  subroutine TimeFiltInit
    !
    ! timefilter_asselin1972 ⥸塼νԤޤ. 
    ! NAMELIST#timefilter_asselin1972_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "timefilter_asselin1972" module is initialized. 
    ! "NAMELIST#timefilter_asselin1972_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /timefilter_asselin1972_nml/ &
      & FilterParameter   !, IntStep
          !
          ! ǥեͤˤĤƤϽ³ "timefilter_asselin1972#Hs94Init" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "timefilter_asselin1972#Hs94Init" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( timefilter_asselin1972_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FilterParameter = 0.05_DP
!!$    IntStep         = 1
!!$    CurStep         = 0

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = timefilter_asselin1972_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = timefilter_asselin1972_nml )
    end if

!!$    ! IntStep Υå
!!$    ! Check "IntStep"
!!$    !
!!$    if ( IntStep < 1 ) then
!!$      call MessageNotify( 'E', module_name, &
!!$        & 'IntStep=<%d> must be greater than 0', &
!!$        & i = (/ IntStep /) )
!!$    end if
!!$
!!$    ! PrevStep 
!!$    ! Configure "PrevStep"
!!$    !
!!$    PrevStep = - IntStep

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
!!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    timefilter_asselin1972_inited = .true.

  end subroutine TimeFiltInit

  !--------------------------------------------------------------------------------------

end module timefilter_asselin1972
