!= Ūѿ׻륵֥롼󡦴ؿ
!
!= Subroutines and functions for calculating auxiliary variables
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module auxiliary
  !
  != Ūѿ׻륵֥롼󡦴ؿ
  !
  != Subroutines and functions for calculating auxiliary variables
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Υ⥸塼Ǥ, Ūѿ׻륵֥롼ؿ󶡤ޤ. 
  !
  ! This module provides subroutines and functions for calculating auxiliary variables. 
  !
  !== Procedures List
  !
  ! AuxVars          :: ٤Ⱦ $ \sigma $ ٥֤
  !                     ȹ٤λ
  ! AuxVarsInit      ::
  ! AuxVarsFinalize  :: λ (⥸塼ѿγդ)
  ! ---------------  :: ---------------
  ! AuxVars          :: Interpolate temperature on half $ \sigma $ level, 
  !                     and calculate pressure and height
  ! AuxVarsInit      ::
  ! AuxVarsFinalize  :: Termination (deallocate variables in this module)
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#auxiliary_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: AuxVars
  public :: AuxVarsFinalize
  public :: AuxVarsInit

  ! ѿ
  ! Public variables
  !
  real(DP), save, public:: RefPress
                              ! ൤. 
                              ! Reference air pressure

  ! ѿ
  ! Private variables
  !
  logical, save :: auxiliary_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), save, allocatable:: z_TempInpolM (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature
  real(DP), save, allocatable:: z_TempInpol (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature

  character(*), parameter:: module_name = 'auxiliary'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: auxiliary.f90,v 1.18 2015/02/06 11:25:12 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  recursive subroutine AuxVars(                           &
    & xy_Ps, xyz_Temp, xyz_QVap,                          &  ! (in )
    & xyr_Temp, xyz_VirTemp, xyr_VirTemp, xy_SurfVirTemp, &  ! (out) optional
    & xyz_Press,  xyr_Press,                              &  ! (out) optional
    & xy_SurfHeight, xy_SurfTemp,                         &  ! (in ) optional
    & xyz_Height, xyr_Height,                             &  ! (out) optional
    & xyz_Exner,  xyr_Exner                               &  ! (out) optional
    & )
    !
    ! ٤Ⱦҥ٥, ȹ٤λ, 
    ! ʡؿη׻Ԥޤ. 
    !
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and height, 
    ! and calculate exner function. 

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma, &
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
      & r_DelSigma
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (Half)

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ.
                              ! Molecular weight of water vapor

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_QVap    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(out), optional:: xyz_VirTemp(0:imax-1, 1:jmax, 1:kmax)
                              ! $ \hat{T} $ . 
                              ! Virtual temperature
    real(DP), intent(out), optional:: xyr_VirTemp(0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Virtual temperature (half level)
    real(DP), intent(out), optional:: xy_SurfVirTemp(0:imax-1, 1:jmax)
                              ! $ \hat{T} $ .  (ɽ). 
                              ! Virtual temperature (surface)
    real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in ), optional:: xy_SurfHeight(0:imax-1,1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(in ), optional:: xy_SurfTemp(0:imax-1,1:jmax)
                              ! $ T_s $ . ɽ̲. 
                              ! Surface temperature. 
    real(DP), intent(out), optional:: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
                              !  (٥). 
                              ! Height (full level)
    real(DP), intent(out), optional:: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
                              !  (Ⱦ٥). 
                              ! Height (half level)
    real(DP), intent(out), optional:: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(out), optional:: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_PressWork  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP):: xyr_PressWork  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP):: xyr_TempWork   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP):: xyz_VirTempWork(0:imax-1, 1:jmax, 1:kmax)
                              ! $ T_v $ . .
                              ! Virtual temperature
    real(DP):: xyr_VirTempWork(0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T}_v $ .  (Ⱦ٥). 
                              ! Virtual temperature (half level)

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. auxiliary_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ٤
    ! Interpolate temperature
    !
    if ( present( xyr_Temp ) ) then
      call AuxVarsInternalRoutine(   &
        & xy_Ps,      xyz_Temp,      &  ! (in )
        & xyr_Temp = xyr_Temp  &  ! (out) optional
        & )
    end if

    ! ٤η׻
    ! Calculate virtual temperature
    !
    if ( present( xy_SurfVirTemp ) ) then
      if ( .not. present( xy_SurfTemp ) ) then
        call MessageNotify( 'E', module_name, 'xy_SurfTemp has to be given in arguments to calculate xy_SurfVirTemp.' )
      end if
      xy_SurfVirTemp = xy_SurfTemp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap(:,:,1) ) )
    end if

    ! ٤η׻
    ! Calculate virtual temperature
    !
    if ( present( xyz_VirTemp ) ) then
      xyz_VirTemp = xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
    end if

    ! ٤
    ! Interpolate virtual temperature
    !
    if ( present( xyr_VirTemp ) ) then
      if ( present( xyz_VirTemp ) ) then
        xyz_VirTempWork = xyz_VirTemp
      else
        xyz_VirTempWork = &
          & xyz_Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QVap) )
      end if
      call AuxVarsInternalRoutine(   &
        & xy_Ps, xyz_VirTempWork,    &  ! (in )
        & xyr_Temp = xyr_VirTemp     &  ! (out) optional
        & )
    end if

    ! η׻
    ! Calculate pressure
    !
    if ( present( xyz_Press ) ) then
      call AuxVarsInternalRoutine(   &
        & xy_Ps,      xyz_Temp,      &  ! (in )
        & xyz_Press = xyz_Press  &  ! (out) optional
        & )
    end if

    if ( present( xyr_Press ) ) then
      call AuxVarsInternalRoutine(   &
        & xy_Ps,      xyz_Temp,      &  ! (in )
        & xyr_Press = xyr_Press  &  ! (out) optional
        & )
    end if

    ! ٤η׻
    ! Calculate height
    !
    if ( present( xyz_Height ) ) then
      if ( .not. present( xy_SurfHeight ) ) then
        call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyz_Height.' )
      end if

!!$      if ( present( xyr_Temp ) ) then
!!$        xyr_TempWork = xyr_Temp
!!$      else
!!$        call AuxVarsInternalRoutine( &
!!$          & xy_Ps, xyz_Temp,         &  ! (in )
!!$          & xyr_Temp = xyr_TempWork  &  ! (out) optional
!!$          & )
!!$      end if
      if ( present( xyz_VirTemp ) .and. present( xyr_VirTemp ) ) then
        xyz_VirTempWork = xyz_VirTemp
        xyr_VirTempWork = xyr_VirTemp
      else
        ! ׻ַ¬
        ! Pause measurement of computation time
        call TimesetClockStop( module_name )
        call AuxVars(                      &
          & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
          & xyz_VirTemp = xyz_VirTempWork, &  ! (out) optional
          & xyr_VirTemp = xyr_VirTempWork  &  ! (out) optional
          & )
        ! ׻ַ¬
        ! Start measurement of computation time
        call TimesetClockStart( module_name )
      end if

!!$      xyz_Height(:,:,1) = &
!!$        & xy_SurfHeight(:,:) &
!!$        & + GasRDry / Grav * xyz_Temp(:,:,1) * ( 1. - z_Sigma(1) )
!!$      do k = 2, kmax
!!$        xyz_Height(:,:,k) = &
!!$          &   xyz_Height(:,:,k-1) &
!!$          & + GasRDry / Grav * xyr_TempWork(:,:,k-1) &
!!$          &   * r_DelSigma(k-1) / r_Sigma(k-1)
!!$      end do

      xyz_Height(:,:,1) =                          &
        & xy_SurfHeight                            &
        & + GasRDry / Grav * xyz_VirTempWork(:,:,1) * ( 1.0_DP - z_Sigma(1) )
      do k = 2, kmax
        xyz_Height(:,:,k) = xyz_Height(:,:,k-1)         &
          & + GasRDry / Grav * xyr_VirTempWork(:,:,k-1) &
          &   * r_DelSigma(k-1) / r_Sigma(k-1)
      end do
    end if

    if ( present( xyr_Height ) ) then
      if ( .not. present( xy_SurfHeight ) ) then
        call MessageNotify( 'E', module_name, 'xy_SurfHeight has to be given in arguments to calculate xyr_Height.' )
      end if

      if ( present( xyz_VirTemp ) ) then
        xyz_VirTempWork = xyz_VirTemp
      else
        ! ׻ַ¬
        ! Pause measurement of computation time
        call TimesetClockStop( module_name )
        call AuxVars(                      &
          & xy_Ps, xyz_Temp, xyz_QVap,     &  ! (in )
          & xyz_VirTemp = xyz_VirTempWork  &  ! (out) optional
          & )
        ! ׻ַ¬
        ! Start measurement of computation time
        call TimesetClockStart( module_name )
      end if

      xyr_Height(:,:,0) = xy_SurfHeight
      do k = 1, kmax
!!$        xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
!!$          & + GasRDry / Grav * xyz_Temp(:,:,k)     &
!!$          &   * z_DelSigma(k) / z_Sigma(k)
        xyr_Height(:,:,k) = xyr_Height(:,:,k-1)        &
          & + GasRDry / Grav * xyz_VirTempWork(:,:,k)  &
          &   * z_DelSigma(k) / z_Sigma(k)
      end do
    end if

    ! ʡؿη׻
    ! Calculate exner function
    !
    if ( present( xyz_Exner ) ) then
      if ( present( xyz_Press ) ) then
        xyz_PressWork = xyz_Press
      else
        call AuxVarsInternalRoutine(   &
          & xy_Ps,      xyz_Temp,      &  ! (in )
          & xyz_Press = xyz_PressWork  &  ! (out) optional
          & )
      end if

      xyz_Exner = ( xyz_PressWork / RefPress ) ** ( GasRDry / CpDry )
    end if


    if ( present( xyr_Exner ) ) then
      if ( present( xyr_Press ) ) then
        xyr_PressWork = xyr_Press
      else
        call AuxVarsInternalRoutine(   &
          & xy_Ps,      xyz_Temp,      &  ! (in )
          & xyr_Press = xyr_PressWork  &  ! (out) optional
          & )
      end if

      xyr_Exner = ( xyr_PressWork / RefPress ) ** ( GasRDry / CpDry )
    end if

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine AuxVars

  !--------------------------------------------------------------------------------------

  subroutine AuxVarsInternalRoutine( &
    & xy_Ps,      xyz_Temp,   &  ! (in )
    & xyr_Temp,               &  ! (out) optional
    & xyz_Press,  xyr_Press   &  ! (out) optional
    & )
    !
    ! ٤Ⱦҥ٥, λ, 
    ! ʡؿη׻Ԥޤ. 
    !
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure, 
    ! and calculate exner function. 

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(out), optional:: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(out), optional:: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out), optional:: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)


    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !


    ! ǧ
    ! Initialization check
    !
    if ( .not. auxiliary_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ٤
    ! Interpolate temperature
    !
    if ( present( xyr_Temp ) ) then
      do k = 2, kmax
        xyr_Temp(:,:,k-1) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
          &                 + z_TempInpol (k) * xyz_Temp(:,:,k)
      end do

      xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
      xyr_Temp(:,:,0)    = xyz_Temp(:,:,1)

    end if

    ! η׻
    ! Calculate pressure
    !
    if ( present( xyz_Press ) ) then
      do k = 1, kmax
        xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
      end do
    end if

    if ( present( xyr_Press ) ) then
      do k = 0, kmax
        xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
      end do
    end if


  end subroutine AuxVarsInternalRoutine

  !--------------------------------------------------------------------------------------

  subroutine AuxVarsInit
    !
    ! auxiliary ⥸塼νԤޤ. 
    ! NAMELIST#auxiliary_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "auxiliary" module is initialized. 
    ! "NAMELIST#auxiliary_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /auxiliary_nml/ &
      & RefPress
          !
          ! ǥեͤˤĤƤϽ³ "auxiliary#AuxVarsInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "auxiliary#AuxVarsInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( auxiliary_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    RefPress        =   1.0e5_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &           ! (in)
        & nml = auxiliary_nml, &  ! (out)
        & iostat = iostat_nml )   ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    !  Ѥηη׻
    !  Calculate coefficient for interpolation
    !
    allocate( z_TempInpolM(1:kmax) )
    allocate( z_TempInpol(1:kmax) )

    z_TempInpolM(1) = 0.0_DP
    z_TempInpol (1) = 0.0_DP

    do k = 2, kmax
      z_TempInpolM(k) = &
        &    ( log( r_Sigma( k-1 ) ) - log( z_Sigma( k ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
      z_TempInpol(k) = &
        &    ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k-1 ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k )   ) )
    end  do

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  z_TempInpolM = %*r', r = real( z_TempInpolM ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '  z_TempInpol  = %*r', r = real( z_TempInpol  ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '  RefPress     = %f', d = (/ RefPress /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    auxiliary_inited = .true.

  end subroutine AuxVarsInit

  !--------------------------------------------------------------------------------------

  subroutine AuxVarsFinalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. auxiliary_inited ) return

    ! դ
    ! Deallocation
    !
    if ( allocated( z_TempInpolM ) ) deallocate( z_TempInpolM )
    if ( allocated( z_TempInpol  ) ) deallocate( z_TempInpol  )

    auxiliary_inited = .false.

  end subroutine AuxVarsFinalize

  !--------------------------------------------------------------------------------------

end module auxiliary
