!= , ɹγ
!
!= snow/ice fraction
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module snowice_frac

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SeaIceAboveThreshold
  public :: CalcSnowFrac
  public :: CalcSeaIceFrac
  public :: CalcMajCompIceFrac
  public :: SnowIceFracInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  real(DP), save :: NOrd

  logical, save :: snowice_frac_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'snowice_frac'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  function SeaIceAboveThreshold( SeaIceConc ) result( FlagExist )

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: &
      & SeaIceThreshold

    real(DP), intent(in) :: SeaIceConc

    logical :: FlagExist


    if ( SeaIceConc > SeaIceThreshold ) then
      FlagExist = .true.
    else
      FlagExist = .false.
    end if

  end function SeaIceAboveThreshold

  !--------------------------------------------------------------------------------------

  subroutine CalcSnowFrac(       &
!!$    & xy_FlagLand, xy_SurfSnow,  & ! (in )
    & xy_SurfSnow,               & ! (in )
    & xy_SnowFrac                & ! (out)
    & )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:            &
      & SnowThreshold => ThresholdSurfSnow

!!$    logical , intent(in ) :: xy_FlagLand( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SurfSnow( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SnowFrac( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. snowice_frac_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do j = 1, jmax
      do i = 0, imax-1

!!$        if ( xy_FlagLand(i,j) ) then
          xy_SnowFrac(i,j) = &
            & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThreshold  - 0.0_DP ) )**NOrd
          xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
!!$        else
!!$          xy_SnowFrac(i,j) = 0.0_DP
!!$        end if

      end do
    end do


  end subroutine CalcSnowFrac

  !--------------------------------------------------------------------------------------

  subroutine CalcSeaIceFrac(       &
!!$    & xy_FlagOcean, xy_SeaIceConc, & ! (in )
    & xy_SeaIceConc,               & ! (in )
    & xy_SeaIceFrac                & ! (out)
    & )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:  &
      & SeaIceThreshold


!!$    logical , intent(in ) :: xy_FlagOcean ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SeaIceConc( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_SeaIceFrac( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. snowice_frac_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do j = 1, jmax
      do i = 0, imax-1

!!$        if ( ( xy_FlagOcean(i,j) ) .and. &
!!$          &  ( xy_SeaIceConc(i,j) > SeaIceThreshold ) ) then
        if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
          xy_SeaIceFrac(i,j) = 1.0_DP
        else
          xy_SeaIceFrac(i,j) = 0.0_DP
        end if

      end do
    end do


  end subroutine CalcSeaIceFrac

  !--------------------------------------------------------------------------------------

  subroutine CalcMajCompIceFrac(      &
!!$    & xy_FlagLand, xy_SurfMajCompIce, & ! (in )
    & xy_SurfMajCompIce,              & ! (in )
    & xy_MajCompIceFrac               & ! (out)
    )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:            &
      & CO2IceThreshold


!!$    logical , intent(in ) :: xy_FlagLand      ( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
    real(DP), intent(out) :: xy_MajCompIceFrac( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    real(DP):: MajCompIceThreshold
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. snowice_frac_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if



    MajCompIceThreshold = CO2IceThreshold
    do j = 1, jmax
      do i = 0, imax-1

!!$        if ( xy_FlagLand(i,j) ) then
          xy_MajCompIceFrac(i,j) =                  &
            &   ( xy_SurfMajCompIce(i,j) - 0.0_DP ) &
            & / ( MajCompIceThreshold    - 0.0_DP )
          xy_MajCompIceFrac(i,j) = max( min( xy_MajCompIceFrac(i,j), 1.0_DP ), 0.0_DP )
!!$        else
!!$          xy_MajCompIceFrac(i,j) = 0.0_DP
!!$        end if

      end do
    end do


  end subroutine CalcMajCompIceFrac

  !--------------------------------------------------------------------------------------

  subroutine SnowIceFracInit

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg


    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /snowice_frac_nml/ &
      & NOrd

    ! ¹ʸ ; Executable statement
    !


    if ( snowice_frac_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    NOrd = 2.0_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                  &  ! (in)
        & nml = snowice_frac_nml,      &  ! (out)
        & iostat = iostat_nml          &  ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = snowice_frac_nml )
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'NOrd = %f', d = (/NOrd/) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    snowice_frac_inited = .true.

  end subroutine SnowIceFracInit

  !--------------------------------------------------------------------------------------

end module snowice_frac
