!= ɽ̥եå桼ƥƥ
!
!= Surface flux utility routines
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_flux_util
  !
  != ɽ̥եå桼ƥƥ
  !
  != Surface flux utility routines
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̥եå׻. 
  !
  ! Surface fluxes are calculated.
  !
  !== References
  !
!!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
!!$  ! A short history of the PBL parameterization at ECMWF, 
!!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
!!$  ! 1982.
  !
  !== Procedures List
  !
!!$  ! SurfaceFlux       :: ɽ̥եåη׻
!!$  ! ------------      :: ------------
!!$  ! SurfaceFlux       :: Calculate surface fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_flux_util_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    & ncmax, &
    & IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SurfaceFluxUtilLimitFlux
  public :: SurfaceFluxUtilInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: surface_flux_util_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(*), parameter:: module_name = 'surface_flux_util'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: surface_flux_util.f90,v 1.1 2013/10/06 13:44:15 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !--------------------------------------------------------------------------------------

  subroutine SurfaceFluxUtilLimitFlux( &
    & DelTime,                         & ! (in)
    & xyzf_QMix, xyr_Press,            & ! (in)
    & xy_SurfH2OVapFlux &!, xyf_QMixFlux  & ! (inout)
    & )
    !
    ! 
    !
    ! Restrict surface flux 
    ! Now, only the H2O vapor flux is restricted.
    !

    ! ⥸塼 ; USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav                  ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: DelTime
                              ! Time step
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(inout):: xy_SurfH2OVapFlux(0:imax-1, 1:jmax)
                              ! ɽ̿եå.
                              ! Water vapor flux at the surface
!!$    real(DP), intent(inout):: xyf_QMixFlux(0:imax-1, 1:jmax, 1:ncmax)
!!$                              ! ɽ漾եå. 
!!$                              ! Specific humidity flux at surface

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
                              ! 
                              ! Mass in each layer
    real(DP):: xy_ConsMass(0:imax-1, 1:jmax)
                              ! 
                              ! Constituent mass in each column
    real(DP):: xy_SurfFlux(0:imax-1, 1:jmax)

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in altitude
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. surface_flux_util_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    do k = 1, kmax
      xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do

!!$    do n = 1, ncmax
    do n = IndexH2OVap, IndexH2OVap

      xy_ConsMass = 0.0_DP
      do k = kmax, 1, -1
        xy_ConsMass = xy_ConsMass + xyz_DelMass(:,:,k) * xyzf_QMix(:,:,k,n)
      end do

      if ( n == IndexH2OVap ) then
        xy_SurfFlux = xy_SurfH2OVapFlux
      else
!!$        xy_SurfFlux = xyf_QMixFlux(:,:,n)
      end if

      do j = 1, jmax
        do i = 0, imax-1
          if ( - xy_SurfFlux(i,j) * DelTime > xy_ConsMass(i,j) ) then
            xy_SurfFlux(i,j) = - xy_ConsMass(i,j) / DelTime !&
!!$              & * ( 1.0_DP - 1.0d-15 )
          end if
        end do
      end do

      if ( n == IndexH2OVap ) then
        xy_SurfH2OVapFlux = xy_SurfFlux
      else
!!$        xyf_QMixFlux(:,:,n) = xy_SurfFlux
      end if

    end do


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SurfaceFluxUtilLimitFlux

  !--------------------------------------------------------------------------------------

  subroutine SurfaceFluxUtilInit
    !
    ! surface_flux_util ⥸塼νԤޤ. 
    ! NAMELIST#surface_flux_util_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "surface_flux_util" module is initialized. 
    ! "NAMELIST#surface_flux_util_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & AxnameX, &
      & AxnameY, &
      & AxnameZ, &
      & AxnameR, &
      & AxnameT

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /surface_flux_util_nml/                                  &
!!$      & FlagConstBulkCoef
          !
          ! ǥեͤˤĤƤϽ³ "surface_flux_util#SurfaceFluxUtilInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_flux_bulk#SurfaceFluxInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( surface_flux_util_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &                ! (in)
!!$        & nml = surface_flux_util_nml, &  ! (out)
!!$        & iostat = iostat_nml )        ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

!!$    call MessageNotify( 'M', module_name, '  VelMinForRi       = %f', d = (/ VelMinForRi   /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_flux_util_inited = .true.

  end subroutine SurfaceFluxUtilInit

  !--------------------------------------------------------------------------------------

end module surface_flux_util
