!= 
!
!= CO2 condensation temperature (Pollack et al., 1981)
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_co2_p81
  !
  != 
  !
  != CO2 condensation temperature (Pollack et al., 1981)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== References
  !
  ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
  !   A Martian general circulation experiment with large topography, 
  !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#major_comp_saturate_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private


  ! ³
  ! Public procedure
  !
  public :: xyz_SaturateCO2P81TempCond
  public :: SaturateCO2P81Init


  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_co2_p81_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate_co2_p81'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !--------------------------------------------------------------------------------------

  function xyz_SaturateCO2P81TempCond( xyz_Press ) result( xyz_TempCond )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press   (:,:,:)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP) :: xyz_TempCond(size(xyz_Press,1), size(xyz_Press,2), size(xyz_Press,3))
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. saturate_co2_p81_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! CO2 condensation temperature (Pollack et al., 1981)

    xyz_TempCond = 149.2_DP + 6.48_DP * log( 0.135_DP * xyz_Press * 1.0e-2_DP )


  end function xyz_SaturateCO2P81TempCond

  !--------------------------------------------------------------------------------------

  subroutine SaturateCO2P81Init
    !
    ! saturate_co2_p81 ⥸塼νԤޤ. 
    ! NAMELIST#saturate_co2_p81_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "saturate_co2_p81" module is initialized. 
    ! "NAMELIST#saturate_co2_p81_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
!!$
!!$    ! ե
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! ̷ѥ᥿
!!$    ! Kind type parameter
!!$    !
!!$    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA


    ! ʸ ; Declaration statements
    !
    implicit none


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /major_comp_saturate_nml/ &
!!$      & FlagUse

          ! ǥեͤˤĤƤϽ³ "major_comp_saturate#MajorCompSaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "major_comp_saturate#MajorCompSaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_co2_p81_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                    &  ! (in)
!!$        & nml = major_comp_saturate_nml, &  ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
!!$    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    saturate_co2_p81_inited = .true.

  end subroutine SaturateCO2P81Init

  !-------------------------------------------------------------------

end module saturate_co2_p81
