!= ⤷ʤͥǥ
!
!= radiation model with no absorption and no scattering
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module rad_none
  !
  != ⤷ʤͥǥ
  !
  != radiation model with no absorption and no scattering
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== References
  !
  !
  !== Procedures List
  !
  ! RadEarthV2Flux :: ͥեåη׻
  ! ------------          :: ------------
  ! RadEarthV2Flux :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_Earth_V2_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ѿ
  ! Public variables
  !
  logical, save :: rad_none_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: RadNoneFlux
  public :: RadNoneInit

  character(*), parameter:: module_name = 'rad_none'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadNoneFlux(                                      &
    & xy_SurfAlbedo,                                           & ! (in)
    & xy_SurfTemp,                                             & ! (in)
    & xyr_RadSUwFlux, xyr_RadSDwFlux,                          & ! (out)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    & )


    ! USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & StB                   ! $ \sigma_{SB} $ .
                              ! ƥեܥĥޥ.
                              ! Stefan-Boltzmann constant

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConst

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome


    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    ! Work variables
    !
    real(DP) :: SolarConst
    real(DP) :: DistFromStarScld
    real(DP) :: DiurnalMeanFactor
    real(DP) :: SolarFluxTOA
    real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)

    integer :: i
    integer :: j
    integer :: k


    ! ǧ
    ! Initialization check
    !
    if ( .not. rad_none_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConst( &
      & SolarConst      & ! (out)
      & )

    ! ûͤη׻
    ! Calculate short wave (insolation) incoming radiation
    !
    call RadShortIncome(                       &
      & xy_CosZet         = xy_CosSZA,         & ! (out) optional
      & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor = DiurnalMeanFactor  &
      & )

    SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor

    do k = 0, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_CosSZA(i,j) >= 0.0_DP ) then
            xyr_RadSDwFlux(i,j,k) = SolarFluxTOA * xy_CosSZA(i,j)
          else
            xyr_RadSDwFlux(i,j,k) = 0.0_DP
          end if
        end do
      end do
    end do
    do k = 0, kmax
      xyr_RadSUwFlux(:,:,k) = xy_SurfAlbedo * xyr_RadSDwFlux(:,:,k)
    end do


    do k = 0, kmax
      xyr_RadLUwFlux(:,:,k) = StB * xy_SurfTemp**4
    end do
    xyr_RadLDwFlux     = 0.0_DP
    xyra_DelRadLUwFlux = 0.0_DP
    xyra_DelRadLDwFlux = 0.0_DP


    ! Output variables
    !

  end subroutine RadNoneFlux

  !--------------------------------------------------------------------------------------

  subroutine RadNoneInit

    ! ե
    ! File I/O support
    !
!!$    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ͥեå
    ! Set solar constant
    !
    use set_solarconst, only : SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit


    ! ʸ ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /rad_Earth_V2_nml/ &
!!$      & CloudIceREffMethod,     &
!!$      & CloudWatREff,           &
!!$      & CloudIceREff

!!$      & SWVer, LWVer
          !
          ! ǥեͤˤĤƤϽ³ "rad_Earth_V2#RadEarthV2Init"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_Earth_V2#RadEarthV2Init" for the default values.
          !

    if ( rad_none_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
!!$    SWVer = 1
!!$    LWVer = 3


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = rad_Earth_V2_nml,         & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! ͥեå
    ! Set solar constant
    !
    call SetSolarConstInit

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
!!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    rad_none_inited = .true.

  end subroutine RadNoneInit

  !--------------------------------------------------------------------------------------

end module rad_none
