!= ľȾ٥
!
!= Prepare vertical sigma half level
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module sigma_data
  !
  != ľȾ٥
  !
  != Prepare vertical sigma half level
  !
  ! ľȾ٥Υץǡ󶡤ޤ. 
  ! 
  ! Prepare sample data of vertical sigma half level. 
  !
  !== Procedures List
  !
  ! SigmaDataGetHalf   :: ľȾ٥. 
  ! ------------  :: ------------
  ! SigmaDataGetHalf   :: Get vertical sigma half level. 

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SigmaDataGetHalf

  ! ѿ
  ! Public variables
  !
  logical, save, public:: sigma_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'sigma_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: sigma_data.f90,v 1.2 2008/08/11 21:50:23 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SigmaDataGetHalf
    module procedure SigmaDataGetHalf
  end interface

contains

  subroutine SigmaDataGetHalf( r_Sigma &  ! (out)
    & )
    !
    ! ľȾ٥Υץǡ󶡤ޤ. 
    ! ľؤοͿ r_Sigma Υǡ
    ! ưŪ˸Фޤ. 
    ! 
    ! Prepare sample data of vertical sigma half level. 
    ! Number of vertical level is detected automatically from
    ! size of a given array "r_Sigma". 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    ! ѿ
    ! Work variables
    !
    integer:: kmax           ! ľؿ. 
                             ! Number of vertical level

    ! ¹ʸ ; Executable statement

    if ( .not. sigma_data_inited ) call SigmaDataInit

    ! kmax  (r_Sigma Υ)
    ! Setting "kmax" (set from size of "r_Sigma")
    !
    kmax = size(r_Sigma) - 1
    if ( kmax < 1 ) &
      call MessageNotify('E', module_name, 'size of "r_Sigma" is too small. ' )

    ! r_Sigma (Ⱦ٥) μư
    ! Automation setting of "r_Sigma" (half level sigma)
    !
    select case (kmax)
    case (2)
      r_Sigma(1:kmax+1) = (/ &
        & 1.0_DP, 0.63_DP, 0.0_DP /)
    case (5)
      r_Sigma(1:kmax+1) = (/ &
        & 1.00_DP, 0.80_DP, 0.60_DP, 0.30_DP, 0.15_DP, &
        & 0.00_DP /)
    case (12)
      r_Sigma(1:kmax+1) = (/ &
        & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.85_DP, &
        & 0.75_DP, 0.63_DP, 0.50_DP, 0.36_DP, 0.22_DP, &
        & 0.10_DP, 0.05_DP, 0.00_DP /)
    case (16)
      r_Sigma(1:kmax+1) = (/ &
        & 1.00_DP, 0.99_DP, 0.97_DP, 0.93_DP, 0.87_DP, &
        & 0.79_DP, 0.70_DP, 0.60_DP, 0.50_DP, 0.41_DP, &
        & 0.33_DP, 0.26_DP, 0.20_DP, 0.15_DP, 0.10_DP, &
        & 0.05_DP, 0.00_DP /)
    case (20)
      r_Sigma(1:kmax+1) = (/ &
        & 1.00_DP, 0.95_DP, 0.90_DP, 0.85_DP, 0.80_DP, &
        & 0.75_DP, 0.70_DP, 0.65_DP, 0.60_DP, 0.55_DP, &
        & 0.50_DP, 0.45_DP, 0.40_DP, 0.35_DP, 0.30_DP, &
        & 0.25_DP, 0.20_DP, 0.15_DP, 0.10_DP, 0.05_DP, &
        & 0.0_DP /)
    case (23)
      r_Sigma(1:kmax+1) = (/ &
        & 1.000_DP, 0.990_DP, 0.980_DP, 0.965_DP, 0.945_DP, &
        & 0.920_DP, 0.890_DP, 0.850_DP, 0.800_DP, 0.740_DP, &
        & 0.650_DP, 0.550_DP, 0.450_DP, 0.360_DP, 0.300_DP, &
        & 0.260_DP, 0.220_DP, 0.180_DP, 0.150_DP, 0.120_DP, &
        & 0.090_DP, 0.060_DP, 0.030_DP, 0.000_DP /)
    case (45)
      r_Sigma(1:kmax+1) = (/ &
        & 1.00000_DP, 0.99000_DP, 0.97000_DP, 0.93000_DP, 0.87000_DP, &
        & 0.79000_DP, 0.70000_DP, 0.60000_DP, 0.50000_DP, 0.41000_DP, &
        & 0.33000_DP, 0.26000_DP, 0.20000_DP, 0.15000_DP, 0.10000_DP, &
        & 0.08610_DP, 0.07410_DP, 0.06380_DP, 0.05490_DP, 0.04720_DP, &
        & 0.04070_DP, 0.03500_DP, 0.03010_DP, 0.02590_DP, 0.02230_DP, &
        & 0.01920_DP, 0.01650_DP, 0.01420_DP, 0.01220_DP, 0.01050_DP, &
        & 0.00907_DP, 0.00781_DP, 0.00672_DP, 0.00578_DP, 0.00498_DP, &
        & 0.00429_DP, 0.00369_DP, 0.00317_DP, 0.00273_DP, 0.00235_DP, &
        & 0.00202_DP, 0.00174_DP, 0.00150_DP, 0.00129_DP, 0.00111_DP, &
        & 0.00000_DP /)
    case default
      call MessageNotify( 'E', module_name, &
        & 'vertical sigma half level data auto-setting is valid ' // &
        & 'only when kmax=<%*d>. ( now kmax=<%d> )', &
        & i = (/2,5,12,16,20,23,45,kmax/), n = (/ 7 /) )
    end select

  end subroutine SigmaDataGetHalf

  !-------------------------------------------------------------------

  subroutine SigmaDataInit

    implicit none

!!$  namelist /sigma_data_nml/ 

    ! ¹ʸ ; Executable statement

    if ( sigma_data_inited ) return
    call InitCheck

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = sigma_data_nml, & ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !

    sigma_data_inited = .true.
  end subroutine SigmaDataInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! ¹ʸ ; Executable statement

  end subroutine InitCheck

end module sigma_data
