!= 
!
!= Saturation adjustment
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturation_adjust
  !
  != 
  !
  != Saturation adjustment
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! Adjust temperature and specific humidity by the use of saturation 
  ! adjustment
  !
  !== References
  !
!!$  !  Manabe, S., J. Smagorinsky, R. F. Strickler,
!!$  !    Simulated climatology of a general circulation model with a hydrologic cycle,
!!$  !    Mon. Wea. Rev., 93, 769-798, 1965.
  !
  !== Procedures List
  ! 
  ! SaturationAdjust :: ٤漾Ĵ
  ! ---------------- :: ------------
  ! SaturationAdjust :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#saturation_adjust_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SaturationAdjust
  public:: SaturationAdjustInit

  ! ѿ
  ! Public variables
  !
  logical, save :: saturation_adjust_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  logical, save:: FlagSublimation
                              !
                              ! flag for treating sublimation

  character(*), parameter:: module_name = 'saturation_adjust'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: saturation_adjust.f90,v 1.4 2015/01/29 12:03:22 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SaturationAdjust(         &
    & xyz_Temp, xyz_QVap,              &  ! (inout)
    & xyz_QH2OLiq,                     &  ! (in)
    & xyz_Press, xyr_Press,            &  ! (in)
    & xyz_DQH2OLiqDt                   &  ! (out)
    & )
    !
    ! 
    !
    ! Adjust temperature and specific humidity by the use of saturation 
    ! adjustment
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat

    ! 絬϶ŷ (ήŷ) (Manabe, 1965)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    use lscond, only : LScaleCond


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in   ):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
                              ! $ q_w $ .   庮. Cloud water mixing ratio
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)


    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾.
                              ! Saturation specific humidity.
    real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_QH2OLiqB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵα庮. 
                              ! Mixing ratio of cloud water before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)

    real(DP):: xyz_EvapQH2OLiq(0:imax-1, 1:jmax, 1:kmax)
    real(DP):: TempTentative

    real(DP):: LatentHeatLocal
                              ! 
                              ! Latent heat used in this routine
    integer:: i
    integer:: j
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction



    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. saturation_adjust_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Set a value for latent heat
    if ( FlagSublimation ) then
      LatentHeatLocal = LatentHeat + LatentHeatFusion
    else
      LatentHeatLocal = LatentHeat
    end if


    ! Ĵ "QVap", "QH2OLiq", "Temp" ¸
    ! Store "QVap", "QH2OLiq", "Temp" before adjustment
    !
    xyz_QVapB    = xyz_QVap
    xyz_QH2OLiqB = xyz_QH2OLiq
    xyz_TempB    = xyz_Temp

    ! ˰漾׻
    ! Calculate saturation specific humidity
    !
    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )

    ! Evaporate all of cloud liquid water temporarily
!!$    xyz_EvapQH2OLiq = xyz_QH2OLiq
    ! Evaporate part of cloud liquid water temporarily
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          xyz_EvapQH2OLiq(i,j,k) = &
            & min( max( xyz_QVapSat(i,j,k), xyz_QVap(i,j,k) ) - xyz_QVap(i,j,k), &
            &      xyz_QH2OLiq(i,j,k) )
          xyz_EvapQH2OLiq(i,j,k) = &
            & xyz_EvapQH2OLiq(i,j,k) * ( 1.0_DP - 1.0e-10_DP )
          TempTentative = xyz_Temp(i,j,k) - LatentHeatLocal * xyz_EvapQH2OLiq(i,j,k) / CpDry
          if ( TempTentative < 1.0_DP ) then
            TempTentative = 1.0_DP
            xyz_EvapQH2OLiq(i,j,k) = &
              & ( xyz_Temp(i,j,k) - TempTentative ) / ( LatentHeatLocal / CpDry )
          end if
        end do
      end do
    end do
    !
    xyz_Temp    = xyz_Temp    - LatentHeatLocal * xyz_EvapQH2OLiq / CpDry
    xyz_QVap    = xyz_QVap    +                   xyz_EvapQH2OLiq
    ! QH2OLiq will be updated in cloud model. Tendency will be updated below.
!!$    xyz_QH2OLiq = 0.0_DP


    call LScaleCond(              &
      & xyz_Temp, xyz_QVap,       &  ! (inout)
      & xyz_Press, xyr_Press,     &  ! (in)
      & xyz_DQH2OLiqDt,           &  ! (out)
      & .false.                   &
      & )


    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
    xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )


    xyz_DQH2OLiqDt = xyz_DQH2OLiqDt - xyz_EvapQH2OLiq / ( 2.0_DP * DelTime )


    ! calculation for output
    xy_RainLsc     = 0.0_DP
    do k = kmax, 1, -1
      xy_RainLsc = xy_RainLsc                                     &
        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc     )
    call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
    call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SaturationAdjust

  !--------------------------------------------------------------------------------------

  subroutine SaturationAdjustInit( &
    & FlagSnow &
    & )
    !
    ! saturation_adjust ⥸塼νԤޤ. 
    ! NAMELIST#saturation_adjust_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "saturation_adjust" module is initialized. 
    ! "NAMELIST#saturation_adjust_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: SaturateInit

    ! 絬϶ŷ (ήŷ) (Manabe, 1965)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    use lscond, only : LScaleCondInit

    ! ʸ ; Declaration statements
    !
    implicit none

    logical, intent(in) :: FlagSnow


    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /saturation_adjust_nml/ &
      & FlagSublimation
          !
          ! ǥեͤˤĤƤϽ³ "saturation_adjust#SaturationAdjustInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturation_adjust#SaturationAdjustInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturation_adjust_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FlagSublimation = .false.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                    ! (in)
        & nml = saturation_adjust_nml, &   ! (out)
        & iostat = iostat_nml )            ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = saturation_adjust_nml )
    end if

    ! Initialization of modules used in this routine

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    call SaturateInit

    ! 絬϶ŷ (ήŷ) (Manabe, 1965)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    !
    call LScaleCondInit( &
      & FlagSnow &
      & )


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    ! HistoryAutoAddVariable is called in LScaleCond for variables below.
    !
!!$    call HistoryAutoAddVariable( 'RainLsc', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'precipitation by large scale condensation', 'kg m-2 s-1' )
!!$    call HistoryAutoAddVariable( 'DTempDtLsc', &
!!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
!!$      & 'large-scale condensation heating', 'K s-1' )
!!$    call HistoryAutoAddVariable( 'DQVapDtLsc', &
!!$      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
!!$      & 'large-scale condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    saturation_adjust_inited = .true.

  end subroutine SaturationAdjustInit

  !--------------------------------------------------------------------------------------

end module saturation_adjust
