!= ҥȥǡ
!
!= History data output
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module history_file_io
  !
  != ҥȥǡ
  !
  != History data output
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ҥȥǡϤν, ʹ, Ͽѿɽ
  ! λԤޤ. 
  ! [gtool5 饤֥]{http://www.gfd-dennou.org/library/gtool}  
  ! gtool_historyauto ⥸塼Ѥޤ. 
  ! 
  ! ƥǡνϤ, ǥγƥץˤ, 
  ! gtool_historyauto ⥸塼뤫󶡤
  ! HistoryAutoAddVariable  HistoryAutoPut Ѥޤ. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:   lmax, & ! ڥȥǡ󥵥
                               ! Size of array for spectral data
    &                  imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
    &                  jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
    &                  kmax, & ! ľؿ. 
                               ! Number of vertical level
    &                kslmax    ! ϲαľؿ. 
                               ! Number of subsurface vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &    ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: HistoryFileOpen, HistoryFileClose

  ! ѿ
  ! Public variables
  !
  logical, save, public:: history_file_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP),      save:: DefaultIntValue
                              ! ҥȥǡνϴֳ֤ο (ǥե). 
                              ! Numerical value for interval of history data output (default value)
  character(12), save:: DefaultIntUnit
                              ! ҥȥǡνϴֳ֤ñ (ǥե). 
                              ! Unit for interval of history data output (default value)
  character(STRING):: DefaultFilePrefix
                              ! ҥȥǡΥե̾Ƭ (ǥե). 
                              ! Prefixes of history data filenames (default value)

!!$  namelist /history_file_io_nml/ 

  character(*), parameter:: module_name = 'history_file_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: history_file_io.F90,v 1.9 2013/09/16 12:23:38 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface HistoryFileOpen
    module procedure HistoryFileOpen
  end interface

  interface HistoryFileClose
    module procedure HistoryFileClose
  end interface

contains

  !-------------------------------------------------------------------

  subroutine HistoryFileOpen
    !
    ! history_file_io ⥸塼νԤޤ. 
    !--
    ! NAMELIST#history_file_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "history_file_io" module is initialized. 
    !--
    ! "NAMELIST#history_file_io_nml" is loaded in this procedure. 
    !++
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $.
                              ! ߼Ψ. Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & AxnameX  , &
      & AxnameY  , &
      & AxnameZ  , &
      & AxnameR  , &
      & AxnameSSZ, &
      & AxnameSSR, &
      & AxnameWN , &
      & AxnameT  , &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma, &
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
      & w_Number, &
                              ! ڥȥǡźֹ. 
                              ! Subscript of spectral data
      & r_SSDepth, &
                              ! subsurface grid on interface of layer
      & z_SSDepth
                              ! subsurface grid at midpoint of layer

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime, &        ! ꥹȳϻ. 
                              ! Restart time of calculation
      & EndTime, &            ! ׻λ. 
                              ! End time of calculation
      & InitialDate, &        ! ׻. 
                              ! Start date of calculation
      & DelTime               ! $ \Delta t $ [s]

    ! gtool4 netCDF ǡϥ󥿡ե (絬ϥǥ)
    ! Interface of Input/Output of gtool4 netCDF data (For large models)
    !
    use gtool_historyauto, only: HistoryAutoCreate, &
      & HistoryAutoAddAttr, HistoryAutoAddWeight, HistoryAutoPutAxis, &
      & HistoryAutoPutAxisMPI

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: CPrintf

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    logical:: flag_mpi_init

    ! ¹ʸ ; Executable statement
    !

    if ( history_file_io_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    DefaultIntValue = 1.0
    DefaultIntUnit  = 'sec'
    DefaultFilePrefix = ''
!!$    DefaultIntValue = 1.0
!!$    DefaultIntUnit  = 'hrs'
!!$    DefaultFilePrefix = 'data01/'

    flag_mpi_init = .false.

    ! HistoryAutoCreate ˤ
    ! Initialization by "HistoryAutoCreate"
    !
    call HistoryAutoCreate( &
      &     title = trim(FileTitle) // ' history data',        &   ! (in)
      &    source = FileSource, institution = FileInstitution, &   ! (in)
      &      dims = (/ AxnameX, AxnameY, AxnameZ, AxnameR,     &   ! (in)
      &                AxnameSSZ, AxnameSSR,                   &   ! (in)
      &                AxnameWN, AxnameT /),                   &   ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1,             &   ! (in)
      &                max(kslmax,1), kslmax+1,                &   ! (in)
      &                lmax, 0 /),                             &   ! (in)
      & longnames = (/ 'longitude                                       ', &
      &                'latitude                                        ', &
      &                'sigma at layer midpoints                        ', &
      &                'sigma at layer interface (half level)           ', &
      &                'depth at subsurface layer midpoints             ', &
      &                'depth at subsurface layer interface (half level)', &
      &                'subscript of spectral data                      ', &
      &                'time                                            ' /), & ! (in)
      &     units = (/ 'degree_east ', 'degree_north', &
      &                '1           ', '1           ', &
      &                'm           ', 'm           ', &
      &                '1           ', DefaultIntUnit /), &        ! (in)
      &     xtypes = (/ 'float', 'float', &
      &                 'float', 'float', &
      &                 'float', 'float', &
      &                 'int  ', 'float' /), &                     ! (in)
      &          origin  = RestartTime, &                      ! (in) optional
      &         terminus = EndTime + 2. * DelTime, &           ! (in) optional
      &         interval = DefaultIntValue, &                  ! (in) optional
#ifdef INCLUDE_TIME_ORIGIN
      &       start_date = InitialDate, &                      ! (in) optional
#endif
!!$      &     slice_start  = (/ 1.0, 1.0, 1.0, 1.0, 1.0 /), & ! (in) optional
!!$      &     slice_end    = (/ 0.0, 0.0, 0.0, 0.0, 0.0 /), & ! (in) optional
!!$      &     slice_stride = (/   1,   1,   1,   1,   1 /), & ! (in) optional
!!$      &    space_average = (/ .false., .false., .false., &
!!$      &                       .false., .false. /), &        ! (in) optional
!!$      & newfile_interval = real( delta_time * 10 ), &       ! (in) optional

!!$      &  flag_mpi_gather = flag_mpi_init, &                    ! (in) optional
      &  flag_mpi_split  = .true., &                           ! (in) optional
      &      file_prefix = DefaultFilePrefix, &                ! (in) optional
      & namelist_filename = namelist_filename )                ! (in) optional


    ! ɸǡؤ°
    ! Attributes of axes data settings
    !
    call HistoryAutoAddAttr( &
      & varname = 'lon', attrname = 'standard_name', &   ! (in)
      & value = 'longitude' )                            ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'lat', attrname = 'standard_name', &   ! (in)
      & value = 'latitude' )                             ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'sig', attrname = 'positive', &        ! (in)
      & value = 'down' )                                 ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'sigm', attrname = 'positive', &       ! (in)
      & value = 'down' )                                 ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'ssz', attrname = 'standard_name', &   ! (in)
      & value = 'depth' )                                ! (in)
    call HistoryAutoAddAttr( &
      & varname = 'sszi', attrname = 'standard_name', &  ! (in)
      & value = 'depth' )                                ! (in)

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAutoPutAxis( &
      & 'lon',  x_Lon / PI * 180.0_DP )  ! (in)
    call HistoryAutoPutAxis( &
      & 'lat',  y_Lat / PI * 180.0_DP )  ! (in)
    call HistoryAutoPutAxis( &
      & 'sig',  z_Sigma )                ! (in)
    call HistoryAutoPutAxis( &
      & 'sigm', r_Sigma )                ! (in)
    if ( kslmax == 0 ) then
      call HistoryAutoPutAxis( &
        & 'ssz',  r_SSDepth )              ! (in)
    else
      call HistoryAutoPutAxis( &
        & 'ssz',  z_SSDepth )              ! (in)
    end if
    call HistoryAutoPutAxis( &
      & 'sszi', r_SSDepth )              ! (in)
    call HistoryAutoPutAxis( &
      & 'wn',   w_Number )               ! (in)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAutoAddWeight( &
      & dim = 'lon', weight = x_Lon_Weight, & ! (in)
      & units = 'radian', xtype = 'double' )  ! (in) optional
    call HistoryAutoAddWeight( &
      & dim = 'lat', weight = y_Lat_Weight, & ! (in)
      & units = 'radian', xtype = 'double' )  ! (in) optional
    call HistoryAutoAddWeight( &
      & dim = 'sig', weight = z_DelSigma, &   ! (in)
      & xtype = 'double' )                    ! (in) optional

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    history_file_io_inited = .true.
  end subroutine HistoryFileOpen

  !-------------------------------------------------------------------

  subroutine HistoryFileClose
    !
    ! ҥȥǡեϤνλԤޤ. 
    !
    ! Terminate history data files output. 

    ! ⥸塼 ; USE statements
    !

    ! gtool4 netCDF ǡϥ󥿡ե (絬ϥǥ)
    ! Interface of Input/Output of gtool4 netCDF data (For large models)
    !
    use gtool_historyauto, only: HistoryAutoClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    call HistoryAutoClose

  end subroutine HistoryFileClose

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module history_file_io
