!= ʪΤߤη׻Τϳز
!
!= A dynamics for calculation with physical processes only
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $ 
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dynamics_physicsonly
  !
  != ʪΤߤη׻Τϳز
  !
  != A dynamics for calculation with physical processes only
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  !== NAMELIST
  !
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level
  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax
                              ! ʬο
                              ! Number of composition

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: DynamicsPhysicsOnly
  public :: DynamicsPhysicsOnlyInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  real(DP), allocatable, save :: xyz_CorPar(:,:,:)
  real(DP)             , save :: UGeo
  real(DP)             , save :: VGeo
  real(DP)             , save :: WMagnitude
  real(DP)             , save :: WHeight
  real(DP)             , save :: WTimeInit

  logical              , save :: FlagDynExp

  logical, save :: dynamics_physicsonly_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  character(*), parameter:: module_name = 'dynamics_physicsonly'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: dynamics_physicsonly.f90,v 1.7 2015/01/31 06:16:26 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  subroutine DynamicsPhysicsOnly(                                &
    & xyz_Exner, xy_SurfHeight, xyz_Height,                      & ! (in)
    & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, & ! (in)
    & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             & ! (in)
    & xy_PsN, xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN,             & ! (in)
    & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              & ! (out)
    & )

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only:                              &
      &                    ncmax,                       &
                               ! ʬο
                               ! Number of composition
      &                    CompositionInqFlagAdv

    ! 1 ׻ϳز桼ƥƥ⥸塼
    ! Utility module for dynamics for 1-D calculation
    !
    use dynamics_1d_utils, only : Dynamics1DUtilsVerAdv

!!$    ! ̤
!!$    ! Mass fixer
!!$    !
!!$    use mass_fixer, only: MassFixerColumn


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in):: xyz_Exner      (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in):: xy_SurfHeight  (0:imax-1, 1:jmax)
    real(DP), intent(in):: xyz_Height     (0:imax-1, 1:jmax, 1:kmax)

    real(DP), intent(in):: xyz_DUDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{u}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ®Ѳ.
                              ! Eastward wind tendency by external force terms (physical processes)
    real(DP), intent(in):: xyz_DVDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{v}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ®Ѳ.
                              ! Northward wind tendency by external force terms (physicalprocesses)
    real(DP), intent(in):: xyz_DTempDtPhy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{T}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ벹Ѳ.
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in):: xyzf_DQMixDtPhy (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \left(\DP{q}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ漾Ѳ.
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in ):: xy_PsB(0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(in ):: xyz_UB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in ):: xyz_VB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(in ):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in ):: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN    (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_UN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyzf_QMixN(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(out):: xy_PsA(0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyz_UA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(out):: xyz_VA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(out):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(out):: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity


    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_PotTempB     (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyz_W            (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyz_DUDtAdv      (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DVDtAdv      (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DPotTempDtAdv(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyzf_DQMixDtAdv  (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)

    real(DP) :: xyz_UT           (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_VT           (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: DelTimeX2

    integer:: k
    integer:: n

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. dynamics_physicsonly_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    DelTimeX2 = 2.0_DP * DelTime


    xyz_PotTempB = xyz_TempB / xyz_Exner

    if ( TimeN >= WTimeInit ) then
      if ( WHeight > 0.0_DP ) then
        do k = 1, kmax
          xyz_W(:,:,k) =                                                     &
            & WMagnitude * min( xyz_Height(:,:,k) - xy_SurfHeight, WHeight ) &
            &            / WHeight
        end do
      else
        xyz_W = 0.0_DP
      end if
    else
      xyz_W = 0.0_DP
    end if

    ! 1 ׻ϳز桼ƥƥ⥸塼
    ! Utility module for dynamics for 1-D calculation
    !
    call Dynamics1DUtilsVerAdv(    &
      & xyz_W, xyz_Height, xyz_UB, &
      & xyz_DUDtAdv                &
      & )
    call Dynamics1DUtilsVerAdv(    &
      & xyz_W, xyz_Height, xyz_VB, &
      & xyz_DVDtAdv                &
      & )
    call Dynamics1DUtilsVerAdv(          &
      & xyz_W, xyz_Height, xyz_PotTempB, &
      & xyz_DPotTempDtAdv                &
      & )
    do n = 1, ncmax
      if ( CompositionInqFlagAdv( n ) ) then
        call Dynamics1DUtilsVerAdv(          &
          & xyz_W, xyz_Height, xyzf_QMixB(:,:,:,n), &
          & xyzf_DQMixDtAdv(:,:,:,n)                &
          & )
      else
        xyzf_DQMixDtAdv(:,:,:,n) = 0.0_DP
      end if
    end do

    xy_PsA = xy_PsB

    if ( FlagDynExp ) then
      xyz_UA = xyz_UB &
        & + ( xyz_DUDtAdv + xyz_CorPar * xyz_VB + xyz_DUDtPhy ) &
        &     * DelTimeX2
      xyz_VA = xyz_VB &
        & + ( xyz_DVDtAdv - xyz_CorPar * xyz_UB + xyz_DVDtPhy ) &
        &     * DelTimeX2
    else
      xyz_UT = xyz_UB + ( xyz_DUDtAdv + xyz_DUDtPhy ) * DelTimeX2
      xyz_VT = xyz_VB + ( xyz_DVDtAdv + xyz_DVDtPhy ) * DelTimeX2
      xyz_UA = &
        &   (   xyz_UT                                                  &
        &     + DelTimeX2 * xyz_CorPar                                  &
        &         * ( xyz_VT - VGeo + DelTimeX2 * xyz_CorPar * UGeo ) ) &
        & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
      xyz_VA = &
        &   (   xyz_VT                                                  &
        &     - DelTimeX2 * xyz_CorPar                                  &
        &         * ( xyz_UT - UGeo - DelTimeX2 * xyz_CorPar * VGeo ) ) &
        & / ( 1.0_DP + ( DelTimeX2 * xyz_CorPar )**2 )
    end if

!!$    xyz_TempA  = xyz_TempB  + xyz_DTempDtPhy  * 2.0d0 * DelTime
    xyz_TempA = xyz_PotTempB &
      & + ( xyz_DPotTempDtAdv + xyz_DTempDtPhy / xyz_Exner ) * DelTimeX2
    xyz_TempA = xyz_TempA * xyz_Exner

    xyzf_QMixA = xyzf_QMixB &
      & + ( xyzf_DQMixDtAdv + xyzf_DQMixDtPhy ) * DelTimeX2
    xyzf_QMixA = max( xyzf_QMixA, 0.0_DP )


  end subroutine DynamicsPhysicsOnly

  !-------------------------------------------------------------------

  subroutine DynamicsPhysicsOnlyInit

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Omega
                              ! $ \Omega $ [s-1].
                              ! ž®.
                              ! Angular velocity

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only : y_Lat

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 1 ׻ϳز桼ƥƥ⥸塼
    ! Utility module for dynamics for 1-D calculation
    !
    use dynamics_1d_utils, only : Dynamics1DUtilsInit


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dynamics_physicsonly_nml/ &
      & FlagDynExp,                     &
      & UGeo, VGeo,                     &
      & WMagnitude, WHeight, WTimeInit
          !
          ! ǥեͤˤĤƤϽ³ "surface_flux_bulk#SurfFluxInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_flux_bulk#SurfFluxInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !


    if ( dynamics_physicsonly_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FlagDynExp = .false.

    UGeo = 0.0_DP
    VGeo = 0.0_DP

    WMagnitude = 0.0_DP
    WHeight    = 0.0_DP
!!$    WMagnitude = - 0.005_DP
!!$    WHeight    =   1000.0_DP
    WTimeInit  = 0.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                      ! (in)
        & nml = dynamics_physicsonly_nml, &  ! (out)
        & iostat = iostat_nml )              ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    allocate( xyz_CorPar(0:imax-1, 1:jmax, 1:kmax) )

    do k = 1, kmax
      do j = 1, jmax
        xyz_CorPar(:,j,k) = 2.0_DP * Omega * sin( y_Lat(j) )
      end do
    end do

    ! 1 ׻ϳز桼ƥƥ⥸塼
    ! Utility module for dynamics for 1-D calculation
    !
    call Dynamics1DUtilsInit


!!$    ! ҥȥǡϤΤΤؤѿϿ
!!$    ! Register of variables for history data output
!!$    !
!!$    call HistoryAutoAddVariable( 'TauX', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'surface stress(x)  ', 'N m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'TauY', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'surface stress(y)  ', 'N m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'Sens', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'sensible heat flux', 'W m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'EVap', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'latent heat flux  ', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagDynExp = %b', l = (/ FlagDynExp /) )
    call MessageNotify( 'M', module_name, '  UGeo = %f', d = (/ UGeo /) )
    call MessageNotify( 'M', module_name, '  VGeo = %f', d = (/ VGeo /) )
    call MessageNotify( 'M', module_name, '  WMagnitude = %f', d = (/ WMagnitude /) )
    call MessageNotify( 'M', module_name, '  WHeight    = %f', d = (/ WHeight    /) )
    call MessageNotify( 'M', module_name, '  WTimeInit  = %f', d = (/ WTimeInit  /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dynamics_physicsonly_inited = .true.

  end subroutine DynamicsPhysicsOnlyInit

  !--------------------------------------------------------------------------------------

end module dynamics_physicsonly
