#!/usr/bin/env ruby
#
#= Remove Preamble from Latex Format
#
#  Developers :: Yasuhiro MORIKAWA
#  Version    :: $Id: latex2body.rb,v 1.1.1.1 2008/07/30 08:41:32 morikawa Exp $
#
#== Overview
#
#Remove Preamble from Latex Format Contents. Input data is STDIN.
#And Output to STDOUT.
#
#
#= Operation Environment
#
#This program is operated in ruby 1.8.2 (2005-01-10) [i386-linux].
#
#== Usage
#
#   $ latex2body.rb < latex > body
#
#== Desctiption
#
#None
#
#== Future Plans
#
#None
#
#== Notes
#
#None
#
#== Acknowledgements
#
#None
#
#== History
#
#These entries is generated by CVS automatically.
#So do not add new information manually.
#(But please adjust old log format to latest log format manually,
#if format gap between them causes).
#
#$Log: latex2body.rb,v $
#Revision 1.1.1.1  2008/07/30 08:41:32  morikawa
#DCPAM (Dennou Club Planetary Atmospheric Model) Version 5
#
#Revision 1.1.1.1  2007/06/21 03:23:59  morikawa
#DCPAM (Dennou Club Planetary Atmosphere Model) Version 4
#
#Revision 1.1.1.1  2005/11/08 14:10:22  morikawa
#dcpam (Dennou Club Planetary Atmospheric Model) version 3
#
#Revision 1.1  2005/05/16 14:09:46  morikawa
#* This script output latex body (without preamble) from entire latex
#  format.
#
#
##################################################

require "kconv"

##################################################

#
#== Latex2Body
#
module Latex2Body

  #
  # $BDj?t$N@_Dj(B
  #

  # CopyRight
  COPYRIGHT = "GFD Dennou Club"

  # $BK\J8;O$^$j$N%^!<%+(B
  BEGINDOC = '\begin{document}'

  # $BK\J8=*$o$j$N%^!<%+(B
  ENDDOC = '\end{document}'

  # CVSHOST
  CVS_HOST       = "www.gfd-dennou.org"

  # CVSROOT
  CVS_ROOT       = "/GFD_Dennou_Club/ftp/arch/dcpam/cvsroot"

  # CVS $B$N%W%m%8%'%/%HL>(B
  CVS_PROJECT    = "dcpam2"

  # $B%P!<%8%g%s%J%s%P!<(B (CVS $B$K$h$j<+F04IM}(B)
  VER = "$Revision: 1.1.1.1 $"

  #
  # $B$3$l$r8F$V$3$H$G!"0z?t$+$i(B \begin{document} $B$h$jA0$H(B
  # \end{document} $B$h$j8e$m$r=|$$$FJV$9!#(B
  #
  def remove_preamble(all=nil)
    return nil    unless str_and_notspace?(all)

    begindoc = Regexp.quote(BEGINDOC)
    enddoc   = Regexp.quote(ENDDOC)

    latex_body_each_line = all.split(/\n/)
    debug(latex_body_each_line)

    latex_body = ""
    bodyflag = false
    latex_body_each_line.each{ |line|
      if /#{begindoc}/ =~ line then
        bodyflag  = true
        next
      elsif /#{enddoc}/ =~ line
        bodyflag  = false
      else
        latex_body << line + "\n" if bodyflag
      end
    }

    debug(latex_body)
    return latex_body
  end

  #
  # $B%G%P%C%0=PNOMQ%a%=%C%I!#AH$_9~$_4X?t(B $DEBUG $B$,??$N>l9g(B ($B$D$^$j!"(B
  # $B%W%m%0%i%`$r(B $ ruby -d ./xxxxxx.rb $B$H$7$F8F$S=P$7$?>l9g(B) $B$K(B
  # debug $B%a%=%C%I$KBeF~$5$l$?JQ?t$r=PNO$9$k!#(B
  #
  def debug(*args)
    p [caller.first, *args] if $DEBUG
  end
  private :debug

  #
  # $B7Y9p$^$?$O%(%i!<!#(B
  # err $B$,(B nil $B$d(B false $B$N>l9g!"(Bmes $B$KM?$($i$l$?%a%C%;!<%8$r(B
  # $B7Y9p$H$7$FI=<($9$k!#(Berr $B$,??$N>l9g$O$=$N%a%C%;!<%8$N=PNO(B
  # $B$HF1;~$K%(%i!<$rH/@8$5$;!"%W%m%0%i%`$r=*N;$5$;$k!#(B
  # errvar $B$KJQ?t$rM?$($k$H!"%(%i!<$N<oN`$r;XDj$G$-$k!#(B
  # quiet $B$r(B true $B$K$9$k$H!"(Berr $B$,(B nil $B$N>l9g!"2?$bF0:n$7$J$/$J$k!#(B
  #
  def warn_or_err(mes=nil, err=nil, quiet=nil, errvar=nil)
    return nil if !mes

    errvar = RuntimeError if !errvar

    if err then
      raise errvar, "Error: #{mes}"
    elsif !quiet
      $stdout.print "[#{caller.first}] \n     Warning: #{mes}"
      return nil
    end
  end
  private :warn_or_err

  #
  # $BBeF~$5$l$?JQ?t$,!"J8;zNs$G!"3n$D6uGrJ8;z$N$_$G$O$J$$$3$H$r(B
  # $BD4$Y$k%a%=%C%I!#F|K\8l$G$"$C$F$b!"J8;zNs$,F~$C$F$$$l$P(B true $B$rJV$9!#(B
  #
  def str_and_notspace?(obj)
    debug(obj)

    if !obj.instance_of?(String) then
      return false
    end

    # $BF|K\8l$NJ8;zNs$bBP1~$G$-$k$h$&$K(B
    Kconv::toeuc(obj)

    if /\S+/e =~ obj.chomp.strip then
      return true
    else
      return false
    end
  end
  private :str_and_notspace?

end

######################################################
if $0 == __FILE__
  include Latex2Body

  body = remove_preamble($stdin.read)

  $stdout.print body
end
