!= 
!
!= Routines for GABLS tests
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: gabls.f90,v 1.1 2013/09/21 14:58:39 yot Exp $
! Tag Name::  $Name: dcpam5-20150214 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gabls
  !
  != 
  !
  != Routines for GABLS tests
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
!!$  ! ShortIncoming      :: û () η׻
!!$  ! ------------       :: ------------
!!$  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#rad_short_income_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʪ
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI                    ! $ \pi $.
                            ! ߼Ψ. Circular constant

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! 
  ! Time control
  !
  use timeset, only: &
    & TimeN,                & !
    & InitialDate             ! ׻.
                              ! Start date of calculation

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SetGabls2SurfTemp
  public :: GablsInit

  ! ѿ
  ! Public variables
  !
  logical, save :: gabls_inited = .false.
                              ! ե饰. 
                              ! Initialization flag.


  ! ѿ
  ! Private variables
  !

!!$  logical,  save:: FlagAnnualMean
!!$                              ! ǯʿͥե饰.
!!$                              ! Flag for annual mean incoming radiation. 

  character(*), parameter:: module_name = 'gabls'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20150214 $' // &
    & '$Id: gabls.f90,v 1.1 2013/09/21 14:58:39 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetGabls2SurfTemp(     &
    & xy_SurfTemp                   & ! (out)
    & )
    !
    ! 
    !
    ! Set surface temperature
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DC_CAL_DATE, DCCalDateCreate, DCCalDateDifference, DCCalInquire

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: xy_SurfTemp(0:imax-1, 1:jmax)
                              ! 
                              ! surface temperature


    ! ѿ
    ! Work variables
    !
    integer         :: hour_in_a_day
    integer         :: min_in_a_hour
    real(DP)        :: sec_in_a_min

    integer           :: Year
    integer           :: Month
    integer           :: Day
    integer           :: Hour
    integer           :: Min
    real(DP)          :: Sec
    type(DC_CAL_DATE) :: Date1999Oct22UT0000

    real(DP) :: Time1999Oct22UT0000

    real(DP) :: HourFrom1999Oct22UT0000


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. gabls_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    call DCCalInquire( &
      & hour_in_day      = hour_in_a_day,     & ! (out)
      & min_in_hour      = min_in_a_hour,     & ! (out)
      & sec_in_min       = sec_in_a_min       & ! (out)
      & )


    Year  = 1999
    Month =   10
    Day   =   22
    Hour  =    0
    Min   =    0
    Sec   =    0.0_DP
    call DCCalDateCreate( &
      & year = Year, month = Month, day = Day, &
      & hour = Hour, min   = Min  , sec = Sec, &
      & date = Date1999Oct22UT0000             &
      & )

    Time1999Oct22UT0000 = &
      & DCCalDateDifference( Date1999Oct22UT0000, InitialDate )

    HourFrom1999Oct22UT0000 = TimeN + Time1999Oct22UT0000
    HourFrom1999Oct22UT0000 = &
      & HourFrom1999Oct22UT0000 / ( min_in_a_hour * sec_in_a_min )


    if ( HourFrom1999Oct22UT0000 <= 17.4_DP ) then
      xy_SurfTemp = &
        & - 10.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 0.2_DP )
    else if ( HourFrom1999Oct22UT0000 <= 30.0_DP ) then
      xy_SurfTemp = &
        & - 0.54_DP * HourFrom1999Oct22UT0000 + 15.2_DP
    else if ( HourFrom1999Oct22UT0000 <= 41.9_DP ) then
      xy_SurfTemp = &
        & -  7.0_DP - 25.0_DP * cos( 0.21 * HourFrom1999Oct22UT0000 + 1.8_DP )
    else if ( HourFrom1999Oct22UT0000 <= 53.3_DP ) then
      xy_SurfTemp = &
        & - 0.37_DP * HourFrom1999Oct22UT0000 + 18.0_DP
    else if ( HourFrom1999Oct22UT0000 <= 65.6_DP ) then
      xy_SurfTemp = &
        & -  4.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 2.5_DP )
    else
      xy_SurfTemp = &
        &    4.4_DP
    end if

    xy_SurfTemp = xy_SurfTemp + 273.15_DP


  end subroutine SetGabls2SurfTemp

  !--------------------------------------------------------------------------------------

  subroutine GablsInit
    !
    ! rad_short_income ⥸塼νԤޤ. 
    ! NAMELIST#rad_short_income_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_short_income" module is initialized. 
    ! "NAMELIST#rad_short_income_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DC_CAL_DATE, &          ! ɽǡ.
                                ! Data type for date and time
      & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
      & DCCalConvertByUnit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /gabls_nml/                                     &
!!$      & FlagRadSynchronous
          !
          ! ǥեͤˤĤƤϽ³ "rad_short_income#RadShortIncomeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_short_income#RadShortIncomeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( gabls_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
!!$    FlagRadSynchronous       = .false.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &                ! (in)
!!$        & nml = gabls_nml, &           ! (out)
!!$        & iostat = iostat_nml )        ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    gabls_inited = .true.

  end subroutine GablsInit

  !-------------------------------------------------------------------

end module gabls
