!= ٥, Ĺ, Φ̤ȳΤκΤ߹θ
!
!= Set surface albedo and roughness length, only considering land-ocean contrast
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: surface_properties_lo.f90,v 1.1 2012-09-08 15:16:40 yot Exp $
! Tag Name::  $Name: dcpam5-20140204 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_properties_lo

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SetAlbedoLO
  public :: SetRoughLenLO
  public :: SurfacePropertiesLOInit


  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  real(DP), save :: AlbedoLand
  real(DP), save :: AlbedoOcean
  real(DP), save :: RoughLenLand
  real(DP), save :: RoughLenOcean


  logical, save :: surface_properties_lo_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'surface_properties_lo'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204 $' // &
    & '$Id: surface_properties_lo.f90,v 1.1 2012-09-08 15:16:40 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !--------------------------------------------------------------------------------------

  subroutine SetAlbedoLO( &
    & xy_SurfCond,        &
    & xy_SurfAlbedo       &
    )

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level


    integer , intent(in   ) :: xy_SurfCond  ( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. surface_properties_lo_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do j = 1, jmax
      do i = 0, imax-1

        if( xy_SurfCond(i,j) == 0 ) then
          xy_SurfAlbedo(i,j) = AlbedoOcean
        else
          xy_SurfAlbedo(i,j) = AlbedoLand
        end if

      end do
    end do


  end subroutine SetAlbedoLO

  !--------------------------------------------------------------------------------------

  subroutine SetRoughLenLO( &
    & xy_SurfCond,          &
    & xy_RoughLen           &
    )

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level


    integer , intent(in   ) :: xy_SurfCond( 0:imax-1, 1:jmax )
    real(DP), intent(inout) :: xy_RoughLen( 0:imax-1, 1:jmax )

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. surface_properties_lo_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do j = 1, jmax
      do i = 0, imax-1

        if( xy_SurfCond(i,j) == 0 ) then
          xy_RoughLen(i,j) = RoughLenOcean
        else
          xy_RoughLen(i,j) = RoughLenLand
        end if

      end do
    end do


  end subroutine SetRoughLenLO

  !--------------------------------------------------------------------------------------

  subroutine SurfacePropertiesLOInit

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_properties_lo_nml/ &
      & AlbedoLand,    &
      & AlbedoOcean,   &
      & RoughLenLand,  &
      & RoughLenOcean

          ! ǥեͤˤĤƤϽ³ "surface_properties_lo#SurfacePropertiesLOInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_properties_lo#SurfacePropertiesLOInit" for the default values.
          !

    if ( surface_properties_lo_inited ) return



    ! ǥեͤ
    ! Default values settings
    !

    AlbedoLand    = 0.3d0
    AlbedoOcean   = 0.1d0
    RoughLenLand  = 1.0d-1
    RoughLenOcean = 1.0d-4


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                   &  ! (in)
        & nml = surface_properties_lo_nml, &  ! (out)
        & iostat = iostat_nml           &  ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_lo_nml )
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'AlbedoLand    = %f', d = (/ AlbedoLand /) )
    call MessageNotify( 'M', module_name, 'AlbedoOcean   = %f', d = (/ AlbedoOcean /) )
    call MessageNotify( 'M', module_name, 'RoughLenLand  = %f', d = (/ RoughLenLand /) )
    call MessageNotify( 'M', module_name, 'RoughLenOcean = %f', d = (/ RoughLenOcean /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    surface_properties_lo_inited = .true.

  end subroutine SurfacePropertiesLOInit

  !--------------------------------------------------------------------------------------

end module surface_properties_lo

