!= 
!
!= set dust flux
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_dust_flux.f90,v 1.1 2013-09-30 02:53:41 yot Exp $
! Tag Name::  $Name: dcpam5-20140204 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_dust_flux
  !
  != 
  !
  != set dust flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
  ! SetDustFlux     :: ȥեå
  ! SetDustFluxInit :: 
  ! --------------- :: ------------
  ! SetDustFlux     :: Set dust flux
  ! SetDustFluxInit :: Initialization
  !
  !== NAMELIST
  !
  ! NAMELIST#set_dust_flux_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! 
  ! Time control
  !
  use timeset, only: &
    & TimeN,                & !
    & InitialDate             ! ׻.
                              ! Start date of calculation

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetDustFlux
  public:: SetDustFluxInit

  ! ѿ
  ! Public variables
  !
  logical, save :: set_dust_flux_inited = .false.
                              ! ե饰. 
                              ! Initialization flag.


  ! ѿ
  ! Private variables
  !
  real(DP), save :: StartDay
                              ! start day of dust injection
  real(DP), save :: DustFlux
                              ! Dust flux

  real(DP), save :: sec_in_a_day

!!$  logical,  save:: FlagAnnualMean
!!$                              ! ǯʿͥե饰.
!!$                              ! Flag for annual mean incoming radiation. 
!!$  logical,  save:: FlagDiurnalMean
!!$                              ! ʿͥե饰.
!!$                              ! Flag for diurnal mean incoming radiation. 
!!$  logical,  save:: FlagPerpetual
!!$                              ! Ѳʤͥե饰.
!!$                              ! Flag for perpetual incoming radiation. 
!!$
!!$  logical,  save:: FlagSpecifySolDay
!!$                              ! 
!!$                              ! Flag for specifying solar day
!!$  real(DP), save :: SolDay
!!$                              ! length of solar day


  ! NOTE:
  !   Distance between the central star and the planet, and the declination can be
  !   determined by specifying following three parameters: 
  !     PerLonFromVE     : the longitude of the perihelion measured from the vernal 
  !                        equinox, 
  !     LonFromVEAtEpoch : the longitude of the planet at epoch, 
  !     epoch            : date or time. 
  !
!!$  real(DP), save:: PerLonFromVE
!!$                              ! ʬ¬äη () (degree)
!!$                              ! Longitude of the perihelion from vernal equinox (degree)
!!$  real(DP), save:: LonFromVEAtEpoch
!!$                              ! ˤη () (degree)
!!$                              ! Longitude of the planet at epoch (degree)
!!$  real(DP), save:: TimeAtEpoch
!!$                              ! ˤ (sec)
!!$                              ! Time at epoch (sec)
!!$
!!$  real(DP), save:: EpsOrb
!!$                              ! ƻг.
!!$                              ! Inclination of equator to orbit.
!!$  real(DP), save:: Eccentricity
!!$                              ! ΥΨ.
!!$                              ! Eccentricity.
!!$
!!$  integer,  save:: MaxItrEccAnomaly
!!$                              ! ΥѤ׻κ緫֤.
!!$                              ! Maximum iteration number of times
!!$                              ! to calculate eccentric anomaly.
!!$  real(DP), save:: ThreEccAnomalyError
!!$                              ! ΥѤ׻θεƤ.
!!$                              ! Threshold of error
!!$                              ! to calculate eccentric anomaly.
!!$
!!$  real(DP), save:: IncomAIns
!!$                              ! $ A_{ins} $ . ǯʿͤη. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$  real(DP), save:: IncomBIns
!!$                              ! $ B_{ins} $ . ǯʿͤη. AIns Ʊ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$  real(DP), save:: IncomAZet
!!$                              ! $ A_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$  real(DP), save:: IncomBZet
!!$                              ! $ B_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
!!$                              ! Coefficient of annual mean incoming radiation. 
!!$                              ! Same as "AIns". 
!!$
!!$
!!$  real(DP), allocatable, save:: xy_InAngle (:,:)
!!$                              ! sec (ͳ). 
!!$                              ! sec (angle of incidence)
!!$
!!$  logical:: FlagRadSynchronous
!!$                              ! ƱžͤΥե饰
!!$                              ! Flag for synchronous rotation

  character(*), parameter:: module_name = 'set_dust_flux'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204 $' // &
    & '$Id: set_dust_flux.f90,v 1.1 2013-09-30 02:53:41 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetDustFlux( &
    & xy_SurfDustFlux     & ! (out)
    & )
    !
    ! 
    !
    ! Set dust flux
    !

    ! ⥸塼 ; USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: xy_SurfDustFlux(0:imax-1, 1:jmax)
                              ! 
                              ! 


    ! ѿ
    ! Work variables
    !


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. set_dust_flux_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( TimeN >= sec_in_a_day * StartDay ) then
      xy_SurfDustFlux = DustFlux
    else
      xy_SurfDustFlux = 0.0_DP
    end if


  end subroutine SetDustFlux

  !--------------------------------------------------------------------------------------

  subroutine SetDustFluxInit
    !
    ! set_dust_flux ⥸塼νԤޤ. 
    ! NAMELIST#set_dust_flux_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "set_dust_flux" module is initialized. 
    ! "NAMELIST#set_dust_flux_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DCCalInquire

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ʸ ; Declaration statements
    !
    implicit none

    integer  :: hour_in_a_day
    integer  :: min_in_a_hour
    real(DP) :: sec_in_a_min


    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
!!$
!!$    logical         :: FlagUseOfEpochDate
!!$    character(TOKEN):: date_print


    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_dust_flux_nml/ &
      & StartDay, DustFlux
          !
          ! ǥեͤˤĤƤϽ³ "set_dust_flux#SetDustFluxInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "set_dust_flux#SetDustFluxInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( set_dust_flux_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    StartDay = 0.0_DP
    DustFlux = 1.0d-6


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = set_dust_flux_nml,  &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !
    ! Preparation of length of a day in second
    !
    call DCCalInquire( &
      & hour_in_day      = hour_in_a_day,     & ! (out)
      & min_in_hour      = min_in_a_hour,     & ! (out)
      & sec_in_min       = sec_in_a_min       & ! (out)
      & )
    sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min


    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'xxxxx' , &
!!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
!!$      & 'xxxx', 'W m-2' )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'StartDay     = %f', d = (/ StartDay /) )
    call MessageNotify( 'M', module_name, 'DustFlux     = %f', d = (/ DustFlux /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    set_dust_flux_inited = .true.

  end subroutine SetDustFluxInit

  !-------------------------------------------------------------------

end module set_dust_flux
