!= Dennou AGCM μѤ˰漾λ
!
!= Evaluate saturation specific humidity with method used by Dennou AGCM
!
! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
! Version::   $Id: saturate_DennouAGCM.f90,v 1.3 2014-02-04 10:21:01 yot Exp $
! Tag Name::  $Name: dcpam5-20140204 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_DennouAGCM
  !
  != Dennou AGCM μѤ˰漾λ
  !
  != Evaluate saturation specific humidity with method used by Dennou AGCM
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Dennou AGCM ѤƤѤ˰¾׻ޤ. 
  ! μ,  ¸ (1992) ˰ͤäƤޤ.
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a formula used in Dennou AGCM. 
  ! This formula is originaly obtained from Numaguti (1992).
  !
  !== References
  !
  ! * Numaguti, 1992: 
  !   <title in Japanese>, 
  !   Doctor thesis, University of Tokyo.
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_t1930_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  logical, save      :: FlagSublimation
                              !
                              ! flag for treating sublimation

  ! ³
  ! Public procedure
  !
  public:: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
  public:: xy_CalcQVapSat , xy_CalcDQVapSatDTemp
  public:: SaturateInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_DennouAGCM_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), parameter:: Es0 = 611.0_DP
                              ! 0 ˰¾ [Pa]. 
                              ! Saturation water vapor pressure at 0 deg C [Pa]

  character(*), parameter:: module_name = 'saturate_DennouAGCM'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204 $' // &
    & '$Id: saturate_DennouAGCM.f90,v 1.3 2014-02-04 10:21:01 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  function xyz_CalcQVapSat( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion, &
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press(:,:,:)
                              ! $ p $ . . Air pressure

    real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    real(DP):: LatentHeatLocal
                              !
                              ! Latent heat used in this routine


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !

    if ( .not. saturate_DennouAGCM_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! Set a value for latent heat
    if ( FlagSublimation ) then
      LatentHeatLocal = LatentHeat + LatentHeatFusion
    else
      LatentHeatLocal = LatentHeat
    end if

    xyz_QVapSat = &
      & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1./273. - 1./xyz_Temp ) ) &
      & / xyz_Press


  end function xyz_CalcQVapSat

  !--------------------------------------------------------------------------------------

  function xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRWet, &
                              ! $ R_v $ [J kg-1 K-1]. 
                              ! ŷʬε. 
                              ! Gas constant of condensible elements
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion, &
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_Temp   (:,:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_QVapSat(:,:,:)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !
    real(DP):: LatentHeatLocal
                              !
                              ! Latent heat used in this routine


    ! ¹ʸ ; Executable statement
    !

    if ( .not. saturate_DennouAGCM_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! Set a value for latent heat
    if ( FlagSublimation ) then
      LatentHeatLocal = LatentHeat + LatentHeatFusion
    else
      LatentHeatLocal = LatentHeat
    end if

    xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )


  end function xyz_CalcDQVapSatDTemp

  !--------------------------------------------------------------------------------------

  function xy_CalcQVapSat( xy_Temp, xy_Press ) result( xy_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp (:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press(:,:)
                              ! $ p $ . . Air pressure

    real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_Temp   (size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ T $ . . Temperature
    real(DP):: xyz_Press  (size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ p $ . . Air pressure
    real(DP):: xyz_QVapSat(size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    if ( .not. saturate_DennouAGCM_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_Temp (:,:,1) = xy_Temp
    xyz_Press(:,:,1) = xy_Press

    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )

    xy_QVapSat = xyz_QVapSat(:,:,1)


  end function xy_CalcQVapSat

  !--------------------------------------------------------------------------------------

  function xy_CalcDQVapSatDTemp( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Temp   (:,:)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_QVapSat(:,:)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_Temp   (size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ T $ . . Temperature
    real(DP):: xyz_QVapSat(size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1:1)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 


    ! ¹ʸ ; Executable statement
    !

    if ( .not. saturate_DennouAGCM_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_Temp   (:,:,1) = xy_Temp
    xyz_QVapSat(:,:,1) = xy_QVapSat

    xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )

    xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)


  end function xy_CalcDQVapSatDTemp

  !--------------------------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate_DennouAGCM ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_DennouAGCM_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_DennouAGCM" module is initialized. 
    !--
    ! "NAMELIST#saturate_DennouAGCM_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /saturate_DennouAGCM_nml/ &
      & FlagSublimation
          !
          ! ǥեͤˤĤƤϽ³ "saturate_DennouAGCM#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_DennouAGCM#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_DennouAGCM_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    FlagSublimation = .false.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &           ! (in)
        & nml = saturate_DennouAGCM_nml, &  ! (out)
        & iostat = iostat_nml )   ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    saturate_DennouAGCM_inited = .true.

  end subroutine SaturateInit

  !--------------------------------------------------------------------------------------

end module saturate_DennouAGCM
