!= ͥǡեץ
!
!= dcpam main program for generation of initial data file
!
! Authors::   Yasuhiro Morikawa, Yoshiyuki O. Takahashi
! Version::   $Id: dcpam_init_data.f90,v 1.1 2013-10-06 13:42:17 yot Exp $
! Tag Name::  $Name: dcpam5-20140204 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_init_data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ͥǡեޤ. 
  !
  ! Initial data file is created. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only : &
    &                ncmax, & ! ʬο
                              ! Number of composition
    &                IndexH2OVap
                              ! Υǥå
                              ! Index for water vapor

  ! ͥǡ (ꥹȥǡ) 
  ! Prepare initial data (restart data)
  !
  use initial_data, only: SetInitData

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: InitialFileOutPut

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_U (:,:,:)
                              ! $ u $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_V (:,:,:)
                              ! $ v $ .   ®. Northward wind
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .   . Temperature
  real(DP), allocatable:: xyzf_QVap (:,:,:,:)
                              ! $ q $ .   漾. Specific humidity
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ p_s $ . ɽ̵. Surface pressure

  ! ѿ
  ! Work variables
  !
  integer :: n


  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ͥǡκ
  ! Generate initial data
  !
  call SetInitData( &
    & xyz_U, xyz_V, xyz_Temp, xyzf_QVap(:,:,:,IndexH2OVap), xy_Ps )  ! (out)
  do n = 1, ncmax
    if ( n /= IndexH2OVap ) then
      xyzf_QVap(:,:,:,n) = 0.0_DP
    end if
  end do

  ! ͥǡν
  ! Output initial data
  !
  call InitialFileOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyzf_QVap, xy_Ps )  ! (in)

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only : &
      &                CompositionInit, &
      &                ncmax   ! ʬο
                               ! Number of composition

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfileInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileInit, RestartFileOpen

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    use initial_data, only: InitDataInit


    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'dcpam_init_data'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name: dcpam5-20140204 $' // &
      & '$Id: dcpam_init_data.f90,v 1.1 2013-10-06 13:42:17 yot Exp $'
                              ! ץΥС
                              ! Main program version
    character(STRING)      :: namelist_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    ! ¹ʸ ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit


    brief = 'Initial data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(       &
      & namelist_filename,   & ! (out)
      & prog_name,           & ! (in )
      & brief                & ! (in )
      & )

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & namelist_filename  & ! (in)
      & )

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    call CompositionInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͥǡ (ꥹȥǡ) 
    ! Prepare initial data (restart data)
    !
    call InitDataInit


    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QVap(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_Ps    (0:imax-1, 1:jmax) )

    ! ե뤫 1 ץեɤꤹ. 
    ! read 1-D profile from a file and set it 
    !
    call Set1DProfileInit

    ! ͥǡ
    ! Initial data output
    !
    call RestartFileInit
    call RestartFileOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data input
    !
    call RestartFileClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
    deallocate( xyz_U     )
    deallocate( xyz_V     )
    deallocate( xyz_Temp  )
    deallocate( xyzf_QVap )
    deallocate( xy_Ps     )

    ! Finalize MPI
    !
    call MPIWrapperFinalize


  end subroutine MainTerminate

end program dcpam_init_data
