!= ɽ̥ǡ
!
!= Setting planetary surface properties
!
! Authors::   Yasuhiro Morikawa, Yukiko Yamada, Yoshiyuki O. Takahashi
! Version::   $Id: surface_properties.f90,v 1.18 2013-11-17 03:13:49 yot Exp $ 
! Tag Name::  $Name: dcpam5-20140204-5 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_properties
  !
  != ɽ
  !
  != Setting planetary surface properties
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ɽ̤̽ꤷޤ. 
  !
  ! Data about sea surface temperature (SST) or various values on surface
  ! are set. 
  !
  !== Procedures List
  ! SetSurfaceProperties  :: ɽ
  !--
!!$  ! GroundFileOpen   :: ɽ̥ǡեΥץ
!!$  ! GroundFileOutput :: ɽ̥ǡեؤΥǡ
!!$  ! GroundFileClose  :: ɽ̥ǡեΥ
  !++
  ! ------------     :: ------------
  ! SetSurfaceProperties  :: Setting surface properties
  !--
!!$  ! GroundFileOpen   :: Open ground data file
!!$  ! GroundFileOutput :: Data output to ground data file
!!$  ! GroundFileClose  :: Close ground data file
  !++
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_properties_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool5 ǡ
  ! Gtool5 data output
  !
  use gtool_history, only: GT_HISTORY

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetSurfaceProperties
  public:: SurfacePropertiesInit

  ! ѿ
  ! Public variables
  !
  logical, save :: surface_properties_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

!!$  logical, save, public:: ground_file_opened = .false.
!!$                              ! ɽ̥ǡեΥץ˴ؤե饰. 
!!$                              ! Flag of ground data file open

  ! ѿ
  ! Private variables
  !
  logical          , save:: FlagSlabOcean
                              ! ֥ 󡿥.
                              ! flag for use of slab ocean on/off

  character(STRING), save:: SurfTempSetting
                              ! ɽ̲٤ˡ
                              ! Setting of surface temperature
  character(STRING), save:: SurfTempFile
                              ! ɽ̲٤Υե̾. 
                              ! File name of surface temperature
  character(TOKEN) , save:: SurfTempName
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature

  character(STRING), save:: SeaIceSetting
                              ! ɹ̩٤ˡ
                              ! Setting of sea ice concentration
  character(STRING), save:: SeaIceFile
                              ! ɹ̩٤Υե̾. 
                              ! File name of sea ice concentration
  character(TOKEN) , save:: SeaIceName
                              ! ɹ̩٤ѿ̾. 
                              ! Variable name of sea ice concentration

  character(STRING), save:: AlbedoSetting
                              ! ɽ٥ɤˡ
                              ! Settingof surface albedo
  character(STRING), save:: AlbedoFile
                              ! ɽ٥ɤΥե̾. 
                              ! File name of surface albedo
  character(TOKEN) , save:: AlbedoName
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo

  character(STRING), save:: HumidCoefSetting
                              ! ɽ٤ˡ
                              ! Setting of surface humidity coefficient
  character(STRING), save:: HumidCoefFile
                              ! ɽ٤Υե̾. 
                              ! File name of surface humidity coefficient
  character(TOKEN) , save:: HumidCoefName
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient

  character(STRING), save:: RoughLengthSetting
                              ! ɽĹˡ
                              ! Setting of surface rough length
  character(STRING), save:: RoughLengthFile
                              ! ɽĹΥե̾. 
                              ! File name of surface rough length
  character(TOKEN) , save:: RoughLengthName
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length

  character(STRING), save:: HeatCapacitySetting
                              ! ɽǮ̤ˡ
                              ! Setting of surface heat capacity
  character(STRING), save:: HeatCapacityFile
                              ! ɽǮ̤Υե̾. 
                              ! File name of surface heat capacity
  character(TOKEN) , save:: HeatCapacityName
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity

  character(STRING), save:: TempFluxSetting
                              ! Ǯեåˡ
                              ! Setting of ground temperature flux
  character(STRING), save:: TempFluxFile
                              ! ǮեåΥե̾. 
                              ! File name of ground temperature flux
  character(TOKEN) , save:: TempFluxName
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux

  character(STRING), save:: SurfCondSetting
                              ! ɽ֤̾ˡ
                              ! Setting of surface condition
  character(STRING), save:: SurfCondFile
                              ! ɽ֤̾Υե̾. 
                              ! File name of surface condition
  character(TOKEN) , save:: SurfCondName
                              ! ɽ֤̾ѿ̾. 
                              ! Variable name of surface condition

  character(STRING), save:: SurfTypeSetting
                              ! ɽ̥ () ˡ
                              ! Setting of surface type (land use)
  character(STRING), save:: SurfTypeFile
                              ! ɽ̥ () Υե̾. 
                              ! File name of surface type (land use)
  character(TOKEN) , save:: SurfTypeName
                              ! ɽ̥ () ѿ̾. 
                              ! Variable name of surface type (land use)

  character(STRING), save:: SurfCulIntSetting
                              ! ... ˡ
                              ! Setting of surface cultivation intensity
  character(STRING), save:: SurfCulIntFile
                              ! ... Υե̾. 
                              ! File name of surface cultivation intensity
  character(TOKEN) , save:: SurfCulIntName
                              ! ... ѿ̾. 
                              ! Variable name of surface cultivation intensity

  character(STRING), save:: SurfHeightSetting
                              ! ɽ̹٤ˡ
                              ! Setting of surface height
  character(STRING), save:: SurfHeightFile
                              ! ɽ̹٤Υե̾. 
                              ! File name of surface height
  character(TOKEN) , save:: SurfHeightName
                              ! ɽ̹٤ѿ̾. 
                              ! Variable name of surface height

  character(STRING), save:: SoilHeatCapSetting
                              ! ھǮ̤ˡ
                              ! Setting of heat conduction coefficient of soil
  character(STRING), save:: SoilHeatCapFile
                              ! ھǮ̤Υե̾. 
                              ! File name of heat conduction coefficient of soil
  character(TOKEN) , save:: SoilHeatCapName
                              ! ھǮ̤ѿ̾. 
                              ! Variable name of heat conduction coefficient of soil

  character(STRING), save:: SoilHeatDiffCoefSetting
                              ! ھǮƳΨˡ
                              ! Setting of heat conduction coefficient of soil
  character(STRING), save:: SoilHeatDiffCoefFile
                              ! ھǮƳΨΥե̾. 
                              ! File name of heat conduction coefficient of soil
  character(TOKEN) , save:: SoilHeatDiffCoefName
                              ! ھǮƳΨѿ̾. 
                              ! Variable name of heat conduction coefficient of soil

  logical, save:: FlagUseBucket


!!$  character(STRING), save:: OutputFile
!!$                              ! Ϥɽ̥ǡΥե̾
!!$                              ! filename of output ground data
!!$  real(DP), save:: IntValue
!!$                              ! ɽ̥ǡνϴֳ. 
!!$                              ! Interval of ground data output
!!$  character(TOKEN):: IntUnit
!!$                              ! ɽ̥ǡνϴֳ֤ñ. 
!!$                              ! Unit for interval of ground data output
!!$
!!$  type(GT_HISTORY), save:: gthst_grd
!!$                              ! ɽ̥ǡ gtool_history#GT_HISTORY ѿ
!!$                              ! "gtool_history#GT_HISTORY" variable for ground data
!!$
!!$
!!$  type(DC_DIFFTIME), save:: PrevOutputTime
!!$                              ! νϻ. 
!!$                              ! Previous output time
!!$
!!$  type(DC_DIFFTIME), save:: IntTime
!!$                              ! ꥹȥǡνϻ. 
!!$                              ! Time interval of restart data output

  character(*), parameter:: module_name = 'surface_properties'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204-5 $' // &
    & '$Id: surface_properties.f90,v 1.18 2013-11-17 03:13:49 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  subroutine SetSurfaceProperties(                       &
    & xy_SurfMajCompIceB, xy_SoilMoistB, xy_SurfSnowB,   & ! (in)    optional
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef,      & ! (inout) optional
    & xy_SurfRoughLength, xy_SurfHeatCapacity,           & ! (inout) optional
    & xy_DeepSubSurfHeatFlux, xy_SurfCond, xy_SurfType,  & ! (inout) optional
    & xy_SurfHeight,                                     & ! (inout) optional
    & xy_SeaIceConc,                                     & ! (inout) optional
    & xy_SoilHeatCap, xy_SoilHeatDiffCoef                & ! (inout) optional
    & )
    !
    ! ɽꤷޤ. 
    !
    ! Set surface properties. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ǡɤ߹
    ! Reading time series
    !
    use read_time_series, only: SetValuesFromTimeSeriesWrapper

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & EndTime, &            ! ׻λ.
                              ! End time of calculation
      & TimesetClockStart, TimesetClockStop

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: SeaIceThreshold

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    use surface_data, only: SetSurfData

    ! Matthews Υǡ˴Ťɽ̥٥
    ! set surface albedo based on data by Matthews
    !
    use albedo_Matthews, only: SetAlbedoMatthews, ModAlbedoMatthewsCultivation

    ! Хĥǥ
    ! Bucket model
    !
    use Bucket_Model, only : BucketSetFlagOceanFromMatthews, BucketModHumidCoef

    ! ȳɹˤ륢٥Ѳ
    ! modification of surface albedo on the snow covered ground and on the sea ice
    !
    use modify_albedo_snowseaice, only: ModAlbedoDueToSnowSeaIce

    ! ٥, Ĺ, Φ̤ȳΤκΤ߹θ
    ! Set albedo and roughness length, only considering land-ocean contrast
    !
    use surface_properties_lo, only: &
      & SetAlbedoLO, SetRoughLenLO

    ! Matthews Υǡ˴Ť٤
    ! set roughness length on land surface based on data by Matthews
    !
    use roughlen_Matthews, only: SetRoughLenLandMatthews, ModRoughLenMatthewsCultivation


    ! ʸ ; Declaration statements
    !
    real(DP), intent(in   ), optional:: xy_SurfMajCompIceB(0:imax-1, 1:jmax)
                              ! $ M_mcs (t-\Delta t) $ .
                              ! Surface major component ice amount (kg m-2)
    real(DP), intent(in   ), optional:: xy_SoilMoistB(0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
    real(DP), intent(in   ), optional:: xy_SurfSnowB(0:imax-1, 1:jmax)
                              ! $ M_ss (t-\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
    real(DP), intent(inout), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(inout), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(inout), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(inout), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(inout), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(inout), optional:: xy_DeepSubSurfHeatFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! "Deep subsurface heat flux"
                              ! Heat flux at the bottom of surface/soil layer.
    integer , intent(inout), optional:: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ̾ (0: , 1: ). 
                              ! Surface condition (0: fixed, 1: variable)
    integer , intent(inout), optional:: xy_SurfType (0:imax-1, 1:jmax)
                              ! ɽ̥ ()
                              ! Surface type (land use)
    real(DP), intent(inout), optional:: xy_SurfHeight (0:imax-1, 1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(inout), optional:: xy_SeaIceConc(0:imax-1,1:jmax)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)
    real(DP), intent(inout), optional:: xy_SoilHeatCap(0:imax-1,1:jmax)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
    real(DP), intent(inout), optional:: xy_SoilHeatDiffCoef(0:imax-1,1:jmax)
                              ! ھǮƳΨ (W m-1 K-1)
                              ! Heat conduction coefficient of soil (W m-1 K-1)

    ! ѿ
    ! Work variables
    !
    real(DP), allocatable, save:: xy_SurfTempSave (:,:)
                              ! ɽ̲٤¸ (K)
                              ! Saved values of surface temperature (K)
    real(DP), allocatable, save:: xy_SeaIceConcSave(:,:)
                              ! ɹ̩٤¸
                              ! Saved values of sea ice concentration
    real(DP), allocatable, save:: xy_SurfAlbedoSave(:,:)
                              ! ٥ɤ¸
                              ! Saved values of albedo

    logical      :: xy_BucketFlagOceanGrid(0:imax-1,1:jmax)
                              !
                              ! Flag for ocean grid point used in bucket model
    real(DP), allocatable, save:: xy_SurfCulIntSave(:,:)
    real(DP)                   :: xy_SurfCulInt    (0:imax-1,1:jmax)
                              !
                              ! Surface cultivation intensity

    logical, save:: flag_first_SurfCond            = .true.
                              ! 򼨤ե饰. 
                              ! Flag that indicates first loop
                              !
    logical, save:: flag_first_SurfType            = .true.
    logical, save:: flag_first_SurfCulInt          = .true.
    logical, save:: flag_first_SeaIceConc          = .true.
    logical, save:: flag_first_SurfTemp            = .true.
    logical, save:: flag_first_SurfHeight          = .true.
    logical, save:: flag_first_SurfAlbedo          = .true.
    logical, save:: flag_first_SurfHumidCoef       = .true.
    logical, save:: flag_first_SurfRoughLength     = .true.
    logical, save:: flag_first_SurfHeatCapacity    = .true.
    logical, save:: flag_first_DeepSubSurfHeatFlux = .true.
    logical, save:: flag_first_SoilHeatCap         = .true.
    logical, save:: flag_first_SoilHeatDiffCoef    = .true.

    logical:: flag_mpi_init

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. surface_properties_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    flag_mpi_init = .true.


    ! NOTICE:
    ! The surface condition has to be set, before other fields are set.
    !
    ! ɽ̥ ()
    ! Surface type (land use)
    !
    if ( present(xy_SurfType) ) then

      if ( SurfTypeSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfType ) then
          call HistoryGet( &
            & SurfTypeFile, SurfTypeName, &     ! (in)
            & xy_SurfType, &                    ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
        if ( SurfCondSetting /= 'generate_from_SurfType' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfCond has to be 'generate_from_SurfType', if SurfTypeSetting = %c.", &
            & c1 = trim(SurfTypeSetting) )
        end if
      else if ( SurfTypeSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfType ) then
          call SetSurfData( &
            & xy_SurfType = xy_SurfType &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfTypeSetting = %c is not appropriate.', &
          & c1 = trim(SurfTypeSetting) )
      end if

      flag_first_SurfType = .false.

    end if


    ! ɽ̾
    ! Surface condition
    ! Flag whether surface temperature is calculated or not
    ! 0 : surface temperature is not calculated
    ! 1 : surface temperature is     calculated
    !
    if ( present(xy_SurfCond) ) then

      if ( SurfCondSetting == 'generate_from_SurfType' ) then
        if ( flag_first_SurfCond ) then
!!$          if ( ( SurfTypeSetting /= 'file' ) .and. ( SurfTypeSetting /= 'generate_internally' ) ) then
!!$            call MessageNotify( 'E', module_name, &
!!$              & " SurfCond has to be 'generate_from_SurfType' or 'generate_internally', if SurfTypeSetting = %c.", &
!!$              & c1 = trim(SurfTypeSetting) )
!!$          end if
          call MessageNotify( 'M', module_name, &
            & ' xy_SurfCond is constructed by use of xy_SurfType values because SurfTypeSetting = %c.', &
            & c1 = trim(SurfTypeSetting) )
          do j = 1, jmax
            do i = 0, imax-1
              if ( xy_SurfType(i,j) == 0 ) then
                if ( FlagSlabOcean ) then
                  xy_SurfCond(i,j) = 1
                else
                  xy_SurfCond(i,j) = 0
                end if
              else
                xy_SurfCond(i,j) = 1
              end if
            end do
          end do
        end if

      else if ( SurfCondSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfCond ) then
          call HistoryGet( &
            & SurfCondFile, SurfCondName, &     ! (in)
            & xy_SurfCond, &                    ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( SurfCondSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfCond ) then
          call SetSurfData( &
            & xy_SurfCond = xy_SurfCond &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfCondSetting = %c is not appropriate.', &
          & c1 = trim(SurfCondSetting) )
      end if

      ! Check of SurfCond values
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( ( xy_SurfCond(i,j) < 0 ) .or. ( xy_SurfCond(i,j) > 1 ) ) then
            call MessageNotify( 'E', module_name, &
              & ' SurfCond value of %d is not appropriate.', &
              & i = (/ xy_SurfCond(i,j) /) )
          end if
        end do
      end do

      flag_first_SurfCond = .false.

    end if


    ! 
    ! Surface cultivation index
    !
    if ( present( xy_SurfType ) ) then
      ! Cultivation intensity is set only when xy_SurfType is present.
      if ( flag_first_SurfCulInt ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SurfCulIntSave(0:imax-1, 1:jmax) )
      end if
      if ( SurfCulIntSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( SurfTypeSetting /= 'file' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfType has to be 'file', when SurfCulIntSetting = %c.", &
            & c1 = trim(SurfCulIntSetting) )
        end if
        call SetValuesFromTimeSeriesWrapper(    &
          & 'CI',                               &
          & SurfCulIntFile, SurfCulIntName,     &
          & xy_SurfCulIntSave                   &               ! (inout)
          & )
      else if ( SurfCulIntSetting == 'generate_internally' ) then
        xy_SurfCulIntSave = 0.0_DP
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfCulIntSetting = %c is not appropriate.', &
          & c1 = trim(SurfCulIntSetting) )
      end if
      !
      xy_SurfCulInt = xy_SurfCulIntSave
      flag_first_SurfCulInt = .false.
    else
      xy_SurfCulInt = 0.0_DP
    end if


    ! NOTICE:
    ! The sea ice distribution has to be set, before set surface temperature. 
    !
    ! ɹ̩
    ! Sea ice concentration
    !
    if ( present(xy_SeaIceConc) ) then

      if ( flag_first_SeaIceConc ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SeaIceConcSave(0:imax-1, 1:jmax) )
      end if
      if ( SeaIceSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !

        ! This will be deleted near future (yot, 2010/10/11)
!!$        if ( flag_first_SeaIceConc ) then
!!$          call HistoryGet( &
!!$            & SeaIceFile, SeaIceName,          & ! (in)
!!$            & xy_SeaIceConcSave,               & ! (out)
!!$            & flag_mpi_split = flag_mpi_init )   ! (in) optional
!!$        end if
        call SetValuesFromTimeSeriesWrapper(    &
          & 'SIC',                              &
          & SeaIceFile, SeaIceName,             &
          & xy_SeaIceConcSave                   &               ! (inout)
          & )
      else if ( SeaIceSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SeaIceConc ) then
          call SetSurfData( &
            & xy_SeaIceConc = xy_SeaIceConcSave &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SeaIceSetting = %c is not appropriate.', &
          & c1 = trim(SeaIceSetting) )
      end if
      ! ɹ̩٤ ( xy_SurfCond == 0 ξΤ )
      ! Setting of sea ice concentration ( where xy_SurfCond == 0 only )
      !
      xy_SeaIceConc = xy_SeaIceConcSave

      flag_first_SeaIceConc = .false.

    end if


    ! NOTICE:
    ! Before set surface temperature, sea ice distribution has to be set.
    !
    ! ɽ̲
    ! surface temperature
    !
    if ( present(xy_SurfTemp) ) then

      if ( flag_first_SurfTemp ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SurfTempSave  (0:imax-1, 1:jmax) )
      end if
      if ( SurfTempSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !

        ! This will be deleted near future (yot, 2010/10/11)
!!$        if ( flag_first_SurfTemp ) then
!!$          call HistoryGet( &
!!$            & SurfTempFile, SurfTempName, &    ! (in)
!!$            & xy_SurfTempSave, &               ! (out)
!!$            & flag_mpi_split = flag_mpi_init ) ! (in) optional
!!$        end if
        call SetValuesFromTimeSeriesWrapper(    &
          & 'SST',                              &
          & SurfTempFile, SurfTempName,         &
          & xy_SurfTempSave                     &               ! (inout)
          & )
      else if ( SurfTempSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfTemp ) then
          call SetSurfData( &
            & xy_SurfTemp = xy_SurfTempSave & ! (out) optional
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfTempSetting = %c is not appropriate.', &
          & c1 = trim(SurfTempSetting) )
      end if
      ! ɽ̲٤ SST ֤ ( xy_SurfCond <=0 ξΤ )
      ! Surface temperature is replaced with SST ( only xy_SurfCond <=0 )
      !
      if ( present(xy_SurfTemp) ) then

        if ( .not. present( xy_SurfCond ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfCond has to be present to set xy_SurfTemp.' )
        end if
        if ( .not. present( xy_SeaIceConc ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SeaIceConc has to be present to set xy_SurfTemp.' )
        end if

        if ( .not. FlagSlabOcean ) then

          do j = 1, jmax
            do i = 0, imax-1
              if ( ( xy_SurfCond(i,j)     == 0               ) .and. &
                &  ( xy_SurfTempSave(i,j) >  0.0_DP          ) .and. &
                &  ( xy_SeaIceConc(i,j)   <  SeaIceThreshold ) ) then

                xy_SurfTemp(i,j) = xy_SurfTempSave(i,j)

              end if
            end do
          end do
        end if

      end if


      flag_first_SurfTemp = .false.
    end if


    ! Ϸ
    ! Topography
    !
    if ( present(xy_SurfHeight) ) then

      if ( SurfHeightSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHeight ) then
          call HistoryGet( &
            & SurfHeightFile, SurfHeightName, &  ! (in)
            & xy_SurfHeight, &                   ! (out)
            & flag_mpi_split = flag_mpi_init )   ! (in) optional
        end if
      else if ( SurfHeightSetting == 'generate_internally' ) then
        if ( flag_first_SurfHeight ) then
          xy_SurfHeight = 0.0_DP
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfHeightSetting = %c is not appropriate.', &
          & c1 = trim(SurfHeightSetting) )
      end if

      flag_first_SurfHeight = .false.
    end if


    ! NOTICE:
    ! The surface condition and sea ice concentration have to be set, before albedo 
    ! is set.
    !
    ! ٥
    ! Albedo
    !
    if ( present(xy_SurfAlbedo) ) then

      if ( flag_first_SurfAlbedo ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SurfAlbedoSave(0:imax-1, 1:jmax) )
      end if
      if ( AlbedoSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfAlbedo ) then
          call HistoryGet( &
            & AlbedoFile, AlbedoName, &        ! (in)
            & xy_SurfAlbedoSave,      &        ! (out)
            & flag_mpi_split = flag_mpi_init ) ! (in) optional
        end if

      else if ( AlbedoSetting == 'Matthews' ) then
        ! ٥ɤ Matthews ΥǡȤ
        ! Surface albedo is set based on Matthews' data
        !
        if ( .not. present( xy_SurfType ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
        end if
        if ( SurfTypeSetting /= 'file' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfType has to be 'file', when AlbedoSetting = %c.", &
            & c1 = trim(AlbedoSetting) )
        end if
        call SetAlbedoMatthews( &
          & xy_SurfType,      &
          & xy_SurfAlbedoSave &
          & )
        ! Modify albedo due to cultivation
        call ModAlbedoMatthewsCultivation( &
          & xy_SurfType, xy_SurfCulInt,    &
          & xy_SurfAlbedoSave              &
          & )
      else if ( AlbedoSetting == 'LOContrast' ) then
        ! ٥ɤ, Φ̤ȳΤκΤ߹θ
        ! Set albedo, only considering land-ocean contrast
        !
        if ( .not. present( xy_SurfType ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
        end if
        if ( SurfTypeSetting /= 'file' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfType has to be 'file', when AlbedoSetting = %c.", &
            & c1 = trim(AlbedoSetting) )
        end if
        call SetAlbedoLO(      &
          & xy_SurfType,       &
          & xy_SurfAlbedoSave  &
          & )
      else if ( AlbedoSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        ! 
        if ( flag_first_SurfAlbedo ) then
          call SetSurfData( &
            & xy_SurfAlbedo = xy_SurfAlbedoSave  & ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' AlbedoSetting = %c is not appropriate.', &
          & c1 = trim(AlbedoSetting) )
      end if
      ! ٥ɤ
      ! Setting of albedo
      !
      xy_SurfAlbedo = xy_SurfAlbedoSave


      if ( present( xy_SurfType ) ) then
        ! ȳɹˤ륢٥Ѳ
        ! modification of surface albedo on the snow covered ground and on the sea ice
        !

        if ( .not. present( xy_SurfMajCompIceB ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfMajCompIceB has to be present to set xy_SurfAlbedo.' )
        end if
        if ( .not. present( xy_SurfSnowB ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfSnowB has to be present to set xy_SurfAlbedo.' )
        end if
        if ( .not. present( xy_SeaIceConc ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SeaIceConc has to be present to set xy_SurfAlbedo.' )
        end if

        if ( .not. present( xy_SurfType ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
        end if
!!$        if ( SurfTypeSetting /= 'file' ) then
!!$          call MessageNotify( 'E', module_name, &
!!$            & " SurfType has to be 'file'." )
!!$        end if

        call ModAlbedoDueToSnowSeaIce(                        &
          & xy_SurfType,                                      &
          & xy_SurfMajCompIceB, xy_SurfSnowB, xy_SeaIceConc,  & ! (in   ) optional
          & xy_SurfAlbedo                                     & ! (inout)
          & )
      else
        call MessageNotify( 'E', module_name, &
          & ' xy_SurfType has to be present to modify albedo due to snow and sea ice.' )
      end if

      flag_first_SurfAlbedo = .false.
    end if


    ! NOTICE:
    ! The surface condition has to be set, before humidity coefficient is set.
    !
    ! ɽ̼
    ! Surface humidity coefficient
    !
    if ( present(xy_SurfHumidCoef) ) then

      if ( HumidCoefSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHumidCoef ) then
          call HistoryGet( &
            & HumidcoefFile, HumidcoefName, &  ! (in)
            & xy_SurfHumidcoef, &              ! (out)
            & flag_mpi_split = flag_mpi_init ) ! (in) optional
        end if
      else if ( HumidCoefSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfHumidCoef ) then
          call SetSurfData( &
            & xy_SurfHumidCoef = xy_SurfHumidCoef  & ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' HumidCoefSetting = %c is not appropriate.', &
          & c1 = trim(HumidCoefSetting) )
      end if

      if ( FlagUseBucket ) then
        if ( &
          & ( present( xy_SurfType   ) ) .and. &
          & ( present( xy_SoilMoistB ) ) .and. &
          & ( present( xy_SurfSnowB  ) )       &
          & ) then
          ! Хĥǥ˴ؤɽ̼٤
          ! Setting of surface humidity coefficient
          !
          call BucketSetFlagOceanFromMatthews( &
            & xy_SurfType,                     & ! (in)
            & xy_BucketFlagOceanGrid           & ! (out)
            & )
          call BucketModHumidCoef(                                 &
            & xy_BucketFlagOceanGrid, xy_SoilMoistB, xy_SurfSnowB, & ! (in   )
            & xy_SurfHumidCoef                                     & ! (inout)
            & )
        else
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType, xy_SoilMoistB and xy_SurfSnowB have to be present to modify humidity coefficient with bucket model.' )
        end if
      end if

      flag_first_SurfHumidCoef = .false.
    end if


    ! Ĺ
    ! Roughness length
    !
    if ( present(xy_SurfRoughLength) ) then

      if ( RoughLengthSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfRoughLength ) then
          call HistoryGet( &
            & RoughLengthFile, RoughLengthName, & ! (in)
            & xy_SurfRoughLength, &               ! (out)
            & flag_mpi_split = flag_mpi_init )    ! (in) optional
        end if
      else if ( RoughLengthSetting == 'LOContrast' ) then
        ! Ĺ, Φ̤ȳΤκΤ߹θ
        ! Set roughness length, only considering land-ocean contrast
        !
        if ( .not. present( xy_SurfType ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
        end if
        if ( SurfTypeSetting /= 'file' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
            & c1 = trim(RoughLengthSetting) )
        end if
        call SetRoughLenLO(    &
          & xy_SurfType,       &
          & xy_SurfRoughLength &
          & )
      else if ( RoughLengthSetting == 'Matthews' ) then
        ! Ĺ, Matthews Υǡ˴Ť
        ! Set roughness length based on Matthews dataset
        !
        if ( .not. present( xy_SurfType ) ) then
          call MessageNotify( 'E', module_name, &
            & ' xy_SurfType has to be present to set xy_SurfAlbedo.' )
        end if
        if ( SurfTypeSetting /= 'file' ) then
          call MessageNotify( 'E', module_name, &
            & " SurfType has to be 'file', when RoughLengthSetting = %c.", &
            & c1 = trim(RoughLengthSetting) )
        end if
        call SetRoughLenLandMatthews( &
          & xy_SurfType,       &
          & xy_SurfRoughLength &
          & )
        ! Modify albedo due to cultivation
        call ModRoughLenMatthewsCultivation( &
          & xy_SurfType, xy_SurfCulInt,      &
          & xy_SurfRoughLength               &
          & )
      else if ( RoughLengthSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfRoughLength ) then
          call SetSurfData( &
            & xy_SurfRoughLength = xy_SurfRoughLength &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' RoughLengthSetting = %c is not appropriate.', &
          & c1 = trim(RoughLengthSetting) )
      end if

      flag_first_SurfRoughLength = .false.
    end if


    ! ɽǮ
    ! Surface heat capacity
    !
    if ( present(xy_SurfHeatCapacity) ) then

      if ( HeatCapacitySetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHeatCapacity ) then
          call HistoryGet( &
            & HeatCapacityFile, HeatCapacityName, & ! (in)
            & xy_SurfHeatCapacity, &                ! (out)
            & flag_mpi_split = flag_mpi_init )      ! (in) optional
        end if
      else if ( HeatCapacitySetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfHeatCapacity ) then
          call SetSurfData( &
            & xy_SurfHeatCapacity = xy_SurfHeatCapacity &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' HeatCapacitySetting = %c is not appropriate.', &
          & c1 = trim(HeatCapacitySetting) )
      end if

      flag_first_SurfHeatCapacity = .false.
    end if


    ! Ǯեå
    ! Ground temperature flux
    !
    if ( present(xy_DeepSubSurfHeatFlux) ) then

      if ( TempFluxSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_DeepSubSurfHeatFlux ) then
          call HistoryGet( &
            & TempFluxFile, TempFluxName, &     ! (in)
            & xy_DeepSubSurfHeatFlux, &              ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( TempFluxSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_DeepSubSurfHeatFlux ) then
          call SetSurfData( &
            & xy_DeepSubSurfHeatFlux = xy_DeepSubSurfHeatFlux &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' TempFluxSetting = %c is not appropriate.', &
          & c1 = trim(TempFluxSetting) )
      end if

      flag_first_DeepSubSurfHeatFlux = .false.
    end if


    ! ھǮ (J K-1 kg-1)
    ! Specific heat of soil (J K-1 kg-1)
    !
    if ( present(xy_SoilHeatCap) ) then

      if ( SoilHeatCapSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SoilHeatCap ) then
          call HistoryGet( &
            & SoilHeatCapFile, SoilHeatCapName, &     ! (in)
            & xy_SoilHeatCap, &              ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( SoilHeatCapSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SoilHeatCap ) then
          call SetSurfData( &
            & xy_SoilHeatCap = xy_SoilHeatCap &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SoilHeatCapSetting = %c is not appropriate.', &
          & c1 = trim(SoilHeatCapSetting) )
      end if

      flag_first_SoilHeatCap = .false.
    end if


    ! ھǮƳΨ (W m-1 K-1)
    ! Heat conduction coefficient of soil (W m-1 K-1)
    !
    if ( present(xy_SoilHeatDiffCoef) ) then

      if ( SoilHeatDiffCoefSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SoilHeatDiffCoef ) then
          call HistoryGet( &
            & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
            & xy_SoilHeatDiffCoef, &              ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( SoilHeatDiffCoefSetting == 'file_thermal_inertia' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SoilHeatDiffCoef ) then
          call HistoryGet( &
            & SoilHeatDiffCoefFile, SoilHeatDiffCoefName, &     ! (in)
            & xy_SoilHeatDiffCoef, &              ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional

          if ( present( xy_SoilHeatCap ) ) then
            xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef**2 / xy_SoilHeatCap
          else
            call MessageNotify( 'E', module_name, &
              & ' xy_SoilHeatCap has to be present to calculate heat diffusion coefficient of soil from thermal inertia.' )
          end if
        end if
      else if ( SoilHeatDiffCoefSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SoilHeatDiffCoef ) then
          call SetSurfData( &
            & xy_SoilHeatDiffCoef = xy_SoilHeatDiffCoef &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SoilHeatDiffCoefSetting = %c is not appropriate.', &
          & c1 = trim(TempFluxSetting) )
      end if

      flag_first_SoilHeatDiffCoef = .false.
    end if


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'SurfCulInt', xy_SurfCulInt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine SetSurfaceProperties

  !--------------------------------------------------------------------------------------

!!$  subroutine GroundFileOpen
!!$    !
!!$    ! ɽ̥ǡե򥪡ץ󤷤ޤ. 
!!$    !
!!$    ! A ground data file is opened. 
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ϥեδܾ
!!$    ! Basic information for output files
!!$    ! 
!!$    use fileset, only: &
!!$      & FileTitle, &
!!$                              ! ϥǡեɽ.
!!$                              ! Title of output data files
!!$      & FileSource, &
!!$                              ! ǡեμ. 
!!$                              ! Source of data file
!!$      & FileInstitution
!!$                              ! ǡեǽŪѹȿ/Ŀ. 
!!$                              ! Institution or person that changes data files for the last time
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: PI   ! $ \pi $ .
!!$                              ! ߼Ψ.  Circular constant
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    use axesset, only: &
!!$      & x_Lon, &
!!$                              ! $ \lambda $ [rad.] . . Longitude
!!$      & x_Lon_Weight, &
!!$                              ! $ \Delta \lambda $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of longitude
!!$      & y_Lat, &
!!$                              ! $ \varphi $ [rad.] . . Latitude
!!$      & y_Lat_Weight, &
!!$                              ! $ \Delta \varphi $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of latitude
!!$      & z_Sigma, &
!!$                              ! $ \sigma $ ٥ (). 
!!$                              ! Full $ \sigma $ level
!!$      & r_Sigma, &
!!$                              ! $ \sigma $ ٥ (Ⱦ). 
!!$                              ! Half $ \sigma $ level
!!$      & z_DelSigma
!!$                              ! $ \Delta \sigma $ (). 
!!$                              ! $ \Delta \sigma $ (Full)
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: &
!!$      & DelTime, &            ! $ \Delta t $ [s]
!!$      & StartTime, &          ! ׻ϻ. 
!!$                              ! Start time of calculation
!!$      & StartDate, &          ! ׻. 
!!$                              ! Start date of calculation
!!$      & StartDateValid        ! ׻ͭ. 
!!$                              ! Validation of start date of calculation
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
!!$      & HistoryPut, HistoryAddAttr
!!$
!!$    ! ʸ
!!$    ! Character handling
!!$    !
!!$    use dc_string, only: StoA
!!$
!!$    ! դӻμ갷
!!$    ! Date and time handler
!!$    !
!!$    use dc_date, only: toChar, EvalByUnit
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: origin_time
!!$                              ! ׻ϻ. 
!!$                              ! Start time of calculation
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. ground_file_io_inited ) call GroundFileInit
!!$    if ( ground_file_opened ) return
!!$
!!$    ! μ
!!$    ! Get time information
!!$    !
!!$    origin_time = EvalByUnit( StartTime, IntUnit )
!!$
!!$    ! ɽ̥ǡեΥץ
!!$    ! Open a ground data file
!!$    !
!!$    call HistoryCreate( &
!!$      &      file = OutputFile,   &
!!$      &     title = trim(FileTitle) // ' ground data', &          ! (in)
!!$      &    source = FileSource, institution = FileInstitution, &   ! (in)
!!$      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
!!$      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
!!$      & longnames = StoA( 'longitude', 'latitude', &
!!$      &                   'sigma at layer midpoints', &
!!$      &                   'sigma at layer end-points (half level)', &
!!$      &                   'time' ), &                              ! (in)
!!$      &     units = StoA( 'degree_east', 'degree_north', &
!!$      &                   '1', '1', IntUnit ), &                   ! (in)
!!$      &    origin = real( origin_time ), &                         ! (in)
!!$      &  interval = real( IntValue ), &                            ! (in)
!!$      &   history = gthst_grd )                                    ! (out)
!!$
!!$    ! $ \Delta t $ ˴ؤɲ
!!$    ! Add information about $ \Delta t $
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & dims = StoA(''), &                ! (in)
!!$      & longname = 'delta time', &        ! (in)
!!$      & units = 's', xtype = 'float', &   ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & array = (/ DelTime /), &          ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'standard_name', &   ! (in)
!!$      & value = 'longitude', &                           ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'standard_name', &   ! (in)
!!$      & value = 'latitude', &                            ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'standard_name', &   ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'time', attrname = 'standard_name', &  ! (in)
!!$      & value = 'time', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'positive', &        ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'positive', &       ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$
!!$    call HistoryPut( &
!!$      & varname = 'lon', &               ! (in)
!!$      & array = x_Lon / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat', &               ! (in)
!!$      & array = y_Lat / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig', &               ! (in)
!!$      & array = z_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( & 
!!$      & varname = 'sigm', &              ! (in)
!!$      & array = r_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$
!!$    ! ɸŤߤ
!!$    ! Axes weights settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'lon_weight', &                           ! (in)
!!$      & dims = StoA('lon'), &                               ! (in)
!!$      & longname = 'weight for integration in longitude', & ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lon_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'lat_weight', &                           ! (in)
!!$      & dims = StoA('lat'), &                               ! (in)
!!$      & longname = 'weight for integration in latitude', &  ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lat_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'sig_weight', &                           ! (in)
!!$      & dims = StoA('sig'), &                               ! (in)
!!$      & longname = 'weight for integration in sigma', &     ! (in)
!!$      & units = '1', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'sig_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ! ͽѿ
!!$    ! Predictional variables settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'UB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t-\Delta t)', &         ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsB', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'UN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t)', &                ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t)', &               ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t)', &                  ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t)', &            ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsN', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t)', &             ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ground_file_opened = .true.
!!$  end subroutine GroundFileOpen
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileOutput( &
!!$    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
!!$    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
!!$    & )
!!$    !
!!$    ! ɽ̥ǡνϤԤޤ. 
!!$    !
!!$    ! Output ground data
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryPut
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: TimeN  ! ƥå $ t $ λ. 
!!$                              ! Time of step $ t $. 
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t-\Delta t) $ .   ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t-\Delta t) $ .   . Temperature
!!$    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
!!$    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t) $ .     ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t) $ .     ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t) $ .     . Temperature
!!$    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t) $ .     漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. ground_file_opened ) call GroundFileOpen
!!$
!!$    ! ϥߥ󥰤Υå
!!$    ! Check output timing
!!$    !
!!$    if ( TimeN - PrevOutputTime < IntTime ) return
!!$    PrevOutputTime = TimeN
!!$
!!$    ! ǡ
!!$    ! Data output
!!$    !
!!$    call HistoryPut( &
!!$      & 'UB', xyz_UB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VB', xyz_VB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempB', xyz_TempB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapB', xyz_QVapB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsB', xy_PsB, history = gthst_grd ) ! (in)
!!$
!!$    call HistoryPut( &
!!$      & 'UN', xyz_UN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VN', xyz_VN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempN', xyz_TempN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapN', xyz_QVapN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsN', xy_PsN, history = gthst_grd ) ! (in)
!!$
!!$  end subroutine GroundFileOutput
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileClose
!!$    !
!!$    ! ɽ̥ǡեϤνλԤޤ. 
!!$    !
!!$    ! Terminate ground data files output. 
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryClose
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    if ( .not. ground_file_opened ) return
!!$
!!$    call HistoryClose( history = gthst_grd ) ! (inout)
!!$
!!$    ground_file_opened = .false.
!!$  end subroutine GroundFileClose

  !--------------------------------------------------------------------------------------

  subroutine SurfacePropertiesInit(                     &
    & ArgFlagSlabOcean, ArgFlagUseBucket, ArgFlagSnow   & ! (in)
    & )
    !
    ! surface_properties ⥸塼νԤޤ. 
    ! NAMELIST#surface_properties_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "surface_properties" module is initialized. 
    ! "NAMELIST#surface_properties_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! 
    ! Time control
    !
    use timeset, only: DelTime  ! $ \Delta t $ [s]

    ! Matthews Υǡ˴Ťɽ̥٥
    ! set surface albedo based on data by Matthews
    !
    use albedo_Matthews, only : AlbedoMatthewsInit

    ! Хĥǥ
    ! Bucket model
    !
    use Bucket_Model, only : BucketModelInit

    ! ȳɹˤ륢٥Ѳ
    ! modification of surface albedo on the snow covered ground and on the sea ice
    !
    use modify_albedo_snowseaice, only : ModAlbedoSnowSeaIceInit

    ! ٥, Ĺ, Φ̤ȳΤκΤ߹θ
    ! Set albedo and roughness length, only considering land-ocean contrast
    !
    use surface_properties_lo, only : SurfacePropertiesLOInit

    ! Matthews Υǡ˴Ť٤
    ! set roughness length on land surface based on data by Matthews
    !
    use roughlen_Matthews, only : RoughLenMatthewsInit

    ! ʸ ; Declaration statements
    !
    logical, intent(in ) :: ArgFlagSlabOcean
                              ! ֥ 󡿥.
                              ! flag for use of slab ocean on/off
    logical, intent(in ) :: ArgFlagUseBucket
                              ! 
                              ! flag for bucket model
    logical, intent(in ) :: ArgFlagSnow
                              ! 
                              ! flag for snow

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_properties_nml/ &
      & SurfTempSetting,     &
      & SurfTempFile,        &
      & SurfTempName,        &
      & SeaIceSetting,       &
      & SeaIceFile,          &
      & SeaIceName,          &
      & AlbedoSetting,       &
      & AlbedoFile,          &
      & AlbedoName,          &
      & HumidCoefSetting,    &
      & HumidCoefFile,       &
      & HumidCoefName,       &
      & RoughLengthSetting,  &
      & RoughLengthFile,     &
      & RoughLengthName,     &
      & HeatCapacitySetting, &
      & HeatCapacityFile,    &
      & HeatCapacityName,    &
      & TempFluxSetting,     &
      & TempFluxFile,        &
      & TempFluxName,        &
      & SurfCondSetting,     &
      & SurfCondFile,        &
      & SurfCondName,        &
      & SurfTypeSetting,     &
      & SurfTypeFile,        &
      & SurfTypeName,        &
      & SurfCulIntSetting,   &
      & SurfCulIntFile,      &
      & SurfCulIntName,      &
      & SurfHeightSetting,   &
      & SurfHeightFile,      &
      & SurfHeightName,      &
      & SoilHeatCapSetting,  &
      & SoilHeatCapFile,     &
      & SoilHeatCapName,     &
      & SoilHeatDiffCoefSetting, &
      & SoilHeatDiffCoefFile,    &
      & SoilHeatDiffCoefName

          ! ǥեͤˤĤƤϽ³ "surface_properties#SurfacePropertiesInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_properties#SurfacePropertiesInit" for the default values. 
          !

!!$      & OutputFile, &
!!$      & IntValue, IntUnit


    ! ¹ʸ ; Executable statement
    !

    if ( surface_properties_inited ) return


    ! Set flag for slab ocean
    FlagUseBucket = ArgFlagUseBucket

    FlagSlabOcean = ArgFlagSlabOcean


    ! ǥեͤ
    ! Default values settings
    !
    SurfTempSetting         = 'generate_internally'
    SurfTempFile            = ''
    SurfTempName            = ''
    SeaIceSetting           = 'generate_internally'
    SeaIceFile              = ''
    SeaIceName              = ''
    AlbedoSetting           = 'generate_internally'
    AlbedoFile              = ''
    AlbedoName              = ''
    HumidCoefSetting        = 'generate_internally'
    HumidCoefFile           = ''
    HumidCoefName           = ''
    RoughLengthSetting      = 'generate_internally'
    RoughLengthFile         = ''
    RoughLengthName         = ''
    HeatCapacitySetting     = 'generate_internally'
    HeatCapacityFile        = ''
    HeatCapacityName        = ''
    TempFluxSetting         = 'generate_internally'
    TempFluxFile            = ''
    TempFluxName            = ''
    SurfCondSetting         = 'generate_internally'
    SurfCondFile            = ''
    SurfCondName            = ''
    SurfTypeSetting         = 'generate_internally'
    SurfTypeFile            = ''
    SurfTypeName            = ''
    SurfCulIntSetting       = 'generate_internally'
    SurfCulIntFile          = ''
    SurfCulIntName          = ''
    SurfHeightSetting       = 'generate_internally'
    SurfHeightFile          = ''
    SurfHeightName          = ''
    SoilHeatCapSetting      = 'generate_internally'
    SoilHeatCapFile         = ''
    SoilHeatCapName         = ''
    SoilHeatDiffCoefSetting = 'generate_internally'
    SoilHeatDiffCoefFile    = ''
    SoilHeatDiffCoefName    = ''

!!$    OutputFile = 'sst.nc'
!!$    IntValue   = 1.0_DP
!!$    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                   &  ! (in)
        & nml = surface_properties_nml, &  ! (out)
        & iostat = iostat_nml           &  ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_nml )
    end if

!!$    ! ϻֳִ֤
!!$    ! Configure time interval of output 
!!$    !
!!$    call DCDiffTimeCreate( PrevOutputTime, & ! (out)
!!$      & sec = 0.0_DP )                       ! (in)
!!$    call DCDiffTimeCreate( IntTime, & ! (out)
!!$      & IntValue, IntUnit )           ! (in)


    ! A Value of "SurfTempSetting" is checked.
    !
    if ( ( SurfTempSetting == 'file' ) .and. ( FlagSlabOcean ) ) then
      call MessageNotify( 'E', module_name, &
        & "If FlagSlabOcean is .true., SurfTempSetting must not be 'file'." )
    end if


    ! Initialization of modules used in this module
    !

    ! Matthews Υǡ˴Ťɽ̥٥
    ! set surface albedo based on data by Matthews
    !
    call AlbedoMatthewsInit

    if ( FlagUseBucket ) then
      ! Хĥǥ
      ! Bucket model
      !
      call BucketModelInit( &
        & ArgFlagSnow       &
        & )
    end if

    ! ȳɹˤ륢٥Ѳ
    ! modification of surface albedo on the snow covered ground and on the sea ice
    !
    call ModAlbedoSnowSeaIceInit

    ! ٥, Ĺ, Φ̤ȳΤκΤ߹θ
    ! Set albedo and roughness length, only considering land-ocean contrast
    !
    call SurfacePropertiesLOInit

    ! Matthews Υǡ˴Ť٤
    ! set roughness length on land surface based on data by Matthews
    !
    call RoughLenMatthewsInit


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'SurfCulInt' , &  ! (in)
      & (/ 'lon ', 'lat ', 'time' /),           &  ! (in)
      & 'cultivation intensity', '1' )             ! (in)


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    call MessageNotify( 'M', module_name, '  SurfTempSetting         = %c', c1 = trim(SurfTempSetting) )
    call MessageNotify( 'M', module_name, '  SurfTempFile            = %c', c1 = trim(SurfTempFile) )
    call MessageNotify( 'M', module_name, '  SurfTempName            = %c', c1 = trim(SurfTempName        ) )
    call MessageNotify( 'M', module_name, '  SeaIceSetting           = %c', c1 = trim(SeaIceSetting) )
    call MessageNotify( 'M', module_name, '  SeaIceFile              = %c', c1 = trim(SeaIceFile) )
    call MessageNotify( 'M', module_name, '  SeaIceName              = %c', c1 = trim(SeaIceName        ) )
    call MessageNotify( 'M', module_name, '  AlbedoSetting           = %c', c1 = trim(AlbedoSetting      ) )
    call MessageNotify( 'M', module_name, '  AlbedoFile              = %c', c1 = trim(AlbedoFile      ) )
    call MessageNotify( 'M', module_name, '  AlbedoName              = %c', c1 = trim(AlbedoName      ) )
    call MessageNotify( 'M', module_name, '  HumidCoefSetting        = %c', c1 = trim(HumidCoefSetting ) )
    call MessageNotify( 'M', module_name, '  HumidCoefFile           = %c', c1 = trim(HumidCoefFile  ) )
    call MessageNotify( 'M', module_name, '  HumidCoefName           = %c', c1 = trim(HumidCoefName  ) )
    call MessageNotify( 'M', module_name, '  RoughLengthSetting      = %c', c1 = trim(RoughLengthSetting ) )
    call MessageNotify( 'M', module_name, '  RoughLengthFile         = %c', c1 = trim(RoughLengthFile ) )
    call MessageNotify( 'M', module_name, '  RoughLengthName         = %c', c1 = trim(RoughLengthName ) )
    call MessageNotify( 'M', module_name, '  HeatCapacitySetting     = %c', c1 = trim(HeatCapacitySetting) )
    call MessageNotify( 'M', module_name, '  HeatCapacityFile        = %c', c1 = trim(HeatCapacityFile) )
    call MessageNotify( 'M', module_name, '  HeatCapacityName        = %c', c1 = trim(HeatCapacityName) )
    call MessageNotify( 'M', module_name, '  TempFluxSetting         = %c', c1 = trim(TempFluxSetting  ) )
    call MessageNotify( 'M', module_name, '  TempFluxFile            = %c', c1 = trim(TempFluxFile  ) )
    call MessageNotify( 'M', module_name, '  TempFluxName            = %c', c1 = trim(TempFluxName  ) )
    call MessageNotify( 'M', module_name, '  SurfCondSetting         = %c', c1 = trim(SurfCondSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfCondFile            = %c', c1 = trim(SurfCondFile   ) )
    call MessageNotify( 'M', module_name, '  SurfCondName            = %c', c1 = trim(SurfCondName   ) )
    call MessageNotify( 'M', module_name, '  SurfTypeSetting         = %c', c1 = trim(SurfTypeSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfTypeFile            = %c', c1 = trim(SurfTypeFile   ) )
    call MessageNotify( 'M', module_name, '  SurfTypeName            = %c', c1 = trim(SurfTypeName   ) )
    call MessageNotify( 'M', module_name, '  SurfCulIntSetting       = %c', c1 = trim(SurfCulIntSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfCulIntFile          = %c', c1 = trim(SurfCulIntFile   ) )
    call MessageNotify( 'M', module_name, '  SurfCulIntName          = %c', c1 = trim(SurfCulIntName   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightSetting       = %c', c1 = trim(SurfHeightSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightFile          = %c', c1 = trim(SurfHeightFile   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightName          = %c', c1 = trim(SurfHeightName   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatCapSetting      = %c', c1 = trim(SoilHeatCapSetting   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatCapFile         = %c', c1 = trim(SoilHeatCapFile   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatCapName         = %c', c1 = trim(SoilHeatCapName   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefSetting = %c', c1 = trim(SoilHeatDiffCoefSetting   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefFile    = %c', c1 = trim(SoilHeatDiffCoefFile   ) )
    call MessageNotify( 'M', module_name, '  SoilHeatDiffCoefName    = %c', c1 = trim(SoilHeatDiffCoefName   ) )


!!$    call MessageNotify( 'M', module_name, 'Output:: ' )
!!$    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
!!$    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_properties_inited = .true.

  end subroutine SurfacePropertiesInit

  !--------------------------------------------------------------------------------------

end module surface_properties
