module sltt_const
  !
  != ߥ饰󥸥ˡ Ѥ
  !
  != Constants for Semi-Lagrangian method
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP    ! ټ¿. Double precision.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only:       &
    &                imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: SLTTConstInit


  ! ѿ
  ! Public variables
  !
!!$  public :: jew !, dtjw
  public :: dtjw
  public :: iexmin
  public :: iexmax
  public :: jexmins
  public :: jexmaxs
  public :: jexminn
  public :: jexmaxn
  public :: Pix2, PIH
  public :: nloop_dp_h, nloop_dp_v


  !
  ! local variables
  !
  ! Set minimum and maximu indices for south-north separate extended arrays
  !
  integer, save :: iexmin
  integer, save :: iexmax
  integer, save :: jexmins
  integer, save :: jexmaxs
  integer, save :: jexminn
  integer, save :: jexmaxn
  !
  ! jew : latitudinal edge width
  !     : jew >= 4 and dtjw (dtjw is defined below)
  !     : In the current version of implimented semi-Lagrangian scheme, 
  !     : the lower limit of jew is 4, which is restricted by the number of
  !     : latitudinal grids needed to estimate values at poles. 
  !
!!$  integer, parameter         :: jew = 3
  !
  ! dtjw : data transfer latitudinal grid width
!!$  !      : int( C * 2 ) + 3 <= mpjwidth <= jmax and jew
!!$  !      : The mpjwidth must be less than jmax and jew, which is defined 
!!$  !      : above.
!!$  !      : The lower limit of mpjwidth is 3, if the Courant number is
!!$  !      :                      less than 0.5. 
!!$  !      : The lower limit of mpjwidth is 4, if the Courant number is
!!$  !      : greater than 0.5 and less than 1. 
!!$  !      : The lower limit of mpjwidth is 5, if the Courant number is
!!$  !      : greater than 1   and less than 1.5. 
!!$  !      : (But now, if the Courant number is greater than 0.5, this 
!!$  !      : routine would stop in sltt_dp_h and sltt_hiq routines.)
!!$  !
  integer, parameter         :: dtjw = 2

  real(DP), save             :: PIx2, PIH


  integer, save              :: nloop_dp_h = 4
  integer, save              :: nloop_dp_v = 4


  ! ѿ
  ! Private variables
  !
  logical, save :: sltt_const_inited = .false.
                              ! ե饰.
                              ! Initialization flag



  character(*), parameter:: module_name = 'sltt_const'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204-5 $' // &
    & '$Id: sltt_const.f90,v 1.2 2013-01-27 11:26:14 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine SLTTConstInit

    use gridset    , only : jmax
    use mpi_wrapper, only : nprocs, myrank
    use constants0 , only : PI


    !
    ! local variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( sltt_const_inited ) return


    PIx2 = PI + PI
    PIH  = PI / 2.0_DP


!!$    if( jew > jmax/2 ) then
!!$      write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
!!$        " JEW = ", jew, " JMAX/2 = ", jmax/2
!!$      write( 6, * ) "SLTT ERROR : JEW MUST BE LESS THAN JMAX."
!!$      stop
!!$    end if
    if( nprocs > 1 ) then
      if( jmax/2 < dtjw ) then
!!$      if( jmax/2 < jew ) then
        write( 6, * ) "SLTT ERROR : MYRANK = ", myrank, &
!!$          " JMAX/2 = ", jmax/2, " TRANSFERED J WIDTH = ", dtjw
          " JMAX/2 = ", jmax/2, " TRANSFERED J WIDTH = ", dtjw
        write( 6, * ) "SLTT ERROR : JMAX MUST BE GREATER THAN TRANSFERED J WIDTH."
        stop
      end if
    end if


    ! Set minimum and maximu indices for south-north separate extended arrays
    iexmin = -2          ! width of halo region of dtjw
    iexmax = imax-1+1+2  ! 1 for 360 longitude and width of halo region of dtjw
    if ( myrank == (nprocs-1) ) then
      jexmins = -dtjw          ! minimum j of southern array
      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
      jexminn = -dtjw+1        ! maximum j of northern array
      jexmaxn = jmax/2+1+dtjw  ! maximum j of northern array
    else
      jexmins = -dtjw+1        ! minimum j of southern array
      jexmaxs = jmax/2+dtjw    ! maximum j of southern array
      jexminn = -dtjw+1        ! maximum j of northern array
      jexmaxn = jmax/2+dtjw    ! maximum j of northern array
    end if


    sltt_const_inited = .true.

  end subroutine SLTTConstInit

  !--------------------------------------------------------------------------------------

end module sltt_const
