!= ϥեδܾ
!= Management basic information for output files
! 
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: fileset.f90,v 1.3 2009-03-03 15:57:35 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20140204-5 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module fileset
  !
  != ϥեδܾ
  !
  != Management basic information for output files
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Variables List
  !
  ! FileTitle        :: ϥǡեɽ
  ! FileSource       :: ǡեμ
  ! FileInstitution  :: ǡեǽŪѹȿ/Ŀ
  ! ------------     :: ------------
  ! FileTitle        :: Title of output data files
  ! FileSource       :: Source of data file
  ! FileInstitution  :: Institution or person that changes data files for the last time
  !
  !
  !== Procedures List
  !
  ! FilesetInit   :: fileset ⥸塼ν
  ! ------------  :: ------------
  ! FilesetInit   :: Initialize "fileset" module
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#fileset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: STRING ! ʸ.       Strings. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: FilesetInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: fileset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(STRING), save, public:: FileTitle
                              ! ϥǡեɽ.
                              ! Title of output data files
  character(STRING), save, public:: FileSource
                              ! ǡեμ. 
                              ! Source of data file
  character(STRING), save, public:: FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'fileset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204-5 $' // &
    & '$Id: fileset.f90,v 1.3 2009-03-03 15:57:35 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface FilesetInit
    module procedure FilesetInit
  end interface

contains

  subroutine FilesetInit
    !
    ! fileset ⥸塼νԤޤ. 
    ! NAMELIST#fileset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "fileset" module is initialized. 
    ! NAMELIST#fileset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /fileset_nml/ &
      & FileTitle, FileSource, FileInstitution
          !
          ! ǥեͤˤĤƤϽ³ "fileset#FilesetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "fileset#FilesetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( fileset_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    FileTitle  = 'dcpam5 test run'
    FileSource = 'dcpam5 $Name: dcpam5-20140204-5 $ (http://www.gfd-dennou.org/library/dcpam)'
    FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = fileset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = fileset_nml )
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FileTitle       = %c', c1 = trim(FileTitle) )
    call MessageNotify( 'M', module_name, '  FileSource      = %c', c1 = trim(FileSource) )
    call MessageNotify( 'M', module_name, '  FileInstitution = %c', c1 = trim(FileInstitution) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    fileset_inited = .true.
  end subroutine FilesetInit

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module fileset
