!= ʬѲ
!
!= Phase change of atmospheric major component
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: saturate_major_comp.f90,v 1.1 2013-09-30 02:55:27 yot Exp $ 
! Tag Name::  $Name: dcpam5-20140204-5 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_major_comp
  !
  != ʬѲ
  !
  != Phase change of atmospheric major component
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== References
  !
  ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
  !   A Martian general circulation experiment with large topography, 
  !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#saturate_major_comp_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private


  integer, save      :: IndexSpc
  integer, parameter :: IndexSpcCO2     = 1


  real(DP), parameter :: LatentHeatCO2Subl = 5.9d5
                              ! Latent heat of CO2 (J kg^{-1})
                              ! This value is obtained from Pollack et al. 
                              ! (1981) and Forget et al. (1998).

  ! ³
  ! Public procedure
  !
  public :: SaturateMajorCompCalcCondTemp
  public :: SaturateMajorCompInqLatentHeat
  public :: SaturateMajorCompInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_major_comp_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'saturate_major_comp'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204-5 $' // &
    & '$Id: saturate_major_comp.f90,v 1.1 2013-09-30 02:55:27 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  interface SaturateMajorCompCalcCondTemp
    module procedure &
      SaturateMajorCompCalcCondTemp3D, &
      SaturateMajorCompCalcCondTemp2D
  end interface


contains

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompCalcCondTemp3D(  &
    & xyz_Press,                               &  ! (in)
    & xyz_TempCond                             &  ! (inout)
    & )
    !
    ! ʬѲ
    !
    ! Major component phase change
    !

    ! ⥸塼 ; USE statements
    !

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    use saturate_co2_p81, only : xyz_SaturateCO2P81TempCond


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press   (:,:,:)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyz_TempCond(:,:,:)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( IndexSpc )
    case ( IndexSpcCO2 )
      ! CO2 condensation temperature

      xyz_TempCond = xyz_SaturateCO2P81TempCond( xyz_Press )

    end select


  end subroutine SaturateMajorCompCalcCondTemp3D

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompCalcCondTemp2D(  &
    & xy_Press,                                &  ! (in)
    & xy_TempCond                              &  ! (inout)
    & )
    !
    ! ʬѲ
    !
    ! Major component phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_Press   (:,:)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xy_TempCond(:,:)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_Press   (size(xy_Press   ,1),size(xy_Press   ,2),1)
    real(DP) :: xyz_TempCond(size(xy_TempCond,1),size(xy_TempCond,2),1)


    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    xyz_Press(:,:,1) = xy_Press

    call SaturateMajorCompCalcCondTemp3D(  &
      & xyz_Press,                         &  ! (in)
      & xyz_TempCond                       &  ! (inout)
      & )

    xy_TempCond = xyz_TempCond(:,:,1)


  end subroutine SaturateMajorCompCalcCondTemp2D

  !--------------------------------------------------------------------------------------

  function SaturateMajorCompInqLatentHeat( ) result( LatentHeat )
    !
    ! ʬǮ֤ޤ. 
    !
    ! Inquiry of latent heat of major component
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP) :: LatentHeat


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. saturate_major_comp_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Set latent heat
    select case ( IndexSpc )
    case ( IndexSpcCO2  )
      LatentHeat = LatentHeatCO2Subl
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select


  end function SaturateMajorCompInqLatentHeat

  !--------------------------------------------------------------------------------------

  subroutine SaturateMajorCompInit(  &
    & CondMajCompName                & ! (in)
    & )
    !
    ! saturate_major_comp ⥸塼νԤޤ. 
    ! NAMELIST#saturate_major_comp_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "saturate_major_comp" module is initialized. 
    ! "NAMELIST#saturate_major_comp_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
!!$
!!$    ! ե
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! ̷ѥ᥿
!!$    ! Kind type parameter
!!$    !
!!$    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    use saturate_co2_p81, only : SaturateCO2P81Init


    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), intent(in) :: CondMajCompName
                                        ! Condensable major component


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_major_comp_nml/ &
!!$      & FlagUse

          ! ǥեͤˤĤƤϽ³ "saturate_major_comp#MajorCompSaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_major_comp#MajorCompSaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_major_comp_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                    &  ! (in)
!!$        & nml = saturate_major_comp_nml, &  ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
!!$    end if


    ! Set index
    select case ( CondMajCompName )
    case ( 'CO2' )
      IndexSpc = IndexSpcCO2
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select


    ! Initialization of modules called in this module
    !

    != 
    != CO2 condensation temperature (Pollack et al., 1981)
    !
    call SaturateCO2P81Init


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    saturate_major_comp_inited = .true.

  end subroutine SaturateMajorCompInit

  !-------------------------------------------------------------------

end module saturate_major_comp
