module ckd_module

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING, &  ! ʸ.       Strings.
    &                 TOKEN      ! .   Keywords.


  ! ʸ ; Declaration statements
  !
  implicit none
  private


  ! ³
  ! Public procedure
  !
  public:: ckd_input

  ! ѿ
  ! Public variables
  !

  ! The structure of bandparam structure may be inappropriate, for this cannot be used 
  ! for multiple radiatively active species. 
  ! Maybe, 
  !   * imol has to be 1D array,
  !   * lnac has to be 4D array.
  ! (yot, 2010/09/12)
  !
  type bandparam
    integer           :: imol
    integer           :: ng, nlnp, nt
    real(DP)          :: wnbnds( 2 )
    real(DP), pointer :: weight( : )
    real(DP), pointer :: lnac  ( :, :, : )
    real(DP), pointer :: pfr   ( :, :, : )
    real(DP), pointer :: g( : ), lnp( : ), t( : )
    real(DP), pointer :: g_ll( : ), g_ul( : )
  end type bandparam

  integer                     , save :: nband
  type(bandparam), allocatable, save :: ckdp( : )


  public :: bandparam, nband, ckdp


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine ckd_input( &
    & ncfn & ! (in)
    & )

    use netcdf_wrapper, only : &
      & NWInqDimLen, &
      & NWGetAtt

    ! gtool ǡ
    ! Gtool data input
    !
    use gtool_history, only: HistoryGet


    character(*), intent(in) :: ncfn

    !
    ! local variables
    !
    character(STRING) :: comment
    character(STRING) :: name_weight
    character(STRING) :: name_g
    character(STRING) :: name_lnac
    character(STRING) :: name_pfr
    character(STRING) :: name_bnds

    integer           :: iband, ig

    logical           :: flag_mpi_init = .false.


    write( 6, * ) 'Read ', trim( ncfn )

    call NWGetAtt( ncfn, 'global', 'comment', comment )

    call NWGetAtt( ncfn, 'global', 'nband'  , nband   )


    allocate( ckdp( nband ) )

    do iband = 1, nband
      write( 6, * ) 'band ', iband 

      call NWGetAtt( ncfn, 'global', 'imol', ckdp(iband)%imol )

      write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
      write( name_weight, '(a,i4.4)' ) "weight_", iband
      write( name_g     , '(a,i4.4)' ) "g_"     , iband
      write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
      write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband

      call NWInqDimLen(        &
        & ncfn,                & ! (in )
        & name_g,              & ! (in )
        & ckdp( iband ) % ng   & ! (out)
        & )
      call NWInqDimLen(        &
        & ncfn,                & ! (in )
        & 't',                 & ! (in )
        & ckdp( iband ) % nt   & ! (out)
        & )
      call NWInqDimLen(        &
        & ncfn,                & ! (in )
        & 'lnp',               & ! (in )
        & ckdp( iband ) % nlnp & ! (out)
        & )


      allocate( &
        & ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
        & ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
        & ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
        & ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
        & )

      allocate( &
        & ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
        & )
      allocate( &
        & ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
        & )


      call HistoryGet(                      &
        & ncfn,                             &
        & name_weight,                      &
        & ckdp(iband)%weight,               &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & name_g,                           &
        & ckdp(iband)%g,                    &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & 'lnp',                            &
        & ckdp(iband)%lnp,                  &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & 't',                              &
        & ckdp(iband)%t,                    &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & name_bnds,                        &
        & ckdp(iband)%wnbnds,               &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & name_lnac,                        &
        & ckdp(iband)%lnac,                 &
        & flag_mpi_split = flag_mpi_init    &
        & )
      call HistoryGet(                      &
        & ncfn,                             &
        & name_pfr,                         &
        & ckdp(iband)%pfr,                  &
        & flag_mpi_split = flag_mpi_init    &
        & )


      write( 6, * ) 'band ', iband 
      write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
      write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
      write( 6, * ) '  ng   = ', ckdp(iband)%ng
      do ig = 1, ckdp(iband)%ng
        write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
      end do
      write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
      write( 6, * ) '  nt   = ', ckdp(iband)%nt
    end do


  end subroutine ckd_input

!!$#ifdef ZZZZZZZZZ
!!$    !**************************************************************************
!!$#ifndef NOUSE_NETCDF
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_mktbl_init
!!$
!!$      use fi_module
!!$      use ni3_module
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      integer(i4b)              :: k, incf, iband, iwn, iras
!!$      real(dp)    , allocatable :: l_wn( : ), l_plev( : ), l_imol( : ), l_t( : )
!!$      real(dp)                  :: wns, wne
!!$      integer(i4b)              :: ng
!!$      real(dp)    , allocatable :: wnbnds_s( : ), wnbnds_e( : ), ngdiv( : )
!!$      character(len=extstr)     :: fn
!!$      integer(i4b)              :: ctlfu, ios
!!$
!!$
!!$      namelist /input_ac/    fn
!!$      namelist /bandnum/  nband
!!$      namelist /bandinfo/ wns, wne, ng
!!$
!!$
!!$      call fi_open( ctlfn, "read", ctlfu )
!!$      nncfile = 0
!!$      do
!!$         read( ctlfu, input_ac, iostat = ios )
!!$         if( ios .ne. 0 ) exit
!!$         nncfile = nncfile + 1
!!$      end do
!!$      allocate( ncfn( nncfile ), ncid( nncfile ) )
!!$      rewind( ctlfu )
!!$      do incf = 1, nncfile
!!$         read( ctlfu, input_ac )
!!$         ncfn( incf ) = fn
!!$         write( 6, * ) 'Input file ', incf, ' : ', trim( ncfn( incf ) )
!!$      end do
!!$      !
!!$      rewind( ctlfu )
!!$      read( ctlfu, bandnum )
!!$      allocate( wnbnds_s( nband ), wnbnds_e( nband ), ngdiv( nband ) )
!!$      rewind( ctlfu )
!!$      do iband = 1, nband
!!$         read( ctlfu, bandinfo )
!!$         write( 6, * ) 'Band range       : ', wns, wne
!!$         write( 6, * ) 'Band subinterval : ', ng
!!$         wnbnds_s( iband ) = wns
!!$         wnbnds_e( iband ) = wne
!!$         ngdiv   ( iband ) = ng
!!$         if( iband .ge. 2 ) then
!!$            if( wnbnds_s( iband ) .ne. wnbnds_e( iband-1 ) ) then
!!$               write( 6, * ) 'Band range is inappropriate.'
!!$               write( 6, * ) iband, wnbnds_s( iband ), wnbnds_e( iband-1 )
!!$               stop
!!$            end if
!!$         end if
!!$      end do
!!$      close( ctlfu )
!!$
!!$
!!$      tm = nncfile
!!$      allocate( temp( tm ) )
!!$
!!$      do incf = 1, nncfile
!!$         call ni3_open( ncfn( incf ), "read", ncid( incf ) )
!!$
!!$         if( incf .eq. 1 ) then
!!$            call ni3_inq_dimlen( ncid( incf ), "wn"  , nwn  )
!!$            call ni3_inq_dimlen( ncid( incf ), "plev", km   )
!!$            call ni3_inq_dimlen( ncid( incf ), "imol", nras )
!!$            allocate( wn( nwn ), plev( km ), imol( nras ) )
!!$            call ni3_get_var( ncid( incf ), "wn"  , wn   )
!!$            call ni3_get_var( ncid( incf ), "plev", plev )
!!$            call ni3_get_var( ncid( incf ), "imol", imol )
!!$
!!$            !
!!$            ! quality check
!!$            !
!!$            if(  ( wn(1  )-(wn(2)-wn(1))*0.5d0 .ne. wnbnds_s( 1     ) ) .or. &
!!$                 ( wn(nwn)+(wn(2)-wn(1))*0.5d0 .ne. wnbnds_e( nband ) ) ) then
!!$               write( 6, * ) 'Unexpectected wavenumber range'
!!$               write( 6, * ) wn( 1   ), wnbnds_s( 1     )
!!$               write( 6, * ) wn( nwn ), wnbnds_e( nband )
!!$               stop
!!$            end if
!!$            do k = 1, km
!!$               if( plev( k ) .le. 0.0d0 ) then
!!$                  write( 6, * ) 'Unexpected zero or negative pressure.'
!!$                  write( 6, * ) k, plev( k )
!!$                  stop
!!$               end if
!!$            end do
!!$
!!$            allocate( l_wn( nwn ), l_plev( km ), l_imol( nras ), l_t( km ) )
!!$         end if
!!$
!!$         call ni3_get_var( ncid( incf ), "wn", l_wn )
!!$         do iwn = 1, nwn
!!$            if( wn( iwn ) .ne. l_wn( iwn ) ) then
!!$               write( 6, * ) 'wavenumber is not identical.'
!!$               write( 6, * ) iwn, wn( iwn ), l_wn( iwn )
!!$               stop
!!$            end if
!!$         end do
!!$
!!$
!!$         !
!!$         ! quality check
!!$         !
!!$         call ni3_get_var( ncid( incf ), "plev", l_plev )
!!$         do k = 1, km
!!$            if( plev( k ) .le. 0.0d0 ) then
!!$               write( 6, * ) 'Unexpected zero or negative pressure.'
!!$               write( 6, * ) k, plev( k )
!!$               stop
!!$            end if
!!$            if( plev( k ) .ne. l_plev( k ) ) then
!!$               write( 6, * ) 'pressure level is not identical.'
!!$               write( 6, * ) k, plev( k ), l_plev( k )
!!$               stop
!!$            end if
!!$         end do
!!$
!!$         call ni3_get_var( ncid( incf ), "imol", l_imol )
!!$         do iras = 1, nras
!!$            if( imol( iras ) .ne. l_imol( iras ) ) then
!!$               write( 6, * ) 'molecular number is not identical.'
!!$               write( 6, * ) iras, imol( iras ), l_imol( iras )
!!$               stop
!!$            end if
!!$         end do
!!$
!!$         call ni3_get_var( ncid( incf ), "t", l_t )
!!$         do k = 1+1, km
!!$            if( l_t( k ) .ne. l_t( 1 ) ) then
!!$               write( 6, * ) 'temperature is not isothermal.'
!!$               write( 6, * ) k, l_t( k ), l_t( 1 )
!!$               stop
!!$            end if
!!$         end do
!!$         temp( incf ) = l_t( 1 )
!!$         if( incf .ge. 2 ) then
!!$            if( temp( incf ) .le. temp( incf-1 ) ) then
!!$               write( 6, * ) 'Order of files is inappropriate.'
!!$               write( 6, * ) incf, temp( incf-1 ), temp( incf )
!!$               stop
!!$            end if
!!$         end if
!!$
!!$      end do
!!$
!!$      deallocate( l_wn, l_plev, l_t )
!!$
!!$
!!$      allocate( ckdp( nband ) )
!!$
!!$
!!$      iras = 1
!!$
!!$
!!$      do iband = 1, nband
!!$
!!$         ckdp( iband ) % imol        = imol( iras )
!!$
!!$         ckdp( iband ) % wnbnds( 1 ) = wnbnds_s( iband )
!!$         ckdp( iband ) % wnbnds( 2 ) = wnbnds_e( iband )
!!$
!!$
!!$         ckdp( iband ) % ng   = ngdiv( iband )
!!$         ckdp( iband ) % nlnp = km
!!$         ckdp( iband ) % nt   = tm
!!$
!!$         allocate( &
!!$              ckdp( iband ) % weight( ckdp( iband ) % ng   ), &
!!$              ckdp( iband ) % g     ( ckdp( iband ) % ng   ), &
!!$              ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
!!$              ckdp( iband ) % t     ( ckdp( iband ) % nt   )  &
!!$              )
!!$
!!$         allocate( &
!!$              ckdp( iband ) % g_ll  ( ckdp( iband ) % ng   ), &
!!$              ckdp( iband ) % g_ul  ( ckdp( iband ) % ng   )  &
!!$              )
!!$
!!$         allocate( &
!!$              ckdp( iband ) % lnac( ckdp(iband)%ng  ,  &
!!$                                    ckdp(iband)%nlnp,  &
!!$                                    ckdp(iband)%nt   ) &
!!$              )
!!$         allocate( &
!!$              ckdp( iband ) % pfr ( ckdp(iband)%ng  ,  &
!!$                                    ckdp(iband)%nlnp,  &
!!$                                    ckdp(iband)%nt   ) &
!!$              )
!!$
!!$
!!$         ckdp( iband ) % lnp( : ) = log( plev( : ) )
!!$         ckdp( iband ) % t  ( : ) = temp( : )
!!$
!!$      end do
!!$
!!$
!!$      deallocate( wnbnds_s, wnbnds_e, ngdiv )
!!$
!!$
!!$    end subroutine ckd_mktbl_init
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_mktbl_end
!!$
!!$      use ni3_module
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      integer(i4b) :: incf, iband
!!$
!!$
!!$      do incf = 1, nncfile
!!$         call ni3_close( ncid( incf ) )
!!$      end do
!!$
!!$
!!$      deallocate( ncfn, ncid )
!!$      deallocate( temp )
!!$      deallocate( wn, plev, imol )
!!$
!!$
!!$      call ckd_deallocate_type
!!$
!!$
!!$    end subroutine ckd_mktbl_end
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_deallocate_type
!!$
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      integer(i4b) :: iband
!!$
!!$
!!$      do iband = 1, nband
!!$         deallocate( ckdp( iband ) % weight, &
!!$                     ckdp( iband ) % g     , &
!!$                     ckdp( iband ) % lnp   , &
!!$                     ckdp( iband ) % t     )
!!$         deallocate( ckdp( iband ) % lnac )
!!$         deallocate( ckdp( iband ) % pfr  )
!!$      end do
!!$
!!$      deallocate( ckdp )
!!$
!!$
!!$      nband = -1
!!$
!!$
!!$    end subroutine ckd_deallocate_type
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_mktbl
!!$
!!$      use ni3_module
!!$      use pf_module
!!$      use sort_module
!!$
!!$
!!$      !
!!$      ! local varialbles
!!$      !
!!$
!!$      real(dp)             , allocatable :: ac_1d( : ), pf_1d( : )
!!$
!!$      real(dp)                           :: wns, wne
!!$
!!$      real(dp)             , allocatable :: ac_i( : )
!!$      real(dp)             , allocatable :: pfrat( : )
!!$
!!$
!!$      integer(i4b)                       :: k, incf, iband, iras, ig
!!$      integer(i4b)                       :: iwn
!!$      integer(i4b)                       :: iwns, iwne
!!$
!!$
!!$
!!$      iras = 1
!!$
!!$      do iband = 1, nband
!!$         wns = ckdp( iband ) % wnbnds( 1 )
!!$         wne = ckdp( iband ) % wnbnds( 2 )
!!$
!!$
!!$         call search_wnindices( nwn, wn, wns, wne, iwns, iwne )
!!$         write( 6, *             ) &
!!$              'band ', iband, ' : wns = ', wns, ', wne = ', wne
!!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwns, ') = ', wn( iwns )
!!$         write( 6, '(a,i10,a,f)' ) '  wn( ', iwne, ') = ', wn( iwne )
!!$
!!$
!!$         allocate( ac_1d( iwne - iwns + 1 ) )
!!$         allocate( pf_1d( iwne - iwns + 1 ) )
!!$         allocate( ac_i ( ckdp( iband ) % ng ) )
!!$         allocate( pfrat( ckdp( iband ) % ng ) )
!!$
!!$
!!$
!!$
!!$!         do ig = 1, ckdp( iband ) % ng
!!$!#if defined CONST_WEIGHT || defined THROUGH
!!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
!!$!                 * ( dble( ig - 1 ) + 0.5d0 )
!!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
!!$!#else
!!$!            call gauleg( 0.0d0, 1.0d0, &
!!$!                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
!!$!#endif
!!$!         end do
!!$
!!$         call set_g( iband, iwns, iwne, iras )
!!$
!!$
!!$
!!$
!!$         do incf = 1, nncfile
!!$
!!$            do k = 1, km
!!$
!!$               call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
!!$
!!$               do iwn = 1, iwne-iwns+1
!!$                  pf_1d( iwn ) = pf( wn( iwn+iwns-1 ), temp( incf ) )
!!$               end do
!!$
!!$
!!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
!!$!               do iwn = 1, iwne-iwns+1
!!$!                  write( 60, * ) wn( iwns-1+iwn ) * 1.0d-2, &
!!$!                       ac_1d( iwn ), pf_1d( iwn )
!!$!               end do
!!$!            end if
!!$
!!$
!!$#ifdef THROUGH
!!$#ifdef THROUGH_SORT
!!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
!!$#endif
!!$#else
!!$               call sort_quick( iwne-iwns+1, ac_1d, pf_1d )
!!$#endif
!!$
!!$
!!$!            if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
!!$!               do iwn = 1, iwne-iwns+1
!!$!                  write( 61, * ) dble( iwn-1+0.5d0 ) / ( iwne-iwns+1 ), &
!!$!                       ac_1d( iwn ), pf_1d( iwn )
!!$!               end do
!!$!            end if
!!$
!!$
!!$#ifdef THROUGH
!!$
!!$               if( ckdp( iband ) % ng .ne. iwne-iwns+1 ) then
!!$                  write( 6, * ) 'ng is equal to iwne-iwns+1.'
!!$                  write( 6, * ) ckdp( iband ) % ng, iwne-iwns+1
!!$                  stop
!!$               end if
!!$               do ig = 1, ckdp( iband ) % ng
!!$                  iwn = ig
!!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_1d( iwn )
!!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pf_1d( iwn ) &
!!$                       / pfint( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
!!$                                5, ckdp(iband)%t(incf) ) &
!!$                       * ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
!!$               end do
!!$
!!$#else
!!$
!!$               call calcpfratio( iwne-iwns+1, pf_1d, &
!!$                    ckdp( iband ) % ng, ckdp( iband ) % weight, pfrat )
!!$
!!$
!!$               do ig = 1, ckdp( iband ) % ng
!!$                  iwn = ckdp( iband ) % g( ig ) * ( iwne-iwns+1 )
!!$                  iwn = max( iwn, 1 )
!!$
!!$                  if( ( iwn .le. 0 ) .or. ( iwn .ge. iwne-iwns+1 ) )then
!!$                     write( 6, * ) 'iwn is inappropriate.'
!!$                     write( 6, * ) iwn, iwne-iwns+1
!!$                     stop
!!$                  else
!!$                     if(  ( ac_1d( iwn   ) .ne. 0.0d0 ) .and. &
!!$                          ( ac_1d( iwn+1 ) .ne. 0.0d0 ) ) then
!!$                        ac_i( ig ) = log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
!!$                             / ( 1.0d0 / dble( iwne-iwns+1 ) ) &
!!$                             * ( ckdp( iband ) % g( ig ) &
!!$                               - dble( iwn-1+0.5d0 ) / dble( iwne-iwns+1 ) ) &
!!$                             + log( ac_1d( iwn ) )
!!$                        ac_i( ig ) = exp( ac_i( ig ) )
!!$                     else
!!$                        ac_i( ig ) = 0.0d0
!!$                     end if
!!$                  end if
!!$
!!$
!!$                  ckdp( iband ) % lnac( ig, k, incf ) = ac_i ( ig )
!!$                  ckdp( iband ) % pfr ( ig, k, incf ) = pfrat( ig )
!!$
!!$!               if( ( incf .eq. 1 ) .and. ( k .eq. km ) ) then
!!$!                  write( 62, * ) actbl_g( ig ), ac_i( ig ), pfrat( ig )
!!$!               end if
!!$
!!$               end do
!!$
!!$#endif
!!$
!!$
!!$            end do
!!$
!!$         end do
!!$
!!$         deallocate( ac_1d )
!!$         deallocate( pf_1d )
!!$         deallocate( ac_i  )
!!$         deallocate( pfrat )
!!$
!!$         do incf = 1, nncfile
!!$            do k = 1, km
!!$               do ig = 1, ckdp( iband ) % ng
!!$                  if( ckdp( iband ) % lnac( ig, k, incf ) .gt. 0.0d0 ) then
!!$                     ckdp( iband ) % lnac( ig, k, incf ) &
!!$                          = log( ckdp( iband ) % lnac( ig, k, incf ) )
!!$                  else
!!$                     ckdp( iband ) % lnac( ig, k, incf ) = 0.0d0
!!$                  end if
!!$               end do
!!$            end do
!!$         end do
!!$
!!$      end do
!!$
!!$      !************************************************************************
!!$
!!$    contains
!!$
!!$      !************************************************************************
!!$
!!$      subroutine set_g( iband, iwns, iwne, iras )
!!$
!!$
!!$        integer(i4b), intent(in ) :: iband, iwns, iwne, iras
!!$
!!$
!!$
!!$        !
!!$        ! local variables
!!$        !
!!$        real(dp)     :: ac_1d( iwne-iwns+1 ), ac_min, ac_max, lnac_ul, ac_ul
!!$#ifdef G_RRTM
!!$        real(dp)     :: rrtm_ul( 16 )
!!$        data rrtm_ul &
!!$             /0.15275d0, 0.30192d0, 0.44402d0, 0.57571d0, 0.69390d0, &
!!$              0.79583d0, 0.87911d0, 0.94178d0, 0.98427d0, 0.98890d0, &
!!$              0.99273d0, 0.99576d0, 0.99798d0, 0.99939d0, 0.99993d0, &
!!$              1.00000d0/
!!$#endif
!!$
!!$        integer(i4b) :: k, ig, incf
!!$
!!$
!!$
!!$#if defined CONST_WEIGHT || defined THROUGH
!!$
!!$!         do ig = 1, ckdp( iband ) % ng
!!$!            ckdp( iband ) % g     ( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
!!$!                 * ( dble( ig - 1 ) + 0.5d0 )
!!$!            ckdp( iband ) % weight( ig ) = 1.0d0 / dble( ckdp( iband ) % ng )
!!$!         end do
!!$
!!$         do ig = 1, ckdp( iband ) % ng - 1
!!$            ckdp( iband ) % g_ul( ig ) = 1.0d0 / dble( ckdp( iband ) % ng ) &
!!$                 * dble( ig )
!!$         end do
!!$         ig = ckdp( iband ) % ng
!!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
!!$         ig = 1
!!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
!!$         do ig = 1+1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
!!$         end do
!!$         do ig = 1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g     ( ig ) &
!!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
!!$                 * 0.5d0
!!$            ckdp( iband ) % weight( ig ) &
!!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
!!$         end do
!!$
!!$#else
!!$#ifdef G_CONST_LNAC
!!$
!!$         incf = 1
!!$         k    = 1
!!$         write( 6, * ) 'Temperature in reference layer : ', temp( incf )
!!$         write( 6, * ) 'Pressure    in reference layer : ', &
!!$              exp( ckdp( iband ) % lnp( k ) )
!!$
!!$         call readac( ncid( incf ), iwne-iwns+1, ac_1d, iras, k, iwns, iwne )
!!$
!!$         call sort_quick( iwne-iwns+1, ac_1d )
!!$
!!$         do iwn = 1, iwne-iwns+1
!!$            if( ac_1d( iwn ) .ne. 0.0d0 ) exit
!!$         end do
!!$
!!$         ac_min = ac_1d( iwn         )
!!$         ac_max = ac_1d( iwne-iwns+1 )
!!$         do ig = 1, ckdp( iband ) % ng - 1
!!$            lnac_ul = log( ac_max / ac_min ) / ckdp( iband ) % ng * ig &
!!$                 + log( ac_min )
!!$            ac_ul = exp( lnac_ul )
!!$            do iwn = 1+1, iwne-iwns+1
!!$               if( ac_1d( iwn ) .gt. ac_ul ) exit
!!$            end do
!!$            iwn = iwn - 1
!!$
!!$!            iwn = min( iwn, iwne-iwns+1 - ( ckdp( iband ) % ng - ig ) )
!!$!            ckdp( iband ) % g_ul( ig ) = dble( iwn ) / dble( iwne-iwns+1 )
!!$
!!$            iwn = min( iwn, iwne-iwns+1-1 )
!!$            ckdp( iband ) % g_ul( ig )                  &
!!$                 = 1.0d0 / dble( iwne-iwns+1 )          &
!!$                 / log( ac_1d( iwn+1 ) / ac_1d( iwn ) ) &
!!$                 * ( lnac_ul - log( ac_1d( iwn ) ) )    &
!!$                 + dble( iwn ) / dble( iwne-iwns+1 )
!!$         end do
!!$         ig = ckdp( iband ) % ng
!!$         ckdp( iband ) % g_ul( ig ) = 1.0d0
!!$         ig = 1
!!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
!!$         do ig = 1+1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
!!$         end do
!!$         do ig = 1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g     ( ig ) &
!!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
!!$                 * 0.5d0
!!$            ckdp( iband ) % weight( ig ) &
!!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
!!$         end do
!!$
!!$
!!$#else
!!$#ifdef G_RRTM
!!$
!!$         if( ckdp( iband ) % ng .ne. 16 ) then
!!$            write( 6, * ) 'ng is not equal to 16'
!!$            write( 6, * ) iband, ckdp( iband ) % ng
!!$            stop
!!$         end if
!!$
!!$         do ig = 1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ul( ig ) = rrtm_ul( ig )
!!$         end do
!!$         ig = 1
!!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
!!$         do ig = 1+1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
!!$         end do
!!$         do ig = 1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g     ( ig ) &
!!$                 = ( ckdp( iband ) % g_ll( ig ) + ckdp( iband ) % g_ul( ig ) )&
!!$                 * 0.5d0
!!$            ckdp( iband ) % weight( ig ) &
!!$                 = ( ckdp( iband ) % g_ul( ig ) - ckdp( iband ) % g_ll( ig ) )
!!$         end do
!!$
!!$#else
!!$         do ig = 1, ckdp( iband ) % ng
!!$            call gauleg( 0.0d0, 1.0d0, &
!!$                 ckdp(iband)%ng, ckdp(iband)%g, ckdp(iband)%weight )
!!$         end do
!!$
!!$         ig = 1
!!$         ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % weight( ig )
!!$         do ig = 1+1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ul( ig ) = ckdp( iband ) % g_ul( ig-1 ) &
!!$                 + ckdp( iband ) % weight( ig )
!!$         end do
!!$         ig = 1
!!$         ckdp( iband ) % g_ll( ig ) = 0.0d0
!!$         do ig = 1+1, ckdp( iband ) % ng
!!$            ckdp( iband ) % g_ll( ig ) = ckdp( iband ) % g_ul( ig-1 )
!!$         end do
!!$
!!$#endif     !#ifdef G_RRTM
!!$#endif     !#ifdef G_CONST_LNAC
!!$#endif     !#if defined CONST_WEIGHT || defined THROUGH
!!$
!!$
!!$         !
!!$         ! check
!!$         !
!!$         do ig = 1, ckdp( iband ) % ng
!!$            if( ckdp( iband ) % weight( ig ) .eq. 0.0d0 ) then
!!$               write( 6, * ) 'weight is zero'
!!$               write( 6, * ) iband, ig, ckdp( iband ) % weight( ig )
!!$               stop
!!$            end if
!!$         end do
!!$
!!$
!!$!         do ig = 1, ckdp( iband ) % ng
!!$!            write( 21, * ) ig, &
!!$!                 ckdp( iband ) % g_ll( ig ), ckdp( iband ) % g_ul( ig ), &
!!$!                 ckdp( iband ) % g   ( ig ), ckdp( iband ) % weight( ig )
!!$!         end do
!!$!         stop
!!$
!!$
!!$       end subroutine set_g
!!$
!!$      !************************************************************************
!!$
!!$      subroutine search_wnindices( nwn, wn, wns, wne, iwns, iwne )
!!$
!!$        integer(i4b), intent(in ) :: nwn
!!$        real(dp)    , intent(in ) :: wn( nwn ), wns, wne
!!$        integer(i4b), intent(out) :: iwns, iwne
!!$
!!$
!!$        !
!!$        ! local variables
!!$        !
!!$        integer(i4b) :: iwn
!!$
!!$
!!$        iwns = 0
!!$        iwne = 1
!!$        do iwn = 1, nwn
!!$           if( wn( iwn ) .lt. wns ) iwns = iwn
!!$           if( wn( iwn ) .le. wne ) iwne = iwn
!!$        end do
!!$        iwns = iwns + 1
!!$
!!$
!!$        if( iwns .gt. iwne ) then
!!$           write( 6, * ) 'iwns is greater than iwne.'
!!$           write( 6, * ) iwns, wn( iwns )
!!$           write( 6, * ) iwne, wn( iwne )
!!$           stop
!!$        end if
!!$
!!$
!!$      end subroutine search_wnindices
!!$
!!$      !************************************************************************
!!$
!!$      subroutine readac( ncid, nwn, ac_1d, iras, k, iwns, iwne )
!!$
!!$        use netcdf
!!$
!!$        integer(i4b), intent(in ) :: ncid, nwn
!!$        real(dp)    , intent(out) :: ac_1d( nwn )
!!$        integer(i4b), intent(in ) :: iras, k, iwns, iwne
!!$
!!$
!!$        !
!!$        ! local variables
!!$        !
!!$        real(dp)              :: l_ac( nwn, 1, 1 )
!!$        integer(i4b)          :: varid
!!$        integer(i4b)          :: istatus
!!$        character(len=extstr) :: err_mes = "in readac"
!!$        integer(i4b)          :: st( 3 ), co( 3 )
!!$
!!$
!!$        call ni3_inq_var( ncid, "ac", varid )
!!$        call ni3_enddef( ncid )
!!$
!!$
!!$        st( 1 ) = iwns
!!$        st( 2 ) = k
!!$        st( 3 ) = iras
!!$        co( 1 ) = iwne - iwns + 1
!!$        co( 2 ) = 1
!!$        co( 3 ) = 1
!!$        istatus = nf90_get_var( ncid, varid, l_ac, start = st, count = co )
!!$        call ni3_handle_err( istatus, err_mes )
!!$
!!$
!!$        ac_1d( : ) = l_ac( :, 1, 1 )
!!$
!!$
!!$      end subroutine readac
!!$
!!$      !************************************************************************
!!$
!!$      subroutine calcpfratio( nwn, pf_1d, ncp, weight, pfrat )
!!$
!!$        integer(i4b), intent(in ) :: nwn
!!$        real(dp)    , intent(in ) :: pf_1d( nwn )
!!$        integer(i4b), intent(in ) :: ncp
!!$        real(dp)    , intent(in ) :: weight( ncp )
!!$        real(dp)    , intent(out) :: pfrat( ncp )
!!$
!!$
!!$        !
!!$        ! local variables
!!$        !
!!$        real(dp)     :: weight_sum, weight_sum_p, x1, x2, dg, pf_sum
!!$        integer(i4b) :: n, iwn, iwns, iwne, iwn1, iwn2
!!$
!!$
!!$        weight_sum_p  = 0.0d0
!!$        weight_sum    = 0.0d0
!!$        pfrat( : ) = 0.0d0
!!$        iwne       = 1-1
!!$        do n = 1, ncp
!!$           weight_sum = weight_sum + weight( n )
!!$           if( n .eq. ncp ) weight_sum = 1.0d0
!!$           if( weight_sum .gt. 1.0d0 ) then
!!$              write( 6, * ) 'weight_sum is greater than 1.'
!!$              write( 6, * ) weight_sum
!!$              stop
!!$           end if
!!$
!!$           iwns = iwne + 1
!!$           iwne = weight_sum * dble( nwn )
!!$           iwn1 = max( iwns-1, 1   )
!!$           iwn2 = min( iwne+1, nwn )
!!$           do iwn = iwn1, iwn2
!!$              x1 = max( dble( iwn-1 ) / dble( nwn ), weight_sum_p )
!!$              x2 = min( dble( iwn   ) / dble( nwn ), weight_sum   )
!!$              dg = max( x2 - x1, 0.0d0 )
!!$              pfrat( n ) = pfrat( n ) + pf_1d( iwn ) * dg
!!$           end do
!!$           weight_sum_p = weight_sum
!!$        end do
!!$
!!$        pf_sum = 0.0d0
!!$        do n = 1, ncp
!!$           pf_sum = pf_sum + pfrat( n )
!!$        end do
!!$
!!$        pfrat( : ) = pfrat( : ) / pf_sum / weight( : )
!!$
!!$
!!$      end subroutine calcpfratio
!!$
!!$      !************************************************************************
!!$
!!$    end subroutine ckd_mktbl
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_output
!!$
!!$      use fi_module
!!$      use ni3_module
!!$      use netcdf
!!$
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      integer(i4b)                       :: ctlfu
!!$      character(len=extstr)              :: ncfn_out
!!$      integer(i4b)                       :: ncid_out
!!$      character(len=extstr)              :: comment
!!$      integer(i4b)                       :: ndims
!!$      character(len=extstr), allocatable :: dimnames( : )
!!$      character(len=extstr)              :: name_bnds, name_weight, &
!!$           name_g, name_lnac, name_pfr
!!$
!!$      integer(i4b)                       :: istatus
!!$      integer(i4b)                       :: iband
!!$
!!$
!!$      namelist /output_nc/ ncfn_out, comment
!!$
!!$
!!$      call fi_open( ctlfn, "read", ctlfu )
!!$      ncfn_out = "out.nc"
!!$      comment  = "comment"
!!$      read( ctlfu, output_nc )
!!$      close( ctlfu )
!!$
!!$
!!$      call ni3_open( ncfn_out, "new", ncid_out )
!!$
!!$      comment = "comment"
!!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "comment", comment )
!!$      call ni3_handle_err( istatus )
!!$
!!$      istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "nband", nband )
!!$      call ni3_handle_err( istatus )
!!$
!!$      call ni3_set_dim( ncid_out, "lnp" , NF90_DOUBLE, ckdp( 1 ) % lnp )
!!$      call ni3_set_dim( ncid_out, "t"   , NF90_DOUBLE, ckdp( 1 ) % t   )
!!$
!!$      call ni3_def_dim( ncid_out, "bnds", NF90_DOUBLE, 2 )
!!$
!!$      do iband = 1, nband
!!$         istatus = nf90_put_att( ncid_out, NF90_GLOBAL, "imol", ckdp(iband)%imol )
!!$         call ni3_handle_err( istatus )
!!$
!!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
!!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
!!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
!!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
!!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
!!$
!!$         call ni3_set_dim( ncid_out, name_g, NF90_DOUBLE, ckdp(iband)%g   )
!!$
!!$         ndims = 1
!!$         allocate( dimnames( ndims ) )
!!$         dimnames( 1 ) = name_g
!!$         call ni3_def_var( ncid_out, name_weight, NF90_DOUBLE, ndims, dimnames )
!!$         deallocate( dimnames )
!!$
!!$         ndims = 1
!!$         allocate( dimnames( ndims ) )
!!$         dimnames( 1 ) = "bnds"
!!$         call ni3_def_var( ncid_out, name_bnds, NF90_DOUBLE, ndims, dimnames )
!!$         deallocate( dimnames )
!!$
!!$         ndims = 3
!!$         allocate( dimnames( ndims ) )
!!$         dimnames( 1 ) = name_g
!!$         dimnames( 2 ) = "lnp"
!!$         dimnames( 3 ) = "t"
!!$         call ni3_def_var( ncid_out, name_lnac, NF90_DOUBLE, ndims, dimnames )
!!$         call ni3_def_var( ncid_out, name_pfr , NF90_DOUBLE, ndims, dimnames )
!!$         deallocate( dimnames )
!!$
!!$         call ni3_put_var( ncid_out, name_weight, ckdp(iband)%weight )
!!$
!!$         call ni3_put_var( ncid_out, name_bnds  , ckdp(iband)%wnbnds )
!!$
!!$         call ni3_put_var( ncid_out, name_lnac  , ckdp(iband)%lnac   )
!!$         call ni3_put_var( ncid_out, name_pfr   , ckdp(iband)%pfr    )
!!$      end do
!!$
!!$      call ni3_close( ncid_out )
!!$
!!$
!!$    end subroutine ckd_output
!!$
!!$    !**************************************************************************
!!$
!!$#endif
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_output_ascii
!!$
!!$      use fi_module
!!$
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$      integer(i4b)                       :: ctlfu
!!$      character(len=extstr)              :: fn_out
!!$      integer(i4b)                       :: fu_out
!!$      character(len=extstr)              :: comment
!!$      character(len=extstr)              :: name_bnds, name_weight, &
!!$           name_g, name_lnac, name_pfr
!!$
!!$      integer(i4b)                       :: iband
!!$
!!$      namelist /output_ascii/ fn_out, comment
!!$
!!$
!!$      call fi_open( ctlfn, "read", ctlfu )
!!$      fn_out  = "out.txt"
!!$      comment = "comment"
!!$      read( ctlfu, output_ascii )
!!$      close( ctlfu )
!!$
!!$
!!$      call fi_open( fn_out, "write", fu_out )
!!$
!!$      write( fu_out, * ) comment
!!$      write( 6, * ) 'Comment         : ', trim( comment )
!!$
!!$      write( fu_out, * ) nband
!!$      write( 6, * ) 'Number of bands : ', nband
!!$
!!$      write( fu_out, * ) ckdp( 1 ) % nlnp
!!$      write( fu_out, * ) ckdp( 1 ) % lnp
!!$
!!$      write( fu_out, * ) ckdp( 1 ) % nt
!!$      write( fu_out, * ) ckdp( 1 ) % t
!!$
!!$      do iband = 1, nband
!!$         write( fu_out, * ) ckdp( iband ) % imol
!!$
!!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
!!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
!!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
!!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
!!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
!!$
!!$         write( fu_out, * ) trim( name_g      )
!!$         write( fu_out, * ) ckdp( iband ) % ng
!!$         write( fu_out, * ) ckdp( iband ) % g
!!$
!!$         write( fu_out, * ) trim( name_weight )
!!$         write( fu_out, * ) ckdp( iband ) % weight
!!$
!!$         write( fu_out, * ) trim( name_bnds   )
!!$         write( fu_out, * ) ckdp( iband ) % wnbnds
!!$
!!$         write( fu_out, * ) trim( name_lnac   )
!!$         write( fu_out, * ) ckdp( iband ) % lnac
!!$
!!$         write( fu_out, * ) trim( name_pfr    )
!!$         write( fu_out, * ) ckdp( iband ) % pfr
!!$      end do
!!$
!!$      close( fu_out )
!!$
!!$
!!$    end subroutine ckd_output_ascii
!!$
!!$    !**************************************************************************
!!$
!!$    subroutine ckd_input_ascii( fn_in )
!!$
!!$      use fi_module
!!$
!!$      character(len=*), intent(in) :: fn_in
!!$
!!$      !
!!$      ! local variables
!!$      !
!!$!      integer(i4b)              :: ctlfu
!!$
!!$!      character(len=extstr)              :: fn_in
!!$      integer(i4b)                       :: fu_in
!!$      character(len=extstr)              :: comment
!!$
!!$      character(len=extstr)              :: name_bnds, name_weight, &
!!$           name_g, name_lnac, name_pfr
!!$
!!$      character(len=extstr)              :: line
!!$      integer(i4b)                       :: iband, ig
!!$
!!$!      namelist /input_ascii/ fn_in
!!$!
!!$!
!!$!      call fi_open( ctlfn, "read", ctlfu )
!!$!      fn_in = "out.txt"
!!$!      read( ctlfu, input_ascii )
!!$!      close( ctlfu )
!!$
!!$
!!$      call fi_open( fn_in, "read", fu_in )
!!$
!!$      read( fu_in, * ) comment
!!$      write( 6, * ) 'Comment         : ', trim( comment )
!!$
!!$      read( fu_in, * ) nband
!!$      write( 6, * ) 'Number of bands : ', nband
!!$
!!$      allocate( ckdp( nband ) )
!!$
!!$      read( fu_in, * ) ckdp( 1 ) % nlnp
!!$      allocate( ckdp( 1 ) % lnp   ( ckdp( 1 ) % nlnp ) )
!!$      read( fu_in, * ) ckdp( 1 ) % lnp
!!$
!!$      read( fu_in, * ) ckdp( 1 ) % nt
!!$      allocate( ckdp( 1 ) % t     ( ckdp( 1 ) % nt   ) )
!!$      read( fu_in, * ) ckdp( 1 ) % t
!!$
!!$      do iband = 1+1, nband
!!$         ckdp( iband ) % nlnp = ckdp( 1 ) % nlnp
!!$         ckdp( iband ) % nt   = ckdp( 1 ) % nt
!!$         allocate( ckdp( iband ) % lnp   ( ckdp( iband ) % nlnp ), &
!!$                   ckdp( iband ) % t     ( ckdp( iband ) % nt   )  )
!!$         ckdp( iband ) % lnp( : ) = ckdp( 1 ) % lnp( : )
!!$         ckdp( iband ) % t  ( : ) = ckdp( 1 ) % t  ( : )
!!$      end do
!!$
!!$      do iband = 1, nband
!!$         write( 6, * ) 'band ', iband 
!!$
!!$         read( fu_in, * ) ckdp( iband ) % imol
!!$
!!$         write( name_bnds  , '(a,i4.4)' ) "wnbnds_", iband
!!$         write( name_g     , '(a,i4.4)' ) "g_"     , iband
!!$         write( name_weight, '(a,i4.4)' ) "weight_", iband
!!$         write( name_lnac  , '(a,i4.4)' ) "lnac_"  , iband
!!$         write( name_pfr   , '(a,i4.4)' ) "pfr_"   , iband
!!$
!!$
!!$         read( fu_in, * ) line
!!$         if( name_g      .ne. line ) then
!!$            write( 6, * ) 'Input file is invalid.'
!!$            write( 6, * ) trim( name_g )
!!$            write( 6, * ) trim( line   )
!!$            stop
!!$         end if
!!$         read( fu_in, * ) ckdp( iband ) % ng
!!$         allocate( ckdp( iband ) % g     ( ckdp( iband ) % ng   )  )
!!$         read( fu_in, * ) ckdp( iband ) % g
!!$
!!$         allocate( ckdp( iband ) % weight( ckdp( iband ) % ng   ) )
!!$
!!$         allocate( &
!!$              ckdp( iband ) % lnac( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
!!$              )
!!$         allocate( &
!!$              ckdp( iband ) % pfr ( ckdp(iband)%ng, ckdp(iband)%nlnp, ckdp(iband)%nt ) &
!!$              )
!!$
!!$         read( fu_in, * ) line
!!$         if( name_weight .ne. line ) then
!!$            write( 6, * ) 'Input file is invalid.'
!!$            write( 6, * ) trim( name_weight )
!!$            write( 6, * ) trim( line        )
!!$            stop
!!$         end if
!!$         read( fu_in, * ) ckdp( iband ) % weight
!!$
!!$         read( fu_in, * ) line
!!$         if( name_bnds   .ne. line ) then
!!$            write( 6, * ) 'Input file is invalid.'
!!$            write( 6, * ) trim( name_bnds   )
!!$            write( 6, * ) trim( line        )
!!$            stop
!!$         end if
!!$         read( fu_in, * ) ckdp( iband ) % wnbnds
!!$
!!$         read( fu_in, * ) line
!!$         if( name_lnac   .ne. line ) then
!!$            write( 6, * ) 'Input file is invalid.'
!!$            write( 6, * ) trim( name_lnac   )
!!$            write( 6, * ) trim( line        )
!!$            stop
!!$         end if
!!$         read( fu_in, * ) ckdp( iband ) % lnac
!!$
!!$         read( fu_in, * ) line
!!$         if( name_pfr    .ne. line ) then
!!$            write( 6, * ) 'Input file is invalid.'
!!$            write( 6, * ) trim( name_pfr    )
!!$            write( 6, * ) trim( line        )
!!$            stop
!!$         end if
!!$         read( fu_in, * ) ckdp( iband ) % pfr
!!$
!!$
!!$         write( 6, * ) 'band ', iband 
!!$         write( 6, * ) '  wns  = ', ckdp(iband)%wnbnds(1)
!!$         write( 6, * ) '  wne  = ', ckdp(iband)%wnbnds(2)
!!$         write( 6, * ) '  ng   = ', ckdp(iband)%ng
!!$         do ig = 1, ckdp(iband)%ng
!!$            write( 6, * ) '     g(', ig, ') = ', ckdp(iband)%g(ig)
!!$         end do
!!$         write( 6, * ) '  nlnp = ', ckdp(iband)%nlnp
!!$         write( 6, * ) '  nt   = ', ckdp(iband)%nt
!!$
!!$      end do
!!$
!!$      close( fu_in )
!!$
!!$
!!$    end subroutine ckd_input_ascii
!!$
!!$    !**************************************************************************
!!$
!!$#endif

  end module ckd_module
