!= ľե륿 (Ishiwatari et al., 2002)
!
!= Vertical filter (Ishiwatari et al., 2002)
!
! Authors::   Satoshi Noda
! Version::   $Id: vertical_filter_wt_VFonlyT.f90,v 1.1 2010-05-07 09:58:22 noda Exp $ 
! Tag Name::  $Name: dcpam5-20140204-5 $
! Copyright:: Copyright (C) GFD Dennou Club, 2010. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module vertical_filter
  !
  != ľե륿 (Ishiwatari et al., 2002)
  !
  != Vertical filter (Ishiwatari et al., 2002)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ľ⡼ɤޤ뤿αľե륿 (Ishiwatari et al., 2002)
  ! ŬѤ뤿Υ⥸塼Ǥ.
  !
  ! ʤ
  ! \begin{align}
  !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2} \\
  ! \end{align}
  ! , 
  ! \begin{align}
  !   \bar{T}_{k-1} &= T_{k-1} + F_T
  !     ( T_{B, k-1} - T_{k-1} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
  !   \bar{T}_{k} &= T_{k} + F_T
  !     ( T_{B, k} - T_{k} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
  !   \bar{T}_{k+1} &= T_{k+1} + F_T
  !     ( T_{B, k+1} - T_{k+1} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
  ! \end{align}
  ! Ȥ򲼤ؤŬѤ뤳Ȥ $ \bar{T} $ ޤ. 
  ! ź $ k $ ؤֹǤ.
  ! ľե륿ŬѤ줿ˤϾ ( $ \bar{\quad} $ )
  ! դƤޤ.
  !
  ! ľե륿η $F_T$  Create κݤꤷޤ.
  !
  !++
  !
  ! Vertical filter (Ishiwatari et al., 2002) for suppression of vertical mode 
  ! is applied.
  !
  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
  ! Reference Temperature is defined as
  ! \begin{align}
  !   T_{B,k} &\equiv \frac{T_{k+1/2} + T_{k-1/2}}{2}.
  ! \end{align}
  ! Operations as follows are applied from lower layer to higher layer.
  ! \begin{align}
  !   \bar{T}_{k-1} &= T_{k-1} + F_T
  !     ( T_{B, k-1} - T_{k-1} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
  !   \bar{T}_{k} &= T_{k} + F_T
  !     ( T_{B, k} - T_{k} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}, \\
  !   \bar{T}_{k+1} &= T_{k+1} + F_T
  !     ( T_{B, k+1} - T_{k+1} )
  !     - \frac{ \Sigma_{k'=k-1}^{k+1} F_T (T_{B,k'} - T_{k'}) \delta p_{k'} }{\Sigma_{k'=k-1}^{k+1}  \delta p_{k'}}
  ! \end{align}
  ! where a suffix $ k $ is the number of layer.
  ! Over-bar ( $ \bar{\quad} $ ) represents the terms
  ! applied vertical filter.
  !
  ! Vertical filter coefficient $ F_T $ is specified by "Create".
  !
  !== Procedures List
  ! 
  ! VerticalFilter    :: ľե륿Ŭ
  ! ----------------  :: ---------------------
  ! VerticalFilter    :: Apply vertical filter
  !
  !== NAMELIST
  !
  ! NAMELIST#vertical_filter_nml
  !
  !== References
  !
  ! * Ishiwatari, M., Takehiro S., Nakajima, K. and Hayashi, Y. -Y. 2002: 
  !   A Numerical Study on Appearance of the Runaway Greenhouse State of a
  !   Three-Dimensional Gray Atmosphere.
  !   <i>J. Atmos. Sci.</i>, <b>59</b>, 3223--3238.
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  use composition, only: ncmax  ! ʬο
                                ! Number of composition

  use timeset, only: DelTime

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: VerticalFilter

  ! ѿ
  ! Public variables
  !
  logical, save, public:: vertical_filter_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: FilterParameter
                              ! ľե륿η. 
                              ! Vertical filter coefficient
!!$  integer, save:: IntStep     ! ľե륿ŬѤ륹ƥå״ֳ. 
!!$                              ! Step interval of vertical filter application
!!$  integer, save:: CurStep     ! VerticalFilter ƤФ줿. 
!!$                              ! Number of times that "VerticalFilter" is called
!!$  integer, save:: PrevStep    ! ľե륿ŬѤƥå׿. 
!!$                              ! Step number that is filtered previously


  character(*), parameter:: module_name = 'vertical_filter'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140204-5 $' // &
    & '$Id: vertical_filter_wt_VFonlyT.f90,v 1.1 2010-05-07 09:58:22 noda Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface VerticalFilter
    module procedure VerticalFilter
  end interface

contains

  subroutine VerticalFilter( &
    & xyz_UA, xyz_VA, xyz_TempA, &
    & xyr_Press, xyr_Temp &
    & )
    !
    ! ͽѿ˱ľե륿ŬѤޤ. 
    !
    ! Vertical filter is applied to predictional variables.
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_UA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
    real(DP), intent(inout):: xyz_VA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
    real(DP), intent(inout):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t+\Delta t) $ .   . Temperature

    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ p_{1/2} (t+\Delta t) $ .   . Pressure
    real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
                              ! $ T_{1/2} (t+\Delta t) $ .   . Temperature


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: k1              ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    real(DP):: xyz_TempRef(0:imax-1, 1:jmax, 1:kmax), &
      & Temp_corr(0:imax-1, 1:jmax)

    integer  :: NLDump, NLNewtonZonal, NLRayleigh
    real(DP) :: CoefDump(1:kmax), CoefNewtonZonal(1:kmax), CoefRayleigh(1:kmax)
    real(DP) :: TimeScaleDump


    !
    ! testing (ľե륿 (Ishiwatari et al., 2002))
    !
    ! Ishiwatari et al. ǻȤƤ (F_T = 0.1)
    
    NLDump = 7
    TimeScaleDump = 10800.0_DP
    
    do k= 1, kmax - NLDump
      CoefDump(k) = 0.0_DP
      print *, '*** DEBUG ***', k, CoefDump(k)
    end do
    
    do k= kmax - NLDump + 1, kmax
      CoefDump(k) = DelTime / (TimeScaleDump * ( kmax - k + 1 ))
      print *, '*** DEBUG ***', k, CoefDump(k)
    end do
    
    NLNewtonZonal = NLDump
    CoefNewtonZonal = CoefDump
   
    NLRayleigh = NLDump
    CoefRayleigh = CoefDump


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. vertical_filter_inited ) call VerticalFilterInit

!!$    ! ƥåפΥå
!!$    ! Check Step
!!$    !
!!$    CurStep = CurStep + 1
!!$    if ( CurStep - PrevStep < IntStep ) return
!!$    PrevStep = CurStep

    ! FilterParameter ͭΥå
    ! Check validity of "FilterParameter"
    !
    if ( FilterParameter == 0.0_DP ) return

    ! ľե륿Ŭ
    ! Apply vertical filter
    !

    do k=1,kmax
      xyz_TempRef(:,:,k)  = 0.5_DP * ( xyr_Temp(:,:,k-1) + xyr_Temp(:,:,k) )
    end do

    do k=2,kmax-1
      Temp_corr = 0.0_DP
      do k1=-1,1
        Temp_corr = Temp_corr + FilterParameter &
          & * ( xyz_TempRef(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) &
          & * ( xyr_Press(:,:,k+k1-1) - xyr_Press(:,:,k+k1) )
      end do
      Temp_corr = Temp_corr / ( xyr_Press(:,:,k-2) - xyr_Press(:,:,k+1) )
      do k1=-1,1
        xyz_TempA(:,:,k+k1) = xyz_TempA(:,:,k+k1) &
          & + FilterParameter * ( xyz_TempRef(:,:,k+k1) - xyz_TempA(:,:,k+k1) ) - Temp_corr
      end do
    end do







    !
    ! testing (˥塼ȥ(Ӿؤʿ경, Ishiwatari et al. 2002))
    !

    xyz_TempRef = 0.0_DP
    ! Ȳ٤η׻
    do k = kmax-NLNewtonZonal+1, kmax
!      do j=1,jmax
        do i=0,imax-1
          xyz_TempRef(0,:,k) = xyz_TempRef(0,:,k) + xyz_TempA(i,:,k)
        end do
        xyz_TempRef(0,:,k) = xyz_TempRef(0,:,k) / imax
        do i=1,imax-1
          xyz_TempRef(i,:,k) = xyz_TempRef(0,:,k)
        end do
!      end do
    end do

    ! ٤
    do k = kmax-NLNewtonZonal+1, kmax
      xyz_TempA(:,:,k) = xyz_TempA(:,:,k) &
        & - CoefNewtonZonal(k) * ( xyz_TempA(:,:,k) - xyz_TempRef(:,:,k) )
    end do

    !
    ! testing (쥤꡼໤)
    !
    
    do k= kmax-NLRayleigh+1,kmax
      xyz_UA(:,:,k) = (1.0_DP - CoefRayleigh(k)) * xyz_UA(:,:,k)
      xyz_VA(:,:,k) = (1.0_DP - CoefRayleigh(k)) * xyz_VA(:,:,k)
    end do







    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine VerticalFilter

  !-------------------------------------------------------------------

  subroutine VerticalFilterInit
    !
    ! vertical_filter ⥸塼νԤޤ. 
    ! NAMELIST#vertical_filter_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "vertical_filter" module is initialized. 
    ! "NAMELIST#vertical_filter_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /vertical_filter_nml/ &
      & FilterParameter   !, IntStep
          !
          ! ǥեͤˤĤƤϽ³ "vertical_filter#VerticalFilterInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "vertical_filter#VerticalFilterInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( vertical_filter_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    FilterParameter = 0.1_DP
!!$    IntStep         = 1
!!$    CurStep         = 0

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = vertical_filter_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = vertical_filter_nml )
    end if

!!$    ! IntStep Υå
!!$    ! Check "IntStep"
!!$    !
!!$    if ( IntStep < 1 ) then
!!$      call MessageNotify( 'E', module_name, &
!!$        & 'IntStep=<%d> must be greater than 0', &
!!$        & i = (/ IntStep /) )
!!$    end if
!!$
!!$    ! PrevStep 
!!$    ! Configure "PrevStep"
!!$    !
!!$    PrevStep = - IntStep

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FilterParameter = %f', d = (/ FilterParameter /) )
!!$    call MessageNotify( 'M', module_name, '  IntStep         = %d', i = (/ IntStep /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    vertical_filter_inited = .true.
  end subroutine VerticalFilterInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module vertical_filter
