!= ͽѿͤγǧ
!
!= Check values of prognostic variables
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: check_prog_vars.f90,v 1.5 2013-02-19 01:33:12 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module check_prog_vars
  !
  != ͽѿͤγǧ
  !
  != Check values of prognostic variables
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ͽѿͤγǧ
  !
  ! Check values of prognostic variables
  !
  !== Procedures List
  !
!!$  ! SurfaceFlux       :: ɽ̥եåη׻
!!$  ! SurfaceFluxOutput :: ɽ̥եåν
!!$  ! ------------      :: ------------
!!$  ! SurfaceFlux       :: Calculate surface fluxes
!!$  ! SurfaceFluxOutput :: Output surface fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#check_prog_vars_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: CheckProgVars
  public :: CheckProgVarsInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: check_prog_vars_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), save:: TempMin
                            ! ٺǾ
                            ! Minimum value of temperature
  real(DP), save:: TempMax
                            ! ٺ
                            ! Maximum value of temperature
  real(DP), save:: VelMin
                            ! ®Ǿ
                            ! Minimum value of wind velocity
  real(DP), save:: VelMax
                            ! ®
                            ! Maximum value of wind velocity

  character(*), parameter:: module_name = 'check_prog_vars'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: check_prog_vars.f90,v 1.5 2013-02-19 01:33:12 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
!!$  interface SurfaceFlux
!!$    module procedure SurfaceFlux
!!$  end interface
!!$
!!$  interface SurfaceFluxOutput
!!$    module procedure SurfaceFluxOutput
!!$  end interface

contains

  subroutine CheckProgVars( &
    & xy_Ps, xyz_U, xyz_V, xyz_Temp, xyzf_QMix   & ! (in)
    & )
    !
    ! ͽѿͤγǧ
    !
    ! Check values of prognostic variables
    !

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon,   & ! $ \lambda $ [rad.] . . Longitude
      & y_Lat,   & ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma    ! $ \sigma $ ٥ ().  Full $ \sigma $ level

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only: ncmax, IndexH2OVap

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! Circular constant

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure (Pa)
    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    real(DP) :: minval, maxval
    integer  :: mini, minj, mink
    integer  :: maxi, maxj, maxk


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. check_prog_vars_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )



    i = 0
    j = 1
    k = 1
    minval = xyz_U(i,j,k)
    maxval = xyz_U(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_U   (i,j,k) < minval ) then
            minval = xyz_U   (i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_U   (i,j,k) ) then
            maxval = xyz_U   (i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < VelMin  ) then
      call MessageNotify( 'M', module_name, 'Min value : U(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( VelMax  < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : U(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if

    i = 0
    j = 1
    k = 1
    minval = xyz_V(i,j,k)
    maxval = xyz_V(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_V   (i,j,k) < minval ) then
            minval = xyz_V   (i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_V   (i,j,k) ) then
            maxval = xyz_V   (i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < VelMin  ) then
      call MessageNotify( 'M', module_name, 'Min value : V(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( VelMax  < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : V(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if

    i = 0
    j = 1
    k = 1
    minval = xyz_Temp(i,j,k)
    maxval = xyz_Temp(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Temp(i,j,k) < minval ) then
            minval = xyz_Temp(i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_Temp(i,j,k) ) then
            maxval = xyz_Temp(i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < TempMin ) then
      call MessageNotify( 'M', module_name, 'Min value : T(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( TempMax < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : T(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if


    ! ҥȥǡ
    ! History data output
    !

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine CheckProgVars

  !-------------------------------------------------------------------

  subroutine CheckProgVarsInit
    !
    ! check_prog_vars ⥸塼νԤޤ. 
    ! NAMELIST#check_prog_vars_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "check_prog_vars" module is initialized. 
    ! "NAMELIST#check_prog_vars_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /check_prog_vars_nml/ &
      & VelMin, VelMax, TempMin, TempMax
          !
          ! ǥեͤˤĤƤϽ³ "check_prog_vars#CheckProgVarsInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "check_prog_vars#CheckProgVarsInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( check_prog_vars_inited ) return
!!$    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    VelMin  = -300.0_DP
    VelMax  =  300.0_DP
    TempMin =   50.0_DP
    TempMax =  330.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = check_prog_vars_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

    call MessageNotify( 'M', module_name, '  VelMin  = %f', d = (/ VelMin  /) )
    call MessageNotify( 'M', module_name, '  VelMax  = %f', d = (/ VelMax  /) )
    call MessageNotify( 'M', module_name, '  TempMin = %f', d = (/ TempMin /) )
    call MessageNotify( 'M', module_name, '  TempMax = %f', d = (/ TempMax /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    check_prog_vars_inited = .true.

  end subroutine CheckProgVarsInit

  !--------------------------------------------------------------------------------------

end module check_prog_vars
