!= ʻȿ
!
!= Number of grid points and maximum truncated wavenumber settings
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Satoshi NODA
! Version::   $Id: gridset.F90,v 1.4 2012-02-01 12:03:32 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gridset
  !
  != ʻȿ
  !
  != Number of grid points and maximum truncated wavenumber settings
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʻꤪݴɤԤޤ. 
  ! ڥȥˡѤ뤳ȤˤƤ, 
  ! ȿݴɤԤޤ. 
  !
  ! Number of grid points is set and stored. 
  ! Maximum truncated wavenumber is set and stored too, 
  ! because spectral method is expected to be used. 
  !
  !== Variables List
  !
  ! nmax         :: ȿ
  ! lmax         :: ڥȥǡ󥵥
  ! imax         :: ٳʻ
  ! jmax_global  :: ٳʻ ()
  ! jmax         :: ٳʻ
  ! kmax         :: ľؿ
  ! kslmax       :: ϲľؿ
  ! ------------ :: ------------
  ! nmax         :: Maximum truncated wavenumber
  ! lmax         :: Size of array for spectral data
  ! imax         :: Number of grid points in longitude
  ! jmax_global  :: Number of grid points in latitude on whole globe
  ! jmax         :: Number of grid points in latitude
  ! kmax         :: Number of vertical level
  ! kslmax       :: Number of subsurface vertical level
  !
  !== Procedures List
  !
  ! GridsetInit   :: ʻȺȿ
  ! ------------  :: ------------
  ! GridsetInit   :: Settings of number of grid points and maximum truncated wavenumber
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#gridset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: GridsetInit
  public :: GridsetCheckNumberOfLatGrid


  ! ѿ
  ! Public variables
  !
  logical, save, public:: gridset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  integer, save, public:: nmax
                              ! ȿ. 
                              ! Maximum truncated wavenumber
  integer, save, public:: lmax
                              ! ڥȥǡ󥵥
                              ! Size of array for spectral data
  integer, save, public:: imax
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, save, public:: jmax_global
                              ! ٳʻ (). 
                              ! Number of grid points in latitude on whole globe
  integer, save, public:: jmax
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, save, public:: kmax
                              ! ľؿ. 
                              ! Number of vertical level
  integer, save, public:: kslmax
                              ! ϲαľؿ. 
                              ! Number of subsurface vertical level

  integer, save, allocatable, public :: a_jmax(:)
                              ! ƥץΰٳʻ. 
                              ! Number of grid points in latitude of each process
  integer, save             , public :: jmax_max
                              ! ƥץΰٳʻκ. 
                              ! Maximum number of grid points in latitude of all processes


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'gridset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: gridset.F90,v 1.4 2012-02-01 12:03:32 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine GridsetInit
    !
    ! gridset ⥸塼νԤޤ. 
    ! NAMELIST#gridset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "gridset" module is initialized. 
    ! NAMELIST#gridset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /gridset_nml/ nmax, imax, jmax, kmax, kslmax
          !
          ! ǥեͤˤĤƤϽ³ "gridset#GridsetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "gridset#GridsetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( gridset_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
#ifdef AXISYMMETRY
    imax        = 1
#elif AXISYMMETRY_SJPACK
    imax        = 1
#else
    imax        = 32
#endif
    jmax        = imax / 2
    kmax        = 5
    nmax        = ( imax - 1 ) / 3

    kslmax      = 0

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = gridset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = gridset_nml )
    end if

    ! Check of array size
    !
#ifdef AXISYMMETRY
    if ( imax /= 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'Number of grid points in longitudinal direction has to be 1.' )
    end if
#elif AXISYMMETRY_SJPACK
    if ( imax /= 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'Number of grid points in longitudinal direction has to be 1.' )
    end if
#endif

    if ( imax /= 1 ) then
      if ( jmax /= imax / 2 ) then
        call MessageNotify( 'E', module_name, &
          & 'Number of grid points in latitudinal direction has to be equal to ' &
          & // 'number of grid points in longitudinal direction divided by 2.' )
      end if
    end if

    ! Set number of grid points in latitudinal direction
    !
    jmax_global = jmax
    !
    ! Calculate and save jmax in all processes
    !   If jmax is 1, the model runs as 1D model. In that case, jmax need not 
    !   be calculated. 
    ! Even if jmax has a value, it is overwritten. 
    !
    call GridsetCalcjmax


    ! Set size of array for spectral data
    !
#ifdef AXISYMMETRY
    lmax =  nmax+1
#elif AXISYMMETRY_SJPACK
    lmax =  nmax+1
#else
    lmax = (nmax+1)**2
#endif


    ! ʻΥå
    ! Check number of grid points
    !
    if ( nmax < 1 .or. imax < 1 .or. jmax_global < 1 .or. jmax < 1 .or. kmax < 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of grid points and maximum truncated wavenumber must be more than 0. ' // &
        & 'nmax=%d, imax=%d, jmax_global=%d, jmax=%d, kmax=%d' , &
        & i = (/ nmax, imax, jmax_global, jmax, kmax /) )
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '    nmax        = %d', i = (/   nmax  /) )
    call MessageNotify( 'M', module_name, '    imax        = %d', i = (/   imax  /) )
    call MessageNotify( 'M', module_name, '    jmax_global = %d', i = (/   jmax_global /) )
    call MessageNotify( 'M', module_name, '    jmax        = %d', i = (/   jmax  /) )
    call MessageNotify( 'M', module_name, '    kmax        = %d', i = (/   kmax  /) )
    call MessageNotify( 'M', module_name, '  kslmax        = %d', i = (/ kslmax  /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    gridset_inited = .true.
  end subroutine GridsetInit

  !-------------------------------------------------------------------

  subroutine GridsetCalcjmax
    !
    ! jmax ׻.
    !
    ! Calculate jmax
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! MPI
    !
    use mpi_wrapper, only: nprocs, myrank

    ! ʸ ; Declaration statements
    !
    implicit none


    ! Local variables
    !
    integer            :: jh, jph, js, je, jch, jc
    integer            :: n


    allocate( a_jmax(0:nprocs-1) )

    if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then

      jmax_max = 1
      a_jmax   = 1

    else

      ! Following calculation is a copy of that in a subroutine SNMINI in snmini.f 
      ! included in ISPACK.

      jh = jmax_global / 2
      jph = ( jh - 1 ) / nprocs + 1

      jmax_max = jph * 2

      do n = 0, nprocs-1

        js = jph * n + 1
        je = min( jph * ( n + 1 ), jh )
        if ( je >= js ) THEN
          jch = je - js + 1
          jc  = jch * 2
        else
          jc = 0
          js = 1
          je = 1
        end if

        a_jmax(n) = jc

      end do

      if ( jmax /= a_jmax( myrank ) ) then
        call MessageNotify( 'M', module_name, &
          & 'jmax is overwritten, and is %d.', i = (/ a_jmax( myrank ) /) )
      end if
      jmax = a_jmax( myrank )

    end if


  end subroutine GridsetCalcjmax

  !-------------------------------------------------------------------

  subroutine GridsetCheckNumberOfLatGrid( jc )
    !
    ! 줾Υץôٳʻǧ.
    !
    ! Check number of latitudinal grids on each process.
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! MPI
    !
    use mpi_wrapper, only: nprocs, myrank, &
      & MPIWrapperISend, &
      & MPIWrapperIRecv, &
      & MPIWrapperWait


    ! ʸ ; Declaration statements
    !
    implicit none

    integer, intent(in ) :: jc

    ! Local variable
    !
    integer , allocatable :: a_jmax_tmp(:)
    real(DP)              :: a_SendBuf (1)
    real(DP), allocatable :: aa_RecvBuf(:,:)
    integer , allocatable :: a_iReqSend(:)
    integer , allocatable :: a_iReqRecv(:)
    integer               :: n

    ! ¹ʸ ; Executable statement
    !


    if ( jmax /= jc ) then
      n = myrank
      call MessageNotify( 'E', module_name,                                                    &
        & 'Saved jmax in myproc=%d is %d, but is not the same as one calculated by spml, %d.', &
        & i = (/myrank, jmax, jc/) )
    end if



    allocate( a_jmax_tmp(0:nprocs-1) )
    allocate( aa_RecvBuf(1,0:nprocs-1) )
    allocate( a_iReqSend(0:nprocs-1) )
    allocate( a_iReqRecv(0:nprocs-1) )

    a_SendBuf(1) = jc

    ! jmax is sent to all nodes, and received by all nodes.

    do n = 0, nprocs-1
      if ( n == myrank ) cycle
      call MPIWrapperISend( n, 1, a_SendBuf      , a_iReqSend(n) )
      call MPIWrapperIRecv( n, 1, aa_RecvBuf(:,n), a_iReqRecv(n) )
    end do

    do n = 0, nprocs-1
      if ( n == myrank ) cycle
      call MPIWrapperWait( a_iReqSend(n) )
      call MPIWrapperWait( a_iReqRecv(n) )
    end do


    do n = 0, nprocs-1
      if ( n == myrank ) then
        a_jmax_tmp(n) = jc
      else
        a_jmax_tmp(n) = aa_RecvBuf(1,n)
      end if
    end do

    ! Check number of latitudinal grid in each process.
    do n = 0, nprocs-1
      if ( a_jmax(n) /= a_jmax_tmp(n) ) then
        call MessageNotify( 'E', module_name,                               &
          & 'jmax in proc=%d is %d, but is not the same as saved one, %d.', &
          & i = (/n, a_jmax_tmp(n), a_jmax(n)/) )
      end if
    end do


    deallocate( aa_RecvBuf )
    deallocate( a_iReqSend )
    deallocate( a_iReqRecv )
    deallocate( a_jmax_tmp )



  end subroutine GridsetCheckNumberOfLatGrid

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module gridset
