!= ͥեå (ñĹȥХɥǥ)
!
!= Radiation flux (simple longwave band model)
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_simple_LW.f90,v 1.2 2012-02-01 05:19:54 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_simple_LW
  !
  != ͥեå (ñĹȥХɥǥ)
  !
  != Radiation flux (simple longwave band model)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! , 漾, , ͥեå׻ͥǥǤ. 
  !
  ! This is a radiation model that calculates radiation flux from
  ! temperature, specific humidity, and air pressure.
  !
  !== References
  !
  !
  !
  !== Procedures List
  !
  ! RadSimpleLWFlux     :: ͥեåη׻
!!$  ! RadSimpleLWFinalize :: λ (⥸塼ѿγդ)
  ! ------------------- :: ------------
  ! RadSimpleLWFlux     :: Calculate radiation flux
!!$  ! RadSimpleLWFinalize :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_Simple_LW_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ꥹȥǡ
  ! Restart data output
  !
  use gtool_history, only: GT_HISTORY

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RadSimpleLWFlux
  public:: RadSimpleLWInit

  ! ѿ
  ! Public variables
  !
  logical, save :: rad_simple_LW_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  logical, save:: Old_Flux_saved = .false.
                              ! ٷ׻եå¸Ȥ򼨤ե饰. 
                              ! Flag for saving of flux calculated once

  integer , save:: nbmax
                              ! ĹȥХɿ. 
                              ! Number of long wave band
  real(DP), save:: a_WNBnds(0:MaxNmlArySize)
                              ! 
                              ! Wavenumber bounds for bands
  real(DP), save:: a_AbsCoefDryCom(1:MaxNmlArySize)
                              ! $ \bar{k}_R $ . εۼ
                              ! Absorption coefficient of dry component
  real(DP), save:: a_PressScaleIndDryCom(1:MaxNmlArySize)
                              ! 
                              ! Pressure scaling index for dry component
  real(DP), save:: a_RefPressDryCom(1:MaxNmlArySize)
                              ! 
                              ! Reference pressure for dry component.
  real(DP), save:: a_AbsCoefH2OVap(1:MaxNmlArySize)
                              ! $ k_R $ . εۼ
                              ! Absorption coefficient of water vapor
  real(DP), save:: a_PressScaleIndH2OVap(1:MaxNmlArySize)
                              ! 
                              ! Pressure scaling index for water vapor
  real(DP), save:: a_RefPressH2OVap(1:MaxNmlArySize)
                              ! 
                              ! Reference pressure for water vapor
  real(DP), save:: DiffFact
                              ! 
                              ! Diffusivity factor

  integer , save:: NumGaussNode


  character(*), parameter:: module_name = 'rad_simple_LW'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: rad_simple_LW.f90,v 1.2 2012-02-01 05:19:54 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine RadSimpleLWFlux(                                          &
    & xy_SurfEmis, xyz_Temp, xyz_Press, xy_SurfTemp,                   & ! (in)
    & xyz_DelAtmMass, xyz_QH2OVap,                                     & ! (in)
    & xyr_RadLUwFlux, xyr_RadLDwFlux,                                  & ! (out)
    & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                           & ! (out)
    & )
    !
    ! Ĺȥեåη׻
    !
    ! Calculate long wave flux
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI,               &   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant
      & StB                   ! $ \sigma_{SB} $ . 
                              ! ƥեܥĥޥ. 
                              ! Stefan-Boltzmann constant

    ! ץ󥯴ؿη׻
    ! Calculate Planck function
    !
    use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    use rad_rte_nonscat, only : RadRTENonScat


    ! ʸ ; Declaration statements
    !
    real(DP), intent(in):: xy_SurfEmis       (0:imax-1, 1:jmax)
                              ! ɽ̼ͽΨ.
                              ! Surface emissivity
    real(DP), intent(in):: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature

    real(DP), intent(in):: xy_SurfTemp       (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xyz_DelAtmMass    (0:imax-1, 1:jmax, 1:kmax)
                              ! 
                              ! Atmospheric mass of layers
    real(DP), intent(in):: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
                              !
                              ! Specific humidity
    real(DP), intent(out):: xyr_RadLUwFlux     (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP), intent(out):: xyr_RadLDwFlux     (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 
    real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_DelOptDepDryCom(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyrr_Trans         (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
                              ! Ʃ᷸. 
                              ! Transmission coefficient
    real(DP) :: xyz_IntPF   (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
    real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
    real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)

    real(DP) :: xyr_RadUwFlux     (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Upward longwave flux
    real(DP) :: xyr_RadDwFlux     (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Downward longwave flux
    real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 
    real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! 

    real(DP) :: WNs
    real(DP) :: WNe

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ĹˤĤƲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber bands

    ! ¹ʸ ; Executable statement
    !


    !   Initialization
    !
    xyr_RadLUwFlux     = 0.0_DP
    xyr_RadLDwFlux     = 0.0_DP
    xyra_DelRadLUwFlux = 0.0_DP
    xyra_DelRadLDwFlux = 0.0_DP
    !
    LOOP_BAND_RTE : do n = 1, nbmax


      ! $ \pi B $, $ \pi DBDT $ η׻
      ! Calculate $ \pi B $ and $ \pi DBDT $
      !
      if ( nbmax == 1 ) then

        xy_SurfIntPF = xy_SurfEmis * StB * ( xy_SurfTemp**4 )
        xyz_IntPF    =               StB * ( xyz_Temp**4 )
        xy_IntDPFDT0 = xy_SurfEmis * 4.0_DP * xy_SurfIntPF / xy_SurfTemp
        xy_IntDPFDT1 =               4.0_DP * xyz_IntPF(:,:,1) / xyz_Temp(:,:,1)

      else

        WNs = a_WNBnds(n-1)
        WNe = a_WNBnds(n  )
        call Integ_PF_GQ_Array3D(        &
          & WNs, WNe, NumGaussNode,      &
          & 0, imax-1, 1, jmax, 1, kmax, &
          & xyz_Temp,                    &
          & xyz_IntPF                    &
          & )
        call Integ_PF_GQ_Array2D(   &
          & WNs, WNe, NumGaussNode, &
          & 0, imax-1, 1, jmax,     &
          & xy_SurfTemp,            &
          & xy_SurfIntPF            &
          & )
        call Integ_DPFDT_GQ_Array2D(             &
          & WNs, WNe, NumGaussNode,              & ! (in )
          & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
          & xy_IntDPFDT1                         & ! (out)
          & )
        call Integ_DPFDT_GQ_Array2D(         &
          & WNs, WNe, NumGaussNode,          & ! (in )
          & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
          & xy_IntDPFDT0                     & ! (out)
          & )

        xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
        xyz_IntPF    =               PI * xyz_IntPF
        xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
        xy_IntDPFDT1 =               PI * xy_IntDPFDT1

      end if


      ! Ūη׻
      ! Calculate optical depth
      !
      xyz_DelOptDepDryCom = a_AbsCoefDryCom(n)                             &
        & * ( xyz_Press / a_RefPressDryCom(n) )**a_PressScaleIndDryCom(n)  &
        & * xyz_DelAtmMass
      xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
        & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
        & * xyz_DelAtmMass * xyz_QH2OVap


      ! Ʃؿη׻
      ! Calculate transmission functions
      !
      xyz_TransEachLayer = exp( - DiffFact * ( xyz_DelOptDepDryCom + xyz_DelOptDepH2OVap ) )
      do k = 0, kmax
        do kk = k, k
          xyrr_Trans(:,:,k,kk) = 1.0d0
        end do
        do kk = k+1, kmax
          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_TransEachLayer(:,:,kk)
        end do
        do kk = 0, k-1
          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
        end do
      end do


      call RadRTENonScat(                                      &
        & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
        & xyrr_Trans,                                          & ! (in)
        & xyr_RadUwFlux, xyr_RadDwFlux,                        & ! (out)
        & xyra_DelRadUwFlux, xyra_DelRadDwFlux                 & ! (out)
        & )


      xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
      xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
      xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
      xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux

    end do LOOP_BAND_RTE


  end subroutine RadSimpleLWFlux

  !--------------------------------------------------------------------------------------

  subroutine RadSimpleLWInit
    !
    ! rad_simple_LW ⥸塼νԤޤ. 
    ! NAMELIST#rad_simple_LW_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_simple_LW" module is initialized. 
    ! "NAMELIST#rad_simple_LW_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime           ! ꥹȳϻ. 
                              ! Retart time of calculation


    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    use rad_rte_nonscat, only : RadRTENonScatInit

    ! ʸ ; Declaration statements
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    real(DP) :: WNBnds             (0:MaxNmlArySize)
    real(DP) :: AbsCoefDryCom      (1:MaxNmlArySize)
    real(DP) :: PressScaleIndDryCom(1:MaxNmlArySize)
    real(DP) :: RefPressDryCom     (1:MaxNmlArySize)
    real(DP) :: AbsCoefH2OVap      (1:MaxNmlArySize)
    real(DP) :: PressScaleIndH2OVap(1:MaxNmlArySize)
    real(DP) :: RefPressH2OVap     (1:MaxNmlArySize)

    integer  :: n

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_simple_LW_nml/ &
      & nbmax, &
      & WNBnds,                                             &
      & AbsCoefDryCom, PressScaleIndDryCom, RefPressDryCom, &
      & AbsCoefH2OVap, PressScaleIndH2OVap, RefPressH2OVap, &
      & DiffFact,                                           &
      & NumGaussNode
          !
          ! ǥեͤˤĤƤϽ³ "rad_DennouAGCM#RadInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_DennouAGCM#RadInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_simple_LW_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

    ! ĹȥեåѾ
    ! Information for long wave flux
    !

    nbmax                  = 1

    WNBnds                 = -999.9_DP
    AbsCoefDryCom          = -999.9_DP
    PressScaleIndDryCom    = -999.9_DP
    RefPressDryCom         = -999.9_DP
    AbsCoefH2OVap          = -999.9_DP
    PressScaleIndH2OVap    = -999.9_DP
    RefPressH2OVap         = -999.9_DP

    AbsCoefDryCom      (1:nbmax) = (/ 5.0d-5 /)
    PressScaleIndDryCom(1:nbmax) = (/ 0.0d0  /)
    RefPressDryCom     (1:nbmax) = (/ 1.0d5  /)

    AbsCoefH2OVap      (1:nbmax) = (/ 1.0d-2 /)
    PressScaleIndH2OVap(1:nbmax) = (/ 0.0d0  /)
    RefPressH2OVap     (1:nbmax) = (/ 1.0d5  /)

    DiffFact        = 1.66_DP

    NumGaussNode    = 5


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                    & ! (in)
        & nml = rad_simple_LW_nml,       & ! (out)
        & iostat = iostat_nml )            ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    if ( nbmax > MaxNmlArySize ) then
      call MessageNotify( 'E', module_name, 'nbmax = %d > %d', i = (/ nbmax, MaxNmlArySize /) )
    end if

    a_WNBnds              = WNBnds * 100.0_DP    ! Convert from cm-1 to m-1
!!$    a_AbsCoefDryCom = 5.0d-5
    a_AbsCoefDryCom       = AbsCoefDryCom
    a_PressScaleIndDryCom = PressScaleIndDryCom
    a_RefPressDryCom      = RefPressDryCom

!!$    a_AbsCoefH2OVap = 1.0d-2
    a_AbsCoefH2OVap = AbsCoefH2OVap
    a_PressScaleIndH2OVap = PressScaleIndH2OVap
    a_RefPressH2OVap      = RefPressH2OVap


    ! Initialization of modules used in this module
    !

    ! ̵뤷ã
    ! Radiative transfer equation without considering scattering
    !
    call RadRTENonScatInit


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

!!$    call MessageNotify( 'M', module_name, 'DelTime:' )
!!$    call MessageNotify( 'M', module_name, '  DelTime  = %f [%c]', &
!!$      & d = (/ DelTimeValue /), c1 = trim( DelTimeUnit ) )

    call MessageNotify( 'M', module_name, 'nbmax         = %d', i = (/ nbmax /) )

!!$    call MessageNotify( 'M', module_name, 'WNBnds              = (/ %*r /)', &
!!$      & r = real( a_WNBnds(0:nbmax) ), n = (/ nbmax+1 /) )
!!$    call MessageNotify( 'M', module_name, 'AbsCoefDryCom       = (/ %*r /)', &
!!$      & r = real( a_AbsCoefDryCom(1:nbmax) ), n = (/ nbmax /) )
!!$    call MessageNotify( 'M', module_name, 'PressScaleIndDryCom = (/ %*r /)', &
!!$      & r = real( a_PressScaleIndDryCom(1:nbmax) ), n = (/ nbmax /) )
!!$    call MessageNotify( 'M', module_name, 'RefPressDryCom      = (/ %*r /)', &
!!$      & r = real( a_RefPressDryCom(1:nbmax) ), n = (/ nbmax /) )
!!$    call MessageNotify( 'M', module_name, 'AbsCoefH2OVap       = (/ %*r /)', &
!!$      & r = real( a_AbsCoefH2OVap(1:nbmax) ), n = (/ nbmax /) )
!!$    call MessageNotify( 'M', module_name, 'PressScaleIndH2OVap = (/ %*r /)', &
!!$      & r = real( a_PressScaleIndH2OVap(1:nbmax) ), n = (/ nbmax /) )
!!$    call MessageNotify( 'M', module_name, 'RefPressH2OVap      = (/ %*r /)', &
!!$      & r = real( a_RefPressH2OVap(1:nbmax) ), n = (/ nbmax /) )

    do n = 1, nbmax
      call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f %f %f %f',       &
        & i = (/ n /),                                                              &
        & d = (/ a_WNBnds(n-1)*1.0e-2, a_WNBnds(n)*1.0e-2,                          &
        &        a_AbsCoefDryCom(n), a_PressScaleIndDryCom(n), a_RefPressDryCom(n), &
        &        a_AbsCoefH2OVap(n), a_PressScaleIndH2OVap(n), a_RefPressH2OVap(n) /) )
    end do

    call MessageNotify( 'M', module_name, 'DiffFact      = %f', d = (/ DiffFact /) )
!
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_simple_LW_inited = .true.

  end subroutine RadSimpleLWInit

  !--------------------------------------------------------------------------------------

end module rad_simple_LW
