!= negative_moist ⥸塼Υƥȥץ
!
!= Test program for "negative_moist"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: negative_moist_test01.f90,v 1.1 2008-08-11 17:23:37 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! negative_moist ⥸塼ưƥȤԤΥץǤ. 
! ΥץबѥǤ뤳, Ӽ¹Ի 
! ץबｪλ뤳ȤǧƤ. 
!
! This program checks the operation of "negative_moist" module. 
! Confirm compilation and execution of this program. 
!

program negative_moist_test01

  ! ⥸塼 ; USE statements
  !

  ! ο
  ! Remove negative moisture
  !
  use negative_moist, only: RemoveNegMoist

  ! ʬʿѤ
  ! Operation for integral and average
  !
  use intavr_operate, only: AvrLonLat_xy

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 

  ! gtool4 ǡ
  ! Gtool4 data input
  !
  use gt4_history, only: HistoryGet

  ! ʸ
  ! Character handling
  !
  use dc_string, only: toChar

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ƥȻٱ
  ! Support tests
  !
  use dc_test, only: AssertEqual

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ʪ
  ! Physical values
  !
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .     漾. Specific humidity

  real(DP), allocatable:: xyz_QVapAns (:,:,:)
                              ! $ q $ .     漾. Specific humidity

  real(DP), allocatable:: xyz_DNegQVapDt (:,:,:)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency
  real(DP), allocatable:: xyz_DNegQVapDtAns (:,:,:)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)

  real(DP):: QVapAvrLonLatSig
                              ! 漾ʿ. 
                              ! Global mean specific humidity
  real(DP):: QVapAvrLonLatSigAns
                              ! 漾ʿ. 
                              ! Global mean specific humidity

  ! ѿ
  ! Work variables
  !
  integer:: k                 ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! μ
  ! Get correct answer
  !
  call HistoryGet( &
    & file = 'negative_moist_test01-01.nc', & ! (in)
    & varname = 'QVap', &                 ! (in)
    & array = xyz_QVapAns )               ! (out)
  call HistoryGet( &
    & file = 'negative_moist_test01-01.nc', & ! (in)
    & varname = 'DNegQVapDt', &           ! (in)
    & array = xyz_DNegQVapDtAns )         ! (out)

  ! 漾μ
  ! Get pressure and specific humidity
  !
  call HistoryGet( &
    & file = 'negative_moist_test01-00.nc', & ! (in)
    & varname = 'PressM', &               ! (in)
    & array = xyr_Press )                 ! (out)

  call HistoryGet( &
    & file = 'negative_moist_test01-00.nc', & ! (in)
    & varname = 'QVap', &                 ! (in)
    & array = xyz_QVap )                  ! (out)

  ! ο
  ! Remove negative moisture
  !
  xyz_DNegQVapDt = 0.0_DP
  call RemoveNegMoist( &
    & xyz_QVap = xyz_QVap, &             ! (inout)
    & xyz_DNegQVapDt = xyz_DNegQVapDt, & ! (inout)
    & xyr_Press = xyr_Press )            ! (in)

  call AssertEqual( 'RemoveNegMoist test 1', &
    & answer = xyz_QVapAns, check = xyz_QVap, &
    & significant_digits = 15, ignore_digits = -15 )

  call AssertEqual( 'RemoveNegMoist test 2', &
    & answer = xyz_DNegQVapDtAns, check = xyz_DNegQVapDt, &
    & significant_digits = 15, ignore_digits = -15 )

  ! ǡ (֥롼)
  ! Output data (Internal subroutine)
  !
!!$  call HistoryOutput


contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! 
    ! Allocation
    !
    allocate( xyz_QVap          (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapAns       (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DNegQVapDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DNegQVapDtAns (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_Press         (0:imax-1, 1:jmax, 0:kmax) )

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStop, TimesetClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

  !-------------------------------------------------------------------

  subroutine HistoryOutput

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
      & HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ǡ
    ! Data I/O
    !
    type(GT_HISTORY):: gthist

    ! ¸ɽ, ǥ̾, °̾
    ! Title of a experiment, name of model, sub-organ
    ! 
    character(*), parameter:: title = &
      & 'data of answer for a test prorgram "negative_moist_test01"'
    character(*), parameter:: source = &
      & 'dcpam5 ' // &
      & '(See http://www.gfd-dennou.org/library/dcpam)'
    character(*), parameter:: institution = &
      & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

    ! ¹ʸ ; Executable statement
    !

    call HistoryCreate( &
      & history = gthist, &                                ! (out)
      & file = 'negative_moist_test01-01.tmp.nc', &        ! (in)
      & title = title, &                                   ! (in)
      & source = source, institution = institution, &      ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
      & longnames = &
      &  StoA('longitude', 'latitude', &
      &       'sigma at layer midpoints', &
      &       'sigma at layer end-points (half level)'), & ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1') )                           ! (out)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lon', array = x_Lon * 180.0_DP / PI )  ! (in)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lat', array = y_Lat * 180.0_DP / PI  ) ! (in)
    call HistoryPut( &
      & history = gthist, &                ! (out)
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & history = gthist, &                 ! (out)
      & varname = 'sigm', array = r_Sigma ) ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)


!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'Temp', &                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$      & longname = 'temperature', &          ! (in)
!!$      & units = 'K', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'Temp', array = xyz_Temp ) ! (in)

    call HistoryClose( history = gthist ) ! (inout)

  end subroutine HistoryOutput

end program negative_moist_test01
