!= intavr_operate ⥸塼Υƥȥץ
!
!= Test program for "intavr_operate"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: intavr_operate_test01.f90,v 1.1 2008-08-11 16:34:48 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! intavr_operate ⥸塼ưƥȤԤΥץǤ. 
! ΥץबѥǤ뤳, Ӽ¹Ի 
! ץबｪλ뤳ȤǧƤ. 
!
! This program checks the operation of "intavr_operate" module. 
! Confirm compilation and execution of this program. 
!

program intavr_operate_test01

  ! ⥸塼 ; USE statements
  !

  ! ʬʿѤ
  ! Operation for integral and average
  !
  use intavr_operate, only: &
    & IntLonLat_xy, &
    & y_IntLon_xy, ya_IntLon_xya, IntLon_x, &
    & x_IntLat_xy, xa_IntLat_xya, IntLat_y, &
    & AvrLonLat_xy, &
    & y_AvrLon_xy, ya_AvrLon_xya, AvrLon_x, &
    & x_AvrLat_xy, xa_AvrLat_xya, AvrLat_y

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 

  ! gtool4 ǡ
  ! Gtool4 data input
  !
  use gt4_history, only: HistoryGet

  ! ʸ
  ! Character handling
  !
  use dc_string, only: toChar

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ƥȻٱ
  ! Support tests
  !
  use dc_test, only: AssertEqual

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ʪ
  ! Physical values
  !
  real(DP), allocatable:: xy_Temp (:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xz_TempIntLat (:,:)
                              ! $ T $ .     ٤ΰʬ. 
                              ! Temperature integration in latitude
  real(DP), allocatable:: yz_TempAvrLon (:,:)
                              ! $ T $ .     ٤ηʿ. 
                              ! Meridional mean temperature

  real(DP), allocatable:: x_TempIntLatAns (:)
                              ! $ T $ .     ٤ΰʬ. 
                              ! Temperature integration in latitude
  real(DP), allocatable:: y_TempAvrLonAns (:)
                              ! $ T $ .     ٤ηʿ. 
                              ! Meridional mean temperature

  real(DP):: TempAvrLonLatAns
                              ! $ T $ .     ٤ΰʿ. 
                              ! Global mean temperature

  ! ѿ
  ! Work variables
  !
  integer:: k                 ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ץǡ
  ! Input sample data
  !
  call HistoryGet( &
    & file = 'intavr_operate_test01-00.nc', & ! (in)
    & varname = 'SurfTemp', &              ! (in)
    & array = xy_Temp )                    ! (out)

  do k = 1, kmax
    call HistoryGet( &
      & file = 'intavr_operate_test01-00.nc', & ! (in)
      & varname = 'SurfTemp', &              ! (in)
      & array = xyz_Temp(:,:,k) )            ! (out)
  end do

  ! ʬƥ
  ! Integration test
  !
  call HistoryGet( &
    & file = 'intavr_operate_test01-01.nc', & ! (in)
    & varname = 'IntLatTemp1', &           ! (in)
    & array = x_TempIntLatAns )            ! (out)

  call AssertEqual( 'integration test 1-2', &
    & answer = x_TempIntLatAns, &
    & check = x_IntLat_xy( xy_Temp ), &
    & significant_digits = 14, ignore_digits = -14 )

  xz_TempIntLat = xa_IntLat_xya( xyz_Temp )
  do k = 1, kmax
    call AssertEqual( 'integration test 2-' // trim(toChar(k)), &
      & answer = x_TempIntLatAns, &
      & check = xz_TempIntLat(:,k), &
      & significant_digits = 14, ignore_digits = -14 )
  end do

  ! ʿѥƥ 1
  ! Average test 1
  !
  call HistoryGet( &
    & file = 'intavr_operate_test01-01.nc', & ! (in)
    & varname = 'AvrLonTemp0', &           ! (in)
    & array = y_TempAvrLonAns )            ! (out)

  call AssertEqual( 'average test 1-1', &
    & answer = y_TempAvrLonAns, &
    & check = y_AvrLon_xy( xy_Temp ), &
    & significant_digits = 14, ignore_digits = -14 )

  call HistoryGet( &
    & file = 'intavr_operate_test01-01.nc', & ! (in)
    & varname = 'AvrLonTemp1', &           ! (in)
    & array = y_TempAvrLonAns )            ! (out)

  call AssertEqual( 'average test 1-2', &
    & answer = y_TempAvrLonAns, &
    & check = y_AvrLon_xy( xy_Temp ), &
    & significant_digits = 14, ignore_digits = -14 )

  yz_TempAvrLon = ya_AvrLon_xya( xyz_Temp )
  do k = 1, kmax
    call AssertEqual( 'average test 2-' // trim(toChar(k)), &
      & answer = y_TempAvrLonAns, &
      & check = yz_TempAvrLon(:,k), &
      & significant_digits = 14, ignore_digits = -14 )
  end do

  ! ʿѥƥ 2
  ! Average test 2
  !
  call HistoryGet( &
    & file = 'intavr_operate_test01-01.nc', & ! (in)
    & varname = 'AvrLonLatTemp1', &        ! (in)
    & array = TempAvrLonLatAns )           ! (out)

  call AssertEqual( 'average test 2-2', &
    & answer = TempAvrLonLatAns, &
    & check = AvrLonLat_xy( xy_Temp ), &
    & significant_digits = 14, ignore_digits = -14 )


  ! ǡ (֥롼)
  ! Output data (Internal subroutine)
  !
!!$  call HistoryOutput


contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! 
    ! Allocation
    !
    allocate( xy_Temp         (0:imax-1, 1:jmax)         )
    allocate( xyz_Temp        (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xz_TempIntLat   (0:imax-1,         1:kmax) )
    allocate( yz_TempAvrLon   (          1:jmax, 1:kmax) )
    allocate( x_TempIntLatAns (0:imax-1)                 )
    allocate( y_TempAvrLonAns (          1:jmax)         )

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStop, TimesetClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

  !-------------------------------------------------------------------

  subroutine HistoryOutput

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
      & HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ǡ
    ! Data I/O
    !
    type(GT_HISTORY):: gthist

    ! ¸ɽ, ǥ̾, °̾
    ! Title of a experiment, name of model, sub-organ
    ! 
    character(*), parameter:: title = &
      & 'data of answer for a test prorgram "intavr_operate_test01"'
    character(*), parameter:: source = &
      & 'dcpam5 ' // &
      & '(See http://www.gfd-dennou.org/library/dcpam)'
    character(*), parameter:: institution = &
      & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

    ! ¹ʸ ; Executable statement
    !

    call HistoryCreate( &
      & history = gthist, &                                ! (out)
      & file = 'intavr_operate_test01-01.tmp.nc', &        ! (in)
      & title = title, &                                   ! (in)
      & source = source, institution = institution, &      ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
      & longnames = &
      &  StoA('longitude', 'latitude', &
      &       'sigma at layer midpoints', &
      &       'sigma at layer end-points (half level)'), & ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1') )                           ! (out)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lon', array = x_Lon * 180.0_DP / PI )  ! (in)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lat', array = y_Lat * 180.0_DP / PI  ) ! (in)
    call HistoryPut( &
      & history = gthist, &                ! (out)
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & history = gthist, &                 ! (out)
      & varname = 'sigm', array = r_Sigma ) ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)


    call HistoryAddVariable( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', &                  ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
      & longname = 'temperature', &          ! (in)
      & units = 'K', xtype = 'double' )      ! (in)
    call HistoryPut( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', array = xyz_Temp ) ! (in)

    call HistoryClose( history = gthist ) ! (inout)

  end subroutine HistoryOutput

end program intavr_operate_test01
