!= radiation_band ⥸塼Υƥȥץ
!
!= Test program for "radiation_band"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: radiation_band_test01.f90,v 1.1 2008-08-03 19:17:06 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! radiation_band ⥸塼ưƥȤԤΥץǤ. 
! ΥץबѥǤ뤳, Ӽ¹Ի 
! ץबｪλ뤳ȤǧƤ. 
!
! This program checks the operation of "radiation_band" module. 
! Confirm compilation and execution of this program. 
!

program radiation_band_test01

  ! ⥸塼 ; USE statements
  !

  ! ͥեå
  ! Radiation flux
  !
  use radiation_band, only: RadiationFlux, RadiationCorrect, RadiationDTempDt

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
  
  ! 
  ! Time control
  !
  use timeset, only: DelTime, Cstep, TimesetGetCurrentTime, &
    & TimesetProgress

  ! ɸǡ
  ! Axes data settings
  !
  use axesset, only: &
    & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  ! ҥȥǡ
  ! History data output
  !
  use gt4_historyauto, only: HistoryAutoProgress

  ! gtool4 ǡ
  ! Gtool4 data input
  !
  use gt4_history, only: HistoryGet

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ƥȻٱ
  ! Support tests
  !
  use dc_test, only: AssertEqual

  ! ʸ
  ! Character handling
  !
  use dc_string, only: toChar

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ʪ
  ! Physical values
  !
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP), allocatable:: xy_SurfAlbedo (:,:)
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .     漾. Specific humidity
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)

  real(DP), allocatable:: xyr_RadLFlux (:,:,:)
                              ! Ĺȥեå. 
                              ! Long wave flux
  real(DP), allocatable:: xya_SurfRadLMtx (:,:,:)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
  real(DP), allocatable:: xyra_DelRadLFlux (:,:,:,:)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
  real(DP), allocatable:: xyr_RadSFlux (:,:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux

  real(DP), allocatable:: xyr_RadLFluxAns (:,:,:)
                              ! Ĺȥեå. 
                              ! Long wave flux
  real(DP), allocatable:: xya_SurfRadLMtxAns (:,:,:)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
  real(DP), allocatable:: xyra_DelRadLFluxAns (:,:,:,:)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
  real(DP), allocatable:: xyr_RadSFluxAns (:,:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux

  real(DP), allocatable:: xyz_DTempDtRadL (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
  real(DP), allocatable:: xyz_DTempDtRadS (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

  real(DP), allocatable:: xyz_DTempDtRadLAns (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
  real(DP), allocatable:: xyz_DTempDtRadSAns (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave



  ! ѿ
  ! Work variables
  !
  integer:: i
  real(DP):: time_value
  character(STRING):: time_range

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ɽ̥ǡν
  ! Prepare surface data
  !
  xy_SurfTemp = 273.0_DP
  xy_SurfAlbedo = 0.3_DP

  ! ǡ
  ! Input data
  !
  call HistoryGet ( &
    & file = 'radiation_band_test01-00.nc', varname = 'Temp', & ! (in)
    & array = xyz_Temp, quiet = .true. )                ! (out)
  call HistoryGet ( &
    & file = 'radiation_band_test01-00.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVap, quiet = .true. )                ! (out)
  call HistoryGet ( &
    & file = 'radiation_band_test01-00.nc', varname = 'PressM', & ! (in)
    & array = xyr_Press, quiet = .true. )                ! (out)

  ! RadiationFlux  RadiationDTempDt ƥ
  ! Test of "RadiationFlux" and "RadiationDTempDt"
  !
  do i = 1, 4

    call RadiationFlux( &
      & xyz_Temp, xyz_QVap, xyr_Press, &         ! (in)
      & xy_SurfTemp, xy_SurfAlbedo, &            ! (in)
      & xyr_RadLFlux, xyr_RadSFlux, &            ! (out)
      & xya_SurfRadLMtx, xyra_DelRadLFlux )      ! (out)

    call RadiationDTempDt( &
      & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
      & xyz_DTempDtRadL, xyz_DTempDtRadS )       ! (out)

    xyz_Temp = &
      & xyz_Temp &
      &  * ( 1.0_DP + DelTime * ( xyz_DTempDtRadL + xyz_DTempDtRadL ) )

    xyz_QVap = xyz_QVap * 5.0_DP

    call TimesetGetCurrentTime( time_value, 'min' )
    time_range = 'time=' // toChar( time_value )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'RadLFlux', &                  ! (in)
      & range = time_range, &                    ! (in)
      & array = xyr_RadLFluxAns )                ! (out)
    call AssertEqual( 'RadLFlux test 1-' // toChar( i ), &
      & answer = xyr_RadLFluxAns, check = xyr_RadLFlux, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'SurfRadLMtx', &            ! (in)
      & range = time_range, &                    ! (in)
      & array = xya_SurfRadLMtxAns )          ! (out)
    call AssertEqual( 'SurfRadLMtx test 1-' // toChar( i ), &
      & answer = xya_SurfRadLMtxAns, check = xya_SurfRadLMtx, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'DelRadLFlux', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyra_DelRadLFluxAns )           ! (out)
    call AssertEqual( 'DelRadLFlux test 1-' // toChar( i ), &
      & answer = xyra_DelRadLFluxAns, check = xyra_DelRadLFlux, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'RadSFlux', &                  ! (in)
      & range = time_range, &                    ! (in)
      & array = xyr_RadSFluxAns )                ! (out)
    call AssertEqual( 'RadSFlux test 1-' // toChar( i ), &
      & answer = xyr_RadSFluxAns, check = xyr_RadSFlux, &
      & significant_digits = 14, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'DTempDtRadL', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyz_DTempDtRadLAns )             ! (out)
    call AssertEqual( 'DTempDtRadL test 1-' // toChar( i ), &
      & answer = xyz_DTempDtRadLAns, check = xyz_DTempDtRadL, &
      & significant_digits = 14, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'radiation_band_test01-01.nc', & ! (in)
      & varname = 'DTempDtRadS', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyz_DTempDtRadSAns )             ! (out)
    call AssertEqual( 'DTempDtRadS test 1-' // toChar( i ), &
      & answer = xyz_DTempDtRadSAns, check = xyz_DTempDtRadS, &
      & significant_digits = 14, ignore_digits = -15 )

    call TimesetProgress
    call HistoryAutoProgress

  end do

  ! ǡ (֥롼)
  ! Output data (Internal subroutine)
  !
!!$  call HistoryOutput


contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! 
    ! Allocation
    !
    allocate( xy_SurfTemp   (0:imax-1, 1:jmax) )
    allocate( xy_SurfAlbedo (0:imax-1, 1:jmax) )

    allocate( xyz_Temp           (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVap           (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_Press          (0:imax-1, 1:jmax, 0:kmax) )

    allocate( xyr_RadLFlux       (0:imax-1, 1:jmax, 0:kmax)      )
    allocate( xya_SurfRadLMtx    (0:imax-1, 1:jmax,        -1:1) )
    allocate( xyra_DelRadLFlux   (0:imax-1, 1:jmax, 0:kmax, 0:1) )
    allocate( xyr_RadSFlux       (0:imax-1, 1:jmax, 0:kmax)      )

    allocate( xyr_RadLFluxAns       (0:imax-1, 1:jmax, 0:kmax)      )
    allocate( xya_SurfRadLMtxAns    (0:imax-1, 1:jmax,        -1:1) )
    allocate( xyra_DelRadLFluxAns   (0:imax-1, 1:jmax, 0:kmax, 0:1) )
    allocate( xyr_RadSFluxAns       (0:imax-1, 1:jmax, 0:kmax)      )

    allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )

    allocate( xyz_DTempDtRadLAns (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDtRadSAns (0:imax-1, 1:jmax, 1:kmax) )

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStop, TimesetClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

  !-------------------------------------------------------------------

  subroutine HistoryOutput

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
      & HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ǡ
    ! Data I/O
    !
    type(GT_HISTORY):: gthist

    ! ¸ɽ, ǥ̾, °̾
    ! Title of a experiment, name of model, sub-organ
    ! 
    character(*), parameter:: title = &
      & 'data of answer for a test prorgram "radiation_band_test01"'
    character(*), parameter:: source = &
      & 'dcpam5 ' // &
      & '(See http://www.gfd-dennou.org/library/dcpam)'
    character(*), parameter:: institution = &
      & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

    ! ¹ʸ ; Executable statement
    !

    call HistoryCreate( &
      & history = gthist, &                                ! (out)
      & file = 'radiation_band_test01-01.tmp.nc', &        ! (in)
      & title = title, &                                   ! (in)
      & source = source, institution = institution, &      ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
      & longnames = &
      &  StoA('longitude', 'latitude', &
      &       'sigma at layer midpoints', &
      &       'sigma at layer end-points (half level)'), & ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1') )                           ! (out)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lon', array = x_Lon * 180.0_DP / PI )  ! (in)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lat', array = y_Lat * 180.0_DP / PI  ) ! (in)
    call HistoryPut( &
      & history = gthist, &                ! (out)
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & history = gthist, &                 ! (out)
      & varname = 'sigm', array = r_Sigma ) ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)


    call HistoryAddVariable( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', &                  ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
      & longname = 'temperature', &          ! (in)
      & units = 'K', xtype = 'double' )      ! (in)
    call HistoryPut( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', array = xyz_Temp ) ! (in)

    call HistoryAddVariable( &
      & history = gthist, &                  ! (inout)
      & varname = 'QVap', &                  ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
      & longname = 'specific humidity', &          ! (in)
      & units = 'kg kg-1', xtype = 'double' )      ! (in)
    call HistoryPut( &
      & history = gthist, &                  ! (inout)
      & varname = 'QVap', array = xyz_QVap ) ! (in)

!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DTempDtCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$      & longname = 'cumulus condensation heating', &          ! (in)
!!$      & units = 'K s-1', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DTempDtCumulus', array = xyz_DTempDtCumulus ) ! (in)
!!$
!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DQVapDtCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$      & longname = 'cumulus condensation moistening', &  ! (in)
!!$      & units = 'kg kg-1 s-1', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DQVapDtCumulus', array = xyz_DQVapDtCumulus ) ! (in)
!!$
!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'RainCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat'), &  ! (in)
!!$      & longname = 'precipitation by cumulus scheme', &  ! (in)
!!$      & units = 'W m-2', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'RainCumulus', array = xy_RainCumulus ) ! (in)

    call HistoryClose( history = gthist ) ! (inout)

  end subroutine HistoryOutput

end program radiation_band_test01
