!= cumulus_adjust ⥸塼Υƥȥץ
!
!= Test program for "cumulus_adjust"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: cumulus_adjust_test01.f90,v 1.2 2008-08-03 19:36:39 morikawa Exp $
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! cumulus_adjust ⥸塼ưƥȤԤΥץǤ. 
! ΥץबѥǤ뤳, Ӽ¹Ի 
! ץबｪλ뤳ȤǧƤ. 
!
! This program checks the operation of "cumulus_adjust" module. 
! Confirm compilation and execution of this program. 
!

program cumulus_adjust_test01

  ! ⥸塼 ; USE statements
  !

  ! ѱѥ᥿ꥼ (ήĴ)
  ! Cumulus parameterization (convection adjust)
  !
  use cumulus_adjust, only: Cumulus

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 

  ! ɸǡ
  ! Axes data settings
  !
  use axesset, only: &
    & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  ! gtool4 ǡ
  ! Gtool4 data input
  !
  use gt4_history, only: HistoryGet

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ƥȻٱ
  ! Support tests
  !
  use dc_test, only: AssertEqual

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ʪ
  ! Physical values
  !
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ p_s $ .   ɽ̵. Surface pressure
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .     漾. Specific humidity
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
!!$  real(DP), allocatable:: xy_RainCumulus (:,:)
!!$                              ! ѱˤ߿. 
!!$                              ! Precipitation by cumulus scheme
!!$  real(DP), allocatable:: xyz_DTempDtCumulus (:,:,:)
!!$                              ! ѱˤ벹ѲΨ. 
!!$                              ! Temperature tendency by cumulus scheme
!!$  real(DP), allocatable:: xyz_DQVapDtCumulus (:,:,:)
!!$                              ! ѱˤ漾ѲΨ. 
!!$                              ! Specific humidity tendency by cumulus scheme

  real(DP), allocatable:: xyz_TempAns (:,:,:)
                              ! $ T $ .     . Temperature
  real(DP), allocatable:: xyz_QVapAns (:,:,:)
                              ! $ q $ .     漾. Specific humidity
!!$  real(DP), allocatable:: xy_RainCumulusAns (:,:)
!!$                              ! ѱˤ߿. 
!!$                              ! Precipitation by cumulus scheme
!!$  real(DP), allocatable:: xyz_DTempDtCumulusAns (:,:,:)
!!$                              ! ѱˤ벹ѲΨ. 
!!$                              ! Temperature tendency by cumulus scheme
!!$  real(DP), allocatable:: xyz_DQVapDtCumulusAns (:,:,:)
!!$                              ! ѱˤ漾ѲΨ. 
!!$                              ! Specific humidity tendency by cumulus scheme


  ! ѿ
  ! Work variables
  !
  integer:: k                 ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ǡ
  ! Input data
  !
  call HistoryGet ( &
    & file = 'cumulus_adjust_test01-00.nc', varname = 'Temp', & ! (in)
    & array = xyz_Temp, quiet = .true. )                ! (out)
  call HistoryGet ( &
    & file = 'cumulus_adjust_test01-00.nc', varname = 'Ps', & ! (in)
    & array = xy_Ps, quiet = .true. )                ! (out)
!!$  call HistoryGet ( &
!!$    & file = 'cumulus_adjust_test01-00.nc', varname = 'QVap', & ! (in)
!!$    & array = xyz_QVap, quiet = .true. )                ! (out)

  do k = 1, kmax
    xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
  end do

  do k = 0, kmax
    xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
  end do

  xyz_QVap = 1.0e-2

  call HistoryGet ( &
    & file = 'cumulus_adjust_test01-01.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempAns, quiet = .true. )                ! (out)
  call HistoryGet ( &
    & file = 'cumulus_adjust_test01-01.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapAns, quiet = .true. )                ! (out)
!!$  call HistoryGet ( &
!!$    & file = 'cumulus_adjust_test01-01.nc', varname = 'DTempDtCumulus', & ! (in)
!!$    & array = xyz_DTempDtCumulusAns, quiet = .true. )                ! (out)
!!$  call HistoryGet ( &
!!$    & file = 'cumulus_adjust_test01-01.nc', varname = 'DQVapDtCumulus', & ! (in)
!!$    & array = xyz_DQVapDtCumulusAns, quiet = .true. )                ! (out)
!!$  call HistoryGet ( &
!!$    & file = 'cumulus_adjust_test01-01.nc', varname = 'RainCumulus', & ! (in)
!!$    & array = xy_RainCumulusAns, quiet = .true. )                ! (out)


  ! Cumulus ƥ
  ! Cumulus test
  !
  call Cumulus( &
    & xyz_Temp,  xyz_QVap, &   ! (inout)
    & xyz_Press, xyr_Press )   ! (in)

  call AssertEqual( 'Cumulus test (Temp)', &
    & answer = xyz_TempAns, check = xyz_Temp, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'Cumulus test (QVap)', &
    & answer = xyz_QVapAns, check = xyz_QVap, &
    & significant_digits = 15, ignore_digits = -15 )

!!$  call AssertEqual( 'Cumulus test (DTempDtCumulus)', &
!!$    & answer = xyz_DTempDtCumulusAns, check = xyz_DTempDtCumulus, &
!!$    & significant_digits = 15, ignore_digits = -15 )
!!$  call AssertEqual( 'Cumulus test (DQVapDtCumulus)', &
!!$    & answer = xyz_DQVapDtCumulusAns, check = xyz_DQVapDtCumulus, &
!!$    & significant_digits = 15, ignore_digits = -15 )
!!$  call AssertEqual( 'Cumulus test (RainCumulus)', &
!!$    & answer = xy_RainCumulusAns, check = xy_RainCumulus, &
!!$    & significant_digits = 14, ignore_digits = -15 )



  ! ǡ (֥롼)
  ! Output data (Internal subroutine)
  !
!!$  call HistoryOutput


contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ¹ʸ ; Executable statement
    !

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! 
    ! Allocation
    !
    allocate( xy_Ps              (0:imax-1, 1:jmax)         )
    allocate( xyz_Temp           (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVap           (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_Press          (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyr_Press          (0:imax-1, 1:jmax, 0:kmax) )
!!$    allocate( xy_RainCumulus     (0:imax-1, 1:jmax)         )
!!$    allocate( xyz_DTempDtCumulus (0:imax-1, 1:jmax, 1:kmax) )
!!$    allocate( xyz_DQVapDtCumulus (0:imax-1, 1:jmax, 1:kmax) )

    allocate( xyz_TempAns           (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVapAns           (0:imax-1, 1:jmax, 1:kmax) )
!!$    allocate( xy_RainCumulusAns     (0:imax-1, 1:jmax)         )
!!$    allocate( xyz_DTempDtCumulusAns (0:imax-1, 1:jmax, 1:kmax) )
!!$    allocate( xyz_DQVapDtCumulusAns (0:imax-1, 1:jmax, 1:kmax) )

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStop, TimesetClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ¹ʸ ; Executable statement
    !

    ! λ
    ! Termination of time control
    !
    call TimesetClose

  end subroutine MainTerminate

  !-------------------------------------------------------------------

  subroutine HistoryOutput

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
      & HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ǡ
    ! Data I/O
    !
    type(GT_HISTORY):: gthist

    ! ¸ɽ, ǥ̾, °̾
    ! Title of a experiment, name of model, sub-organ
    ! 
    character(*), parameter:: title = &
      & 'data of answer for a test prorgram "cumulus_adjust_test01"'
    character(*), parameter:: source = &
      & 'dcpam5 ' // &
      & '(See http://www.gfd-dennou.org/library/dcpam)'
    character(*), parameter:: institution = &
      & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

    ! ¹ʸ ; Executable statement
    !

    call HistoryCreate( &
      & history = gthist, &                                ! (out)
      & file = 'cumulus_adjust_test01-01.tmp.nc', &        ! (in)
      & title = title, &                                   ! (in)
      & source = source, institution = institution, &      ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm'), &        ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1/), &       ! (in)
      & longnames = &
      &  StoA('longitude', 'latitude', &
      &       'sigma at layer midpoints', &
      &       'sigma at layer end-points (half level)'), & ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1') )                           ! (out)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lon', array = x_Lon * 180.0_DP / PI )  ! (in)

    call HistoryPut( &
      & history = gthist, &               ! (out)
      & varname = 'lat', array = y_Lat * 180.0_DP / PI  ) ! (in)
    call HistoryPut( &
      & history = gthist, &                ! (out)
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & history = gthist, &                 ! (out)
      & varname = 'sigm', array = r_Sigma ) ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                    ! (inout)
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                         ! (inout)
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)


    call HistoryAddVariable( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', &                  ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
      & longname = 'temperature', &          ! (in)
      & units = 'K', xtype = 'double' )      ! (in)
    call HistoryPut( &
      & history = gthist, &                  ! (inout)
      & varname = 'Temp', array = xyz_Temp ) ! (in)

    call HistoryAddVariable( &
      & history = gthist, &                  ! (inout)
      & varname = 'QVap', &                  ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
      & longname = 'specific humidity', &          ! (in)
      & units = 'kg kg-1', xtype = 'double' )      ! (in)
    call HistoryPut( &
      & history = gthist, &                  ! (inout)
      & varname = 'QVap', array = xyz_QVap ) ! (in)

!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DTempDtCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$      & longname = 'cumulus condensation heating', &          ! (in)
!!$      & units = 'K s-1', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DTempDtCumulus', array = xyz_DTempDtCumulus ) ! (in)
!!$
!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DQVapDtCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig'), &  ! (in)
!!$      & longname = 'cumulus condensation moistening', &  ! (in)
!!$      & units = 'kg kg-1 s-1', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'DQVapDtCumulus', array = xyz_DQVapDtCumulus ) ! (in)
!!$
!!$    call HistoryAddVariable( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'RainCumulus', &            ! (in)
!!$      & dims = StoA('lon', 'lat'), &  ! (in)
!!$      & longname = 'precipitation by cumulus scheme', &  ! (in)
!!$      & units = 'W m-2', xtype = 'double' )      ! (in)
!!$    call HistoryPut( &
!!$      & history = gthist, &                  ! (inout)
!!$      & varname = 'RainCumulus', array = xy_RainCumulus ) ! (in)

    call HistoryClose( history = gthist ) ! (inout)

  end subroutine HistoryOutput

end program cumulus_adjust_test01
