#!/bin/sh
#
#= Make tar ball
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: tarcomp.sh,v 1.1 2008-08-06 10:30:18 morikawa Exp $
# Tag Name::  $Name: dcpam5-20080812 $
# Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#= Overview
#
# This script make tar ball 
#

######################################################################
#
#== Settings

TAR="tar"
COMPOPT="cfvzh"

# End Settings
######################################################################

set -e

######################################################################
#== Check echo options
case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

report_me() {
	echo Error: $*
	echo please report it to GFD-Dennou Club.
	exit 1
}

help() {
	cat <<'END_OF_HELP'
tarcpmp.sh - Tar ball maker

END_OF_HELP
	exit 1
}


curdir=`pwd | xargs basename`
tarfiledef=${curdir}.tar.gz
tarfile=

cd ..

if [ -f ${tarfiledef} ]; then

    while [ -z "${tarfile}" ]; do

	echo "  \"${tarfiledef}\" is already exist."
	echo "    1. Overwrite (default)"
	echo "    2. Change file name"
	echo "    3. Exit"
	echo $ECHO_N "  Please select [1-3]: $ECHO_C"
	read sel

	case $sel in
	    1)
		tarfile=$tarfiledef
		;;
	    2)
		echo "  (Parent working directory is `pwd`)"
		echo $ECHO_N "  Enter filename: $ECHO_C"
		read newfile
		if [ -z "${newfile}" ]; then
		    echo "  blanks are invalid."
		elif [ -f ${newfile} ]; then
		    tarfiledef=${newfile}
		else
		    tarfile=${newfile}
		fi
		;;
	    3)
		echo ""
		echo "  $0: exit"
		exit 1
		;;
	    *)
		echo "  Enter 1-3"
		;;
	esac
    done

else
    tarfile=$tarfiledef
fi

echo ${TAR} ${COMPOPT} ${tarfile} ${curdir}
${TAR} ${COMPOPT} ${tarfile} ${curdir}
