!= ľȻեå (Mellor and Yamada, 1974)
!
!= Vertical diffusion flux (Mellor and Yamada, 1974)
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: vdiffusion_my1974.f90,v 1.3 2008-08-09 15:23:27 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module vdiffusion_my1974
  !
  != ľȻեå (Mellor and Yamada, 1974)
  !
  != Vertical diffusion flux (Mellor and Yamada, 1974)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ľȻեå׻ޤ. 
  !
  ! Vertical diffusion flux is calculated. 
  !
  !== Procedures List
  ! 
  ! VerticalDiffusion :: ľȻեåη׻
  ! ------------      :: ------------
  ! VerticalDiffusion :: Calculate vertical diffusion flux
  !
  !== NAMELIST
  !
  ! NAMELIST#vdiffusion_my1974_nml
  !

  ! ⥸塼 ; USE statements
  !
  !== References
  !
  ! * Mellor, G. L, Yamada, T., 1974: 
  !   A hierarchy of turbulence closure models for 
  !   planetary boundary layers. 
  !   <i>J. Atmos. Sci.</i>, <b>31</b>, 1791--1806.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: VerticalDiffusion

  ! ѿ
  ! Public variables
  !
  logical, save, public:: vdiffusion_my1974_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !


  ! ľȻեåФΤѿ
  ! Variables for calculation of vertical diffusion flux
  !
  real(DP), save:: RefPress
                              ! ȵ. 
                              ! Reference air pressure
  real(DP), save:: BasePotTemp
                              ! ܲ. 
                              ! Base potential temperature
  real(DP), save:: SquareVelMin
                              ! 躹Ǿ. 
                              ! Minimum value of square of velocity
  real(DP), save:: BulkRiNumMin
                              ! Х륯 $ R_i $ Ǿ. 
                              ! Minimum value of bulk $ R_i $

  ! ȻФΤѿ
  ! Veriables for calculation of diffusion coefficients
  !
  real(DP), save:: MixLengthMax
                              ! 纮Υ. 
                              ! Maximum mixing length
  real(DP), save:: TildeShMin
                              ! $ \tilde{S_h} $ Ǿ. 
                              ! Minimum $ \tilde{S_h} $
  real(DP), save:: TildeSmMin
                              ! $ \tilde{S_m} $ Ǿ. 
                              ! Minimum $ \tilde{S_m} $
  real(DP), save:: VelDiffCoeffMin
                              ! $ \Dvect{u} $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ \Dvect{u} $
  real(DP), save:: TempDiffCoeffMin
                              ! $ T $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ T $
  real(DP), save:: QvapDiffCoeffMin
                              ! $ q $ ȻǾ. 
                              ! Minimum diffusion coefficient of $ q $
  real(DP), save:: VelDiffCoeffMax
                              ! $ \Dvect{u} $ Ȼ. 
                              ! Maximum diffusion coefficient of $ \Dvect{u} $
  real(DP), save:: TempDiffCoeffMax
                              ! $ T $ Ȼ. 
                              ! Maximum diffusion coefficient of $ T $
  real(DP), save:: QvapDiffCoeffMax
                              ! $ q $ Ȼ. 
                              ! Maximum diffusion coefficient of $ q $

  ! Mellor Yamada Level 2 
  ! Constants for Mellor Yamada Level 2
  !
  real(DP), save:: MYLv2ParamA1
  real(DP), save:: MYLv2ParamB1
  real(DP), save:: MYLv2ParamA2
  real(DP), save:: MYLv2ParamB2
  real(DP), save:: MYLv2ParamC1


  character(*), parameter:: module_name = 'vdiffusion_my1974'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: vdiffusion_my1974.f90,v 1.3 2008-08-09 15:23:27 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface VerticalDiffusion
    module procedure VerticalDiffusion
  end interface

contains

  subroutine VerticalDiffusion( &
    & xyz_U,     xyz_V,     xyz_QVap, &                   ! (in)
    & xyz_Temp,  xyr_Temp, &                              ! (in)
    & xyz_Press, xyr_Press, xyz_GeoPot,   xyr_GeoPot, &   ! (in)
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (inout)
    & xyza_UVMtx, xyra_TempMtx, xyza_QVapMtx &            ! (inout)
    & )
    !
    ! ľȻեå׻ޤ. 
    !
    ! Vertical diffusion flux is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & FKarm, &
                              ! $ k $ .
                              ! ޥ. 
                              ! Karman constant
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(in):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(in):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_GeoPot (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP), intent(in):: xyr_GeoPot (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{\phi} $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)

    real(DP), intent(inout):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(inout):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(inout):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(inout):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(inout):: xyza_UVMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP), intent(inout):: xyra_TempMtx (0:imax-1, 1:jmax, 0:kmax, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP), intent(inout):: xyza_QVapMtx (0:imax-1, 1:jmax, 1:kmax, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity

    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_DVelDz (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \DD{|\Dvect{v}|}{z} $
    real(DP):: xyr_BulkRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $
    real(DP):: xyr_VelTransCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
    real(DP):: xyr_TempTransCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP):: xyr_QvapTransCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity
    real(DP):: xyr_VelDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼư. 
                              ! Diffusion coefficient: velocity
    real(DP):: xyr_TempDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ. 
                              ! Transfer coefficient: temperature
    real(DP):: xyr_QvapDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ漾. 
                              ! Diffusion coefficient: specific humidity
    real(DP):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VtcllDiffInit

    ! Exner ؿ
    ! Calculate Exner functions
    !
    xyz_Exner = ( xyz_Press / RefPress ) ** ( GasRDry / CpDry )
    xyr_Exner = ( xyr_Press / RefPress ) ** ( GasRDry / CpDry )

    ! Х륯 $ R_i $ 
    ! Calculate bulk $ R_i $
    !
    xyr_DVelDz    = 0.0_DP
    xyr_BulkRiNum = 0.0_DP
    
    do k = 1, kmax-1
      xyr_DVelDz(:,:,k) = &
        &  sqrt( max( SquareVelMin , &
        &             ( xyz_U(:,:,k+1) - xyz_U(:,:,k) )**2 &
        &           + ( xyz_V(:,:,k+1) - xyz_V(:,:,k) )**2 &
        &           )    &
        &      ) &
        &  / ( xyz_GeoPot(:,:,k+1) - xyz_GeoPot(:,:,k) )
      
      xyr_BulkRiNum(:,:,k) = &
        &  Grav / BasePotTemp &
        &  * (   xyz_Temp(:,:,k+1) / xyz_Exner(:,:,k+1)   &
        &      - xyz_Temp(:,:,k)   / xyz_Exner(:,:,k)   ) &
        &  / ( xyz_GeoPot(:,:,k+1) - xyz_GeoPot(:,:,k) ) &
        &  / xyr_DVelDz(:,:,k)**2
      
      xyr_BulkRiNum(:,:,k) = max( xyr_BulkRiNum(:,:,k) , BulkRiNumMin )
      
    end do
    
    ! Ȼη׻
    ! Calculate diffusion coefficients
    !
    call VtclDiffCoefficient( &
      & xyr_GeoPot, xyr_DVelDz, xyr_BulkRiNum, &                 ! (in)
      & xyr_VelDiffCoeff, xyr_TempDiffCoeff, xyr_QvapDiffCoeff ) ! (out)
    
    ! ѱή
    ! Shallow cumulus convection
    !
    ! (AGCM5 Ƴͽ)
    
    
    ! Ȼν
    ! Output diffusion coefficients
    !
    ! (嵭ΡѱήƳ˺)

    
    ! ͢η׻
    ! Calculate transfer coefficient
    !
    xyr_VelTransCoeff  = 0.0_DP
    xyr_TempTransCoeff = 0.0_DP
    xyr_QvapTransCoeff = 0.0_DP
    
    do k = 1, kmax-1
      xyr_VelTransCoeff(:,:,k) = &
        &                 xyr_VelDiffCoeff(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_GeoPot(:,:,k+1) - xyz_GeoPot(:,:,k) )

      xyr_TempTransCoeff(:,:,k) = &
        &                 xyr_TempDiffCoeff(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_GeoPot(:,:,k+1) - xyz_GeoPot(:,:,k) )

      xyr_QvapTransCoeff(:,:,k) = &
        &                 xyr_QvapDiffCoeff(:,:,k) &
        &                   * xyr_Press(:,:,k) / GasRDry / xyr_Temp(:,:,k) &
        &                   / ( xyz_GeoPot(:,:,k+1) - xyz_GeoPot(:,:,k) )
    end do
    
    ! եåη׻
    ! Calculate fluxes
    !
    do k = 1, kmax-1
      xyr_UFlux(:,:,k) =   &
        &   xyr_UFlux(:,:,k) &
        & + xyr_VelTransCoeff(:,:,k) * ( xyz_U(:,:,k) - xyz_U(:,:,k+1) )
      
      xyr_VFlux(:,:,k) =   &
        &   xyr_VFlux(:,:,k) &
        & + xyr_VelTransCoeff(:,:,k) * ( xyz_V(:,:,k) - xyz_V(:,:,k+1) )
      
      xyr_TempFlux(:,:,k) = &
        &   xyr_TempFlux(:,:,k) &
        & + CpDry * xyr_TempTransCoeff(:,:,k) * xyr_Exner(:,:,k) &
        &   * (   xyz_Temp(:,:,k)   / xyz_Exner(:,:,k)      &
        &       - xyz_Temp(:,:,k+1) / xyz_Exner(:,:,k+1) )
      
      xyr_QvapFlux(:,:,k) = &
        &   xyr_QvapFlux(:,:,k) &
        & + LatentHeat * xyr_QvapTransCoeff(:,:,k) &
        &   * ( xyz_Qvap(:,:,k) - xyz_Qvap(:,:,k+1) )
      
    end do
    

    ! η׻
    ! Calculate implicit matrices
    !
    do k = 2, kmax
      xyza_UVMtx(:,:,k, 0)   = xyza_UVMtx(:,:,k,0) + xyr_VelTransCoeff(:,:,k-1)

      xyza_UVMtx(:,:,k,-1)   =                     - xyr_VelTransCoeff(:,:,k-1)
      
      xyra_TempMtx(:,:,k, 0) =   xyra_TempMtx(:,:,k,0) &
        &                      + CpDry * xyr_TempTransCoeff(:,:,k-1) &
        &                          * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k)

      xyra_TempMtx(:,:,k,-1) = - CpDry * xyr_TempTransCoeff(:,:,k-1) &
        &                          * xyr_Exner(:,:,k-1) / xyz_Exner(:,:,k-1)
      
      xyza_QvapMtx(:,:,k, 0) =   xyza_QvapMtx(:,:,k,0) &
        &                      + CpDry * xyr_QvapTransCoeff(:,:,k-1)

      xyza_QvapMtx(:,:,k,-1) = - CpDry * xyr_QvapTransCoeff(:,:,k-1)
    end do
    
    do k = 1, kmax-1
      xyza_UVMtx(:,:,k,0)    =   xyza_UVMtx(:,:,k,0) &
        &                      + xyr_VelTransCoeff(:,:,k)

      xyza_UVMtx(:,:,k,1)    = - xyr_VelTransCoeff(:,:,k)
      
      xyra_TempMtx(:,:,k,0)  =   xyra_TempMtx(:,:,k,0) &
        &                      + CpDry * xyr_TempTransCoeff(:,:,k) &
        &                          * xyr_Exner(:,:,k) / xyz_Exner(:,:,k)

      xyra_TempMtx(:,:,k,1)  = - CpDry * xyr_TempTransCoeff(:,:,k) &
        &                          * xyr_Exner(:,:,k) / xyz_Exner(:,:,k+1)
      
      xyza_QvapMtx(:,:,k,0)  =   xyza_QvapMtx(:,:,k,0) &
        &                      + CpDry * xyr_QvapTransCoeff(:,:,k)

      xyza_QvapMtx(:,:,k,1)  = - CpDry * xyr_QvapTransCoeff(:,:,k)
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'UDiffFlux',    xyr_UFlux )
    call HistoryAutoPut( 'VDiffFlux',    xyr_VFlux )
    call HistoryAutoPut( 'TempDiffFlux', xyr_TempFlux )
    call HistoryAutoPut( 'QVapDiffFlux', xyr_QVapFlux )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine VerticalDiffusion



  subroutine VtclDiffCoefficient( &
    & xyr_GeoPot, xyr_DVelDz, xyr_BulkRiNum, &                 ! (in)
    & xyr_VelDiffCoeff, xyr_TempDiffCoeff, xyr_QvapDiffCoeff & ! (out)
    & )
    !
    ! ľȻեå׻ޤ. 
    !
    ! Vertical diffusion flux is calculated. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & FKarm
                              ! $ k $ .
                              ! ޥ. 
                              ! Karman constant

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_GeoPot (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{\phi} $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)
    real(DP), intent(in):: xyr_DVelDz (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \DD{|\Dvect{v}|}{z} $
    real(DP), intent(in):: xyr_BulkRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $
    real(DP), intent(out):: xyr_VelDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(out):: xyr_TempDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ. 
                              ! Transfer coefficient: temperature
    real(DP), intent(out):: xyr_QvapDiffCoeff (0:imax-1, 1:jmax, 0:kmax)
                              ! Ȼ漾. 
                              ! Diffusion coefficient: specific humidity



    ! ѿ
    ! Work variables
    !
    real(DP):: xyr_FluxRiNum (0:imax-1, 1:jmax, 0:kmax)
                              ! եå $ R_i $ . 
                              ! Flux $ R_i $ number
    real(DP):: xyr_TildeSh (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \tilde{S_h} $ (, 漾). 
                              ! $ \tilde{S_h} $ (temperature, specific humidity)
    real(DP):: xyr_TildeSm (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \tilde{S_m} $ (ư). 
                              ! $ \tilde{S_m} $ (momentum)
    real(DP):: xyr_MixLength (0:imax-1, 1:jmax, 0:kmax)
                              ! Υ. 
                              ! Mixing length

    real(DP):: Alpha1, Alpha2
    real(DP):: Beta1, Beta2, Beta3, Beta4
    real(DP):: Gamma1, Gamma2
    real(DP):: CrtlFluxRiNum

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. vdiffusion_my1974_inited ) call VtcllDiffInit

    ! ׻
    ! Calculate constants
    !
    Gamma1 = ( 1.0_DP / 3.0_DP ) - ( 2.0_DP * MYLv2ParamA1 / MYLv2ParamB1 )
    Gamma2 =   ( MYLv2ParamB2 / MYLv2ParamB1 ) &
      &      + ( 6.0_DP * MYLv2ParamA1 / MYLv2ParamB1 )
    Alpha1 = 3.0_DP  * MYLv2ParamA2 * Gamma1
    Alpha2 = 3.0_DP  * MYLv2ParamA2 * ( Gamma1 + Gamma1 )
    Beta1  = MYLv2ParamA1 * MYLv2ParamB1 * ( Gamma1 - MYLv2ParamC1 )
    Beta2  = MYLv2ParamA1 &
      &      * (   MYLv2ParamB1 * ( Gamma1 - MYLv2ParamC1 ) &
      &          + 6.0_DP * MYLv2ParamA1 &
      &          + 3.0_DP * MYLv2ParamA2 )
    Beta3  = MYLv2ParamA2 * MYLv2ParamB1 * Gamma1
    Beta4  = MYLv2ParamA2 * (   MYLv2ParamB1 * ( Gamma1 + Gamma2 ) &
      &                       - 3.0_DP * MYLv2ParamA1 )
    CrtlFluxRiNum = Gamma1 / ( Gamma1 + Gamma2 )

    ! եå $ R_i $ λ
    ! Calculate flux $ R_i $ number
    !
    xyr_FluxRiNum = &
      & (   Beta1 &
      &   + Beta4 * xyr_BulkRiNum &
      &   - sqrt(   ( Beta1 + Beta4 * xyr_BulkRiNum )**2 &
      &           - 4.0_DP * Beta2 * Beta3 * xyr_BulkRiNum &
      &         ) &
      & ) / ( 2.0_DP * Beta2 )
    
    ! $ \tilde{S_h} $  $ \tilde{S_m} $ λ
    ! Calculate $ \tilde{S_h} $ and $ \tilde{S_m} $
    !
    xyr_TildeSh = 0.0_DP
    xyr_TildeSm = 0.0_DP
    
    do k = 0, kmax-1
      do i = 0, imax-1
        do j = 1, jmax
          
          if ( xyr_FluxRiNum(i,j,k) < CrtlFluxRiNum ) then 
            
            xyr_TildeSh(i,j,k) = &
              &   (   Alpha1 - Alpha2 * xyr_FluxRiNum(i,j,k) ) &
              &   / ( 1.0_DP - 1.0_DP * xyr_FluxRiNum(i,j,k) )

            xyr_TildeSm(i,j,k) = &
              &   (   Beta1 - Beta2 * xyr_FluxRiNum(i,j,k) ) &
              &   / ( Beta3 - Beta4 * xyr_FluxRiNum(i,j,k) ) &
              &   * xyr_TildeSh(i,j,k)

            xyr_TildeSh(i,j,k) = max( xyr_TildeSh(i,j,k), TildeShMin )
            xyr_TildeSm(i,j,k) = max( xyr_TildeSm(i,j,k), TildeSmMin )
            
          else
            
            xyr_TildeSh(i,j,k) = TildeShMin
            xyr_TildeSm(i,j,k) = TildeSmMin
            
          end if
          
        end do
      end do
    end do
    
    
    ! Υλ
    ! Calculate mixing length
    !
    xyr_MixLength = &
      & FKarm * xyr_GeoPot / (1.0_DP + FKarm * xyr_GeoPot / MixLengthMax )
    
    ! Ȼλ
    ! Calculate diffusion constants
    !
    xyr_VelDiffCoeff = &
      &   xyr_MixLength**2 &
      &   * xyr_DVelDz &
      &   * sqrt ( MYLv2ParamB1 * ( 1.0_DP - xyr_FluxRiNum ) * xyr_TildeSm ) &
      &   * xyr_TildeSm
    
    xyr_TempDiffCoeff = &
      &   xyr_MixLength ** 2 &
      &   * xyr_DVelDz &
      &   * sqrt ( MYLv2ParamB1 * ( 1.0_DP - xyr_FluxRiNum ) * xyr_TildeSm ) &
      &   * xyr_TildeSh
    
    xyr_QvapDiffCoeff = xyr_TempDiffCoeff
    
    do k = 0, kmax-1
      do i = 0, imax-1
        do j = 1, jmax
          xyr_VelDiffCoeff(i,j,k) = &
            & max( min( xyr_VelDiffCoeff(i,j,k), VelDiffCoeffMax ), &
            &      VelDiffCoeffMin &
            &    )
          xyr_TempDiffCoeff(i,j,k) = &
            & max( min( xyr_TempDiffCoeff(i,j,k), TempDiffCoeffMax ), &
            &      TempDiffCoeffMin &
            &    )
          xyr_QvapDiffCoeff(i,j,k) = &
            & max( min( xyr_QvapDiffCoeff(i,j,k), QvapDiffCoeffMax ), &
            &      QvapDiffCoeffMin &
            &    )
        end do
      end do
    end do
    
    xyr_VelDiffCoeff(:,:,0)     = 0.0_DP
    xyr_TempDiffCoeff(:,:,0)    = 0.0_DP
    xyr_QvapDiffCoeff(:,:,0)    = 0.0_DP
    xyr_VelDiffCoeff(:,:,kmax)  = 0.0_DP
    xyr_TempDiffCoeff(:,:,kmax) = 0.0_DP
    xyr_QvapDiffCoeff(:,:,kmax) = 0.0_DP

  end subroutine VtclDiffCoefficient



  subroutine VtcllDiffInit
    !
    ! vdiffusion_my1974 ⥸塼νԤޤ. 
    ! NAMELIST#vdiffusion_my1974_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "vdiffusion_my1974" module is initialized. 
    ! "NAMELIST#vdiffusion_my1974_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /vdiffusion_my1974_nml/ &
      & RefPress, BasePotTemp, SquareVelMin, BulkRiNumMin, &
!
      & MixLengthMax, TildeShMin, TildeSmMin, &
      & VelDiffCoeffMin, TempDiffCoeffMin, QvapDiffCoeffMin, &
      & VelDiffCoeffMax, TempDiffCoeffMax, QvapDiffCoeffMax, &
!
      & MYLv2ParamA1, MYLv2ParamB1, MYLv2ParamA2, MYLv2ParamB2, MYLv2ParamC1
          !
          ! ǥեͤˤĤƤϽ³ "vdiffusion_my1974#VtcllDiffInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "vdiffusion_my1974#VtcllDiffInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( vdiffusion_my1974_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    RefPress        =   1.0e+6_DP
    BasePotTemp     =   300.0_DP
    SquareVelMin    =     0.1_DP
    BulkRiNumMin    = - 100.0_DP

    MixLengthMax     = 300.0_DP
    TildeShMin       =   0.0_DP
    TildeSmMin       =   0.0_DP
    VelDiffCoeffMin  =   0.1_DP
    TempDiffCoeffMin =   0.1_DP
    QvapDiffCoeffMin =   0.1_DP
    VelDiffCoeffMax  = 10000.0_DP
    TempDiffCoeffMax = 10000.0_DP
    QvapDiffCoeffMax = 10000.0_DP

    MYLv2ParamA1 =  0.92_DP
    MYLv2ParamB1 = 16.6_DP
    MYLv2ParamA2 =  0.74_DP
    MYLv2ParamB2 = 10.1_DP
    MYLv2ParamC1 =  0.08_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                   ! (in)
        & nml = vdiffusion_my1974_nml, &  ! (out)
        & iostat = iostat_nml )           ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = vdiffusion_my1974_nml )
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'UDiffFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'eastward wind flux by vertical diffusion', 'N m-2' )
    call HistoryAutoAddVariable( 'VDiffFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'northward wind flux by vertical diffusion', 'N m-2' )
    call HistoryAutoAddVariable( 'TempDiffFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'temperature flux by vertical diffusion', 'W m-2' )
    call HistoryAutoAddVariable( 'QVapDiffFlux', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'specific humidity flux by vertical diffusion', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'For vertical diffusion flux:' )
    call MessageNotify( 'M', module_name, '  RefPress     = %f', d = (/ RefPress /) )
    call MessageNotify( 'M', module_name, '  BasePotTemp  = %f', d = (/ BasePotTemp /) )
    call MessageNotify( 'M', module_name, '  SquareVelMin = %f', d = (/ SquareVelMin /) )
    call MessageNotify( 'M', module_name, '  BulkRiNumMin = %f', d = (/ BulkRiNumMin /) )
    call MessageNotify( 'M', module_name, 'For diffusion coefficients:' )
    call MessageNotify( 'M', module_name, '  MixLengthMax     = %f', d = (/ MixLengthMax     /) )
    call MessageNotify( 'M', module_name, '  TildeShMin       = %f', d = (/ TildeShMin       /) )
    call MessageNotify( 'M', module_name, '  TildeSmMin       = %f', d = (/ TildeSmMin       /) )
    call MessageNotify( 'M', module_name, '  VelDiffCoeffMin  = %f', d = (/ VelDiffCoeffMin  /) )
    call MessageNotify( 'M', module_name, '  TempDiffCoeffMin = %f', d = (/ TempDiffCoeffMin /) )
    call MessageNotify( 'M', module_name, '  QvapDiffCoeffMin = %f', d = (/ QvapDiffCoeffMin /) )
    call MessageNotify( 'M', module_name, '  VelDiffCoeffMax  = %f', d = (/ VelDiffCoeffMax  /) )
    call MessageNotify( 'M', module_name, '  TempDiffCoeffMax = %f', d = (/ TempDiffCoeffMax /) )
    call MessageNotify( 'M', module_name, '  QvapDiffCoeffMax = %f', d = (/ QvapDiffCoeffMax /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamA1     = %f', d = (/ MYLv2ParamA1     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamB1     = %f', d = (/ MYLv2ParamB1     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamA2     = %f', d = (/ MYLv2ParamA2     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamB2     = %f', d = (/ MYLv2ParamB2     /) )
    call MessageNotify( 'M', module_name, '  MYLv2ParamC1     = %f', d = (/ MYLv2ParamC1     /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    vdiffusion_my1974_inited = .true.
  end subroutine VtcllDiffInit



  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module vdiffusion_my1974
