!= ο
!
!= Remove negative moisture
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: negative_moist.f90,v 1.1 2008-08-11 17:23:37 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module negative_moist
  !
  != ο
  !
  != Remove negative moisture
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! οޤ.
  !
  ! Remove negative moisture
  !
  !== Procedures List
  !
  ! RemoveNegMoist   :: ον
  ! ---------------  :: ---------------
  ! RemoveNegMoist   :: Remove negative moisture
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#negative_moist_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RemoveNegMoist

  ! ѿ
  ! Public variables
  !
  logical, save, public:: negative_moist_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'negative_moist'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: negative_moist.f90,v 1.1 2008-08-11 17:23:37 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface RemoveNegMoist
    module procedure RemoveNegMoist
  end interface

contains

  subroutine RemoveNegMoist( &
    & xyz_QVap, xyz_DNegQVapDt, & ! (inout)
    & xyr_Press &                 ! (in)
    & )
    !
    ! *xyz_QVap* ͤޤ. 
    ! *xyz_DNegQVapDt* ˤ *xyz_QVap* Ѳ̤֤ޤ. 
    ! *xyz_DNegQVapDt* ϰʤΤ, Ѳ̤ͤ
    ! 褻֤ޤ. Ϥ줿ͤ *xyz_QVap* Ѳ̤
    ! ƶڤܤޤ. 
    !
    ! Remove negative values in *xyz_QVap*. 
    ! Variation of *xyz_QVap* is returned to *xyz_DNegQVapDt*. 
    ! So *xyz_DNegQVapDt* is input/output argument, variation is 
    ! added on input values. Input values do not have influence on
    ! variation of *xyz_QVap*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʬʿѤ
    ! Operation for integral and average
    !
    use intavr_operate, only: AvrLonLat_xy

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(inout):: xyz_DNegQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{q}{t} $ .  漾Ψ. 
                              ! Specific humidity correction
    real(DP), intent(in):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xy_QVapW (0:imax-1, 1:jmax)
                              ! 漾 (ѿ). 
                              ! Specific humidity (work variable). 

    real(DP):: xyz_DPressDz (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta p $
                              ! 
    real(DP):: xyz_QVapDPressDz (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q \Delta p $
                              ! 
    real(DP):: xyz_DelQVapDPressDz (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta q \Delta p $
                              ! 
    real(DP):: QVapDPressDzAvrLonLatSig
                              ! $ \int<q \Delta p>dz $
                              ! 
    real(DP):: DelQVapDPressDzAvrLonLatSig
                              ! $ \int<\Delta q \Delta p>dz $
                              ! 

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. negative_moist_inited ) call NegMoistInit

    ! Ĵ漾¸
    ! Save specific humidity before adjust
    !
    xyz_QVapB = xyz_QVap

    ! $ \Delta p $ η׻
    ! Calculate $ \Delta p $
    !
    do k = 1, kmax
      xyz_DPressDz(:,:,k) = xyr_Press(:,:,k-1) - xyr_Press(:,:,k)
    end do

    ! ɽǤ (ͤǲؤ)
    ! Correction at local (Negative values moved to botton layer)
    !
    xy_QVapW = 0.0_DP
    do k = kmax, 2, -1
      where ( xyz_QVap(:,:,k) < 0.0_DP )
        xy_QVapW = - xyz_QVap(:,:,k) &
          &          * xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
        xyz_QVap(:,:,k) = 0.0_DP
        xyz_QVap(:,:,k-1) = xyz_QVap(:,:,k-1) - xy_QVapW
      end where
    end do

    ! Ǥ
    ! Correction in global
    !

    ! ؤˤ̤λ
    ! Calculate amount of correction in each layer
    !
    xyz_QVapDPressDz = xyz_QVap * xyz_DPressDz
    where ( xyz_QVapDPressDz < 0.0_DP )
      xyz_DelQVapDPressDz = - xyz_QVapDPressDz
    elsewhere
      xyz_DelQVapDPressDz = 0.0_DP
    end where

    ! ̤̱ľʿ
    ! Zonal and meridional and vertical mean of amount of correction
    !
    QVapDPressDzAvrLonLatSig = 0.0_DP
    DelQVapDPressDzAvrLonLatSig = 0.0_DP

    do k = 1, kmax
      QVapDPressDzAvrLonLatSig = &
        &   QVapDPressDzAvrLonLatSig  &
        & + AvrLonLat_xy( xyz_QVapDPressDz(:,:,k) )

      DelQVapDPressDzAvrLonLatSig = &
        &   DelQVapDPressDzAvrLonLatSig  &
        & + AvrLonLat_xy( xyz_DelQVapDPressDz(:,:,k) )
    end do

    ! ͤ򥼥Ȥ, ʬΤ. 
    ! Minus values are brought back to zero, 
    !   and total is reduced by just that much
    !
    if ( QVapDPressDzAvrLonLatSig /= 0.0_DP ) then 
      xyz_QVap = &
        &   QVapDPressDzAvrLonLatSig &
        &   / ( QVapDPressDzAvrLonLatSig + DelQVapDPressDzAvrLonLatSig ) &
        &   * max( xyz_QVap, 0.0_DP )
    end if

    ! 漾Ѳλ
    ! Calculate specific humidity variance
    !
    xyz_DNegQVapDt = &
      &   xyz_DNegQVapDt + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RemoveNegMoist

  !-------------------------------------------------------------------

  subroutine NegMoistInit
    !
    ! negative_moist ⥸塼νԤޤ. 
    ! NAMELIST#negative_moist_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "negative_moist" module is initialized. 
    ! "NAMELIST#negative_moist_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /negative_moist_nml/
          !
          ! ǥեͤˤĤƤϽ³ "negative_moist#NegMoistInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "negative_moist#NegMoistInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( negative_moist_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = negative_moist_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    negative_moist_inited = .true.
  end subroutine NegMoistInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module negative_moist
