!= ٤Ⱦҥ٥, ȥݥƥ󥷥λ
!
!= Interpolate temperature on half sigma level, and calculate pressure and geo-potential
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: intpol_half.f90,v 1.2 2008-08-11 16:35:36 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module intpol_half
  !
  != ٤Ⱦҥ٥, ȥݥƥ󥷥λ
  !
  != Interpolate temperature on half sigma level, and calculate pressure and geo-potential
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Υ⥸塼Ǥ, 
  ! ٤Ⱦ $ \sigma $ ٥֤
  ! ȥݥƥ󥷥λФΤΥ֥롼󶡤ޤ.
  !
  ! This module provides subroutines that
  ! interpolate temperature on half $ \sigma $ level, or
  ! calculate pressure and geo-potential. 
  !
  !== Procedures List
  !
  ! IntpolHalfLevel  :: ٤Ⱦ $ \sigma $ ٥֤
  !                     ȥݥƥ󥷥λ
  ! ---------------  :: ---------------
  ! IntpolHalfLevel  :: Interpolate temperature on half $ \sigma $ level, 
  !                     and calculate pressure and geo-potential
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#intpol_half_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: IntpolHalfLevel

  ! ѿ
  ! Public variables
  !
  logical, save, public:: intpol_half_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  real(DP), allocatable:: z_TempInpolM (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature
  real(DP), allocatable:: z_TempInpol (:)
                              ! ٤Ѥη. 
                              ! Coefficient for interpolation of temperature

  character(*), parameter:: module_name = 'intpol_half'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: intpol_half.f90,v 1.2 2008-08-11 16:35:36 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface IntpolHalfLevel
    module procedure IntpolHalfLevel
  end interface

contains

  subroutine IntpolHalfLevel( &
    & xy_Ps,      xyz_Temp, &    ! (in)
    & xyr_Temp, &                ! (out)
    & xyz_Press,  xyr_Press, &   ! (out)
    & xyz_GeoPot, xyr_GeoPot &   ! (out)
    & )
    !
    ! ٤Ⱦҥ٥, ȥݥƥ󥷥λФԤޤ. 
    !
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and geo-potential. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma, &
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
      & r_DelSigma
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (Half)

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry               ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! 
    ! Time control
    !
    use timeset, only: TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xy_Ps       (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(out):: xyr_Temp   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T} $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(out):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out):: xyz_GeoPot (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP), intent(out):: xyr_GeoPot (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{\phi} $ . ݥƥ󥷥 (Ⱦ٥). 
                              ! Geo-potential (half level)


    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. intpol_half_inited ) call IntpolHalfInit

    ! ٤
    ! Interpolate temperature
    !
    do k = 2, kmax
      xyr_Temp(:,:,k-1) =   z_TempInpolM(k) * xyz_Temp(:,:,k-1)  &
        &                 + z_TempInpol (k) * xyz_Temp(:,:,k)
    end do

    xyr_Temp(:,:,kmax) = xyz_Temp(:,:,kmax)
    xyr_Temp(:,:,0)    = xyz_Temp(:,:,1)

    ! η׻
    ! Calculate pressure
    !
    do k = 1, kmax
      xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
    end do

    do k = 0, kmax
      xyr_Press(:,:,k) = xy_Ps * r_Sigma(k)
    end do

    ! ݥƥ󥷥η׻
    ! Calculate geo-potential
    !
    xyz_GeoPot(:,:,1) = &
      & GasRDry / Grav * xyz_Temp(:,:,1) * ( 1.0_DP - z_Sigma(1) )

    do k = 2, kmax
      xyz_GeoPot(:,:,k) = &
        &   xyz_GeoPot(:,:,k-1) &
        & + GasRDry / Grav * xyr_Temp(:,:,k-1) &
        &   * r_DelSigma(k-1) / r_Sigma(k-1)
    end do

    xyr_GeoPot = 0.0_DP
    do k = 1, kmax
      xyr_GeoPot(:,:,k) = &
        &   xyr_GeoPot(:,:,k-1) &
        & + GasRDry / Grav * xyz_Temp(:,:,k)  &
        &   * z_DelSigma(k) / z_Sigma(k)
    end do


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine IntpolHalfLevel

  !-------------------------------------------------------------------

  subroutine IntpolHalfInit
    !
    ! intpol_half ⥸塼νԤޤ. 
    ! NAMELIST#intpol_half_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "intpol_half" module is initialized. 
    ! "NAMELIST#intpol_half_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /intpol_half_nml/
          !
          ! ǥեͤˤĤƤϽ³ "intpol_half#IntpolHalfInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "intpol_half#IntpolHalfInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( intpol_half_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = intpol_half_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  Ѥηη׻
    !  Calculate coefficient for interpolation
    !
    allocate( z_TempInpolM(1:kmax) )
    allocate( z_TempInpol(1:kmax) )

    z_TempInpolM = 0.0_DP
    z_TempInpol = 0.0_DP

    do k = 2, kmax
      z_TempInpolM(k) = &
        &    ( log( r_Sigma( k-1 ) ) - log( z_Sigma( k ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k ) ) )
      z_TempInpol(k) = &
        &    ( log( z_Sigma( k-1 ) ) - log( r_Sigma( k-1 ) ) ) &
        &  / ( log( z_Sigma( k-1 ) ) - log( z_Sigma( k )   ) )
    end  do

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  z_TempInpolM = %*r', r = real( z_TempInpolM ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '  z_TempInpol  = %*r', r = real( z_TempInpol  ), n = (/ kmax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    intpol_half_inited = .true.
  end subroutine IntpolHalfInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module intpol_half
