!= ɽ̥եå (Х륯ˡ)
!
!= Surface flux (Bulk method)
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: surface_flux_bulk.f90,v 1.4 2008-08-12 08:53:43 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_flux_bulk
  !
  != ɽ̥եå
  !
  != Surface flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̥եå׻ޤ. 
  !
  ! Surface fluxes are calculated.
  !
  !== Procedures List
  !
  ! SurfaceFlux   :: ɽ̥եåη׻
  ! ------------  :: ------------
  ! SurfaceFlux   :: Calculate surface fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_flux_bulk_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SurfaceFlux

  ! ѿ
  ! Public variables
  !
  logical, save, public:: surface_flux_bulk_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !
  real(DP), save:: BasePotTemp
                            ! ܲ. 
                            ! Basic potential temperature
  real(DP), save:: VelMinForRi
                            ! $ R_i $ Ǿ. 
                            ! Minimum value of velocity for $ R_i $ number
  real(DP), save:: VelMinForVel
                            ! ưǾ. 
                            ! Minimum value of velocity for momentum
  real(DP), save:: VelMinForTemp
                            ! ǮǾ. 
                            ! Minimum value of velocity for thermal
  real(DP), save:: VelMinForQVap
                            ! Ǿ. 
                            ! Minimum value of velocity for vapor
  real(DP), save:: VelMaxForVel
                            ! ư. 
                            ! Maximum value of velocity for momentum
  real(DP), save:: VelMaxForTemp
                            ! Ǯ. 
                            ! Maximum value of velocity for thermal
  real(DP), save:: VelMaxForQVap
                            ! . 
                            ! Maximum value of velocity for vapor


  ! Х륯
  ! Bluk coefficients
  !
  logical, save:: Neutral
                            ! ΩǤ뤫ݤ. 
                            ! Whether it was neutral or not?
  real(DP), save:: ConstBulkCoeff
                            ! Х륯. 
                            ! Steady value of bulk coefficient
  real(DP), save:: VelBulkCoeffMin
                            ! $ u $ Х륯Ǿ. 
                            ! Minimum value of $ u $ bulk coefficient
  real(DP), save:: TempBulkCoeffMin
                            ! $ T $ Х륯Ǿ. 
                            ! Minimum value of $ T $ bulk coefficient
  real(DP), save:: QVapBulkCoeffMin
                            ! $ q $ Х륯Ǿ. 
                            ! Minimum value of $ q $ bulk coefficient
  real(DP), save:: VelBulkCoeffMax
                            ! $ u $ Х륯. 
                            ! Maximum value of $ u $ bulk coefficient
  real(DP), save:: TempBulkCoeffMax
                            ! $ T $ Х륯. 
                            ! Maximum value of $ T $ bulk coefficient
  real(DP), save:: QVapBulkCoeffMax
                            ! $ q $ Х륯. 
                            ! Maximum value of $ q $ bulk coefficient


  character(*), parameter:: module_name = 'surface_flux_bulk'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: surface_flux_bulk.f90,v 1.4 2008-08-12 08:53:43 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SurfaceFlux
    module procedure SurfaceFlux
  end interface

contains

  subroutine SurfaceFlux( &
    & xyz_U, xyz_V, xyz_Temp, xyr_Temp, xyz_QVap, &       ! (in)
    & xyz_Press, xyr_Press, xyz_GeoPot, &                 ! (in)
    & xy_SurfTemp, xy_SurfHumidCoeff, &                   ! (in)
    & xy_SurfRoughLength, xy_SurfCondition, &             ! (in)
    & xyr_UFlux, xyr_VFlux, xyr_TempFlux, xyr_QVapFlux, & ! (inout)
    & xy_SurfUVMtx, xyaa_SurfTempMtx, xyaa_SurfQVapMtx &  ! (out)
    & )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! ˰漾׻ (Nakajima et al., 1992)
    ! Evaluate saturation specific humidity (Nakajima et al., 1992)
    !
    use saturate_nha1992, only: CalcQVapSat, CalcDQVapSatDTemp

    ! 
    ! Time control
    !
    use timeset, only: Cstep, & ! ߤΥƥå׿. Current steps
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoPut

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind

    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyr_Temp (0:imax-1, 1:jmax, 0:kmax)
                              ! $ T $ .  (Ⱦ٥). 
                              ! Temperature (half level)
    real(DP), intent(in):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p_s $ . ɽ̵ (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(in):: xyz_GeoPot (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \phi $ . ݥƥ󥷥 (٥). 
                              ! Geo-potential (full level)
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_SurfHumidCoeff (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(in):: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    integer, intent(in):: xy_SurfCondition (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(inout):: xyr_UFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Eastward wind flux
    real(DP), intent(inout):: xyr_VFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ®եå. 
                              ! Northward wind flux
    real(DP), intent(inout):: xyr_TempFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(inout):: xyr_QVapFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(out):: xy_SurfUVMtx (0:imax-1, 1:jmax)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP), intent(out):: xyaa_SurfTempMtx (0:imax-1, 1:jmax, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP), intent(out):: xyaa_SurfQVapMtx (0:imax-1, 1:jmax, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface


    ! ѿ
    ! Work variables
    !
    real(DP):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $ number
    real(DP):: xy_SurfTempTransCoeff (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP):: xy_SurfQVapTransCoeff (0:imax-1, 1:jmax)
                              ! ͢漾. 
                              ! Transfer coefficient: specific humidity
    real(DP):: xy_SurfVelTransCoeff (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP):: xy_SurfTempBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯. 
                              ! Bulk coefficient: temperature
    real(DP):: xy_SurfQVapBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯漾. 
                              ! Bulk coefficient: specific humidity
    real(DP):: xy_SurfVelBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯ư. 
                              ! Bulk coefficient: temperature
    real(DP):: xy_SurfExner (0:imax-1, 1:jmax)
                              ! Exner ؿ. 
                              ! Exner function
    real(DP):: xy_SurfVelAbs (0:imax-1, 1:jmax)
                              ! ®. 
                              ! Absolute velocity
    real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
                              ! ɽ˰漾. 
                              ! Saturated specific humidity on surface
    real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
                              ! ɽ˰漾Ѳ. 
                              ! Saturated specific humidity tendency on surface

    real(DP):: xy_UFluxSurf (0:imax-1, 1:jmax)
                              ! ɽ̤®եå. 
                              ! Eastward wind flux on surface
    real(DP):: xy_VFluxSurf (0:imax-1, 1:jmax)
                              ! ɽ̤®եå. 
                              ! Northward wind flux on surface
    real(DP):: xy_TempFluxSurf (0:imax-1, 1:jmax)
                              ! ɽ̤β٥եå. 
                              ! Temperature flux on surface
    real(DP):: xy_QVapFluxSurf (0:imax-1, 1:jmax)
                              ! ɽ̤漾եå. 
                              ! Specific humidity flux on surface

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. surface_flux_bulk_inited ) call SurfFluxInit

    ! Exner ؿ
    ! Calculate Exner functions
    !
    xy_SurfExner = ( xyz_Press(:,:,1) / xyr_Press(:,:,0)  )**( GasRDry / CpDry )

    ! Х륯 $ R_i $ 
    ! Calculate bulk $ R_i $
    !
    do i = 0, imax-1
      do j = 1, jmax
        xy_SurfVelAbs(i,j) = sqrt ( xyz_U(i,j,1)**2 + xyz_V(i,j,1)**2 )

        xy_SurfBulkRiNum(i,j) = &
          &   Grav / BasePotTemp &
          &   * ( xyz_Temp(i,j,1) / xy_SurfExner(i,j) - xy_SurfTemp(i,j)  ) &
          &     / max( xy_SurfVelAbs(i,j), VelMinForRi )**2 &
          &       * xyz_GeoPot(i,j,1)
      end do
    end do
    
    ! Х륯
    ! Calculate bulk coefficients
    !
    call BulkCoeff( &
      & xy_SurfBulkRiNum, &     ! (in)
!!$      & xy_SurfVelAbs, &        ! (in)
      & xy_SurfRoughLength, &   ! (in)
      & xy_SurfRoughLength, &   ! (in)
      & xyz_GeoPot(:,:,1), &    ! (in)
      & xy_SurfVelBulkCoeff, &  ! (out)
      & xy_SurfTempBulkCoeff, & ! (out)
      & xy_SurfQVapBulkCoeff )  ! (out)

    ! ͢η׻
    ! Calculate transfer coefficient
    !
    do i = 0, imax-1
      do j = 1, jmax
        
        xy_SurfVelTransCoeff(i,j) = &
          &   xy_SurfVelBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForVel ), VelMaxForVel )
        
        xy_SurfTempTransCoeff(i,j) = &
          &   xy_SurfTempBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForTemp ), VelMaxForTemp )
        
        xy_SurfQVapTransCoeff(i,j) = &
          &   xy_SurfQVapBulkCoeff(i,j) &
          &   * xyr_Press(i,j,0) / ( GasRDry * xyr_Temp(i,j,0) ) &
          &   * min( max( xy_SurfVelAbs(i,j), VelMinForQVap ), VelMaxForQVap )
        
      end do
    end do
    
    ! ˰漾η׻
    ! Calculate saturated specific humidity
    !
    call CalcQVapSat( &
      & xy_SurfTemp, xyr_Press(:,:,0), & ! (in)
      & xy_SurfQVapSat )                 ! (out)

    call CalcDQVapSatDTemp( &
      & xy_SurfTemp, xyr_Press(:,:,0), & ! (in)
      & xy_SurfDQVapSatDTemp )           ! (out)

!!$    xy_SurfQVapSat = &
!!$      &   EpsV * ES0  &
!!$      &   * exp( LatentHeat / RVap * ( 1.0_DP / 273.0_DP - 1.0_DP / xy_SurfTemp ) ) &
!!$      &   / xyr_Press(:,:,0)
!!$
!!$    xy_SurfDQVapSatDTemp = &
!!$      &   LatentHeat * xy_SurfQVapSat &
!!$      &   / ( RVap * xy_SurfTemp * xy_SurfTemp )

    ! ɽ̥եåη׻
    ! Calculate fluxes on flux
    !
    xy_UFluxSurf    = - xy_SurfVelTransCoeff * xyz_U(:,:,1)
    xy_VFluxSurf    = - xy_SurfVelTransCoeff * xyz_V(:,:,1)
    xy_TempFluxSurf =   CpDry * xy_SurfTempTransCoeff &
      &                   * (   xy_SurfTemp           &
      &                       - xyz_Temp(:,:,1) / xy_SurfExner )
    xy_QVapFluxSurf =   LatentHeat * xy_SurfQVapTransCoeff &
      &                   * xy_SurfHumidCoeff &
      &                   * ( xy_SurfQVapSat - xyz_QVap(:,:,1) )

    ! եåη׻
    ! Calculate fluxes
    !
    xyr_UFlux(:,:,0)    = xyr_UFlux(:,:,0)    + xy_UFluxSurf
    xyr_VFlux(:,:,0)    = xyr_VFlux(:,:,0)    + xy_VFluxSurf
    xyr_TempFlux(:,:,0) = xyr_TempFlux(:,:,0) + xy_TempFluxSurf
    xyr_QVapFlux(:,:,0) = xyr_QVapFlux(:,:,0) + xy_QVapFluxSurf

!!$    xyr_UFlux(:,:,0) =   xyr_UFlux(:,:,0) &
!!$      &                - xy_SurfVelTransCoeff * xyz_U(:,:,1)
!!$
!!$    xyr_VFlux(:,:,0) =   xyr_VFlux(:,:,0) &
!!$      &                - xy_SurfVelTransCoeff * xyz_V(:,:,1)
!!$
!!$    xyr_TempFlux(:,:,0) =   xyr_TempFlux(:,:,0) &
!!$      &                   + CpDry * xy_SurfTempTransCoeff &
!!$      &                     * (   xy_SurfTemp           &
!!$      &                         - xyz_Temp(:,:,1) / xy_SurfExner )
!!$
!!$    xyr_QVapFlux(:,:,0) =   xyr_QVapFlux(:,:,0) &
!!$      &                   + LatentHeat * xy_SurfQVapTransCoeff * xy_SurfHumidCoeff &
!!$      &                     * ( xy_SurfQVapSat - xyz_QVap(:,:,1) )
    
    ! η׻
    ! Calculate implicit matrices
    !
    xyaa_SurfTempMtx = 0.0_DP
    xyaa_SurfQVapMtx = 0.0_DP
    
    xy_SurfUVMtx = xy_SurfVelTransCoeff
    
    xyaa_SurfTempMtx(:,:,1,0) =   CpDry * xy_SurfTempTransCoeff / xy_SurfExner
    xyaa_SurfTempMtx(:,:,0,1) = - CpDry * xy_SurfTempTransCoeff / xy_SurfExner
    
    xyaa_SurfQVapMtx(:,:,1,0) =   CpDry * xy_SurfQVapTransCoeff * xy_SurfHumidCoeff
    xyaa_SurfQVapMtx(:,:,0,1) = - CpDry * xy_SurfQVapTransCoeff * xy_SurfHumidCoeff
    
    do i = 0, imax-1
      do j = 1, jmax
        if ( xy_SurfCondition(i,j) >= 1 ) then
          
          xyaa_SurfTempMtx(i,j,1,-1) = - CpDry * xy_SurfTempTransCoeff(i,j)
          xyaa_SurfTempMtx(i,j,0,0)  =   CpDry * xy_SurfTempTransCoeff(i,j)
          
          xyaa_SurfQVapMtx(i,j,1,-1) = &
            & - LatentHeat * xy_SurfQVapTransCoeff(i,j) &
            &   * xy_SurfHumidCoeff(i,j) * xy_SurfDQVapSatDTemp(i,j)

          xyaa_SurfQVapMtx(i,j,0,0)  =   &
            &   LatentHeat * xy_SurfQVapTransCoeff(i,j) &
            &   * xy_SurfHumidCoeff(i,j) * xy_SurfDQVapSatDTemp(i,j)
          
        end if
      end do
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( 'UFluxSurf', xy_UFluxSurf )
    call HistoryAutoPut( 'VFluxSurf', xy_VFluxSurf )
    call HistoryAutoPut( 'TempFluxSurf', xy_TempFluxSurf )
    call HistoryAutoPut( 'QVapFluxSurf', xy_QVapFluxSurf )

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SurfaceFlux

  !-------------------------------------------------------------------

  subroutine BulkCoeff( &
    & xy_SurfBulkRiNum, &       ! (in)
!!$    & xy_SurfVelAbs, &          ! (in)
    & xy_SurfVelRoughLength, &  ! (in)
    & xy_SurfTempRoughLength, & ! (in)
    & xy_SurfGeoPot, &          ! (in)
    & xy_SurfVelBulkCoeff, &    ! (out)
    & xy_SurfTempBulkCoeff, &   ! (out)
    & xy_SurfQVapBulkCoeff &    ! (out)
    & )
    !
    ! Х륯򻻽Фޤ.
    !
    ! Bulk coefficients are calculated.
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & FKarm                 ! $ k $ .
                              ! ޥ. 
                              ! Karman constant

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_SurfBulkRiNum (0:imax-1, 1:jmax)
                              ! Х륯 $ R_i $ . 
                              ! Bulk $ R_i $ number

!!$    real(DP), intent(in):: xy_SurfVelAbs (0:imax-1, 1:jmax)
!!$                              ! ®. 
!!$                              ! Absolute velocity
    real(DP), intent(in):: xy_SurfVelRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ (ư). 
                              ! Surface rough length (momentum)
    real(DP), intent(in):: xy_SurfTempRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ (Ǯ). 
                              ! Surface rough length (thermal)
    real(DP), intent(in):: xy_SurfGeoPot (0:imax-1, 1:jmax)
                              ! $ \phi $ . ݥƥ󥷥 (ɽ). 
                              ! Geo-potential (on surface)
    real(DP), intent(out):: xy_SurfVelBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯ư. 
                              ! Bulk coefficient: temperature
    real(DP), intent(out):: xy_SurfTempBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯. 
                              ! Bulk coefficient: temperature
    real(DP), intent(out):: xy_SurfQVapBulkCoeff (0:imax-1, 1:jmax)
                              ! Х륯漾. 
                              ! Bulk coefficient: specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !

    ! ΩХ륯η׻
    ! Calculate neutral bulk coefficients
    !
    if ( ConstBulkCoeff < 0.0_DP ) then
      
      xy_SurfVelBulkCoeff  = &
        & ( FKarm / log ( xy_SurfGeoPot / xy_SurfVelRoughLength ) )**2

      xy_SurfTempBulkCoeff = &
        & ( FKarm / log ( xy_SurfGeoPot / xy_SurfTempRoughLength ) )**2

      xy_SurfQVapBulkCoeff = xy_SurfTempBulkCoeff
      
    else
      xy_SurfVelBulkCoeff  = ConstBulkCoeff
      xy_SurfTempBulkCoeff = ConstBulkCoeff
      xy_SurfQVapBulkCoeff = ConstBulkCoeff
    end if
    
    ! ΩХ륯η׻
    ! Calculate non-neutral bulk coefficients
    !
    if ( .not. Neutral ) then
      
      do i = 0, imax-1
        do j = 1, jmax

          if ( xy_SurfBulkRiNum(i,j) > 0.0_DP ) then 

            xy_SurfVelBulkCoeff(i,j) = &
              &   xy_SurfVelBulkCoeff(i,j) &
              &   / (   1.0_DP &
              &       + 10.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) ) &
              &     )

            xy_SurfTempBulkCoeff(i,j) = &
              &   xy_SurfTempBulkCoeff(i,j) &
              &   / (   1.0_DP &
              &       + 15.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) ) )

            xy_SurfQVapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)

          else

            xy_SurfVelBulkCoeff(i,j) = &
              &   xy_SurfVelBulkCoeff(i,j) &
              &   * (   1.0_DP &
              &       - 10.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / (   1.0_DP &
              &             + 75.0_DP * xy_SurfVelBulkCoeff(i,j) &
              &               * sqrt( - xy_SurfGeoPot(i,j) &
              &                         / xy_SurfVelRoughLength(i,j) &
              &                         * xy_SurfBulkRiNum(i,j) &
              &                     ) &
              &           ) &
              &     )
            
            xy_SurfTempBulkCoeff(i,j) = &
              &   xy_SurfTempBulkCoeff(i,j) &
              &   * (   1.0_DP &
              &       - 15.0_DP * xy_SurfBulkRiNum(i,j) &
              &         / (   1.0_DP &
              &             + 75.0_DP * xy_SurfTempBulkCoeff(i,j) &
              &               * sqrt( - xy_SurfGeoPot(i,j) &
              &                         / xy_SurfTempRoughLength(i,j) &
              &                         * xy_SurfBulkRiNum(i,j) &
              &                     ) &
              &           ) &
              &     )

            xy_SurfQVapBulkCoeff(i,j) = xy_SurfTempBulkCoeff(i,j)

          end if
        end do
      end do
      
    end if
    
    ! /Ǿ Ƚ
    ! Measure maximum/minimum
    !
    do i = 0, imax-1
      do j = 1, jmax

        xy_SurfVelBulkCoeff(i,j)  = &
          & max( min( xy_SurfVelBulkCoeff(i,j), VelBulkCoeffMax ), &
          &      VelBulkCoeffMin )

        xy_SurfTempBulkCoeff(i,j) = &
          & max( min( xy_SurfTempBulkCoeff(i,j), TempBulkCoeffMax ), &
          &      TempBulkCoeffMin )

        xy_SurfQVapBulkCoeff(i,j) = &
          & max( min( xy_SurfQVapBulkCoeff(i,j), QVapBulkCoeffMax ), &
          &      QVapBulkCoeffMin )

      end do
    end do

  end subroutine BulkCoeff

  !-------------------------------------------------------------------

  subroutine SurfFluxInit
    !
    ! surface_flux_bulk ⥸塼νԤޤ. 
    ! NAMELIST#surface_flux_bulk_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "surface_flux_bulk" module is initialized. 
    ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetIntStepEval

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gt4_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_flux_bulk_nml/ &
      & VelMinForRi, VelMinForVel, VelMinForTemp, VelMinForQVap, &
      & VelMaxForVel, VelMaxForTemp, VelMaxForQVap, &
! 
      & Neutral, ConstBulkCoeff, &
      & VelBulkCoeffMin, TempBulkCoeffMin, QVapBulkCoeffMin, &
      & VelBulkCoeffMax, TempBulkCoeffMax, QVapBulkCoeffMax
          !
          ! ǥեͤˤĤƤϽ³ "surface_flux_bulk#SurfFluxInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_flux_bulk#SurfFluxInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( surface_flux_bulk_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    BasePotTemp   = 300.0_DP
    VelMinForRi   = 0.01_DP
    VelMinForVel  = 0.01_DP
    VelMinForTemp = 0.01_DP
    VelMinForQVap = 0.01_DP
    VelMaxForVel  = 1000.0_DP
    VelMaxForTemp = 1000.0_DP
    VelMaxForQVap = 1000.0_DP

    Neutral          = .false.
    ConstBulkCoeff   = -1.0_DP
    VelBulkCoeffMin  =  0.0_DP
    TempBulkCoeffMin =  0.0_DP
    QVapBulkCoeffMin =  0.0_DP
    VelBulkCoeffMax  =  1.0_DP
    TempBulkCoeffMax =  1.0_DP
    QVapBulkCoeffMax =  1.0_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = surface_flux_bulk_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'UFluxSurf' , &
      & (/ 'lon ', 'lat ', 'time'/), &
      & 'eastward wind flux by surface process', 'N m-2' )

    call HistoryAutoAddVariable( 'VFluxSurf' , &
      & (/ 'lon ', 'lat ', 'time'/), &
      & 'northward wind flux by surface process', 'N m-2' )

    call HistoryAutoAddVariable( 'TempFluxSurf' , &
      & (/ 'lon ', 'lat ', 'time'/), &
      & 'temperature flux by surface process', 'W m-2' )

    call HistoryAutoAddVariable( 'QVapFluxSurf' , &
      & (/ 'lon ', 'lat ', 'time'/), &
      & 'specific humidity flux by surface process', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

    call MessageNotify( 'M', module_name, '  VelMinForRi   = %f', d = (/ VelMinForRi   /) )
    call MessageNotify( 'M', module_name, '  VelMinForVel  = %f', d = (/ VelMinForVel  /) )
    call MessageNotify( 'M', module_name, '  VelMinForTemp = %f', d = (/ VelMinForTemp /) )
    call MessageNotify( 'M', module_name, '  VelMinForQVap = %f', d = (/ VelMinForQVap /) )
    call MessageNotify( 'M', module_name, '  VelMaxForVel  = %f', d = (/ VelMaxForVel  /) )
    call MessageNotify( 'M', module_name, '  VelMaxForTemp = %f', d = (/ VelMaxForTemp /) )
    call MessageNotify( 'M', module_name, '  VelMaxForQVap = %f', d = (/ VelMaxForQVap /) )

    call MessageNotify( 'M', module_name, 'Bulk coefficients:' )
    call MessageNotify( 'M', module_name, '  Neutral          = %b', l = (/ Neutral          /) )
    call MessageNotify( 'M', module_name, '  ConstBulkCoeff   = %f', d = (/ ConstBulkCoeff   /) )
    call MessageNotify( 'M', module_name, '  VelBulkCoeffMin  = %f', d = (/ VelBulkCoeffMin  /) )
    call MessageNotify( 'M', module_name, '  TempBulkCoeffMin = %f', d = (/ TempBulkCoeffMin /) )
    call MessageNotify( 'M', module_name, '  QVapBulkCoeffMin = %f', d = (/ QVapBulkCoeffMin /) )
    call MessageNotify( 'M', module_name, '  VelBulkCoeffMax  = %f', d = (/ VelBulkCoeffMax  /) )
    call MessageNotify( 'M', module_name, '  TempBulkCoeffMax = %f', d = (/ TempBulkCoeffMax /) )
    call MessageNotify( 'M', module_name, '  QVapBulkCoeffMax = %f', d = (/ QVapBulkCoeffMax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_flux_bulk_inited = .true.
  end subroutine SurfFluxInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module surface_flux_bulk
