!= 
!
!= Time control
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: timeset.f90,v 1.1.1.1 2008-07-30 08:41:33 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timeset
  !
  != 
  !
  != Time control
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! δԤޤ. 
  !
  ! Information of time is controlled. 
  !
  !== Variables List
  !
  ! Nstep        :: ƥå׿
  ! Cstep        :: ߤΥƥå׿
  ! DelTime      :: $ \Delta t $ [s]
  ! ------------ :: ------------
  ! Nstep        :: Number of full steps
  ! Cstep        :: Current steps
  ! DelTime      :: $ \Delta t $ [s]
  !
  !== Procedures List
  !
  ! TimesetInit           :: timeset ⥸塼ν
  ! TimesetClose          :: timeset ⥸塼νλ
  ! TimesetProgress       :: οʹ
  ! TimesetClockStart     :: ׻ַ¬
  ! TimesetClockStop      :: ׻ַװ
  ! TimesetIntStepEval    :: ƥå״ֳָѤ
  ! TimesetGetStartTime   :: ׻ϻμ
  ! TimesetGetEndTime     :: ׻λμ
  ! TimesetGetDelTime     :: $ \Delta t $ μ
  ! TimesetGetCurrentTime :: ߻μ
  ! ------------          :: ------------
  ! TimesetInit           :: Initialize "timeset" module
  ! TimesetClose          :: Terminate "timeset" module
  ! TimesetProgress       :: Progress time
  ! TimesetClockStart     :: Start measurement of computation time
  ! TimesetClockStop      :: Pause measurement of computation time
  ! TimesetIntStepEval    :: Eval interval of step
  ! TimesetGetStartTime   :: Get start time of calculation
  ! TimesetGetEndTime     :: Get end time of calculation
  ! TimesetGetDelTime     :: Get $ \Delta t $
  ! TimesetGetCurrentTime :: Get current time
  !
  !== NAMELIST
  !
  ! NAMELIST#timeset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &  ! ټ¿. Double precision. 
    &                 TOKEN  ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time

  ! CPU ַ¬
  ! CPU time monitor
  !
  use dc_clock, only: CLOCK

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: TimesetInit, TimesetClose, TimesetProgress
  public:: TimesetClockStart, TimesetClockStop
  public:: TimesetIntStepEval
  public:: TimesetGetStartTime, TimesetGetEndTime, TimesetGetDelTime
  public:: TimesetGetCurrentTime

  ! ѿ
  ! Public variables
  !
  logical, save, public:: timeset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  integer, save, public:: Nstep
                              ! ƥå׿. Number of full steps
  integer, save, public:: Cstep
                              ! ߤΥƥå׿. Current steps
  real(DP), save, public:: DelTime
                              ! $ \Delta t $ [s]

  ! ѿ
  ! Private variables
  !
  real(DP), save:: StartTimeValue
                              ! ׻ϻ. 
                              ! Start time of calculation
  character(TOKEN), save:: StartTimeUnit
                              ! ׻ϻñ. 
                              ! Unit of start time of calculation

  real(DP), save:: EndTimeValue
                              ! ׻λ. 
                              ! End time of calculation
  character(TOKEN), save:: EndTimeUnit
                              ! ׻ϻñ. 
                              ! Unit of end time of calculation

  real(DP), save:: DelTimeValue
                              ! $ \Delta t $ .  ñ̤ DelTimeUnit ˤƻ.
                              ! Unit is specified by "DelTimeUnit". 
  character(TOKEN), save:: DelTimeUnit
                              ! $ \Delta t $ ñ. 
                              ! Unit of $ \Delta t $ 

  integer, save:: PredictIntStep
                              ! λͽ¬ɽֳ֥ƥå׿. 
                              ! Interval steps of predicted end time output
  real(DP), save:: PredictIntValue
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output
  character(TOKEN), save:: PredictIntUnit
                              ! λͽ¬ɽֳ (ñ). 
                              ! Unit for interval of predicted end time output

  type(DC_DIFFTIME), save:: DCdiffCurrentTime
                              ! ߤ. 
                              ! Current date and time
  type(DC_DIFFTIME), save:: DCdiffDelTime
                              ! $ \Delta t $ 

  logical, save:: CpuTimeMoniter
                              ! CPU ַ¬Υ󥪥
                              ! On/off of CPU time monitoring

  integer, parameter:: clkmax = 64
                              ! CPU ַ¬Ԥץκ. 
                              ! Maximum number of processes monitored CPU time
  integer, save:: clk_proc_num = 0
                              ! CPU ַ¬ԤäƤץο. 
                              ! Number of processes monitored CPU time
  type(CLOCK), save:: clocks(1:clkmax)
                              ! CPU ַ¬ѹ¤
                              ! Derived type for monitoring CPU time
  character(TOKEN), save:: clocks_name(1:clkmax) = ''
                              ! CPU ַ¬ԤäƤץ̾
                              ! Names of processes monitored CPU time

  character(*), parameter:: module_name = 'timeset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: timeset.f90,v 1.1.1.1 2008-07-30 08:41:33 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface TimesetInit
    module procedure TimesetInit
  end interface

  interface TimesetClose
    module procedure TimesetClose
  end interface

  interface TimesetProgress
    module procedure TimesetProgress
  end interface

  interface TimesetIntStepEval
    module procedure TimesetIntStepEval
  end interface

  interface TimesetClockStart
    module procedure TimesetClockStart
  end interface

  interface TimesetClockStop
    module procedure TimesetClockStop
  end interface

contains

  !-------------------------------------------------------------------

  subroutine TimesetInit
    !
    ! timeset ⥸塼νԤޤ. 
    ! NAMELIST#timeset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "timeset" module is initialized. 
    ! NAMELIST#timeset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    type(DC_DIFFTIME):: dcdiff_start
                              ! ׻ϻ. 
                              ! Start time of calculation
    type(DC_DIFFTIME):: dcdiff_end
                              ! ׻λ. 
                              ! End time of calculation
    type(DC_DIFFTIME):: dcdiff_delt
                              ! $ \Delta t $
    type(DC_DIFFTIME):: dcdiff_predict
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /timeset_nml/ &
      & StartTimeValue,  StartTimeUnit, &
      & EndTimeValue,    EndTimeUnit, &
      & DelTimeValue,    DelTimeUnit, &
      & PredictIntValue, PredictIntUnit, &
      & CpuTimeMoniter
          !
          ! ǥեͤˤĤƤϽ³ "timeset#TimesetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "timeset#TimesetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( timeset_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    Nstep = 0
    Cstep = 0

    StartTimeValue = 0.0_DP
    StartTimeUnit = 'day'

    EndTimeValue = 7.0_DP
    EndTimeUnit = 'day'

    DelTime = 180.0_DP
    DelTimeValue = 30.0_DP
    DelTimeUnit = 'min'

    PredictIntStep = 1
    PredictIntValue = 1.0_DP
    PredictIntUnit = 'day'

    CpuTimeMoniter = .true.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = timeset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = timeset_nml )
    end if

    ! DC_DIFFTIME ѿ
    ! Configure DC_DIFFTIME type variables
    !
    call DCDiffTimeCreate( dcdiff_start, &    ! (out)
      & StartTimeValue, StartTimeUnit )       ! (in)
    call DCDiffTimeCreate( dcdiff_end, &      ! (out)
      & EndTimeValue, EndTimeUnit )           ! (in)
    call DCDiffTimeCreate( dcdiff_delt, &     ! (out)
      & DelTimeValue, DelTimeUnit )           ! (in)
    call DCDiffTimeCreate( dcdiff_predict, &  ! (out)
      & PredictIntValue, PredictIntUnit)      ! (in)

    ! Υå
    ! Check validation of time
    !
    call TimeValidCheck( &
      & dcdiff_start, dcdiff_end, dcdiff_delt, dcdiff_predict & ! (in)
      & )

    ! ƥå׿
    ! Calculate number of full steps
    !
    Nstep = int( ( dcdiff_end - dcdiff_start ) / dcdiff_delt )
    Nstep = Nstep + 1

    ! $ \Delta t $ [s] 
    ! Calculate $ \Delta t $ [s] 
    !
    DelTime = EvalSec( dcdiff_delt )

    ! λͽ¬ɽֳ֥ƥå׿
    ! Calculate interval steps of predicted end time output
    PredictIntStep = int( dcdiff_predict / dcdiff_delt )
    PredictIntStep = max( PredictIntStep, 1 )

    ! DC_DIFFTIME ѿ
    ! Configure DC_DIFFTIME type variables
    !
    call DCDiffTimeCreate( DCdiffCurrentTime, &    ! (out)
      & StartTimeValue, StartTimeUnit )            ! (in)
    call DCDiffTimeCreate( DCdiffDelTime, &    ! (out)
      & DelTimeValue, DelTimeUnit )            ! (in)

    ! CPU ַ¬ (ǥ)
    ! Start CPU time monitoring (for entire model)
    !
    if ( CpuTimeMoniter ) then
      call DCClockCreate( clocks(clk_proc_num + 1), 'total' ) ! (in)
      call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
      clocks_name(clk_proc_num + 1) = 'total'
      clk_proc_num = clk_proc_num + 1
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  Nstep = %d', i = (/ Nstep /) )
    call MessageNotify( 'M', module_name, '  StartTime  = %f [%c]', &
      & d = (/ StartTimeValue /), c1 = trim(StartTimeUnit) )
    call MessageNotify( 'M', module_name, '  EndTime    = %f [%c]', &
      & d = (/ EndTimeValue /), c1 = trim(EndTimeUnit) )
    call MessageNotify( 'M', module_name, '  DelTime    = %f [%c]', &
      & d = (/ DelTimeValue /), c1 = trim(DelTimeUnit) )
    call MessageNotify( 'M', module_name, '             = %f [%c]', &
      & d = (/ DelTime /), c1 = 'sec' )
    call MessageNotify( 'M', module_name, '  PredictInt = %f [%c]', &
      & d = (/ PredictIntValue /), c1 = trim(PredictIntUnit) )
    call MessageNotify( 'M', module_name, '  PredictIntStep = %d', &
      & i = (/ PredictIntStep /) )
    call MessageNotify( 'M', module_name, '  CpuTimeMoniter = %b', &
      & l = (/ CpuTimeMoniter /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    Cstep = 1
    timeset_inited = .true.
  end subroutine TimesetInit

  !-------------------------------------------------------------------

  subroutine TimesetProgress
    !
    ! timeset ⥸塼λʤޤ. 
    ! ޤ, TimesetProgress#PredictIntStep ꤵ줿ͤ˱, 
    ! ߤޤǤη׻֤ȷ׻λͽ¬ɽޤ. 
    !
    ! Progress time configured in "timeset" module. 
    ! And, computation time until now and 
    ! predicted end of computation time are printed 
    ! according to configured "TimesetProgress#PredictIntStep"
    !

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockPredict, DCClockStop, DCClockClose, &
      & operator(+), operator(-)

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: operator(==), operator(+)

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    type(CLOCK):: clock_tmp

    ! ¹ʸ ; Executable statement
    !

    ! λͽ¬ɽ
    ! Print predicted end time
    !
    if ( mod( Cstep, PredictIntStep ) == 0 ) then
      if ( CpuTimeMoniter ) then
        clock_tmp = clocks(1)
        call DCClockStop( clock_tmp ) ! (in)
        call DCClockPredict( &
          & clock_tmp, real(Cstep) / real(Nstep) ) ! (in)
        call DCClockClose( clock_tmp ) ! (in)
      else
        call MessageNotify( 'M', module_name, &
          & ' Current/Total = [ %d / %d ]', i = (/ Cstep, Nstep /) )
      end if
    end if

    ! οʹ
    ! Progress time
    !
    Cstep = Cstep + 1
    DCdiffCurrentTime = DCdiffCurrentTime + DCdiffDelTime
  end subroutine TimesetProgress

  !-------------------------------------------------------------------

  subroutine TimesetClose
    !
    ! ׻֤פɽޤ. 
    !
    ! Total computation time is printed. 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop, DCClockResult, DCClockSetName, &
      & operator(+), operator(-)

    ! ʸ ; Declaration statements
    !
    implicit none
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    ! CPU ַ¬λ (ǥ)
    ! Stop CPU time monitoring (for entire model)
    !
    call DCClockStop( clocks(1) ) ! (in)

    ! ֤¾פ CPU ֤򻻽
    ! Calculate CPU time of "Others"
    !
    clocks(clk_proc_num + 1) = clocks(1)
    do i = 2, clk_proc_num
      clocks(clk_proc_num + 1) = clocks(clk_proc_num + 1) - clocks(i)
    end do
    call DCClockSetName( clocks(clk_proc_num + 1), 'others' )

    ! CPU ֤פɽ
    ! Print total CPU time
    !
    call DCClockResult( &
      & clocks(2:clk_proc_num + 1), total_auto = .true. ) ! (in)

  end subroutine TimesetClose

  !-------------------------------------------------------------------

  subroutine TimesetClockStart( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬򳫻Ϥޤ. 
    !
    ! Start measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockCreate, DCClockStart

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStart( clocks(i) ) ! (in)
        return
      end if
    end do

    call DCClockCreate( clocks(clk_proc_num + 1), name ) ! (in)
    call DCClockStart( clocks(clk_proc_num + 1) ) ! (in)
    clocks_name(clk_proc_num + 1) = name
    clk_proc_num = clk_proc_num + 1

  end subroutine TimesetClockStart

  !-------------------------------------------------------------------

  subroutine TimesetClockStop( name & ! (in)
    & )
    !
    ! ץñ (˥⥸塼) Ȥλַ¬ߤޤ.
    !
    ! Pause measurement of computation time by program unit
    ! (expected modules). 

    ! ⥸塼 ; USE statements
    !

    ! CPU ַ¬
    ! CPU time monitor
    !
    use dc_clock, only: DCClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), intent(in):: name
                              ! ⥸塼̾. 
                              ! Name of module

    ! ѿ
    ! Work variables
    !
    integer:: i               ! clocks, clocks_name  DO 롼Ѻѿ
                              ! Work variables for DO loop for "clocks", "clocks_name"

    ! ¹ʸ ; Executable statement
    !

    if ( .not. CpuTimeMoniter ) return

    do i = 1, clk_proc_num
      if ( trim(clocks_name(i)) == trim(name) ) then
        call DCClockStop( clocks(i) ) ! (in)
        return
      end if
    end do

    call MessageNotify( 'W', module_name, ' name "%c" is not found in "TimesetClockStop"', c1 = trim(name) )

  end subroutine TimesetClockStop

  !-------------------------------------------------------------------

  subroutine TimesetIntStepEval( &
    & DelTime_Value, DelTime_Unit, & ! (in)
    & IntStep &                      ! (out)
    & )
    !
    ! Ϳ줿 DelTime_Value  DelTime_Unit 
    ! timeset ⥸塼¸Ƥ $ \Delta t $ ǳ, η̤
    ! ƥå״ֳ֤Ȥ IntStep ֤ޤ. 
    !
    ! 1 ʲˤʤˤ 1 ֤ޤ. 
    !
    ! Given "DelTime_Value" and "DelTime_Unit" are
    ! divided by $ \Delta t $ stored in "timeset" module, 
    ! and the result are returned to "IntStep" as interval of step.
    !
    ! If the result is less than 1, 1 is returned.
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: DelTime_Value
                              ! $ \Delta t $ .  ñ̤ DelTimeUnit ˤƻ.
                              ! Unit is specified by "DelTimeUnit". 
    character(*), intent(in):: DelTime_Unit
                              ! $ \Delta t $ ñ. 
                              ! Unit of $ \Delta t $ 
    integer, intent(out):: IntStep
                              ! ƥå״ֳ. 
                              ! Interval of steps

    ! ѿ
    ! Work variables
    !
    type(DC_DIFFTIME):: dcdiff_delt_ext
                              ! $ \Delta t $
    type(DC_DIFFTIME):: dcdiff_delt_int
                              ! $ \Delta t $

    ! ¹ʸ ; Executable statement
    !

    ! DC_DIFFTIME ѿ
    ! Configure DC_DIFFTIME type variables
    !
    call DCDiffTimeCreate( dcdiff_delt_ext, &  ! (out)
      & DelTime_Value, DelTime_Unit )          ! (in)
    call DCDiffTimeCreate( dcdiff_delt_int, &  ! (out)
      & DelTimeValue, DelTimeUnit )            ! (in)

    ! IntStep λ
    ! Calculate IntStep
    !
    IntStep = int( dcdiff_delt_ext / dcdiff_delt_int )
    IntStep = max( IntStep, 1 )

  end subroutine TimesetIntStepEval

  !-------------------------------------------------------------------

  subroutine TimesetGetStartTime( &
    & time, & ! (out)
    & unit  & ! (in) optional
    & )
    !
    ! ׻ϻ time ֤ޤ. 
    ! ǥեȤǤ, NAMELIST#timeset_nml 
    ! StartTimeUnit ˻ꤵΤλñ̤Ǥ. 
    ! ץʥ unit ñ̤ꤹ뤳ȤǤñ̤
    ! 郎֤ޤ. 
    !
    ! Start time of calculation is returned to "time". 
    ! By default, "StartTimeUnit"in "NAMELIST#timeset_nml" is units of 
    ! the time. 
    ! If a unit is specified to an optional argument "unit", 
    ! a time according to the unit is returned. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalByUnit

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: time
                              ! ׻ϻ. 
                              ! Start time of calculation
    character(*), intent(in), optional:: unit
                              ! ׻ϻñ. 
                              ! Unit of start time of calculation

    ! ѿ
    ! Work variables
    !
    type(DC_DIFFTIME):: dcdiff_time

    ! ¹ʸ ; Executable statement
    !

    if ( .not. present(unit) ) then
      time = StartTimeValue
    else
      call DCDiffTimeCreate( dcdiff_time, &  ! (out)
        & StartTimeValue, StartTimeUnit )    ! (in)
      time = EvalByUnit( dcdiff_time, unit )
    end if

  end subroutine TimesetGetStartTime

  !-------------------------------------------------------------------

  subroutine TimesetGetEndTime( &
    & time, & ! (out)
    & unit  & ! (in) optional
    & )
    !
    ! ׻λ time ֤ޤ. 
    ! ǥեȤǤ, NAMELIST#timeset_nml 
    ! EndTimeUnit ˻ꤵΤλñ̤Ǥ. 
    ! ץʥ unit ñ̤ꤹ뤳ȤǤñ̤
    ! 郎֤ޤ. 
    !
    ! End time of calculation is returned to "time". 
    ! By default, "EndTimeUnit"in "NAMELIST#timeset_nml" is units of 
    ! the time. 
    ! If a unit is specified to an optional argument "unit", 
    ! a time according to the unit is returned. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalByUnit

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: time
                              ! ׻λ. 
                              ! End time of calculation
    character(*), intent(in), optional:: unit
                              ! ׻λñ. 
                              ! Unit of end time of calculation

    ! ѿ
    ! Work variables
    !
    type(DC_DIFFTIME):: dcdiff_time

    ! ¹ʸ ; Executable statement
    !

    if ( .not. present(unit) ) then
      time = EndTimeValue
    else
      call DCDiffTimeCreate( dcdiff_time, &  ! (out)
        & EndTimeValue, EndTimeUnit )        ! (in)
      time = EvalByUnit( dcdiff_time, unit )
    end if

  end subroutine TimesetGetEndTime

  !-------------------------------------------------------------------

  subroutine TimesetGetDelTime( &
    & time, & ! (out)
    & unit  & ! (in) optional
    & )
    !
    ! $ \Delta t $  time ֤ޤ. 
    ! ǥեȤǤ, NAMELIST#timeset_nml 
    ! DelTimeUnit ˻ꤵΤλñ̤Ǥ. 
    ! ץʥ unit ñ̤ꤹ뤳ȤǤñ̤
    ! 郎֤ޤ. 
    !
    ! $ \Delta t $  is returned to "time". 
    ! By default, "DelTimeUnit"in "NAMELIST#timeset_nml" is units of 
    ! the time. 
    ! If a unit is specified to an optional argument "unit", 
    ! a time according to the unit is returned. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalByUnit

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: time
                              ! $ \Delta t $ 
    character(*), intent(in), optional:: unit
                              ! $ \Delta t $ ñ. 
                              ! Unit of $ \Delta t $ 

    ! ѿ
    ! Work variables
    !
    type(DC_DIFFTIME):: dcdiff_time

    ! ¹ʸ ; Executable statement
    !

    if ( .not. present(unit) ) then
      time = DelTimeValue
    else
      call DCDiffTimeCreate( dcdiff_time, &  ! (out)
        & DelTimeValue, DelTimeUnit )        ! (in)
      time = EvalByUnit( dcdiff_time, unit )
    end if

  end subroutine TimesetGetDelTime

  !-------------------------------------------------------------------

  subroutine TimesetGetCurrentTime( &
    & time, & ! (out)
    & unit  & ! (in) optional
    & )
    !
    ! ߻ time ֤ޤ. 
    ! ǥեȤǤ, NAMELIST#timeset_nml 
    ! DelTimeUnit ˻ꤵΤλñ̤Ǥ. 
    ! ץʥ unit ñ̤ꤹ뤳ȤǤñ̤
    ! 郎֤ޤ. 
    !
    ! Current time is returned to "time". 
    ! By default, "DelTimeUnit"in "NAMELIST#timeset_nml" is units of 
    ! the time. 
    ! If a unit is specified to an optional argument "unit", 
    ! a time according to the unit is returned. 
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: time
                              ! ߻. Current time
    character(*), intent(in), optional:: unit
                              ! ߻ñ. 
                              ! Unit of current time

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( .not. present(unit) ) then
      time = EvalByUnit( DCdiffCurrentTime, DelTimeUnit )
    else
      time = EvalByUnit( DCdiffCurrentTime, unit )
    end if

  end subroutine TimesetGetCurrentTime

  !-------------------------------------------------------------------

  subroutine TimeValidCheck( &
    & dcdiff_start, dcdiff_end, dcdiff_delt, dcdiff_predict & ! (in)
    & )
    !
    ! ˤĤƤͭåޤ. 
    !
    ! Check validation about infomation time
    !

    ! ⥸塼 ; USE statements
    !

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
      & operator(*), operator(==), operator(<), operator(>), &
      & operator(/), operator(+), operator(-)

    implicit none

    ! ѿ
    ! Work variables
    !
    type(DC_DIFFTIME):: dcdiff_start
                              ! ׻ϻ. 
                              ! Start time of calculation
    type(DC_DIFFTIME):: dcdiff_end
                              ! ׻λ. 
                              ! End time of calculation
    type(DC_DIFFTIME):: dcdiff_delt
                              ! $ \Delta t $ [s]
    type(DC_DIFFTIME):: dcdiff_predict
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted end time output

    ! ¹ʸ ; Executable statement
    !

    if ( .not. 0.0_DP < EvalSec( dcdiff_end - dcdiff_start )  ) then
      call MessageNotify( 'E', module_name, &
        & 'StartTime=<%f[%c]> is later than EndTime=<%f[%c]>', &
        & d = (/ StartTimeValue, EndTimeValue /), &
        & c1 = trim(StartTimeUnit), c2 = trim(EndTimeUnit) )
    end if

    if ( dcdiff_delt > ( dcdiff_end - dcdiff_start ) ) then
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> is larger than ' // &
        & 'EndTime=<%f[%c]> - StartTime=<%f[%c]>.', &
        & d = (/ DelTimeValue, EndTimeValue, StartTimeValue /), &
        & c1 = trim(DelTimeUnit), &
        & c2 = trim(EndTimeUnit), c3 = trim(StartTimeUnit) )
    end if

    if ( .not. EvalSec( dcdiff_delt ) > 0.0_DP ) then
      call MessageNotify( 'E', module_name, &
        & 'DelTime=<%f[%c]> must be more than 0.', &
        & d = (/ DelTimeValue /), &
        & c1 = trim(DelTimeUnit) )
    end if

    if ( .not. EvalSec( dcdiff_predict ) > 0.0_DP ) then
      call MessageNotify( 'E', module_name, &
        & 'PredictInt=<%f[%c]> must be more than 0.', &
        & d = (/ PredictIntValue /), &
        & c1 = trim(PredictIntUnit) )
    end if

  end subroutine TimeValidCheck

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module timeset
