!= ʻȿ
!
!= Number of grid points and maximum truncated wavenumber settings
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gridset.f90,v 1.2 2008-08-05 19:31:47 morikawa Exp $ 
! Tag Name::  $Name: dcpam5-20080812 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gridset
  !
  != ʻȿ
  !
  != Number of grid points and maximum truncated wavenumber settings
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʻꤪݴɤԤޤ. 
  ! ڥȥˡѤ뤳ȤˤƤ, 
  ! ȿݴɤԤޤ. 
  !
  ! Number of grid points is set and stored. 
  ! Maximum truncated wavenumber is set and stored too, 
  ! because spectral method is expected to be used. 
  !
  !== Variables List
  !
  ! nmax         :: ȿ
  ! imax         :: ٳʻ
  ! jmax         :: ٳʻ
  ! kmax         :: ľؿ
  ! ------------ :: ------------
  ! nmax         :: Maximum truncated wavenumber
  ! imax         :: Number of grid points in longitude
  ! jmax         :: Number of grid points in latitude
  ! kmax         :: Number of vertical level
  !
  !== Procedures List
  !
  ! GridsetInit   :: ʻȺȿ
  ! ------------  :: ------------
  ! GridsetInit   :: Settings of number of grid points and maximum truncated wavenumber
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#gridset_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: GridsetInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: gridset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  integer, save, public:: nmax
                              ! ȿ. 
                              ! Maximum truncated wavenumber
  integer, save, public:: imax
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, save, public:: jmax
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, save, public:: kmax
                              ! ľؿ. 
                              ! Number of vertical level

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'gridset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20080812 $' // &
    & '$Id: gridset.f90,v 1.2 2008-08-05 19:31:47 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface GridsetInit
    module procedure GridsetInit
  end interface

contains

  subroutine GridsetInit
    !
    ! gridset ⥸塼νԤޤ. 
    ! NAMELIST#gridset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "gridset" module is initialized. 
    ! NAMELIST#gridset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /gridset_nml/ nmax, imax, jmax, kmax
          !
          ! ǥեͤˤĤƤϽ³ "gridset#GridsetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "gridset#GridsetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( gridset_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    nmax = 10
    imax = 32
    jmax = 16
    kmax = 5

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = gridset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = gridset_nml )
    end if

    ! ʻΥå
    ! Check number of grid points
    !
    if ( nmax < 1 .or. imax < 1 .or. jmax < 1 .or. kmax < 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of grid points and maximum truncated wavenumber must be more than 0. ' // &
        & 'nmax=%d, imax=%d, jmax=%d, kmax=%d' , &
        & i = (/ nmax, imax, jmax, kmax /) )
    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  nmax = %d', i = (/ nmax /) )
    call MessageNotify( 'M', module_name, '  imax = %d', i = (/ imax /) )
    call MessageNotify( 'M', module_name, '  jmax = %d', i = (/ jmax /) )
    call MessageNotify( 'M', module_name, '  kmax = %d', i = (/ kmax /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    gridset_inited = .true.
  end subroutine GridsetInit

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module gridset
